
from elisa.core.tests import component_test_case
from elisa.plugins.base.controllers.list_controller import ListController
from elisa.base_components.controller import Controller
from elisa.core.backend import Backend

class TestListController(component_test_case.ComponentTestCase):

    component_class = ListController

    def test_parent(self):

        root_controller = ListController()
        child_list_controller = ListController()
        child_controller = Controller()
        child_controller2 = Controller()

        self.assertEquals(root_controller.parent, None)
        self.assertEquals(child_list_controller.parent, None)
        self.assertEquals(child_controller.parent, None)

        root_controller.append(child_controller)
        self.assertEquals(root_controller.parent, None)
        self.assertEquals(child_list_controller.parent, None)
        self.assertEquals(child_controller.parent, root_controller)

        root_controller.append(child_list_controller)
        self.assertEquals(root_controller.parent, None)
        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, root_controller)

        root_controller.remove(child_list_controller)
        self.assertEquals(root_controller.parent, None)
        self.assertEquals(child_list_controller.parent, None)
        self.assertEquals(child_controller.parent, root_controller)

        root_controller.remove(child_controller)
        self.assertEquals(root_controller.parent, None)
        self.assertEquals(child_list_controller.parent, None)
        self.assertEquals(child_controller.parent, None)


        root_controller.append(child_list_controller)
        self.assertEquals(child_list_controller.parent, root_controller)
        root_controller.extend([child_controller, child_controller2])
        self.assertEquals(child_controller.parent, root_controller)
        self.assertEquals(child_controller2.parent, root_controller)

        root_controller.pop()
        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, root_controller)
        self.assertEquals(child_controller2.parent, None)

        root_controller.insert(0, child_controller2)
        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, root_controller)
        self.assertEquals(child_controller2.parent, root_controller)

        del root_controller[0]
        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, root_controller)
        self.assertEquals(child_controller2.parent, None)
        child_list_controller = ListController()

        root_controller[1] = child_controller2
        self.assertEquals(child_list_controller.parent, None)
        self.assertEquals(child_controller.parent, None)
        self.assertEquals(child_controller2.parent, root_controller)

        root_controller.insert(0, child_list_controller)
        root_controller.insert(1, child_controller)
        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, root_controller)
        self.assertEquals(child_controller2.parent, root_controller)

        del root_controller[0:2]
        self.assertEquals(child_list_controller.parent, None)
        self.assertEquals(child_controller.parent, None)
        self.assertEquals(child_controller2.parent, root_controller)
        child_list_controller = ListController()
        child_controller = Controller()

        root_controller=ListController()
        root_controller.append(child_list_controller)
        root_controller.append(child_controller)
        root_controller.append(child_controller2)
        child_controller3 = Controller()
        child_controller4 = Controller()

        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, root_controller)
        self.assertEquals(child_controller2.parent, root_controller)
        self.assertEquals(child_controller3.parent, None)
        self.assertEquals(child_controller4.parent, None)

        root_controller[1:2] = [child_controller3, child_controller4]
        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, None)
        self.assertEquals(child_controller2.parent, root_controller)
        self.assertEquals(child_controller3.parent, root_controller)
        self.assertEquals(child_controller4.parent, root_controller)


    def test_parent2(self):
        root_controller = ListController()
        child_list_controller = ListController()
        child_controller = Controller()

        child_list_controller.append(child_controller)
        root_controller.append(child_list_controller)

        self.assertEquals(root_controller.parent, None)
        self.assertEquals(child_list_controller.parent, root_controller)
        self.assertEquals(child_controller.parent, child_list_controller)


    def test_backend(self):
        root_controller = ListController()
        backend = Backend(root_controller)
        root_controller.backend = backend

        child_list_controller = ListController()
        child_controller = Controller()

        child_list_controller.append(child_controller)
        root_controller.append(child_list_controller)

        self.assertEquals(root_controller.backend, backend)
        self.assertEquals(child_list_controller.backend, backend)
        self.assertEquals(child_controller.backend, backend)


    def test_focus(self):
        root_controller = ListController()
        root_controller.debug_name = 'root_controller'
        backend = Backend(root_controller)
        root_controller.backend = backend

        child_list_controller = ListController()
        child_list_controller.debug_name = 'child_list_controller'
        child_controller1 = Controller()
        child_controller1.debug_name = 'child_controller1'
        child_controller2 = Controller()
        child_controller2.debug_name = 'child_controller2'
        child_controller3 = Controller()
        child_controller3.debug_name = 'child_controller3'
        child_list_controller.append(child_controller3)
        root_controller.append(child_controller1)
        root_controller.append(child_controller2)
        root_controller.append(child_list_controller)

        self.assertEquals(root_controller.focused, False)

        root_controller.focus()
        self.assertEquals(root_controller.focused, True)
        self.assertEquals(child_list_controller.focused, False)
        self.assertEquals(child_controller1.focused, False)
        self.assertEquals(child_controller2.focused, False)
        self.assertEquals(child_controller3.focused, False)

        self.assertEquals(root_controller.current_index, 0)
        self.assertEquals(child_list_controller.current_index, 0)

        child_controller1.focus()
        self.assertEquals(root_controller.focused, True)
        self.assertEquals(child_list_controller.focused, False)
        self.assertEquals(child_controller1.focused, True)
        self.assertEquals(child_controller2.focused, False)
        self.assertEquals(child_controller3.focused, False)

        self.assertEquals(root_controller.current_index, 0)
        self.assertEquals(child_list_controller.current_index, 0)

        child_controller2.focus()
        self.assertEquals(root_controller.focused, True)
        self.assertEquals(child_list_controller.focused, False)
        self.assertEquals(child_controller1.focused, False)
        self.assertEquals(child_controller2.focused, True)
        self.assertEquals(child_controller3.focused, False)

        child_controller3.focus()
        self.assertEquals(root_controller.focused, True)
        self.assertEquals(child_list_controller.focused, True)
        self.assertEquals(child_controller1.focused, False)
        self.assertEquals(child_controller2.focused, False)
        self.assertEquals(child_controller3.focused, True)

        child_list_controller.focus()
        self.assertEquals(root_controller.focused, True)
        self.assertEquals(child_list_controller.focused, True)
        self.assertEquals(child_controller1.focused, False)
        self.assertEquals(child_controller2.focused, False)
        self.assertEquals(child_controller3.focused, False)


    def test__selection(self):

        root_controller = ListController()
        root_controller.debug_name = 'root_controller'
        backend = Backend(root_controller)
        root_controller.backend = backend

        child_list_controller = ListController()
        child_list_controller.debug_name = 'child_list_controller'
        child_controller1 = Controller()
        child_controller1.debug_name = 'child_controller1'
        child_controller2 = Controller()
        child_controller2.debug_name = 'child_controller2'
        child_controller3 = Controller()
        child_controller3.debug_name = 'child_controller3'
        child_controller4 = Controller()
        child_controller4.debug_name = 'child_controller4'
        child_list_controller.append(child_controller3)
        root_controller.append(child_controller1)
        root_controller.append(child_controller2)
        child_list_controller.append(child_controller4)
        root_controller.append(child_list_controller)

        self.assertEquals(root_controller.current_index, 0)
        self.assertEquals(child_list_controller.current_index, 0)

        root_controller.current_index = 0
        self.assertEquals(root_controller.current_index, 0)
        self.assertEquals(child_list_controller.current_index, 0)

        root_controller.current_index = 1
        self.assertEquals(root_controller.current_index, 1)
        self.assertEquals(child_list_controller.current_index, 0)

        root_controller.current_index = 2
        self.assertEquals(root_controller.current_index, 2)
        self.assertEquals(child_list_controller.current_index, 0)

        child_list_controller.current_index = 0
        child_list_controller.focus()
        self.assertEquals(root_controller.current_index, 2)
        self.assertEquals(child_list_controller.current_index, 0)


        child_list_controller.current_index = 1
        self.assertEquals(root_controller.current_index, 2)
        self.assertEquals(child_list_controller.current_index, 1)

        child_list_controller.current_index = 127
        self.assertEquals(root_controller.current_index, 2)
        self.assertEquals(child_list_controller.current_index, 1)
