# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from list_model import ListModel


class MenuNodeModel(ListModel):
    """
    Modelize a menu node.

    DOCME more.

    @ivar text:             label of the node
    @type text:             string or L{elisa.extern.translator.Translatable}
    @ivar theme_icon:       identifier of the icon used for the node
    @type theme_icon:       string
    @ivar thumbnail_source: URI of a picture thumbnailed for the node; optional
    @type thumbnail_source: L{elisa.core.media_uri.MediaUri}
    @ivar has_children:     True if the node has children nodes, False otherwise
    @type has_children:     boolean
    @ivar uri:              URI of the media represented by the node
    @type uri:              L{elisa.core.media_uri.MediaUri}
    """

    text = ''
    theme_icon = 'unknown_icon'
    thumbnail_source = None
    has_children = False
    uri = None
    
    def __repr__(self):
        return "<MenuNodeModel instance %r for %r, %r children>" % (self.id,
                                                                    self.text,
                                                                    len(self))
    def __lt__(self, other):
        if isinstance(other, MenuNodeModel):
            return self.text < other.text
        return

    def __le__(self, other):
        if isinstance(other, MenuNodeModel):
            return self.text <= other.text
        return

    def __gt__(self, other):
        if isinstance(other, MenuNodeModel):
            return self.text > other.text
        return

    def __ge__(self, other):
        if isinstance(other, MenuNodeModel):
            return self.text >= other.text
        return
