# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.activity import Activity
from elisa.core import common


class SlideshowActivity(Activity):

    def get_model(self):
        registry = common.application.plugin_registry
        slideshow_model = registry.create_component('base:slideshow_model')

        # TODO: make this configurable
        playlist_activity = registry.create_component('base:default_playlist')
        playlist_activity.media_types = ["image"]

        playlist_model = playlist_activity.get_model()
        slideshow_model.playlist = playlist_model
        slideshow_model.activity = self
        return slideshow_model
