# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.base_components.action import Action

class SlideshowAction(Action):
    """
    DOCME
    """

    label = 'slideshow'
    supported_file_types = ('image',)

    # Attribute to set at initialization
    # MediaURI instance
    uri = None
    # URI of the picture the slideshow will start at
    start_uri = None
    # position to add the URI in playlist
    # -1 : add at the end.
    position = -1
    # base:slideshow_model instance
    slideshow_model = None

    # Options:
    # if True, the playlist will be played after URI adding
    play_now = True
    # if True, the playlist will be emptied before adding the new URIs
    erase_before_enqueue = True


    def __call__(self, controller, origin=None):
        playlist_model = self.slideshow_model.playlist
        playlist_activity = playlist_model.activity

        if self.erase_before_enqueue:
            playlist_activity.empty()
        
        self.slideshow_model.playing = False
        self.slideshow_model.preview_mode = False

        playlist_activity.add_uri(self.uri, -1)

        def load_playlist(model):
            if len(model) > 0:
                if self.start_uri in model:
                    index = model.index(self.start_uri)
                else:
                    index = 0

                self.slideshow_model.current_index = index

        dfr = playlist_activity.loadmore(self.uri, playlist_model)
        dfr.addCallback(load_playlist)

        if self.play_now == True:
            def play_now(model):
                self.slideshow_model.playing = True

            dfr.addCallback(play_now)
