# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.base_components.view import View

import pygtk
pygtk.require('2.0')
import gtk

class WeatherGtkView(View):

    """
    This class implements gtk weather view
    """

    supported_controllers = ('weather:weather_controller')
    default_associations = ()

    def __init__(self):
        View.__init__(self)
        self.table = gtk.Table(rows=6, columns=4, homogeneous=True)
        ## The Syntax is: self.table.attach
        ## (child, left_attach, right_attach, top_attach, bottom_attach,
        ##self.icon = gtk.Image

        self.lbl_local = gtk.Label("Location")
        self.table.attach(self.lbl_local,0,2,0,1)
        self.lbl_local_val = gtk.Label()
        self.table.attach(self.lbl_local_val,2,4,0,1)
        self.lbl_local.show()
        self.lbl_local_val.show()

        self.lbl_temp = gtk.Label("Temprature")
        self.table.attach(self.lbl_temp,0,1,3,4)
        self.lbl_temp_val = gtk.Label()
        self.table.attach(self.lbl_temp_val,1,2,3,4)
        self.lbl_temp.show()
        self.lbl_temp_val.show()

        self.lbl_hum = gtk.Label("relative Humidity")
        self.lbl_hum_val = gtk.Label()
        self.table.attach(self.lbl_hum,0,1,4,5)
        self.table.attach(self.lbl_hum_val,1,2,4,5)
        self.lbl_hum.show()
        self.lbl_hum_val.show()

        self.lbl_dew = gtk.Label("Dew point")
        self.table.attach(self.lbl_dew,2,3,1,2)
        self.lbl_temp.show()
        self.lbl_dew_val = gtk.Label()
        self.table.attach(self.lbl_dew_val,3,4,1,2)
        self.lbl_temp_val.show()


        self.lbl_press = gtk.Label("Pressure")
        self.table.attach(self.lbl_press,2,3,2,3)
        self.lbl_press.show()
        self.lbl_press_val = gtk.Label()
        self.table.attach(self.lbl_press_val,3,4,2,3)
        self.lbl_press_val.show()

        self.lbl_wspeed = gtk.Label("Wind speed")
        self.lbl_wspeed_val = gtk.Label()
        self.table.attach(self.lbl_wspeed,2,3,3,4)
        self.table.attach(self.lbl_wspeed_val,3,4,3,4)
        self.lbl_wspeed.show()
        self.lbl_wspeed_val.show()

        self.lbl_windD = gtk.Label("Wind direction")
        self.table.attach(self.lbl_windD,2,3,4,5)
        self.lbl_windD.show()
        self.lbl_windD_val = gtk.Label()
        self.table.attach(self.lbl_windD_val,3,4,4,5)
        self.lbl_windD_val.show()



        self.lbl_sky = gtk.Label("Sky conditions")
        self.table.attach(self.lbl_sky,0,2,5,6)
        self.lbl_sky.show()
        self.lbl_sky_val = gtk.Label()
        self.table.attach(self.lbl_sky_val,2,4,5,6)
        self.lbl_sky_val.show()

        self.table.show()
        self.context_path = 'gtk:gtk_context'
        treestore = gtk.TreeStore(str)
        treeview = gtk.TreeView(treestore)
        ## delete this line, if you want to use it inside elisa
        self.context_handle = self.table


    def controller_changed(self):

        self.icon = gtk.Image()
        pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(
                                self.frontend.theme.get_media(
                                        self.controller.model.icon,
                                        ('weather:data/%s.png'
                                                % self.controller.model.icon)
                                    ),
                                250,
                                250)
        self.icon.set_from_pixbuf(pixbuf)
        self.icon.show()
        self.table.attach(self.icon,0,2,1,3)
        self.debug("The icon is: %s and the path is: %s"  %
                            (self.controller.model.icon,
                                self.frontend.theme.get_media(
                                            self.controller.model.icon,
                                            ('weather:data/%s.png' %
                                                            self.controller.model.icon
                                            ))
                            )
                        )
        self.lbl_local_val.set_text(self.controller.model.location)
        self.lbl_temp_val.set_text("%d °C" %
                                                    self.controller.model.temp)
        self.lbl_wspeed_val.set_text("%d km/h" %
                                                    self.controller.model.wind_speed)
        self.lbl_windD_val.set_text("%d °" %
                                                    self.controller.model.wind_dir)
        self.lbl_hum_val.set_text("%d %%" %
                                                    self.controller.model.relHumidity)
        self.lbl_dew_val.set_text("%d °C" %
                                                    self.controller.model.dew)
        self.lbl_sky_val.set_text(self.controller.model.sky)
        self.lbl_press_val.set_text("%d hPa" %
                                                    self.controller.model.press)
