# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.core import common
from elisa.core.media_uri import MediaUri
from elisa.core import plugin_registry

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-dvd')


try:
    from dvd_player import *
    FLUENDO_DVD_INSTALLED = True
except:
    FLUENDO_DVD_INSTALLED = False

MenuActivity = plugin_registry.get_component_class('base:menu_activity')

class DvdActivity(MenuActivity):

    menu_name = T_(N_("DVD"))
    menu_icon_name = "dvd"
    media_types = ["video",]
    
    config_doc = {'dvd_uri': 'uri of the dvd. must be file:///* or dvd://'}

    default_config = {'dvd_uri': 'dvd://'}


    def initialize(self):
        MenuActivity.initialize(self)
        self.root_menu = None

    def _get_dvd_menu(self):
        registry = common.application.plugin_registry
        dvd_uri = MediaUri(self.config.get('dvd_uri', 'dvd://'))

        root_menu = MenuActivity._create_menu_model(self,
                                                    self.menu_name,
                                                    self.menu_icon_name)

        play = self._create_menu_model(T_(N_("play DVD")), "dvd_play")
        menu = self._create_menu_model(T_(N_("Display menu")), "dvd_menu")
        eject = self._create_menu_model(T_(N_("Eject")), "dvd_eject")
        
        
        action = registry.create_component('base:play_action')
        action.player_model = self.dvd_player_model
        action.uri = dvd_uri
        play.activate_action = action


        action = registry.create_component('dvd:menu_action')
        action.player_model = self.dvd_player_model
        action.uri = dvd_uri
        menu.activate_action = action

        action = registry.create_component('base:eject_action')
        action.uri = dvd_uri
        action.player_model = self.dvd_player_model
        eject.activate_action = action

        root_menu.append(play)
        root_menu.append(menu)
        root_menu.append(eject)
        root_menu.has_children = True
        return root_menu
    
    
    def _get_empty_menu(self):
        root_menu = MenuActivity._create_menu_model(self,
                                                    self.menu_name,
                                                    self.menu_icon_name)

        empty = self._create_menu_model(T_(N_("no player installed")), "empty")
        root_menu.has_children = True
        
        root_menu.append(empty)
        return root_menu
    
    
    def get_model(self):
        if not self.root_menu:
            if FLUENDO_DVD_INSTALLED:
                self.root_menu = self._get_dvd_menu()
            else:
                self.root_menu = self._get_empty_menu()
        self.root_menu.activity = self
        return self.root_menu
