# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.utils import misc
from elisa.core import media_uri
import os, platform
import random, string

class TestMisc(ElisaTestCase):

    def _random_string(self, length=10):
        return ''.join(random.sample(string.ascii_letters, length))

    def test_env_var_expand(self):
        platform_type = platform.system().lower()

        var_name = self._random_string()
        
        os.environ[var_name] = 'test!'
        expanded = misc.env_var_expand('$%s' % var_name)
        self.assertEquals(expanded, 'test!')

        var_name2 = self._random_string()
        os.environ[var_name2] = 'test2'
        os.environ[var_name] = 'test:$%s' % var_name2
        expanded = misc.env_var_expand('$%s' % var_name)
        self.assertEquals(expanded, 'test:test2')

        if platform_type == 'windows':
            # TODO
            pass
        elif platform_type == 'linux':
            expanded = misc.env_var_expand('$HOME/Music')
            home = os.path.expanduser('~')
            self.assertEquals(expanded, os.path.join(home, 'Music'))
        
    def test_uncamelify(self):

        self.assertEquals(misc.un_camelify('F'), 'f')
        self.assertEquals(misc.un_camelify('f'), 'f')

        self.assertEquals(misc.un_camelify('FooBar'), 'foo_bar')
        self.assertEquals(misc.un_camelify('Foo Bar'), 'foo_bar')
        self.assertEquals(misc.un_camelify('fooBar'), 'foo_bar')

    def test_get_media_infos_from_mime(self):

        uris = {'file://./foo.mp3': ('audio/mpeg', 'audio'),
                'file://./test.ogg': ('application/ogg', 'audio'),
                'file://./test.ogm': ('', 'video'),
                'file:///tmp': ('', '')
                }
        for uri, expected in uris.iteritems():
            infos = misc.get_media_infos_from_mime(media_uri.MediaUri(uri))
            self.assertEquals(infos, expected)
