# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase, BoilerPlateApp
from elisa.core import plugin
from elisa.core import log, common
from elisa.core import media_manager, metadata_manager, media_uri
from twisted.internet import defer
from elisa.plugins.base.media_providers.local_media import LocalMedia

import os
import sys

class FooPlugin(plugin.Plugin):
    name = 'foo'
    components = {'local_media': {'path': LocalMedia}}

class TestThumbnailer(ElisaTestCase):

    def setUp(self):

        common.boot()

        if 'ELISA_DEBUG' not in os.environ:
            log.setDebug('*:0')

        app = BoilerPlateApp('empty.conf')
        common.set_application(app)

        from elisa.core.common import application

        application.plugin_registry.register_plugin(FooPlugin)

        c = application.plugin_registry.create_component

        m_manager = metadata_manager.MetadataManager()

        application.media_manager = media_manager.MediaManager(m_manager)

        application.media_manager.register_component(c('foo:local_media'))
        application.media_manager.start()

        from elisa.core.thumbnailer import Thumbnailer

        self._thumbnailer = Thumbnailer()


    def tearDown(self):
        from elisa.core.common import application
        application.media_manager.stop()
        ElisaTestCase.tearDown(self)

    def test_thumbnail_image(self):
        from elisa.core.common import application
        from elisa import statprof
        import time

        base_path = '/media/nfs/pictures/fafa/famille/'


        def walk_path(path):

            for root, dirs, files in os.walk(path):

                for d in dirs:
                    walk_path(root + '/' + d)

                for f in files:
                    uri = media_uri.MediaUri(u'file://' + root + '/' + f)
                    print "uri:",uri
                    ret = ('',)
                    try:
                        ret = self._thumbnailer._retrieve_thumbnail(uri, 255, "image")
                        #time.sleep(0.5)
                        self.failUnless(os.path.exists(ret[0]))
                    except:
                        pass


        statprof.start()
        walk_path(base_path)
        statprof.stop()
        statprof.display()

    test_thumbnail_image.skip = "This test does not look like a unit test."
