# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.base_components import input_provider
from elisa.core import input_manager, input_event
from elisa.core import plugin, plugin_registry, config
from elisa.core import common
from twisted.internet import reactor
from elisa.core.tests.test_input_provider import MousePollInputProvider, \
     MousePushInputProvider

class TestInputManager(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._input_manager = input_manager.InputManager()
        #self._input_manager.start()
        self._called = {self.mouse_upped:False,
                        self.mouse_down: False}

    def mouse_triggerred(self, event):
        if event.type == input_event.EventType.MOUSE_UP:
            self.mouse_upped(event)
        elif event.type == input_event.EventType.MOUSE_DOWN:
            self.mouse_down(event)

    def mouse_upped(self, event):
        self.assertEquals(event.type, input_event.EventType.MOUSE_UP)
        self.assertEquals(event.value, input_event.EventValue.MOUSE_LEFT)
        self._called[self.mouse_upped] = True

    def mouse_down(self, event):
        self.assertEquals(event.type, input_event.EventType.MOUSE_DOWN)
        self.assertEquals(event.value, input_event.EventValue.MOUSE_LEFT)
        self._called[self.mouse_down] = True

    def _connect(self, component):
        #import pdb; pdb.set_trace()
        self._called[self.mouse_upped] = False
        self._called[self.mouse_down] = False
        self._input_manager.subscribe(component.path, self.mouse_triggerred)

    def _disconnect(self, component):
        self._input_manager.unsubscribe(component.path, self.mouse_triggerred)

    def test_poll_events(self):
        """
        """
        mouse_poll = MousePollInputProvider()
        mouse_poll.path = 'mouse_poll_input_provider'
        self._input_manager.register_component(mouse_poll)

        self._connect(mouse_poll)

        self._input_manager._poll_events()
        self.assertEquals(self._called[self.mouse_upped], True)
        self.assertEquals(self._called[self.mouse_down], True)

        self._disconnect(mouse_poll)
        self._input_manager.unregister_component(mouse_poll)

    def test_push_events(self):
        """
        """
        mouse_push = MousePushInputProvider()
        mouse_push.path = 'mouse_push_input_provider'
        self._input_manager.register_component(mouse_push)

        self._connect(mouse_push)

        mouse_push.trigger_some_events()
        self.assertEquals(self._called[self.mouse_upped], True)
        self.assertEquals(self._called[self.mouse_down], True)

        self._disconnect(mouse_push)
        self._input_manager.unregister_component(mouse_push)
