# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


from elisa.core.tests.elisa_test_case import ElisaTestCase

from elisa.core import config, config_upgrader
import os

class TestConfigUpgrader(ElisaTestCase):

    data_dir = '../elisa/core/tests/data'
    
    def _upgrade(self, old_conf_file, default_conf_file, version):
        
        old_conf_file = os.path.join(self.data_dir, old_conf_file)
        old_config = config.Config(old_conf_file)

        default_conf_file = os.path.join(self.data_dir, default_conf_file)
        default = open(default_conf_file).read()
        upgrader = config_upgrader.ConfigUpgrader(old_config, default)
        cfg = upgrader.update_for(version)

        cfg_version = cfg.get_option('version', section='general')
        version_str = '.'.join([str(i) for i in version])        
        self.assertEquals(cfg_version, version_str)
        return cfg

    def _assert_0_3_2(self, cfg):
        for path in ['base:local_media', 'coherence_plugin:upnp_media',
                     'media_good:gnomevfs_media', 'media_bad:ipod_media',
                     'media_good:elisa_media', 'audiocd:audiocd_media']:
            self.failIf(path not in cfg.get_option('media_providers'))

        for path in ['media_good:amazon_covers', 'media_good:taglib_metadata',
                     'media_good:cover_cache', 'media_good:gst_metadata',
                     'media_good:cover_in_dir']:
            self.failIf(path not in cfg.get_option('metadata_providers'))

        for path in ['base:audio_activity', 'base:video_activity',
                     'base:image_activity', 'base:config_activity',
                     'base:service_activity']:
            self.failIf(path not in cfg.get_option('menu_activities',
                                                   section='base:main_menu_activity'))
        
        self.assertEqual(cfg.get_option('input_providers', section='backend1'),
                         ['input_good:lirc_input'])
        self.assertEqual(cfg.get_option('input_providers', section='frontend1'),
                         ['pigment:pigment_input'])
        self.assertEqual(cfg.get_option('service_providers'),
                         ['hal:hal_service',
                          'coherence_plugin:coherence_service'])
        self.assertEqual(cfg.get_option('service_activities', 
                                        section='base:service_activity'),
                         ['service:about_activity'])
    
    def testUpgrade0_1_7To_0_3_1(self):
        " 0.1.7 -> 0.3.1 "
        self._upgrade('elisa_0_1_7.conf', 'elisa_0_3_1.conf', (0, 3, 1))

    def testUpgrade0_1_7To_0_3_2(self):
        " 0.1.7 -> 0.3.2 "
        self._upgrade('elisa_0_1_7.conf','elisa_0_3_2.conf', (0, 3, 2))
        
    def testUpgrade0_3_1To_0_3_2(self):
        " 0.3.1 -> 0.3.2 "
        cfg = self._upgrade('elisa_0_3_1.conf', 'elisa_0_3_2.conf', (0, 3, 2))
        self._assert_0_3_2(cfg)
