# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


class Observer(object):
    """Instances of Observer are notified of changes happening in the
    L{elisa.core.observers.observable.Observable} instance they are attached to.
    """

    def __init__(self):
        self._observable = None

    def observe(self, observable):
        """Attach the observer to an observable instance so that the former will
        get notified for each change occuring to the latter.
        
        @param observable: the Observable instance to observe
        @type observable:  L{elisa.core.observers.observable.Observable}
        """
        if self._observable != None:
            self.stop_observing()

        self._observable = observable
        observable.add_observer(self)

    def stop_observing(self):
        """Detach the observer from an observable instance: no change
        notification will be sent to the Observer anymore.
        """
        self._observable.remove_observer(self)

    def attribute_set(self, key, old_value, new_value):
        """Called when an attribute of the observed object is changed.

        @param key:       attribute changed
        @type key:        string
        @param old_value: value of the attribute before being set; None if
                          attribute was not existing
        @type:            any
        @param new_value: value of the attribute after being set
        @type:            any
        """
        pass
