# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.plugins.pigment.widgets.indicator_progressbar import IndicatorProgressBar
from elisa.plugins.pigment.widgets.const import *
from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.theme import Theme
from elisa.plugins.poblesec.widgets.player.button import Button

import pgm


class VolumeBar(Widget):

    def __init__(self):
        super(VolumeBar, self).__init__()

        self.spacing = 0

        self.progressbar = IndicatorProgressBar()
        self.progressbar.visible = True

        self.volup = Button()
        self.volup.set_backgrounds(
              "elisa.plugins.poblesec.player.volume.volup",
              "elisa.plugins.poblesec.player.volume.volup",
              "elisa.plugins.poblesec.player.volume.volup")
        self.volup.alignment = pgm.IMAGE_RIGHT
        self.volup.visible = True

        self.voldown = Button()
        self.voldown.set_backgrounds(
              "elisa.plugins.poblesec.player.volume.voldown",
              "elisa.plugins.poblesec.player.volume.voldown",
              "elisa.plugins.poblesec.player.volume.voldown")
        self.voldown.alignment = pgm.IMAGE_LEFT
        self.voldown.visible = True

        self.add(self.voldown)
        self.add(self.progressbar)
        self.add(self.volup)

        self.spacing = 0.0

        self.update_style_properties(self.style.get_items())

    def update_style_properties(self, props=None):

        if props is None:
            return

        theme = Theme.get_default()

        for key, value in props.iteritems():
            if key == 'osd-volume-bar-empty-indicator':
                self.progressbar.empty_indicator_resource = value
            elif key == 'osd-volume-bar-full-indicator':
                self.progressbar.full_indicator_resource = value
            elif key == 'osd-volume-bar-buttons-width':
                self.voldown.width = value
                self.volup.width = value
            elif key == 'osd-volume-bar-width':
                self.progressbar.width = value
            elif key == 'osd-volume-bar-height':
               self.progressbar.height = value
               self.volup.height = value
               self.voldown.height = value
            elif key == 'osd-volume-bar-buttons-spacing':
                self.spacing = value

        self.voldown.position = (0, 0, 0)
        self.progressbar.position = (self.voldown.width + self.spacing,
                                     0, 0)
        self.volup.position = (self.progressbar.x + self.progressbar.width \
                                                  + self.spacing,
                               0, 0)

    @classmethod
    def _demo_widget(cls, *args, **kwargs):
        widget = cls(*args)

        widget = VolumeBar()
        widget.progressbar.items_number = 20
        widget.progressbar.current_index = 3
        widget.visible = True

        return widget


if __name__ == '__main__':
    import logging
    import pgm

    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    theme = Theme.load_from_module('elisa.plugins.poblesec')
    Theme.set_default(theme)
    volumebar = VolumeBar.demo()

    try:
        __IPYTHON__
    except NameError:
        pgm.main()
