# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.components.message import Message

class PigmentFrontendLoadedMessage(Message):
    """
    Sent by the pigment frontend after the first controller was successfully
    loaded.

    @ivar controller: the main controller
    @type controller: L{elisa.plugins.pigment.controller.Controller}
    """
    def __init__(self, controller):
        super(PigmentFrontendLoadedMessage, self).__init__()
        self.controller = controller
