# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
# Authors: Alessandro Decina <alessandro@fluendo.com>

import dbus
import dbus.service

class DBusFrontend(dbus.service.Object):
    interface = 'com.fluendo.Elisa.Plugins.Pigment.Frontend'
    
    def __init__(self, frontend, *args, **kw):
        dbus.service.Object.__init__(self, *args, **kw)
        self.frontend = frontend

    @dbus.service.method(dbus_interface=interface,
            in_signature='', out_signature='') 
    def show(self):
        toplevel = self._get_toplevel_window()
        toplevel.show()
        toplevel.focus()

        self._show_player_osd()

    @dbus.service.method(dbus_interface=interface,
            in_signature='', out_signature='') 
    def hide(self):
        toplevel = self._get_toplevel_window()
        toplevel.hide()

    def _get_toplevel_window(self):
        return self.frontend.gtk_window or self.frontend.viewport

    def _show_player_osd(self):
        path = "/poblesec"
        main = self.frontend.retrieve_controllers(path)[0]
        player = main.current_player

        if main.focused_controller == player:
            # the player is in foreground, show the osd
            player.player_osd.show()
            player.player_osd.control_ribbon.show()
            player.player_osd.mouse_osd.show()
