static char rcsid[]="$Id: err_tab.c,v 1.6 1997/08/28 17:30:45 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

/* This file is part of the Eli translator construction system.

Eli is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

Eli is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Eli; see the file COPYING.  If not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>

FILE *fopen();

static FILE *out;
static char OutFileName[BUFSIZ];

void
OutputInit(fn)
char *fn;
{
   if ((out = fopen(fn, "w")) == NULL) {
           (void)fprintf(stderr, "Could not open output file %s\n", fn);
           exit(1);
        }

   OutFileName[0] = '\0';
}

void
OutputFinl()
{
}

#if defined(__STDC__) || defined(__cplusplus)
int main(int argc, char **argv)
#else
main(argc,argv)
int argc; char *argv[];
#endif
{
   char FileLine[BUFSIZ];
   int FileLineNumber, NextLineNumber, IncludeFlag, Offset;
   FILE *f;

   if (argc != 3) {
      (void)fprintf(stderr, "Usage %s file output\n", argv[0]);
      exit(1);
   }


   if ((f = fopen(argv[1], "r")) == NULL) {
           (void)fprintf(stderr, "Could not open input file %s\n", argv[1]);
           exit(1);
        }

   OutputInit(argv[2]);

   FileLineNumber = 1;

   while (fgets(FileLine, BUFSIZ, f) != NULL) {
      if (FileLine[0] == '#') {
         IncludeFlag = 0;
         (void)sscanf(FileLine, "# %d \"%[^\"]\" %d",
            &NextLineNumber, OutFileName, &IncludeFlag);
	 Offset = -FileLineNumber + NextLineNumber -1;
	 (void)fprintf(out,"%d %d %s\n", FileLineNumber, Offset, OutFileName);
      }
      FileLineNumber++;
   }

   OutputFinl();
   exit(0);
}
