#include <string.h>

#include "ptg_gn.h"
#include "DynSpace.h"
#include "err.h"

static void *dynspace = (void *)0;

NodeArray 
#ifdef PROTO_OK
NewNodeArray(int count)
#else
NewNodeArray(count)
int count;
#endif
{
        NodeArray a;

        if (!dynspace)
                dynspace = InitDynSpace();

        a = (NodeArray) DynAlloc(dynspace, sizeof(*a));
        a->size = count;
        a->n = DynAlloc(dynspace, sizeof(NODEPTR) * count);
        
        memset(a->n, 0, sizeof(NODEPTR) * count);
        return a;
}

NodeArray 
#ifdef PROTO_OK
SetNodeArray(NodeArray a, POSITION *pos, int i, DefTableKey key)
#else
SetNodeArray(a, pos, i, key)
NodeArray a; 
POSITION *pos;
int i;
DefTableKey key;
#endif
{
        if (! a->n[i])
                a->n[i] = Mktargtype(pos, key);
        return a;
}

NODEPTR 
#ifdef PROTO_OK
GetNodeTree(NodeArray a)
#else
GetNodeTree(a)
NodeArray a;
#endif
{
        int i;
        NODEPTR tree= NULLNODEPTR;

        for (i = 0; i < a->size; i++)
        {
                if (!a->n[i])
                {
                        DefTableKey k = NewKey();
                        ResetIndex(k, i+1);
                        ResetType(k, NODE);
                        ResetInserted(k, 1);
                        a->n[i] = Mktargtype(NoPosition, k);
                }
                        
                tree = Mk2targtypes(NoPosition, tree, a->n[i]);
        }

        return Mktargtypes(NoPosition, tree);
}

char *MapNodetypes[] = {
        (char *)0, "PTGNode", "char *", "void *", "int", "short", "long", "char",
        "float", "double"
};

char *MapMacronames[] = {
        "", "", "STRING", "", "INT", "SHORT", "LONG", "CHAR",
        "FLOAT", "DOUBLE"
};

static int ci = 0;

#ifdef PROTO_OK
void condindent(PTG_OUTPUT_FILE f)
#else
void condindent(f) PTG_OUTPUT_FILE f;
#endif
{ if (ci) PTG_OUTPUT_CHAR(f, '\t'); }

#ifdef PROTO_OK
void condindenton(PTG_OUTPUT_FILE f)
#else
void condindenton(f) PTG_OUTPUT_FILE f;
#endif
{ ci=1; }

#ifdef PROTO_OK
void condindentoff(PTG_OUTPUT_FILE f)
#else
void condindentoff(f) PTG_OUTPUT_FILE f;
#endif
{ ci=0; }



