#include <stdio.h>
#include <stdlib.h>

#include "ptg_gen.h"
#include "obstack.h"

/* -------------------------------------------------------- */
/*                      Memory Management                   */
/* -------------------------------------------------------- */

static Obstack _PTGObstack;
static void *_PTGFirstObj = NULL;

static void _PTGInit()
{
	if (_PTGFirstObj)
		return;
	obstack_init(&_PTGObstack);
	_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);
}

void PTGFree()
{
	obstack_free(&_PTGObstack, _PTGFirstObj);
	_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);
}


#if defined(__STDC__) || defined(__cplusplus)
static void *MALLOC(int size)
#else
static void *MALLOC(size) int size;
#endif
{
	if (! _PTGFirstObj)
		_PTGInit();
	return (obstack_alloc(&_PTGObstack, size));
}

/* -------------------------------------------------------- */
/*                       Output-functions                   */
/* -------------------------------------------------------- */

static PTG_OUTPUT_FILE f;
static char buffer[40];

#if PTG_OUTPUT_DEFAULT
#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
	PTGNode r;
#endif
{
	f = stdout;
	if (r) {
		(* (r->_print)) (r);
	}
	return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
	char * fn; PTGNode r;
#endif
{
	if ((f = fopen(fn, "w"))  == (FILE *)NULL)
	{
		fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
		exit(1);
	}
	if (r)
		(* (r->_print)) (r);
	fclose(f);
	return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
	FILE *fptr; PTGNode r;
#endif
{
	if ((f = fptr) == (FILE *)NULL)
	{
		fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
		exit(1);
	}
	if (r)
		(* (r->_print)) (r);
	return (r);
}

#endif

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGProcess(PTG_OUTPUT_FILE file, PTGNode r)
#else
PTGNode PTGProcess(file, r)
	PTG_OUTPUT_FILE file; PTGNode r;
#endif
{
	f = file;
	if (r)
		(* (r->_print)) (r);
	return (r);
}
/* -------------------------------------------------------- */
/*                            PTGNULL                       */
/* -------------------------------------------------------- */

/* Define PTGNULL as a PTGNode that prints nothing. */

#if defined(__STDC__) || defined(__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { (_PTGProc) _PrPTGNULL };

/* -------------------------------------------------------- */
/*          Node-Construction and Print-functions           */
/* -------------------------------------------------------- */


/* Implementation of Pattern Seq */

typedef struct _SPTGSeq{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGSeq;

#ifdef PROTO_OK
static void _PrPTGSeq(_PPTGSeq n)
#else
static void _PrPTGSeq(n)
	_PPTGSeq n;
#endif
{
	n->p1->_print(n->p1);
	n->p2->_print(n->p2);
}

#ifdef PROTO_OK
PTGNode PTGSeq(PTGNode p1, PTGNode p2)
#else
PTGNode PTGSeq(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGSeq n;

	n = (_PPTGSeq)MALLOC(sizeof(struct _SPTGSeq));
	if(p1 == PTGNULL && p2 == PTGNULL)
		return PTGNULL;

	n->_print = (_PTGProc)_PrPTGSeq;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern SpcSeq */

typedef struct _SPTGSpcSeq{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGSpcSeq;

#ifdef PROTO_OK
static void _PrPTGSpcSeq(_PPTGSpcSeq n)
#else
static void _PrPTGSpcSeq(n)
	_PPTGSpcSeq n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, " ");
	n->p2->_print(n->p2);
}

#ifdef PROTO_OK
PTGNode PTGSpcSeq(PTGNode p1, PTGNode p2)
#else
PTGNode PTGSpcSeq(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGSpcSeq n;

	n = (_PPTGSpcSeq)MALLOC(sizeof(struct _SPTGSpcSeq));
	n->_print = (_PTGProc)_PrPTGSpcSeq;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern Str */

typedef struct _SPTGStr{
	_PTGProc _print;
	char * p1;
} * _PPTGStr;

#ifdef PROTO_OK
static void _PrPTGStr(_PPTGStr n)
#else
static void _PrPTGStr(n)
	_PPTGStr n;
#endif
{
	PTG_OUTPUT_STRING(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGStr(char * p1)
#else
PTGNode PTGStr(p1)
char * p1;
#endif
{
	_PPTGStr n;

	n = (_PPTGStr)MALLOC(sizeof(struct _SPTGStr));
	n->_print = (_PTGProc)_PrPTGStr;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern At */

typedef struct _SPTGAt{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGAt;

#ifdef PROTO_OK
static void _PrPTGAt(_PPTGAt n)
#else
static void _PrPTGAt(n)
	_PPTGAt n;
#endif
{
	PTG_OUTPUT_STRING(f, "@");
	n->p1->_print(n->p1);
}

#ifdef PROTO_OK
PTGNode PTGAt(PTGNode p1)
#else
PTGNode PTGAt(p1)
PTGNode p1;
#endif
{
	_PPTGAt n;

	n = (_PPTGAt)MALLOC(sizeof(struct _SPTGAt));
	n->_print = (_PTGProc)_PrPTGAt;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Dollar */

typedef struct _SPTGDollar{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGDollar;

#ifdef PROTO_OK
static void _PrPTGDollar(_PPTGDollar n)
#else
static void _PrPTGDollar(n)
	_PPTGDollar n;
#endif
{
	PTG_OUTPUT_STRING(f, "$");
	n->p1->_print(n->p1);
}

#ifdef PROTO_OK
PTGNode PTGDollar(PTGNode p1)
#else
PTGNode PTGDollar(p1)
PTGNode p1;
#endif
{
	_PPTGDollar n;

	n = (_PPTGDollar)MALLOC(sizeof(struct _SPTGDollar));
	n->_print = (_PTGProc)_PrPTGDollar;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Connection */

typedef struct _SPTGConnection{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGConnection;

#ifdef PROTO_OK
static void _PrPTGConnection(_PPTGConnection n)
#else
static void _PrPTGConnection(n)
	_PPTGConnection n;
#endif
{
	PTG_OUTPUT_STRING(f, "&");
	n->p1->_print(n->p1);
}

#ifdef PROTO_OK
PTGNode PTGConnection(PTGNode p1)
#else
PTGNode PTGConnection(p1)
PTGNode p1;
#endif
{
	_PPTGConnection n;

	n = (_PPTGConnection)MALLOC(sizeof(struct _SPTGConnection));
	n->_print = (_PTGProc)_PrPTGConnection;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Rule */

typedef struct _SPTGRule{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGRule;

#ifdef PROTO_OK
static void _PrPTGRule(_PPTGRule n)
#else
static void _PrPTGRule(n)
	_PPTGRule n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, ": ");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, " .\n");
}

#ifdef PROTO_OK
PTGNode PTGRule(PTGNode p1, PTGNode p2)
#else
PTGNode PTGRule(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGRule n;

	n = (_PPTGRule)MALLOC(sizeof(struct _SPTGRule));
	n->_print = (_PTGProc)_PrPTGRule;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern Sepa */

typedef struct _SPTGSepa{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
	PTGNode p3;
} * _PPTGSepa;

#ifdef PROTO_OK
static void _PrPTGSepa(_PPTGSepa n)
#else
static void _PrPTGSepa(n)
	_PPTGSepa n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, ": ");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, " .\n");
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, ": ");
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, " ");
	n->p3->_print(n->p3);
	PTG_OUTPUT_STRING(f, " ");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, " .\n");
}

#ifdef PROTO_OK
PTGNode PTGSepa(PTGNode p1, PTGNode p2, PTGNode p3)
#else
PTGNode PTGSepa(p1, p2, p3)
PTGNode p1;
PTGNode p2;
PTGNode p3;
#endif
{
	_PPTGSepa n;

	n = (_PPTGSepa)MALLOC(sizeof(struct _SPTGSepa));
	n->_print = (_PTGProc)_PrPTGSepa;
	n->p1 = p1;
	n->p2 = p2;
	n->p3 = p3;
	return (PTGNode)n;
}

/* Implementation of Pattern Empty */

typedef struct _SPTGEmpty{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGEmpty;

#ifdef PROTO_OK
static void _PrPTGEmpty(_PPTGEmpty n)
#else
static void _PrPTGEmpty(n)
	_PPTGEmpty n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, ": .\n");
}

#ifdef PROTO_OK
PTGNode PTGEmpty(PTGNode p1)
#else
PTGNode PTGEmpty(p1)
PTGNode p1;
#endif
{
	_PPTGEmpty n;

	n = (_PPTGEmpty)MALLOC(sizeof(struct _SPTGEmpty));
	n->_print = (_PTGProc)_PrPTGEmpty;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Rec */

typedef struct _SPTGRec{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGRec;

#ifdef PROTO_OK
static void _PrPTGRec(_PPTGRec n)
#else
static void _PrPTGRec(n)
	_PPTGRec n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, ": ");
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, " ");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, " .\n");
}

#ifdef PROTO_OK
PTGNode PTGRec(PTGNode p1, PTGNode p2)
#else
PTGNode PTGRec(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGRec n;

	n = (_PPTGRec)MALLOC(sizeof(struct _SPTGRec));
	n->_print = (_PTGProc)_PrPTGRec;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}


/* -------------------------------------------------------- */
/*                  Default Output Functions                */
/* -------------------------------------------------------- */


#ifdef PROTO_OK
void _PTGPrintInt(PTG_OUTPUT_FILE file, int param)
#else
void _PTGPrintInt(file, param)
	PTG_OUTPUT_FILE file; int param;
#endif
{    /* used for short and int */
	sprintf(buffer,"%d",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintLong(PTG_OUTPUT_FILE file, long param)
#else
void _PTGPrintLong(file, param)
	PTG_OUTPUT_FILE file; long param;
#endif
{
	sprintf(buffer,"%ld",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintDouble(PTG_OUTPUT_FILE file, double param)
#else
void _PTGPrintDouble(file, param)
	PTG_OUTPUT_FILE file; double param;
#endif
{    /* used for float and double */
	sprintf(buffer,"%g",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintChar(PTG_OUTPUT_FILE file, char param)
#else
void _PTGPrintChar(file, param)
	PTG_OUTPUT_FILE file; char param;
#endif
{
	buffer[0] = param;
	buffer[1] = 0;
	PTG_OUTPUT_STRING(file,buffer);
}

