/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibáñez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "eiciel_xattr_controler.hpp"

EicielXAttrControler::EicielXAttrControler()
	: gestorXAttr(NULL), finestra(NULL), _fitxerObert(false)
{
}

void EicielXAttrControler::obrirFitxer(const Glib::ustring& nomFitxer) throw (GestorXAttrException)
{
	if (gestorXAttr != NULL)
	{
		delete gestorXAttr;
	}

	try
	{
		gestorXAttr = new GestorXAttr(nomFitxer);
		_fitxerObert = true;

		finestra->activacio(true);

		comprovarEditable();

		finestra->ompleAtributs(gestorXAttr->donarLlistaAtributs());
	}
	catch (GestorXAttrException e)
	{
		delete gestorXAttr;
		gestorXAttr = NULL;
		_fitxerObert = false;
		finestra->activacio(false);
	}
}

void EicielXAttrControler::eliminarAtribut(const Glib::ustring& nomAtrib)  throw (GestorXAttrException)
{
	gestorXAttr->eliminarAtribut(nomAtrib);
}

void EicielXAttrControler::afegirAtribut(const Glib::ustring& nomAtrib, const Glib::ustring& valorAtrib) throw (GestorXAttrException)
{
	gestorXAttr->afegirAtribut(nomAtrib, valorAtrib);
}

void EicielXAttrControler::actualitzarValorAtribut(const Glib::ustring& nomAtrib, const Glib::ustring& valorNouAtrib) throw (GestorXAttrException) 
{
	gestorXAttr->afegirAtribut(nomAtrib, valorNouAtrib);
}

void EicielXAttrControler::modificarNomAtribut(const Glib::ustring& nomAnticAtribut, const Glib::ustring& nomNouAtribut) throw (GestorXAttrException)
{
	gestorXAttr->canviarNomAtribut(nomAnticAtribut, nomNouAtribut);
}

void EicielXAttrControler::comprovarEditable()
{
	/*
	 * Comprovem que es el propietari o root
	 */
	uid_t real_user = getuid();
	if ((real_user != 0) && (real_user != gestorXAttr->donarUidPropietari()))
	{
		finestra->establirNomesLectura(true);
	}
	else
	{
		finestra->establirNomesLectura(false);
	}
	
}
