/* Copyright (C) 2005 Chris Vine

The library comprised in this file or of which this file is part is
distributed by Chris Vine under the GNU Lesser General Public
License as follows:

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License, version 2.1, for more details.

   You should have received a copy of the GNU Lesser General Public
   License, version 2.1, along with this library (see the file LGPL.TXT
   which came with this source code package in the src/utils sub-directory);
   if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA, 02111-1307, USA.

*/

#ifndef MUTEX_H
#define MUTEX_H

#include <pthread.h>

namespace Thread {

class Cond;

class Mutex {
  pthread_mutex_t pthr_mutex;
  
  // mutexes cannot be copied
  Mutex(const Mutex&);
  Mutex& operator=(const Mutex&);
public:
  class Lock;
  friend class Cond;

  int lock(void) {return pthread_mutex_lock(&pthr_mutex);}
  int trylock(void) {return pthread_mutex_trylock(&pthr_mutex);}
  int unlock(void) {return pthread_mutex_unlock(&pthr_mutex);}

  Mutex(void) {pthread_mutex_init(&pthr_mutex, 0);}
  ~Mutex(void) {pthread_mutex_destroy(&pthr_mutex);}
};

class Mutex::Lock {
  Mutex& mutex;

  // locks cannot be copied
  Lock(const Mutex::Lock&);
  Mutex::Lock& operator=(const Mutex::Lock&);
public:

  Lock(Mutex& mutex_): mutex(mutex_) {mutex.lock();}
  ~Lock(void) {mutex.unlock();}
};

class Cond {
  pthread_cond_t cond;

  // Cond cannot be copied
  Cond(const Cond&);
  Cond& operator=(const Cond&);
public:
  int signal(void) {return pthread_cond_signal(&cond);}
  int broadcast(void) {return pthread_cond_broadcast(&cond);}
  int wait(Mutex& mutex) {return pthread_cond_wait(&cond, &mutex.pthr_mutex);}

  Cond(void) {pthread_cond_init(&cond, 0);}
  ~Cond(void) {pthread_cond_destroy(&cond);}
};

} // namespace Thread

#endif
