/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#include <glib/gconvert.h>

#include "utf8_utils.h"
#include "shared_handle.h"


namespace Utf8 {

std::string filename_from_utf8(const std::string& input) {
  GError* error_p = 0;
  gsize written = 0;
  GcharScopedHandle result_h(g_filename_from_utf8((const char*)input.data(), input.size(), 0,
						  &written, &error_p));
    
  if (error_p) throw ConversionError(error_p);

  return std::string(result_h.get(), written);
}

std::string filename_to_utf8(const std::string& input) {
  GError* error_p = 0;
  gsize written = 0;
  GcharScopedHandle result_h(g_filename_to_utf8((const char*)input.data(), input.size(), 0,
						&written, &error_p));
    
  if (error_p) throw ConversionError(error_p);

  return std::string(result_h.get(), written);
}

std::string locale_from_utf8(const std::string& input) {
  GError* error_p = 0;
  gsize written = 0;
  GcharScopedHandle result_h(g_locale_from_utf8((const char*)input.data(), input.size(), 0,
						&written, &error_p));
    
  if (error_p) throw ConversionError(error_p);

  return std::string(result_h.get(), written);
}

std::string locale_to_utf8(const std::string& input) {
  GError* error_p = 0;
  gsize written = 0;
  GcharScopedHandle result_h(g_locale_to_utf8((const char*)input.data(), input.size(), 0,
					      &written, &error_p));
    
  if (error_p) throw ConversionError(error_p);

  return std::string(result_h.get(), written);
}

} // namespace Utf8_utils
