/* messages.c
 * Error, warning, and info messages, in your host language,
 * as determined by the variable $LANG.
 * Copyright (c) Karl Dahlke, 2008
 * This file is part of the edbrowse project, released under GPL.
 */

#include "eb.h"

#include "locale.h"
#include "wchar.h"

/* Arrays of messages, one array for each language. */

static const char *englishMessages[] = {
    "EOF",
    "no file",
    "none",
    "substitutions global",
    "substitutions local",
    "case insensitive",
    "case sensitive",
    "directories readonly",
    "directories writable",
    "directories writable with delete",
    "no http redirection",
    "http redirection",
    "do not send referrer",
    "send referrer",
    "javascript disabled",
    "javascript enabled",
    "treating binary like text",
    "watching for binary files",
    "passive mode",
    "active mode",
    "passive/active mode",
    "don't verify ssl connections (less secure)",
    "verify ssl connections",
    "don't show hidden files in directory mode",
    "show hidden files in directory mode",
    "text areas use unix newlines",
    "text areas use dos newlines",
    "end markers off",
    "end markers on listed lines",
    "end markers on",
    "javascript disabled, no action taken",
    "javascript is disabled, going straight to the url",
    "redirection interrupted by user",
    "empty",
    "new session",
    "no trailing newline",
    "directory mode",
    "binary data",
    "ok",
    " [binary]",
    "no title",
    "no description",
    "no keywords",
    "session %d\n",
    "SendMail link.  Compose your mail, type sm to send, then ^ to get back.",
    "line %d has been updated\n",
    "no subject",
    "no config file present",
    ".ebrc config file does not contain a subjfilter{...} block",
    "interrupt, type qt to quit completely",
    "edbrowse ready",
    "entered command line contains nulls; you can use \\0 in a search/replace string to indicate null",
    "authorization requested - type x to abort.",
    "too many redirections",
    "success",
    "directory",
    "redirect to %s delayed by %d seconds",
    "Username: ",
    "user name too long, limit %d characters",
    "Password: ",
    "password too long, limit %d characters",
    "your config file does not specify a cooky jar",
    "warning, the directory is inaccessible - the listing will be empty",
    "disaster, error message length %d is too long\n",
    "line %d: ",
    "browse error: ",
    "The following has been sent to your browser, but there is no buffer to contain it.",
    "no options",
    "form has been reset",
    "submitting form",
    "A separate window has been created in buffer %d\n",
    " many",
    " recommended",
    "]",
    "no options contain the string %s\n",
    "sending mail to %s\n",
    "Your information has been sent; watch for a reply via return mail.",
    "junk",
    "quit",
    "next",
    "delete",
    "ip delete",
    "-p option disables this feature",
    "no blacklist file specified, feature disabled",
    "end of message",
    "not yet implemented",
    "filename: ",
    "Sorry, file %s already exists.\n",
    "abbreviated ",
    "empty attachment",
    "attachment ",
    "no buffers left, atachment discarded",
    "could not copy the attachment into buffer %d",
    "cannot create file %s, attachment is discarded\n",
    "cannot write to file %s, attachment is discarded\n",
    "no mail",
    "%d messages\n",
    "spam",
    " from ",
    "?\tprint this help message.\nq\tquit this program.\nx\texit without changing anything on the mail server.\nspace\tread more of this mail message.\nn\tmove on to the next mail message.\nd\tdelete this message.\nj\tjunk this subject for ten days.\nJ\tjunk this subject for a year.\nw\twrite this message to a file and delete it.\nk\tkeep this message in a file, but don't delete it.\nu\twrite this message unformatted to a file, and delete it.",
    "cannot create file %s\n",
    "cannot write to file %s\n",
    "mail save, %d bytes",
    " appended",
    "this page is finished, please use your back key or quit",
    "Sorry, innerText update not yet implemented.",
    "no errors",
    "proxy authentication for a non-proxy url",
    "session %d is not active",
    "session 0 is invalid",
    "session %d is out of bounds, limit %d",
    "you are already in session %d",
    "expecting `w'",
    "expecting `w' on session %d",
    "Your limit of 1 million lines has been reached.\nSave your files, then exit and restart this program.",
    "absolute path name too long, limit %d chars",
    "directories are readonly, type dw to enable directory writes",
    "could not create " TRASHDIR " under your home directory, to hold the deleted files",
    "could not remove file %s",
    "Could not move %s to the trash bin, set dx mode to actually remove the file",
    "destination lies inside the block to be moved or copied",
    "no change",
    "cannot join one line",
    "cannot read from the database into another file",
    "cannot read different tables into the same session",
    "missing file name",
    "empty domain in url",
    "cannot write to a url",
    "cannot write to a database table",
    "cannot write an empty file",
    "cannot create %s",
    "cannot write to %s",
    "session is not interactive",
    "line %c is out of range",
    "cannot embed nulls in a shell command",
    "label %c not set",
    "invalid delimiter",
    "no remembered search string",
    "no remembered replacement string",
    "regular expression too long",
    "line ends in backslash",
    "unexpected closing )",
    "replacement string can only use $1 through $9",
    "%s modifier has no preceding character",
    "no closing ]",
    "no closing )",
    "empty buffer",
    "error in regular expression, %s",
    "unexpected error while evaluating the regular expression at line %d",
    "search string not found",
    "line number too large",
    "negative line number",
    "no regular expression after %c",
    "missing delimiter",
    "no lines match the g pattern",
    "all lines match the v pattern",
    "none of the marked lines were successfully modified",
    "operation interrupted",
    "no match",
    "no changes",
    "agent number %c is not defined",
    "could not print new directory",
    "could not establish current directory",
    "invalid directory",
    "cannot play audio from an empty buffer",
    "cannot play audio in browse mode",
    "cannot play audio in directory mode",
    "cannot play audio in database mode",
    "file has no suffix, use mt.xxx to specify your own suffix",
    "suffix is limited to 5 characters",
    "suffix .%s is not a recognized mime type, please check your config file.",
    "no file name or url to refresh",
    "not in database mode",
    "not in browse mode",
    "file name does not contain /",
    "file name ends in /",
    "invalid characters after the sm command",
    "you must specify exactly one of %s after the B command",
    "line does not contain an open %c",
    "both %c and %c are unbalanced on this line, try B%c or B%c",
    "line does not contain an unbalanced brace, parenthesis, or bracket",
    "cannot find the line that balances %c",
    "session %d is currently in browse mode",
    "session %d is currently in directory mode",
    "no file name",
    "end of buffer",
    "no more lines to join",
    "bad range",
    "cannot break lines in directory mode",
    "cannot break lines in database mode",
    "cannot break lines in browse mode",
    "unknown command %c",
    "%c not available in directory mode",
    "%c not available in database mode",
    "%c not available in browse mode",
    "zero line number",
    "no space after command",
    "the %c command cannot be applied globally",
    "invalid move/copy destination",
    "unexpected text after the %c command",
    "nothing to undo",
    "please enter k[a-z]",
    "cannot label an entire range",
    "backing up 0 is invalid",
    "warning: no buffers available to handle the ancillary window",
    "unexpected text after the q command",
    "cannot change the name of a directory",
    "cannot change the name of a table",
    "cannot append to another buffer",
    "no file specified",
    "cannot write to the directory; files are modified as you go",
    "cannot write to the database; rows are modified as you go",
    "unexpected text after the ^ command",
    "no previous text",
    "unexpected text after the M command",
    "destination session not specified",
    "no previous text, cannot back up",
    "cannot apply the g command to a range",
    "g not available in database mode",
    "cannot apply the i%c command to a range",
    "cannot use i< in a global command",
    "buffer %d is empty",
    "buffer %d contains more than one line",
    "cannot open %s",
    "cannot read from %s",
    "input text contains nulls",
    "line contains an embeded carriage return",
    "first line of %s is too long",
    "file is currently in buffer - please use the rf command to refresh",
    "cannot browse a binary file",
    "cannot browse an empty file",
    "this doesn't look like browsable text",
    "already browsing",
    "label %s is not found",
    "i not available in browse mode",
    "cannot run an insert command from an edbrowse function",
    "cannot read text into a database session",
    "command %c not yet implemented",
    "%d is out of range",
    "no options contain the string %s",
    "multiple options contain the string %s",
    "this is a button; use i* to push the button",
    "this is a submit button; use i* to push the button",
    "this is a reset button; use i* to push the button",
    "this is a textarea, you must edit it from session %d",
    "readonly field",
    "input field cannot contain a newline character",
    "input too long, limit %d characters",
    "field must be set to + or -",
    "you cannot clear a radio button; you must set another one",
    "%s is not an accessible file",
    "number expected",
    "session %d contains nulls",
    "sending a file requires method=post and enctype=multipart/form-data",
    "this is an input field, not a button",
    "this button is not part of a form",
    "no javascript associated with this button",
    "form does not include a destination url",
    "the action of the form is not a url",
    "javascript is disabled, cannot activate this form",
    "This form has changed from https to http, and is now insecure",
    "cannot submit using protocol %s",
    "%d is out of range, please use %c1 through %c%d",
    "%d is out of range, please use %c1, or simply %c",
    "cannot replace multiple instances of the empty string",
    "line exceeds %d bytes after substitution",
    "no regular expression after %c",
    "multiple numbers after the third delimiter",
    "unexpected substitution suffix after the third delimiter",
    "cannot use both a numeric suffix and the `g' suffix simultaneously",
    "sorry, cannot apply the bl command to lines longer than %d bytes",
    "replacement data contains newlines",
    "replacement data contains null characters",
    "cannot embed slash, newline, or null in a directory name",
    "destination file already exists",
    "cannot rename file to %s",
    "cannot embed nulls in an input field",
    "cannot embed newlines in an input field",
    "no input fields present",
    "no links present",
    "no buttons present",
    "multiple input fields present, please use %c1 through %c%d",
    "multiple links present, please use %c1 through %c%d",
    "multiple buttons present, please use %c1 through %c%d",
    "could not read the data from the server",
    "%s is not a url",
    "secure proxy not yet implemented",
    "cannot identify %s on the network",
    "the %s protocol is not supported by edbrowse, and is not included in the mime types in your config file",
    "warning: could not preload <buffer %d> with its initial text\n",
    "warning: fields without names will not be transmitted",
    "cannot connect to %s",
    "cannot establish a secure connection to %s, error %d",
    "The certificate for host %s could not be verified - SSL connection aborted",
    "could not send the request to the web server",
    "authorization method %s not recognized",
    "web page requires authorization",
    "login aborted",
    "cannot create temp file %s to uncompress the web page",
    "cannot write to temp file %s to uncompress the web page",
    "zcat cannot uncompress the data to reconstruct the web page",
    "cannot access the uncompressed web page in %s",
    "cannot read the uncompressed web page in %s",
    "could not spawn subcommand %s, errno %d",
    "ftp could not connect to remote host",
    "ftp could not connect to remote host (timed out)",
    "ftp transfer failed",
    "ftp transfer failed (timed out)",
    "ftp no such directory",
    "ftp could not change directory (timed out)",
    "ftp malformed url",
    "ftp usage error",
    "ftp error in login config file",
    "ftp library initialization failed",
    "ftp session initialization failed",
    "ftp unexpected error %d",
    "edbrowse was not compiled with database access",
    "missing alias in address book line %d",
    "missing : in address book line %d",
    "alias in address book line %d is too long, limit 15 characters",
    "email in address book line %d is too long, limit 63 characters",
    " email in address book line %d does not have an @",
    "cannot handle whitespace in email, address book line %d",
    "unprintable characters in your alias or email, address book line %d",
    "last line of your address book is not terminated",
    "cannot send data to the mail server",
    "cannot read data from the mail server",
    "line from the mail server is too long, or unterminated",
    "cannot locate the mail server %s",
    "cannot connect to the mail server",
    "warning: form url specifies a section %s, which will be ignored\n",
    "file %s is empty",
    "your email should begin with subject:",
    "empty subject line",
    "subject line too long, limit %d characters",
    "invalid characters in the subject line, please use only spaces and printable ascii text",
    ".signature is not a regular file",
    "cannot access .signature file",
    "cannot mail the binary file %s, perhaps this should be an attachment?",
    "either none or all of the attachments must be declared \"alternative\"",
    "too many recipients, limit %d",
    "No address book specified, please check your .ebrc config file",
    "alias %s not found in your address book",
    "no recipients specified",
    "session %d is empty, cannot atach",
    "cannot access attachment %s",
    "file %s is not a regular file, cannot attach",
    "file %s is empty, cannot attach",
    "unexpected prompt \"%s\" at the start of the sendmail session",
    "mail server doesn't recognize %s",
    "mail server rejected %s",
    "mail server is not ready to receive data, %s",
    "could not send mail message, %s",
    "no mail accounts specified, plese check your config file",
    "invalid account number %d, please use 1 through %d",
    "cannot send mail while in browse mode",
    "cannot send mail while in database mode",
    "cannot send mail from directory mode",
    "cannot mail binary data, should this be an attachment?",
    "cannot mail an empty file",
    "no recipient at line %d",
    "cannot cc or bcc to the first recipient",
    "no attachment at line %d",
    "invalid account number at line %d",
    "empty subject",
    "line %d should begin with to: attach: alt: account: or subject:",
    "there is no subject line",
    "no recipients specified, place to: emailaddress at the top of youre file",
    "%s:// expected",
    "unrecognized protocol %s",
    "invalid :port specifier at the end of the domain",
    "domain name too long",
    "user name too long",
    "password too long",
    "too many fetches from the internet, you may want to disable `redirect html'",
    "web page indirectly fetches itself, an infinite loop",
    "no function specified",
    "function name should only contain letters and numbers",
    "no such function %s",
    "too many arguments",
    "~%d has no corresponding argument",
    "could not spawn subcommand %s, errno %d",
    "could not create temp file %s, errno %d",
    "too many sql tables in cache, limit %d",
    "%s is not a regular file",
    "file is too large, limit 40MB",
    "cannot read the contents of %s",
    "cannot access %s",
    "environement variable %s not set",
    "cannot expand * ? or [] prior to the last /",
    "%s is not an accessible directory",
    "shell pattern is too long",
    "sorry, I don't know how to expand filenames with \\ in them",
    "improperly formed [] pattern",
    "error compiling the shell pattern, %s",
    "unexpected error while evaluating the shell pattern",
    "shell pattern does not match any files",
    "shell pattern matches more than one file",
    "line becomes too long when shell variables are expanded",
    "the config file does not specify the database - cannot connect",
    "cannot connect to the database - error %d",
    "unexpected sql error %d",
    "no key column specified",
    "column name %s is too long, limit %d characters",
    "syntax error in where clause",
    "column %d is out of range",
    "multiple columns match %s",
    "no column matches %s",
    "no such table %s",
    "invalid column name",
    "cannot select more than one blob column",
    "the data contains pipes, which is my reserved delimiter",
    "the data contains newlines",
    "line contains too many fields, please do not introduce any pipes into the text",
    "line contains too few fields, please do not remove any pipes from the text",
    "key column not specified",
    "miscelaneous sql error %d",
    "cannot delete more than 100 rows at a time",
    "cannot change a key column",
    "cannot change a blob field",
    "cannot change a text field",
    "oops!  I deleted %d row(s), and %d database record(s) were affected.",
    "oops!  I inserted %d row(s), and %d database record(s) were affected.",
    "oops!  I updated %d row(s), and %d database record(s) were affected.",
    "some other row in the database depends on this row",
    "row or table is locked",
    "you do not have permission to modify the database in this way",
    "deadlock detected",
    "placing null into a not-null column",
    "check constraint violated",
    "database timeout",
    "cannot modify a view",
    "no closing %s",
    "warning, javascript cannot be invoked through keystroke events",
    "javascript cannot be invoked through focus or blur",
    "onchange handler is not accessible",
    "%s is not part of a fill-out form",
    "%s does not have a name",
    "unrecognized method, plese use GET or POST",
    "unrecognized enctype, plese use multipart/form-data or application/x-www-form-urlencoded",
    "form cannot submit using protocol %s",
    "unrecognized input type %s",
    "multiple radio buttons have been selected",
    "%s is closed inside %s",
    "%s begins in the middle of %s",
    "an unexpected closure of %s, which was never opened",
    "a text area begins in the middle of a text area",
    "%s appears inside an anchor",
    "%s contains html tags",
    "option cannot contain a comma when it is part of a multiple select",
    "empty option",
    "multiple titles",
    "%s is not inside a list",
    "%s is not inside a table",
    "%s is not inside a table row",
    "option appears outside a select statement",
    "multiple options are selected",
    "unprocessed tag action %d",
    "%s is not closed at eof",
    "java is opening a blank window",
    "unexpected characters after the encoded attachment",
    "invalid characters in the encoded attachment",
    "onchange handler does not work with textarea",
    "warning, javascript cannot be invoked by a double click",
    "error resolving option %s during sync or form submit",
    "tag cannot have onunload and onclik handlers simultaneously",
    "script is not closed at eof, suspending javascript",
    "could not fetch local javascript, %s",
    "could not fetch javascript from %s, code %d",
    "could not fetch javascript, %s",
    "javascript disabled, skipping the onclick code",
    "javascript disabled, skipping the onchange code",
    "javascript disabled, skipping the onreset code",
    "javascript disabled, skipping the onsubmit code",
    "could not find the html tag associated with the javascript variable being modified",
    "javascript modified a textarea, and that isn't implemented yet",
    "warning: garbled refresh directive, %s\n",
    "warning: unrecognized http compression method %s\n",
    "warning: http redirection %d, but a new url is not specified\n",
    "warning: http error %d, %s\n",
    "warning: page does not have a recognizable http header",
    "warning: cannot update config file",
    "help messages on",
    "ftp download",
    "no ssl certificate file specified; secure connections cannot be verified",
    "could not rewrite your config file; your configuration data may be lost!",
    ".ebrc: null characters at line %d",
    ".ebrc: missing function name at line %d",
    ".ebrc: function name at line %d begins with a digit",
    ".ebrc: function name at line %d is too long, limit ten characters",
    ".ebrc: improper function definition syntax at line %d",
    ".ebrc: line %d, \"condition > file\" expected",
    ".ebrc: line %d, filter rule has no match string",
    ".ebrc: line %d, match on %s is set nowhere",
    ".ebrc: line %d, too many mail filters",
    ".ebrc: unrecognized keyword %s at line %d",
    ".ebrc: line %d, attribute %s canot be set outside of a mail descriptor",
    ".ebrc: line %d, attribute %s canot be set outside of a mime descriptor",
    ".ebrc: line %d, attribute %s canot be set outside of a table descriptor",
    ".ebrc: line %d, attribute %s canot be set inside a mail descriptor or filter block",
    ".ebrc: line %d, attribute %s canot be set inside a mime descriptor",
    ".ebrc: line %d, attribute %s canot be set inside a table descriptor",
    ".ebrc: line %d, attribute %s is set to nothing",
    ".ebrc: line %d, too many columns, limit %d",
    ".ebrc: line %d, keycol should be number or number,number",
    ".ebrc: line %d, keycol is out of range; only %d columns specified",
    ".ebrc: address book %s is not a regular file",
    ".ebrc: ip blacklist %s is not a regular file",
    ".ebrc: %s is not a directory",
    ".ebrc: line %d, too many user agents, limit 9",
    ".ebrc: cookie jar %s is not a regular file",
    ".ebrc: cannot create cookie jar %s",
    ".ebrc: too many no js directives, limit %d",
    ".ebrc: line %d, domain %s does not contain a dot",
    ".ebrc: mail trash can %s is not a regular file",
    ".ebrc: SSL certificate file %s is not a regular file",
    ".ebrc: SSL certificate file %s does not exist or is not readable.",
    ".ebrc: line %d, keyword %s is not yet implemented",
    ".ebrc: setting multiple mail accounts as default",
    ".ebrc: missing inserver at line %d",
    ".ebrc: missing outserver at line %d",
    ".ebrc: missing login at line %d",
    ".ebrc: missing password at line %d",
    ".ebrc: missing from at line %d",
    ".ebrc: missing reply at line %d",
    ".ebrc: missing type at line %d",
    ".ebrc: missing description at line %d",
    ".ebrc: missing suffix or protocol list at line %d",
    ".ebrc: missing program at line %d",
    ".ebrc: missing table name at line %d",
    ".ebrc: missing short name at line %d",
    ".ebrc: missing columns at line %d",
    ".ebrc: unexpected } at line %d",
    ".ebrc: else at line %d is not part of an if statement",
    ".ebrc: garbled text at line %d",
    ".ebrc: line %d, cannot start a function, mail/mime descriptor, or filter block inside %s",
    ".ebrc: statement at line %d must appear inside a function",
    "too many email accounts in your .ebrc config file, limit %d",
    "too many mime types in your .ebrc config file, limit %d",
    "too many sql tables in your .ebrc config file, limit %d",
    "too many functions in your .ebrc config file, limit %d",
    ".ebrc: line %d, control structures are nested too deeply",
    ".ebrc: function %s is not closed at eof",
    ".ebrc: mail or mime block is not closed at EOF",
    "home directory not defined by $HOME.",
    "%s is not a directory",
    "no mail accounts specified, please check your .ebrc config file",
    "invalid account number, please use 1 through %d",
    "edbrowse  -v    (show version)\n\edbrowse -h (this message)\n\edbrowse -c (edit config file)\n\edbrowse  [-e] [-d?] -[u|p]m?    (read your mail) \n\edbrowse  [-e] [-d?] -m? address1 address2 ... file [+attachments]\n\edbrowse  [-e] [-d?] file1 file2 ...",
    "please specify at least one recipient and the file to send",
    "please specify at least one recipient and the file to send, before your attachments",
    "too many files open simultaneously, limit %d",
    "invalid session %d in fetchLineContext()",
    "invalid line number %d in fetchLineContext()",
    "line %d->%d became null",
    "session %d out of range in cxActive",
    "double init on session %d",
    "quitting a nonactive session %d",
    "empty new piece in addToMap()",
    "no newline on directory entry %s",
    "no closing > at line %d",
    "fieldInBuffer could not find tag %d newtext %s",
    "cannot rebuild your cookie jar %s",
    "too many ip addresses in blacklist, limit %d",
    "fetchmail client is interactive, and cannot run in the background",
    "mailbox directory not specified in your .ebrc file",
    "Cannot change directory to %s",
    "Unexpected pop3 introduction <%s>",
    "Could not complete the pop3 login/password sequence <%s>",
    "Could not obtain status information on your mailbox <%s>",
    "error reading message from the server, errno %d",
    "cannot fetch mail message %d <%s>",
    "Sorry, you took too long; mail server hung up.",
    "unable to delete message <%s>",
    "tag code %d has bad character %c following",
    "calling preFormatTag without parsePage",
    "htmlParse() is not reentrant.",
    "unexpected input type in submitForm()",
    "list = 0 in tagFromJavaVar()",
    "empty host in httpConnect",
    "could not allocate memory for javascript operations.",
    "unable to create javascript context",
    "unable to create window object for javascript",
    "unable to create standard classes for javascript",
    "unable to create document object for javascript",
    "hostname:port is too long",
    "protocol: is too long",
    "error allocating %u bytes",
    "error callocating %u bytes",
    "reallocMem(p,0)",
    "reallocMem(0,%d)",
    "error re-allocating %u bytes",
    "stringInList(null,...)",
    "stringInListCI(null,...)",
    "charInList(null,...)",
    "null pointer in pstLength",
    "canot use ioctl() to manage the tty",
    "cannot open %s",
    "cannot create or write to %s",
    "calling fopen() with invalid mode %s",
    "misplaced / in getDirURL(%s)",
    "misplaced / in %s",
    "decodePostData(0,0)",
    "cannot convert pdf to html; make sure pdftohtml is installed, and try running it on %s",
    "only sendmail `auth login' method is supported at this time",
    "Could not complete the smtp login/password sequence <%s>",
    "cannot reply in directory mode",
    "cannot reply in database mode",
    "cannot reply to an empty file",
    "cannot reply to a binary file",
    "subject and reply lines are required",
    "warning, there is no message ID to reference",
    "Sorry, email headers are not available.\nYou must start with an unformatted email message, browse, then reply all.",
    "l expands control chars into hex",
    "l expands control and nonascii chars into hex",
    "Warning: search/substitution functions will not support utf8 characters,\nbecause your pcre library lacks this functionality.\nexport PCREUTF8=off to disable this feature and suppress this warning message.",
    "converting to iso8859",
    "converting to utf8",
    "do not convert between iso8859 and utf8",
    "automatically convert between iso8859 and utf8",
    "cannot copy a directory tree to your trash bin on another file system;\nuse cpio -p or cp -r from the shell",
    "cannot delete a directory tree; use rm -r from the shell",
};

/* Translation by Erwin Bliesenick: erwinb@no-log.org */
static const char *frenchMessages[] = {
    "EOF - fin de fichier",
    "pas de fichier",
    "rien",
    "substitutions globales",
    "substitutions locales",
    "insensible  la casse",
    "sensible  la casse",
    "rpertoires en lecture seule",
    "rpertoires en lecture criture",
    "rpertoires en lecture criture avec effacement",
    "pas de redirection http",
    "redirection http",
    "ne pas envoyer le rfrent",
    "envoyer le rfrent",
    "javascript ddactiv",
    "javascript activ",
    "binaire trait comme texte",
    "dtection des fichiers binaires",
    "mode passif",
    "mode actif",
    "mode passif/actif",
    "pas de vrification des connexions ssl (moins sr)",
    "vrification des connexions ssl",
    "ne pas afficher les fichiers cachs en mode rpertoire",
    "afficher les fichiers cachs en mode rpertoire",
    "fins de ligne unix dans les zones de texte",
    "fins de ligne dos dans les zones de texte",
    "marqueurs de fin de ligne dsactivs",
    "marqueurs de fin de ligne activs pour les lignes listes",
    "marqueurs de fin de ligne activs",
    "javascript dsactiv, aucune action lance",
    "javascript dsactiv, on va directement  l'url",
    "redirection interrompue par l'utilisateur",
    "vide",
    "nouvelle session",
    "pas de saut de ligne  la fin",
    "mode rpertoire",
    "donnes binaires",
    "ok",
    " [binaire]",
    "pas de titre",
    "pas de description",
    "pas de mots-cls",
    "session %d\n",
    "Envoi de courrier. Tapez votre courrier, tapez sm pour l'envoyer, puis ^ pour revenir.",
    "la ligne %d a t modifie\n",
    "pas de sujet",
    "pas de fichier de configuration",
    "pas de bloc subjfilter{...} dans le fichier de configuration .ebrc",
    "interruption, tapez qt pour quitter compltement",
    "edbrowse prt",
    "la ligne de commande contient des caractres nuls; vous pouvez utiliser \\0 dans une chane de recherche/remplacement pour indiquer le caractre nul",
    "autorisation ncessaire - tapez x pour annuler.",
    "trop de redirections",
    "succs",
    "rpertoire",
    "redirection vers %s retarde de %d secondes",
    "Nom d'utilisateur: ",
    "nom d'utilisateur trop long, la limite est de %d caractres",
    "Mot de passe: ",
    "nom de passe trop long, la limite est de %d caractres",
    "pas de rcipient pour les cookies dans votre fichier de configuration",
    "attention, rpertoire inaccessible - la liste des fichiers sera vide",
    "dsastre, message d'erreur %d trop long\n",
    "ligne %d: ",
    "erreur de navigation: ",
    "Le navigateur a reu la suite, mais il n'y a pas de tampon pour la recevoir",
    "pas d'options",
    "formulaire rinitialis",
    "formulaire en cours de soumission",
    "Une nouvelle fentre a t cre dans le tampon %d\n",
    " beaucoup",
    " recommend",
    "]",
    "aucune option ne contient la chane %s\n",
    "envoi du courrier  %s\n",
    "Envoi effectu; attendez une rponse par retour de courrier.",
    "indsirable",
    "quitter",
    "suivant",
    "effacement",
    "ip effac",
    "l'option -p dsactive cette fonctionnalit",
    "pas de fichier liste noire, fonctionnalit dsactive",
    "fin du message",
    "pas encore implment",
    "nom de fichier: ",
    "Dsol, le fichier %s existe dj.\n",
    "abrg ",
    "pice jointe vide",
    "pice jointe ",
    "plus de tampon disponible, pice jointe ignore",
    "impossible de copier la pice jointe dans le tampon %d",
    "impossible de crer le fichier %s, pice jointe ignore\n",
    "impossible de sauvegarder le fichier %s, pice jointe ignore\n",
    "pas de courrier",
    "%d messages\n",
    "spam",
    " from ",
    "?\taffiche ce message d'aide.\nq\tquitte ce programme.\nx\tquitte sans rien modifier sur le serveur de courrier.\nespace\tcontinuer la lecture de ce message.\nn\taller au message suivant.\nd\teffacer ce message.\nj\ttraiter ce sujet comme indsirable pendant dix jours.\nJ\ttraiter ce sujet comme indsirable pendant un an.\nw\tsauvegarder ce message et l'effacer.\nk\tsauvegarder ce message sans l'effacer.\nu\tsauvegader ce message non format, puis l'effacer.",
    "cration du fichier %s impossible\n",
    "sauvegarde du fichier %s impossible\n",
    "courrier sauvegard, %d octets",
    " ajout",
    "page termine, utilisez la touche retour arrire ou quittez",
    "Dsol, innerText n'est pas encore implment",
    "pas d'erreurs",
    "authentification proxy pour une url non-proxy",
    "session %d non active",
    "session 0 invalide",
    "dbordement de la session %d, la limite est de %d",
    "vous tes dj dans la session %d",
    "`w' attendu",
    "`w' attendu en session %d",
    "Vous avez atteint la limite d'un million de lignes.\nSauvegardez vos fichiers, puis sortez et redmarrez le programme.",
    "chemin du rpertoire trop long, la limite est de %d caractres",
    "rpertoires en lecture seule, tapez dw pour autoriser l'criture",
    "impossible de crer le fichier corbeille " TRASHDIR ", pour contenir vos fichiers effacs",
    "effacement du fichier %s impossible",
    "impossible de mettre %s  la corbeille, passez en mode dx pour l'effacer",
    "destination  l'intrieur du bloc  dplacer ou  copier",
    "pas de modification",
    "ne peut fusionner une seule ligne",
    "impossible de lire la base de donnes dans un autre fichier",
    "impossible de lire plusieurs tables dans la mme session",
    "nom de fichier absent",
    "nom de domaine vide dans l'url",
    "impossible d'crire sur une url",
    "impossible d'crire dans une table de base de donnes",
    "impossible de sauvegarder un fichier vide",
    "impossible de crer %s",
    "ne peut crire dans %s",
    "session non interactive",
    "ligne %c trop grande",
    "une commande shell ne peut contenir des caractres nuls",
    "label %c non dfini",
    "dlimiteur invalide",
    "chane de recherche non conserve",
    "chane de remplacement non conserve",
    "expression rgulire trop grande",
    "ligne termine par un anti-slash",
    "parenthse fermante inattendue",
    "on ne peut remplacer que de $1  $9",
    "le modificateur %s n'est prcd d'aucun caractre",
    "pas de crochet fermant",
    "pas de parenthse fermante",
    "tampon vide",
    "erreur dans l'expression rgulire, %s",
    "erreur inattendue en valuant l'expression rgulire %d",
    "chane de recherche non trouve",
    "numro de ligne trop grand",
    "numro de ligne ngatif",
    "pas d'expression rgulire aprs %c",
    "dlimiteur absent",
    "aucune ligne ne correspond au modle g",
    "toutes les lignes correspondent au modle v",
    "aucune des lignes marques n'a pu tre modifie avec succs",
    "opration interrompue",
    "pas de correspondance",
    "pas de changements",
    "l'agent numro %c n'est pas dfini",
    "impossible d'afficher le nouveau rpertoire",
    "impossible d'tablir le rpertoire courant",
    "rpertoire invalide",
    "lecture audio impossible  partir d'un tampon vide audio",
    "lecture audio impossible en mode navigation",
    "lecture audio impossible en mode rpertoire",
    "lecture audio impossible en mode base de donnes",
    "le fichier n'a pas d'extension, utilisez mt.xxx pour dfinir votre propre extension",
    "extension limite  5 caractres",
    "l'extension .%s n'est pas un type mime connu, vrifiez votre fichier de configuration.",
    "pas de nom de fichier ou d'url  rafficher",
    "pas en mode base de donnes",
    "pas en mode navigation",
    "le nom de fichier ne contient pas le caractre /",
    "le nom de fichier se termine par le caractre /",
    "commande sm suivie de caractres invalides",
    "vous devez spcifier exactement un %s aprs la commande B",
    "la ligne ne contient pas de %c ouvrant(e)",
    "%c et %c non quilibrs sur cette ligne, essayez B%c ou B%c",
    "la ligne ne contient pas de parenthses, de crochets ou d'accolades non quilibrs",
    "ne peux trouver de ligne quilibrant %c",
    "session %d actuellement en mode navigation",
    "session %d actuellement en mode rpertoire",
    "pas de nom de fichier",
    "fin du tampon",
    "plus de lignes  fusionner",
    "mauvais intervalle",
    "impossible de dcouper les lignes en mode rpertoire",
    "impossible de dcouper les lignes en mode base de donnes",
    "impossible de dcouper les lignes en mode navigation",
    "commande %c inconnue",
    "%c impossible en mode rpertoire",
    "%c impossible en mode base de donnes",
    "%c impossible en mode navigation",
    "ligne numro zro",
    "pas d'espace aprs la commande",
    "la commande %c ne peut s'appliquer globalement",
    "destination du dplacement ou de la copie invalide",
    "texte inattendu aprs la commande %c",
    "rien  dfaire",
    "tapez svp k[a-z]",
    "impossible d'tiqueter un intervalle entier",
    "ne peux sauvegarder 0",
    "attention : pas de tampon pour grer la fentre auxiliaire",
    "texte inattendu aprs la commande q",
    "impossible de renommer le rpertoire",
    "impossible de renommer la table",
    "impossible d'ajouter  un autre tampon",
    "pas de fichier spcifi",
    "ne peut mettre  jour le rpertoire; les fichiers seront modifis quand vous quitterez",
    "ne peut mettre  jour la base de donnes; les lignes seront modifies quand vous quitterez",
    "texte inattendu aprs la commande ^",
    "pas de texte antrieur",
    "texte inattendu aprs la commande M",
    "destination de la session non spcifie",
    "pas de texte antrieur, sauvegarde impossible",
    "impossible d'appliquer la commande g  un intervalle",
    "g impossible en mode base de donnes",
    "impossible d'appliquer la commande i%c  un intervalle",
    "impossible d'utiliser i< dans une commande globale",
    "le tampon %d est vide",
    "le tampon %d contient plus d'une ligne",
    "impossible d'ouvrir %s",
    "impossible de lire %s",
    "le texte entr contient des caractres nuls",
    "il y a un retour-chariot dans la ligne",
    "le premire ligne de %s est trop longue",
    "le fichier est actuellement dans le tampon - utilisez la commande rf pour le rafficher",
    "navigation impossible dans un fichier binaire",
    "navigation impossible dans un fichier vide",
    "ce contenu ne semble pas navigable",
    "en cours de navigation",
    "label %s non trouv",
    "i impossible en mode navigation",
    "impossible de lancer une commande d'insertion  partir d'une fonction d'edbrowse",
    "impossible de lire du texte dans une session base de donnes",
    "commande %c non implmente",
    "%d hors limites",
    "aucune option ne contient la chane %s",
    "de multiples options contiennent la chane %s",
    "c'est un bouton; tapez i* pour le dclencher",
    "c'est un bouton de validation; tapez i* pour le dclencher",
    "c'est un bouton d'annulation; tapez i* pour le dclencher",
    "c'est une zone de texte, vous devez l'diter dans la session %d",
    "champ en lecture seule",
    "une zone de saisie ne peut contenir un saut de ligne",
    "saisie trop long, la limite est de %d caractres",
    "le champ doit tre dfini + or -",
    "vous ne pouvez rinitialiser un bouton radio; vous devez en activer un autre",
    "%s n'est pas un fichier accessible",
    "nombre attendu",
    "la session %d contient des caractres nuls",
    "l'envoi d'un fichier exige 'method=post and enctype=multipart/form-data'",
    "c'est une zone de saisie, pas un bouton",
    "ce bouton ne fait pas partie d'un formulaire",
    "pas de javascript associ  ce bouton",
    "le formulaire n'inclut aucune URL de destination",
    "l'action de ce formulaire ne renvoie pas  une destination URL",
    "javascript dsactiv, impossible d'activer ce formulaire",
    "Le formulaire est pass du mode https au mode http, il n'est plus scuris",
    "impossible de soumettre avec le protocole %s",
    "%d hors limites, utilisez s'il vous plait %c1  %c%d",
    "%d hors limites, utilisez s'il vous plait  %c1, ou simplement %c",
    "impossible de remplacer plusieurs fois la chane vide",
    "la ligne dpasse %d caractres aprs la substitution",
    "pas d'expression rgulire aprs %c",
    "nombres multiples aprs le troisime dlimiteur",
    "suffixe de substitution inattendu aprs le troisime dlimiteur",
    "impossible d'utiliser simultanment un suffixe numrique et le suffixe `g'",
    "dsol, impossible d'excuter la commande bl sur les lignes excdant %d caractres",
    "les donnes de remplacement contiennent des sauts de ligne",
    "les donnes de remplacement contiennent des caractres nuls",
    "un nom de rpertoire ne peut contenir un slash, un saut de ligne ou un caractre nul",
    "le fichier destination existe dj",
    "impossible de renommer le fichier  %s",
    "une zone de saisie ne peut contenir des caractres nuls",
    "une zone de saisie ne peut contenir des sauts de ligne",
    "aucune zone de saisie prsente",
    "aucun lien prsent",
    "aucun bouton prsent",
    "il y a plusieurs zones de saisie, utilisez svp %c1  %c%d",
    "il y a plusieurs liens, utilisez svp %c1  %c%d",
    "il y a plusieurs boutons, utilisez svp %c1  %c%d",
    "impossible de lire les donnes sur le serveur",
    "%s n'est pas une url",
    "proxy scuris non implment",
    "impossible d'identifier %s sur le rseau",
    "le protocole %s n'est pas support par edbrowse, et n'est pas dfini dans les types mime de votre fichier de configuration",
    "attention : impossible de prcharger le texte initial dans le <tampon %d>\n",
    "attention : les champs dpourvus de nom ne seront pas transmis",
    "connexion impossible  %s",
    "connexion scurise impossible  %s, erreur %d",
    "Le certificat de scurit de l'hte %s ne peut tre vrifi - connexion SSL abandonne",
    "impossible d'envoyer la requte au serveur web",
    "mthode d'autorisation %s inconnue",
    "la page web requiert une autorisation",
    "authentification abandonne",
    "impossible de crer le fichier temporaire %s pour dcompresser la page web",
    "impossible d'crire dans le fichier temporaire %s pour dcompresser la page web",
    "zcat ne peut dcompresser les donnes pour reconstruire la page web",
    "impossible d'accder  la page web dcompresse dans %s",
    "impossible de lire la page web dcompresse dans %s",
    "impossible de crer la sous-commande %s, erreur numro %d",
    "connexion ftp impossible  l'hte distant",
    "connexion ftp impossible  l'hte distant (dlai dpass)",
    "chec du transfert ftp",
    "chec du transfert ftp (dlai dpass)",
    "ftp : rpertoire inexistant",
    "ftp : ne peut changer de rpertoire (dlai dpass)",
    "ftp : url mal forme",
    "ftp : erreur d'utilisation",
    "ftp : erreur d'authentification dans le fichier de configuration",
    "ftp : chec de l'initialisation de la librairie",
    "ftp : chec de la session d'initialisation",
    "ftp : erreur inattendue %d",
    "edbrowse n'a pas t compil avec l'accs aux bases de donnes",
    "alias manquant dans le carnet d'adresses  la ligne %d",
    "manquant dans le carnet d'adresses  la ligne %d",
    "alias trop long dans le carnet d'adresses, limite 15 caractres",
    "email trop long dans le carnet d'adresses, limite 63 caractres",
    " pas de @ dans l'email  la ligne %d du carnet d'adresses",
    "espaces interdits dans un email,  la ligne %d du carnet d'adresses",
    "caractres non imprimables dans un alias ou un email,  la ligne %d du carnet d'adresses",
    "la dernire ligne de votre carnet d'adresses n'est pas termine",
    "impossible d'envoyer les donnes au serveur de courrier",
    "donnes du serveur de courrier impossibles  lire",
    "la ligne envoye par le serveur de courrier est trop longue, ou n'est pas close",
    "impossible de localiser le serveur de courrier %s",
    "impossible de se connecter au serveur de courrier",
    "attention : le formulaire url spcifie une section %s, qui sera ignore\n",
    "le fichier %s est vide",
    "votre mail devrait commencer par 'subject:':",
    "ligne sujet vide",
    "ligne sujet trop longue, la limite est de %d caractres",
    "caractres invalides dans la ligne sujet, n'utilisez svp que des espaces ou des caractres imprimables",
    ".signature n'est pas un fichier rgulier",
    "impossible d'accder au fichier .signature",
    "impossible d'envoyer le fichier binaire %s, serait-ce une pice jointe ?",
    "aucune ou bien toutes les pices jointes doivent tre spcifies \"alternative\"",
    "trop de destinataires, la limite est de %d",
    "Pas de carnet d'adresses dfini, contrlez votre fichier de configuration .ebrc",
    "impossible de trouver l'alias %s dans votre carnet d'adresses",
    "aucun destinataire spcifi",
    "la session %d est vide, impossible de joindre quelque chose",
    "impossible d'accder  la pice jointe %s",
    "impossible de joindre le fichier %s, ce n'est pas un fichier rgulier",
    "le fichier %s est vide, impossible de le joindre",
    "invite inattendue \"%s\" au dpart de la session d'envoi",
    "le serveur de courrier ne reconnait pas %s",
    "le serveur de courrier a rejet %s",
    "le serveur de courrier n'est pas prt  recevoir les donnes, %s",
    "impossible d'envoyer le courrier, %s",
    "pas de comptes de courrier dfinis, contrlez votre fichier de configuration",
    "numro de compte de courrier invalide %d, utilisez 1  %d",
    "impossible d'envoyer du courrier en mode navigation",
    "impossible d'envoyer du courrier en mode base de donnes",
    "impossible d'envoyer du courrier en mode rpertoire",
    "impossible d'envoyer des donnes binaires, serait-ce une pice jointe ?",
    "impossible d'envoyer un fichier vide",
    "pas de destinataire  la ligne %d",
    "impossible de mettre le premier destinataire en cc ou bcc",
    "pas de pice jointe  la ligne %d",
    "numro de compte de courrier invalide  la ligne %d",
    "pas de sujet",
    "la ligne %d devrait dbuter par to: attach: alt: account: ou subject:",
    "pas de ligne subject",
    "pas de destinataires spcifis, placez to: adresse email au dbut de votre fichier",
    "%s:// attendu",
    "protocole %s non reconnu",
    ":port invalide  la fin du nom de domaine",
    "nom de domaine trop long",
    "nom d'utilisateur trop long",
    "mot de passe trop long",
    "trop de donnes provenant de l'internet, peut-tre faudrait-il dsactiver `redirect html'",
    "la page web s'appelle elle-mme indirectement, c'est une boucle infinie",
    "pas de fonction spcifie",
    "les noms de fonction ne peuvent contenir que des lettres et des chiffres",
    "fonction %s non trouve",
    "trop d'arguments",
    "~%d n'a pas d'argument correspondant",
    "impossible de crer la sous-commande %s, erreur numro %d",
    "impossible de crer le fichier temporaire %s, erreur numro %d",
    "trop de tables sql dans le cache, la limite est de %d",
    "%s n'est pas un fichier rgulier",
    "fichier trop grand, la limite est de 40MB",
    "impossible de lire le contenu de %s",
    "impossible d'accder  %s",
    "la variable d'environnement %s n'est pas dfinie",
    "impossible de dvelopper * ? ou [] antrieur au dernier /",
    "%s n'est pas un rpertoire accessible",
    "modle shell trop long",
    "dsol, j'ignore comment dvelopper les noms de fichiers contenant \\",
    "modle [] mal form",
    "erreur de compilation du modle shell, %s",
    "erreur inattendue d'valuation du modle shell",
    "le modle shell ne correspond  aucun nom de fichier",
    "le modle shell correspond  plusieurs noms de fichier",
    "ligne trop longue aprs expansion des variables shell",
    "le fichier de config ne dfinit aucune base de donnes - connexion impossible",
    "connexion  la base de donnes impossible - erreur %d",
    "erreur sql inattendue %d",
    "pas de colonne index spcifie",
    "nom de colonne %s trop long, la limite est de %d caractres",
    "erreur de syntaxe dans la clause where",
    "dbordement dans la colonne %d",
    "plusieurs colonnes correspondent  %s",
    "aucune colonne ne correspond  %s",
    "la table %s n'existe pas",
    "nom de colonne invalide",
    "impossible de slectionner plus d'une colonne contenant des donnes binaires",
    "les donnes contiennent le caractre pipe, rserv comme dlimiteur de champ",
    "les donnes contiennent des sauts de ligne",
    "trop de champs dans la ligne, s'il vous plait, ne mettez pas de caractres pipe dans le texte",
    "pas assez de champs dans la ligne, s'il vous plait, ne supprimez pas de caractres pipe dans le texte",
    "colonne index non spcifie",
    "erreur sql %d",
    "impossible de supprimer plus de 100 lignes  la fois",
    "impossible de modifier une colonne index",
    "impossible de modifier un champ de donnes binaires",
    "impossible de modifier un champ de texte",
    "oups!  j'ai supprim %d ligne(s), et %d enregistrement(s) de la base de donnes ont t affects.",
    "oups!  j'ai supprim %d ligne(s), et %d enregistrement(s) de la base de donnes ont t affects.",
    "oups!  j'ai supprim %d ligne(s), et %d enregistrement(s) de la base de donnes ont t affects.",
    "d'autres lignes de la base de donnes dpendent de cette ligne",
    "la ligne ou la table sont verrouilles",
    "vous n'avez pas la permission de modifier la base de donnes par ce moyen",
    "deadlock (verrou mortel) dtect",
    "placement d'un null dans une colonne non null",
    "violation de contrainte",
    "dpassement de dlai de la base de donnes",
    "impossible de modifier une vue",
    "pas de fermeture de %s",
    "attention, javascript ne peut tre invoqu par un vnement clavier",
    "javascript ne peut tre invoqu par un focus ou un blur",
    "gestionnaire onchange inaccessible",
    "%s n'appartient pas  un formulaire",
    "%s n'a pas de nom",
    "mthode inconnue, utilisez s'il vous plat GET ou POST",
    "codage enctype non reconnu, utilisez s'il vous plat multipart/form-data or application/x-www-form-urlencoded",
    "le formulaire ne peut tre soumis en utilisant le protocole %s",
    "saisie de type inconnu %s",
    "plusieurs boutons radio ont t activs",
    "%s est inclus dans %s",
    "%s dbute au milieu de %s",
    "fermeture inattendue de %s, qui n'a jamais t ouvert",
    "une zone de texte dbute au milieu d'une zone de texte",
    "%s apparat dans une ancre",
    "%s contient des balises html",
    "l'option ne peut contenir une virgule lorsqu'elle fait partie d'une slection multiple",
    "option vide",
    "titres multiples",
    "%s n'est pas dans une liste",
    "%s n'est pas dans une table",
    "%s n'est pas dans une ligne de la table",
    "option apparat  l'extrieur d'un ordre select",
    "de multiples options sont slectionnes",
    "commande %d du tag non traite",
    "%s non ferm  la fin du fichier",
    "java ouvre une fentre vide",
    "caractres inattendus aprs la pice jointe encode",
    "caractres invalides dans la pice jointe encode",
    "le gestionnaire handler ne fonctionne pas avec les zones de texte",
    "attention, javascript ne peut tre invoqu par un double clic",
    "erreur de dtermination de l'option %s pendant la synchronisation ou la soumission du formulaire",
    "une balise ne peut simultanment grer onunload and onclik",
    "le script n'est pas clos en fin de fichier, javascript est suspendu",
    "impossible de charger localement javascript, %s",
    "impossible de charger javascript depuis %s, code %d",
    "impossible de charger javascript, %s",
    "javascript dsactiv, code onclick ignor",
    "javascript dsactiv, code onchange ignor",
    "javascript dsactiv, code onreset ignor",
    "javascript dsactiv, code onsubmit ignor",
    "impossible de trouver la balise html associe  la variable javascript modifie",
    "javascript a modifi une zone de texte, et ce n'est pas encore implment",
    "attention : directive de rafrachissement altre, %s\n",
    "attention : mthode %s de compression http inconnue\n",
    "attention: redirection http %d, mais la nouvelle url n'a pas t spcifie\n",
    "attention : erreur html %d, %s\n",
    "attention : la page n'a pas d'en-tte http reconnaissable",
    "attention : impossible de modifier le fichier de configuration",
    "messages d'aide activs",
    "tlchargement ftp",
    "pas de fichier de certificats ssl; les connexions scurises ne pourront tre vrifies",
    "Impossible de r-crire votre fichier de configuration : les donnes risquent d'tre perdues !",
    "Caractres nuls  la ligne %d",
    ".ebrc : pas de nom de fonction  la ligne %d",
    ".ebrc : le nom de fonction  la ligne %d commence par un chiffre",
    ".ebrc : nom de fonction  la ligne %d trop long : la limite est de dix caractres",
    ".ebrc : erreur de syntaxe dans la dfinition de fonction  la ligne %d",
    ".ebrc : ligne %d,  \"condition > fichier\" attendu",
    ".ebrc : ligne %d, la rgle de filtrage ne correspond  aucune chane",
    ".ebrc : ligne %d, la correspondance sur %s n'est pas dfinie",
    ".ebrc : ligne %d, trop de filtres de courrier",
    ".ebrc : mot cl %s inconnu  la ligne %d",
    ".ebrc : ligne %d, l'attribut %s ne peut tre dfini hors d'un descripteur de courrier",
    ".ebrc : ligne %d, l'attribut %s ne peut tre dfini hors d'un descripteur mime",
    ".ebrc : ligne %d, l'attribut %s ne peut tre dfini hors d'un descripteur de table",
    ".ebrc : ligne %d, l'attribut %s ne peut tre dfini dans un descripteur de courrier ou un bloc de filtrage",
    ".ebrc : ligne %d, l'attribut %s ne peut tre dfini dans un descripteur mime",
    ".ebrc : ligne %d, l'attribut %s ne peut tre dfini dans un descripteur de table",
    ".ebrc : ligne %d, l'attribut %s n'est pas dfini",
    ".ebrc : ligne %d,trop de connes, la limite est de %d",
    ".ebrc : ligne %d, la colonne index ne peut tre que numrique",
    ".ebrc : colonne index hors limites; seules %d colonnes ont t spcifies",
    ".ebrc : le carnet d'adresses %s n'est pas un fichier rgulier",
    ".ebrc : la liste noirs des IP n'est pas un fichier rgulier",
    ".ebrc : %s n'est pas un rpertoire",
    ".ebrc : ligne %d, trop d'agents utilisateurs, la limite est de 9",
    ".ebrc : le rcipient de cookies n'est pas un fichier rgulier",
    ".ebrc : impossible de crer  le rcipient de cookies",
    ".ebrc : trop de directives no js, la limite est de %d",
    ".ebrc : ligne %d, le domaine ne contient pas de point",
    ".ebrc : la corbeille de courrier n'est pas un fichier rgulier",
    ".ebrc : le fichier de certificats SSL n'est pas un fichier rgulier",
    ".ebrc :  fichier de certificats SSL absent ou illisible",
    ".ebrc : ligne %d, le mot-cl %s n'est pas encore implment",
    ".ebrc : plus d'un compte mail est dfini comme compte par dfaut",
    ".ebrc : serveur entrant manquant",
    ".ebrc : serveur sortant manquant",
    ".ebrc : nom d'utilisateur manquant",
    ".ebrc : mot de passe manquant",
    ".ebrc : ligne from manquante  la ligne %d",
    ".ebrc : ligne reply manquante  la ligne %d",
    ".ebrc : type manquant  la ligne %d",
    ".ebrc : description manquante  la ligne %d",
    ".ebrc : suffixe ou liste de protocoles manquants  la ligne %d",
    ".ebrc : programme manquant  la ligne %d",
    ".ebrc : nom de table manquant  la ligne %d",
    ".ebrc : surnom manquant  la ligne %d",
    ".ebrc : colonnes manquantes  la ligne %d",
    ".ebrc : } inattendue  la ligne %d",
    ".ebrc : else  la ligne %d ne fait pas partie d'une instruction",
    ".ebrc : texte altr  la ligne %d",
    ".ebrc : la ligne %d ne peut lancer une fonction, un descripteur mime ou de type, ou un filtre dans %s",
    ".ebrc : l'instruction  la ligne %d doit apparatre dans une fonction",
    "Trop de comptes de courrier dans votre fichier de configuration, la limite est de %d",
    "Trop de types mime dans votre fichier de configuration, la limite est de %d",
    "Trop de tables sql dans votre fichier de configuration, la limite est de %d",
    "Trop de fonctions dans votre fichier de configuration, la limite est de %d",
    ".ebrc : ligne %d, trop de structures imbriques",
    ".ebrc : la fonction %s n'est pas ferme",
    ".ebrc : le bloc mime ou courrier n'est pas ferm",
    "Votre rpertoire personnel n'est pas dfini par la variable $HOME",
    "%s n'est pas un rpertoire",
    "Pas de comptes de courrier dfinis, vrifiez votre fichier .ebrc",
    "Numro de compte de courrier invalide, utilisez svp de 1  %d",
    "edbrowse  -v    (montre version)\n\edbrowse -h (ce message)\n\edbrowse -c (edit fichier config)\n\edbrowse  [-e] [-d?] -[u|p]m?    (lecture courrier \n\edbrowse  [-e] [-d?] -m? adresse1 adresse2 ... fichier [+pices jointes]\n\edbrowse  [-e] [-d?] fichier1 fichier2 ...",
    "Dfinissez s'il vous plat au moins un destinataire et le fichier  envoyer",
    "Dfinissez s'il vous plat au moins un destinataire et le fichier  envoyer, avant vos pices jointes",
    "Trop de fichiers ouverts, la limite est de %d",
    "Session %d invalide dans la fonction fetchLineContext()",
    "Numro %d de ligne invalide dans la fonction fetchLineContext()",
    "La ligne %d->%d est devenue nulle",
    "La session %d est hors limites dans cxActive",
    "Double init dans la session %d",
    "Quitte la session %d inactive",
    "Nouveau morceau vide dans la fonction addToMap()",
    "Pas de retour-chariot aprs la ligne du rpertoire %s",
    "Pas de caractre  > dans la ligne %d",
    "FieldInBuffer ne peut trouver le tag %d nouveau texte %s",
    "Impossible de reconstruire votre rcipient %s de cookies",
    "Trop d'adresse IP en liste noire, la limite est de %d",
    "Le client de courrier est interactif, et ne peut tre lanc en arrire-fond",
    "rpertoire de courrier non dfini dans votre fichier .ebrc",
    "Ne peut aller dans le rpertoire %s",
    "Introduction pop3 inattendue <%>",
    "Squence pop3 nom utilisateur/mot de passe interrompue <%s>",
    "Ne peut obtenir le statut de votre bote  lettres",
    "Erreur de lecture du message sur le serveur, numro d'erreur %d",
    "Impossible de rcuprer le message %d <%s>",
    "Dsol, vous avez pris trop de temps; le serveur de courrier a raccroch",
    "Impossible de supprimer le message <%s>",
    "Le tag %d est suivi d'un caractre %c erron",
    "Appel de preFormat sans parsePage",
    "HtmlParse() n'est pas rentrant",
    "Type de donnes inattendu dans submitForm()",
    "List = 0 dans tagFromJavaVar()",
    "Pas de nom d'hte dans httpConnect",
    "Impossible d'allouer de la mmoire pour les oprations javascript",
    "Impossible de crer un contexte javascript",
    "Impossible de crer un objet fentre pour javascript",
    "Impossible de crer les classe standards pour javascript",
    "Impossible de crer un document objet pour javascript",
    "Hostname:port trop long",
    "Protocol: trop long",
    "Erreur alloc de %u octets",
    "Erreur calloc de %u octets",
    "reallocMem(p,0)",
    "reallocMem(0,%d)",
    "Erreur de r-allocation de %u octets",
    "StringInList(null,...)",
    "StringInListCI(null,...)",
    "charInList(null,...)",
    "Pointeur nul dans pstLength",
    "Impossible d'utiliser ioctl() pour grer le terminal",
    "Impossible d'ouvrir %s",
    "Impossible de crer ou d'crire %s",
    "Mode d'appel %s de fopen() invalide",
    "/ mal plac dans getDirUrl(%s)",
    "/ mal plac dans %s",
    "decodePostData(0,0)",
    "impossible de convertir le pdf en html : assurez-vous d'avoir pdftohtml install, et essayez de le lancer sur %s",
    "seule la squence `auth login' de sendmail est supporte jusqu' prsent",
    "Squence smtp nom utilisateur/mot de passe interrompue <%s>",
    "impossible de rpondre en mode rpertoire",
    "impossible de rpondre en mode base de donnes",
    "impossible de rpondre  un fichier vide",
    "impossible de rpondre  un fichier binaire",
    "lignes 'subject' et 'reply' obligatoires",
    "attention, pas d'identificateur ID de message pour le rfrencer",
    "Dsol, pas d'en-ttes de courrier.\nVous devez commencer avec un courrier non format, le consulter, puis rpondre  tous.",
    "l affiche tous les caractres de contrle en hexadcimal",
    "l affiche tous les caractres non-ascii et de contrle en hexadcimal",
    "Attention : les fonctions de recherche/remplacement ne fonctionneront pas avec les caractres utf8,\nparce que cette fonctionnalit est absente de la librairie pcre.\nExportez PCREUT8=off pour dsactiver cette fonctionnalit et supprimer ce message d'avertissement",
    "converti en utf8",
    "converti en iso8859",
    "pas de conversion entre iso8859 et utf8",
    "conversion automatique entre iso8859 et utf8",
    "impossible de copier un rpertoire dans la corbeille sur un autre systme de fichiers;n utilisez cpio -p ou cp -r  partir du shell",
    "impossible de supprimer un rpertoire; utilisez rm -r  partir du shell",
};

/* Translation by Cleverson: clever92000@yahoo.com.br */
static const char *brazilianPortugueseMessages[] = {
    "Fim do arquivo",
    "nenhum arquivo",
    "nenhum",
    "substituio  global",
    "substituio  local",
    "no diferencia maisculas",
    "diferencia maisculas",
    "diretrio  somente leitura",
    "diretrio pode ser escrito",
    "diretrio pode ser escrito e seu contedo apagado",
    "sem redirecionamento http",
    "redirecionamento http",
    "no envia referncia",
    "envia referncia",
    "javascript desligado",
    "javascript ligado",
    "criando binrio como texto",
    "cuidando arquivos binrios",
    "modo passivo",
    "modo ativo",
    "modo passivo/ativo",
    "no verifica conexes SSL (menos seguro)",
    "verifica conexes SSL",
    "no exibe arquivos ocultos no modo diretrio",
    "exibe arquivos ocultos no modo diretrio",
    "reas de edio usam fim de linha Unix",
    "reas de edio usam fim de linha DOS",
    "marcadores de fim desligados",
    "marcadores de fim em linhas listadas",
    "marcadores de fim ligados",
    "javascript desativado; nenhuma ao",
    "javascript est desativado;indo direto  URL",
    "redirecionamento interrompido pelo usurio",
    "vazio",
    "nova sesso",
    "nenhum espao de linha nova",
    "modo diretrio",
    "dados binrios",
    "OK",
    " [binrio]",
    "sem ttulo",
    "sem descrio",
    "sem palavras chave",
    "sesso %d\n",
    "linque de correio.  Escreva a carta, digite sm para enviar e depois ^ para voltar.",
    "linha %d atualizada\n",
    "sem assunto",
    "sem arquivo de configurao",
    "arquivo de configurao .ebrc no contm blocos subjfilter{...}",
    "interrompendo; digite qt para sair completamente",
    "edbrowse ativado",
    "comando contm caracteres nulos; voc pode usar \\0 numa cadeia de busca/substituio para indicar nulos",
    "autorizao solicitada - digite x para cancelar.",
    "redirecionamentos demais",
    "sucesso",
    "diretrio",
    "redireo para %s atrasada em %d segundos",
    "Nome de usurio: ",
    "nome de usurio longo demais; limite %d caracteres",
    "Senha: ",
    "senha longa demais; limite %d caracteres",
    "arquivo de configurao no especifica uma cooky jar",
    "aviso: diretrio inacessvel - listagem ficar vazia",
    "catstrofe; mensagem de erro %d  comprida demais\n",
    "linha %d: ",
    "erro de navegao: ",
    "O que segue foi enviado ao navegador, mas no h buffer para exibir.",
    "sem opes",
    "formulrio limpo",
    "submetendo formulrio",
    "criada janela separada no buffer %d\n",
    " muitos",
    " recomendado",
    "]",
    "sem opes com a cadeia %s\n",
    "enviando carta para %s\n",
    "informao enviada; aguarde resposta por e-mail.",
    "lixo",
    "sair",
    "prximo",
    "apagar",
    "apagar IP",
    "a opo -p desativa este recurso",
    "nenhum arquivo de lista negra especificado; recurso desativado",
    "fim da mensagem",
    "no implementado ainda",
    "nome do arquivo: ",
    "arquivo %s j existe.\n",
    "abreviado",
    "anexo vazio",
    "anexo ",
    "sem buffers; anexos descartados",
    "no foi possvel copiar o anexo para o buffer %d",
    "impossvel criar o arquivo %s; anexo descartado\n",
    "impossvel escrever no arquivo %s; anexo descartado\n",
    "sem cartas",
    "%d mensagens\n",
    "spam",
    " de",
    "?\tmostra esta mensagem de ajuda.\nq\tsai do programa.\nx\tsai sem mexer no servidor.\nespao\tcontinua a ler esta carta.\nn\tvai para prxima carta.\nd\tapaga carta.\nj\tenvia para a lixeira cartas com este assunto durante dez dias.\nJ\tenvia para lixeira cartas com este assunto durante um ano.\nw\tguarda carta em arquivo e apaga carta.\nk\tguarda carta em arquivo mas no a apaga.\nu\tguarda carta em arquivo sem formatar e apaga carta",
    "impossvel criar o arquivo %s\n",
    "impossvel escrever no arquivo %s\n",
    "carta salva; %d bytes",
    " adicionado",
    "pgina terminou; por favor use a tecla de retorno ou saia",
    "atualizao de texto interno no implementada ainda.",
    "sem erros",
    "autenticao proxy para URL no proxy",
    "sesso %d no ativa",
    "sesso 0  invlida",
    "a sesso %d est fora do limite %d",
    "j est na sesso %d",
    "esperando `w'",
    "esperando `w' na sesso %d",
    "limite de 1 milho de linhas alcansado.\nSalve os arquivos, saia e reinicie o programa.",
    "caminho absoluto comprido demais; o limite  de %d caracteres",
    "os diretrios so somente leitura; digite dw para ativar a escrita em diretrios",
    "no foi possvel criar o " TRASHDIR " no seu diretrio home para armazenar arquivos apagados",
    "no foi possvel remover o arquivo %s",
    "no foi possvel mover %s para a lixeira; ative o modo dx para remover permanentemente o arquivo",
    "local de destino fica dentro do bloco a copiar ou mover",
    "sem mudana",
    "impossvel juntar uma linha",
    "impossvel ler do banco de dados para outro arquivo",
    "impossvel ler tabelas diferentes dentro da mesma sesso",
    "nome do arquivo faltando",
    "domnio vazio na URL",
    "impossvel escrever numa URL",
    "impossvel escrever numa tabela do banco de dados",
    "impossvel escrever um arquivo vazio",
    "impossvel criar %s",
    "impossvel escrever em %s",
    "sesso no interativa",
    "linha %c fora do intervalo",
    "impossvel embutir caracteres nulos num comando de shell",
    "rtulo %c no definido",
    "delimitador invlido",
    "nenhuma cadeia de busca memorizada",
    "nenhuma cadeia de substituio memorizada",
    "expresso regular longa demais",
    "a linha termina em barra invertida",
    "fecho inesperado )",
    "cadeia de substituio pode usar apenas $1 at $9",
    "o modificador %s no possui caractere predecessor",
    "sem fecho ]",
    "sem fecho )",
    "buffer vazio",
    "erro na expresso regular; %s",
    "erro inesperado a avaliar a expresso regular na linha %d",
    "cadeia no achada",
    "nmero de linha grande demais",
    "nmero de linha negativo",
    "sem expresso regular aps %c",
    "delimitador faltando",
    "nenhuma linha condiz com o padro g",
    "todas as linhas condizem com o padro v",
    "nenhuma linha marcada modificada com sucesso",
    "operao interrompida",
    "nada similar",
    "sem mudanas",
    "agente nmero %c no definido",
    "no foi possvel mostrar diretrio novo",
    "no foi possvel estabelecer o diretrio atual",
    "diretrio invlido",
    "impossvel reproduzir udio a partir de um buffer vazio",
    "impossvel reproduzir udio em modo navegao",
    "impossvel reproduzir udio em modo de diretrio",
    "impossvel reproduzir udio em modo banco de dados",
    "arquivo no tem sufixo; use mt.xxx para especificar um sufixo prprio",
    "sufixo pode ter no mximo 5 caracteres",
    "sufixo .%s no  um mime conhecido; consulte por favor o arquivo de configurao.",
    "sem arquivo ou URL para atualizar",
    "no est em modo banco de dados",
    "no est em modo navegao",
    "nome do arquivo no possui /",
    "nome do arquivo termina em /",
    "caracteres invlidos aps o comando sm",
    "voc deve especificar exatamente um dos %s aps o comando B",
    "linha no possui um %c de abertura",
    "ambos %c e %c no esto completados nesta linha; experimente B%c ou B%c",
    "linha no possui uma chave, um parntese ou um colchete no completado",
    "impossvel achar a linha que completa o %c",
    "sesso %d est atualmente em modo navegao",
    "sesso %d est atualmente em modo diretrio",
    "sem nome de arquivo",
    "fim do buffer",
    "sem mais linhas para juntar",
    "intervalo no recomendado",
    "impossvel quebrar linhas em modo diretrio",
    "impossvel quebrar linhas em modo banco de dados",
    "impossvel quebrar linhas em modo navegao",
    "comando %c desconhecido",
    "%c no disponvel em modo diretrio",
    "%c no disponvel em modo banco de dados",
    "%c no disponvel em modo navegao",
    "nmero de linha zero",
    "sem espao aps comando",
    "o comando %c no se aplica globalmente",
    "local de destino para cpia/moo invlido",
    "texto inesperado aps o comando %c",
    "nada a desfazer",
    "por favor entre k[a-z]",
    "impossvel rotular um intervalo inteiro",
    "copiar 0  invlido",
    "aviso: nenhum buffer disponvel para gerir a janela auxiliar",
    "texto inesperado aps o comando q",
    "impossvel trocar o nome de um diretrio",
    "impossvel trocar o nome de uma tabela",
    "impossvel adicionar a outro buffer",
    "sem arquivo especificado",
    "impossvel escrever no diretrio; os arquivos so modificados conforme voc tenta",
    "impossvel escrever no banco de dados; as linhas so modificadas conforme voc tenta",
    "texto inesperado aps o comando ^",
    "sem texto anterior",
    "texto inesperado aps o comando M",
    "sesso destino no especificada",
    "sem texto anterior; impossvel copiar",
    "impossvel aplicar comando g a um intervalo",
    "g no disponvel em modo banco de dados",
    "impossvel aplicar comando i%c a um intervalo",
    "impossvel usar i< num comando global",
    "o buffer %d est vazio",
    "o buffer %d contm mais que uma linha",
    "impossvel abrir %s",
    "impossvel ler a partir de %s",
    "texto de entrada contm caracteres nulos",
    "a linha possui um retorno de carro embutido",
    "a primeira linha do %s  comprida demais",
    "arquivo atualmente no buffer - use por favor o comando rf para atualizar",
    "impossvel navegar num arquivo binrio",
    "impossvel navegar num arquivo vazio",
    "isto no parece um texto navegvel",
    "j est navegando",
    "rtulo %s no achado",
    "i no disponvel em modo navegao",
    "impossvel executar um comando insert a partir de uma funo do edbrowse",
    "impossvel ler texto numa sesso de banco de dados",
    "comando %c ainda no implementado",
    "%d est fora do intervalo",
    "no h opes com a cadeia %s",
    "vrias opes contm a cadeia %s",
    "boto; use i* para pression-lo",
    "boto de submeter; use i* para pression-lo",
    "boto de limpar; use i* para pression-lo",
    "rea de edio; edite na sesso %d",
    "somente leitura",
    "campo de entrada no pode ter caracteres de nova linha",
    "entrada comprida demais; o limite  de %d caracteres",
    "campo deve ser preenchido com + ou -",
    "no pode desmarcar um boto de opo; tem que marcar outro",
    "%s no  um arquivo acessvel",
    "espera-se um nmero",
    "a sesso %d contm caracteres nulos",
    "enviar um arquivo requer method=post e enctype=multipart/form-data",
    "isto  um campo de entrada e no um boto",
    "boto no faz parte de um formulrio",
    "sem javascript associado a este boto",
    "formulrio no inclui URL de destino",
    "ao do formulrio no  uma URL",
    "javascript desligado; impossvel ativar este formulrio",
    "formulrio mudou de https para http e agora no  seguro",
    "impossvel submeter usando protocolo %s",
    "%d fora do intervalo; por favor use %c1 at %c%d",
    "%d fora do intervalo; por favor use %c1 ou simplesmente %c",
    "impossvel substituir vrias ocorrncias de uma cadeia vazia",
    "linha excede %d bytes aps a substituio",
    "sem expresso regular aps %c",
    "vrios nmeros aps o terceiro delimitador",
    "sufixo de substituio inesperado aps o terceiro delimitador",
    "impossvel usar um sufixo numrico e o sufixo `g' simultaneamente",
    "impossvel aplicar o comando bl a linhas maiores que %d bytes",
    "dados de substituio contm linhas novas",
    "dados de substituio contm caracteres nulos",
    "impossvel embutir barra, nova linha ou caractere nulo num nome de diretrio",
    "arquivo destino j existe",
    "impossvel renomear o arquivo para %s",
    "impossvel embutir caracteres nulos num campo de entrada",
    "impossvel embutir novas linhas num campo de entrada",
    "sem campos de entrada presentes",
    "sem linques presentes",
    "sem botes presentes",
    "presentes vrios campos de entrada; por favor use %c1 at %c%d",
    "presentes vrios linques; por favor use %c1 at %c%d",
    "presentes; por favor use %c1 at %c%d",
    "no consegui ler os dados do servidor",
    "%s no  uma URL",
    "proxy seguro no implementado ainda",
    "impossvel identificar %s na rede",
    "o protocolo %s no  suportado pelo edbrowse e no est includo nos tipos mime do arquivo de configurao",
    "aviso: no foi possvel precarregar o <buffer %d> com o texto inicial do mesmo\n",
    "aviso: campos sem nome no sero transmitidos",
    "no  possvel conectar a %s",
    "no  possvel estabelecer uma conexo segura com %s; erro %d",
    "o certificado do servidor %s no pde ser verificado - conexo SSL abortada",
    "no consegui enviar a solicitao ao servidor web",
    "mtodo de autorizao %s no reconhecido",
    "pgina da web requer autorizao",
    "Login cancelado",
    "no  possvel criar o arquivo temporrio %s para descomprimir a pgina da web",
    "no  possvel escrever no arquivo temporrio %s para descomprimir a pgina da web",
    "o zcat no consegue descomprimir os dados para reconstruir a pgina da web",
    "no  possvel acessar a pgina da web descomprimida em %s",
    "no  possvel ler a pgina da web descomprimida em %s",
    "no foi possvel executar o subcomando %s, erro %d",
    "o FTP no conseguiu conectar ao servidor remoto",
    "o FTP no conseguiu conectar ao servidor remoto (tempo esgotado)",
    "transferncia FTP falhou",
    "transferncia FTP falhou (tempo esgotado)",
    "diretrio FTP no existe",
    "no consegui trocar de diretrio FTP (tempo esgotado)",
    "URL FTP mal-formada",
    "erro no uso do FTP",
    "erro de FTP no arquivo de configurao do Login",
    "falha na inicializao da biblioteca de FTP",
    "falha a iniciar sesso de FTP",
    "erro de FTP inesperado %d",
    "o edbrowse no foi compilado com acesso a bancos de dado",
    "faltando apelido na linha %d do catlogo de endereos",
    "faltando : na linha %d do catlogo de endereos",
    "o apelido na linha %d do catlogo de endereos  comprido demais; o limite  de 15 caracteres",
    "o e-mail na linha %d do catlogo de endereos  comprido demais; o limite  de 63 caracteres",
    " o e-mail na linha %d do catlogo de endereos no possui uma @",
    "impossvel deixar espaos em branco em endereos de e-mail; linha %d do catlogo de endereos",
    "caracteres no imprimveis no apelido ou no e-mail; linha %d do catlogo de endereos",
    "a ltima linha do catlogo de endereos no possui terminao",
    "no  possvel enviar dados ao servidor",
    "no  possvel ler dados do servidor",
    "a linha do servidor  longa demais ou sem fim",
    "no  possvel localizar o servidor %s",
    "no  possvel conectar ao servidor",
    "aviso: a URL do formulrio especifica uma sesso %s que ser ignorada\n",
    "arquivo %s vazio",
    "carta deve comear pelo assunto:",
    "assunto em branco",
    "assunto comprido demais; o limite  de %d caracteres",
    "caracteres invlidos no assunto; por favor use apenas espaos e texto ascii",
    ".signature no  um arquivo regular",
    "impossvel acessar o arquivo .signature",
    "no  possvel enviar o arquivo binrio %s; quem sabe ele devesse ser um anexo ?",
    "ou nenhum ou todos os anexos tm de ser declarados como \"alternative\"",
    "destinatrios demais; limite  %d",
    "sem catlogo de endereo; confira por favor seu arquivo de configurao .ebrc",
    "apelido %s no achado no catlogo de endereos",
    "nenhum destinatrio especificado",
    "sesso %d vazia; impossvel anexar",
    "impossvel acessar o anexo %s",
    "o arquivo %s no  regular; impossvel anexar",
    " arquivo %s vazio; impossvel anexar",
    "prompt inesperado \"%s\" no incio da sesso sendmail",
    "servidor no reconhece %s",
    "servidor recusou %s",
    "servidor no est pronto para receber dados; %s",
    "no consegui enciar as cartas; %s",
    "sem contas de correio; confira por favor o arquivo de configurao",
    "nmero de conta %d invlido; por favor use 1 at %d",
    "no posso enviar cartas em modo navegao",
    "no posso enviar cartas em modo banco de dados",
    "no posso enviar cartas em modo diretrio",
    "no posso enviar dados binrios; isto no tem que ser um anexo ?",
    "no posso enviar um arquivo vazio",
    "sem destinatrio na linha %d",
    "no posso enviar CC ou CCO para o primeiro destinatrio",
    "sem anexo na linha %d",
    "nmero de conta invlido na linha %d",
    "assunto em branco",
    "a linha %d deve comear com to: attach: alt: account: ou subject:",
    "nenhuma linha para assunto",
    "sem destinatrio; coloque to: endereco no topo do arquivo",
    "%s:// esperado",
    "protocolo desconhecido  %s",
    ":porta invlida ao final do domnio",
    "nome de domnio longo demais",
    "nome de usurio longo demais",
    "senha longa demais",
    "dados demais trazidos da Internet; talvez voc queira desabilitar o `redirect html'",
    "pgina traz ela prpria indiretamente; um lupe infinito",
    "sem funo especificada",
    "o nome da funo deve conter apenas letras e nmeros",
    "funo %s no existe",
    "argumentos demais",
    "~%d no possui argumento correspondente",
    "no consegui executar o subcomando %s; erro %d",
    "no consegui criar o arquivo temporrio %s; erro %d",
    "tabelas SQL demais no cache; limite  %d",
    "%s no  um arquivo regular",
    "arquivo muito grande; limite  40MB",
    "impossvel ler o contedo do %s",
    "impossvel acessar %s",
    "varivel de ambiente %s no definida",
    "no  possvel expandir * ? ou [] antes da ltima /",
    "%s no  um diretrio acessvel",
    "padro shell comprido demais",
    "Desculpe, no sei como expandir nomes de arquivo que contenham \\",
    "padro [] formado de maneira inadequada",
    "erro a compilar o padro shell; %s",
    "erro inesperado a avaliar o padro shell",
    "padro shell no condiz com nenhum arquivo",
    "padro shell condiz com mais que um arquivo",
    "as linhas ficam longas demais quando as variveis do shell so expandidas",
    "o arquivo de configurao no especifica um banco de dados - impossvel conectar",
    "no consigo conectar ao banco de dados - erro %d",
    "erro SQL inesperado; %d",
    "sem coluna chave especificada",
    "nome de coluna %s  longo demais; limite  %d caracteres",
    "erro de sintaxe na clusula where",
    "coluna %d fora do intervalo",
    "vrias colunas condizem com %s",
    "nenhuma coluna condiz com %s",
    "tabela %s no existe",
    "nome de coluna invlido",
    "no posso selecionar mais que uma coluna de bolha",
    "dados possuem pipas que so os meus delimitadores reservados",
    "dados contm novas linhas",
    "a linha possui campos demais; por favor no insira pipas no texto",
    "a linha possui muito poucos campos; por favor no remova nenhuma pipa do texto",
    "coluna chave no especificada",
    "erro miscelneo de SQL; %d",
    "no posso apagar mais que 100 linhas de uma vez",
    "no posso alterar uma coluna chave",
    "no posso alterar um campo de bolha",
    "no posso alterar um campo de texto",
    "ops !  Apaguei %d linha(s) e %d entrada(s) de banco de dados foram afetadas.",
    "ops !  Inseri %d linha(s) e %d entrada(s) de banco de dados foram afetadas.",
    "ops !  Atualizei %d linha(s) e %d entrada(s) de banco de dados foram afetadas.",
    "outra linha no banco de dados depende desta",
    "a linha ou a tabela est bloqueada",
    "Voc no tem permisso para modificar o banco de dados desse jeito",
    "paralizao detectada",
    "colocando nulo numa coluna no nula",
    "restrio de conferncia violada",
    "tempo do banco de dados esgotado",
    "impossvel modificar um panorama",
    "sem fecho %s",
    "aviso: o javascript no pode ser invocado por eventos de teclas de atalho",
    "o javascript no pode ser invocado por foco ou imagem obscura",
    "manipulador onchange no est acessvel",
    "%s no  parte de um formulrio a ser preenchido",
    "%s no tem nome",
    "mtodo desconhecido; por favor use GET ou POST",
    "codificao desconhecida; por favor use multipart/form-data ou application/x-www-form-urlencoded",
    "o formulrio no pode submeter usando protocolo %s",
    "tipo de entrada %s desconhecido",
    "selecionados vrios botes de opo",
    "%s fechado em %s",
    "%s comea no meio de %s",
    "fecho inesperado de %s que no foi aberto",
    "uma rea de edio comea no meio de uma rea de edio",
    "%s aparece no meio de uma ncora",
    "%s possui etiquetas HTML",
    "a opo no pode conter vrgula quando for parte de seleo mltipla",
    "opo vazia",
    "vrios ttulos",
    "%s no est numa lista",
    "%s no est numa tabela",
    "%s no est numa linha de tabela",
    "a opo aparece fora de uma seleo",
    "selecionadas vrias opes",
    "ao de tag %d no processada",
    "%s no  fechado no fim do arquivo",
    "o java est abrindo uma janela vazia",
    "caracteres inesperados aps o anexo codificado",
    "caracteres invlidos no anexo codificado",
    "o manipulador onchange no funciona com reas de edio",
    "aviso: o javascript no pode ser invocado por duplo clique",
    "erro a resolver a opo %s durante um sync ou submisso de formulrio",
    "a etiqueta no pode ter manipuladores onunload and onclik simultaneamente",
    "script no  fechado ao fim do arquivo; suspendendo javascript",
    "no consegui trazer o javascript local; %s",
    "no consegui trazer o javascript de %s; cdigo %d",
    "no consegui trazer o javascript; %s",
    "javascript desligado; ignorando cdigo onclick",
    "javascript desligado; ignorando onchange cdigo",
    "javascript desligado; ignorando cdigo onreset",
    "javascript desligado; ignorando cdigo onsubmit",
    "no consegui achar a etiqueta HTML associada  varivel javascript que est sendo modificada",
    "o javascript modificou uma rea de edio e isso no foi implementado ainda",
    "aviso: diretiva de atualizao adulterada; %s\n",
    "aviso: mtodo de compresso HTTP %s desconhecido\n",
    "aviso: redirecionamento HTTP %d mas no foi especificada uma URL nova\n",
    "aviso: erro de HTTP %d, %s\n",
    "aviso: a pgina no possui um cabealho HTTP conhecido",
    "aviso: impossvel atualizar arquivo de configurao",
    "mensagens de ajuda ligadas",
    "download via FTP",
    "nenhum arquivo de certificados SSL; conexes seguras no podem ser verificadas",
    "no foi possvel reescrever o arquivo de configurao; dados de configurao podem ser perdidos !",
    ".ebrc: caracteres nulos na linha %d",
    ".ebrc: falta nome de funo na linha %d",
    ".ebrc: nome de funo na linha %d comea com um algarismo",
    ".ebrc: nome de funo na linha %d  longo demais; o limite  dez caracteres",
    ".ebrc: a sintaxe de definio de funo na linha %d  imprpria",
    ".ebrc: linha %d, esperado \"condio > arquivo\" ",
    ".ebrc: linha %d, regras de filtragem no tm cadeias a coincidir",
    ".ebrc: linha %d, critrio em %s no est definido em lugar algum",
    ".ebrc: linha %d, filtros de e-mail em ecesso",
    ".ebrc: palavra-chave desconhecida %s na linha %d",
    ".ebrc: linha %d, o atributo %s no pode ser definido fora de um descritor de mensagem",
    ".ebrc: linha %d, o atributo %s no pode ser definido fora de um descritor mime",
    ".ebrc: linha %d, o atributo %s no pode ser definido fora de um descritor de tabela",
    ".ebrc: linha %d, o atributo %s no pode ser definido dentro de um descritor de mensagem ou bloco de filtro",
    ".ebrc: linha %d, o atributo %s no pode ser definido dentro de um descritor de mime",
    ".ebrc: linha %d, o atributo %s no pode ser definido dentro de um descritor de tabela",
    ".ebrc: linha %d, o atributo %s est definido para nada",
    ".ebrc: linha %d, colunas em excesso; o limite  %d",
    ".ebrc: linha %d, keycol tem que ser nmero ou nmero,nmero",
    ".ebrc: linha %d, keycol fora do intervalo; especificadas somente %d colunas",
    ".ebrc: o catlogo de endereos %s no  um arquivo regular",
    ".ebrc: a lista negra de IPs %s no  um arquivo regular",
    ".ebrc: %s no  um diretrio",
    ".ebrc: linha %d, agentes do usurio em excesso; o limite  9",
    ".ebrc: cookie jar %s no  um arquivo regular",
    ".ebrc: no posso criar a cookie jar %s",
    ".ebrc: diretivas no js em excesso; o limit  %d",
    ".ebrc: linha %d, o domnio %s no possui ponto",
    ".ebrc: lixeira de cartas %s no  um arquivo regular",
    ".ebrc: arquivo de certificados SSL %s no  um arquivo regular",
    ".ebrc: arquivo de certificados SSL %s no existe ou no  legvel.",
    ".ebrc: linha %d, palavra-chave %s no foi implementada ainda",
    ".ebrc: definindo vrias contas de e-mail como padro",
    ".ebrc: falta o servidor de entrada na linha %d",
    ".ebrc: falta o servidor de sada na linha %d",
    ".ebrc: falta o usurio na linha %d",
    ".ebrc: falta a senha na linha %d",
    ".ebrc: falta o remetente na linha %d",
    ".ebrc: falta o endereo para resposta na linha %d",
    ".ebrc: falta o tipo na linha %d",
    ".ebrc: falta a descrio na linha %d",
    ".ebrc: falta o sufixo ou a lista de protocolos na linha %d",
    ".ebrc: falta o programa na linha %d",
    ".ebrc: falta o nome da tabela na linha %d",
    ".ebrc: falta o nome curto na linha %d",
    ".ebrc: faltam colunas na linha %d",
    ".ebrc: } inesperada na linha %d",
    ".ebrc: else na linha %d no faz parte de um comando if",
    ".ebrc: texto adulterado na linha %d",
    ".ebrc: linha %d, impossvel iniciar funo, descritor de mail/mime ou bloco de filtro dentro de %s",
    ".ebrc: comando na linha %d deve aparecer dentro de uma funo",
    "contas de e-mail demais no arquivo de configurao .ebrc; o limite  %d",
    "tipos mime demais no arquivo de configurao .ebrc; o limite  %d",
    "tabelas SQL demais no arquivo de configurao .ebrc; o limite  %d",
    "funes demais no arquivo de configurao .ebrc; o limite  %d",
    ".ebrc: linha %d, as estruturas de controle esto aninhadas at um nvel alto demais",
    ".ebrc: funo %s no se fecha no fim do arquivo",
    ".ebrc: mail ou bloco mime no se fecha no fim do arquivo",
    "diretrio home no definido por $HOME.",
    "%s no  um diretrio",
    "nenhuma conta de e-mail especificada; confira por favor o arquivo de configurao .ebrc",
    "nmero de conta invlido; por favor use 1 at %d",
    "edbrowse  -v    (mostra verso)\n\edbrowse -h (esta mensagem)\n\edbrowse -c (edita arquivo de configurao)\n\edbrowse  [-e] [-d?] -[u|p]m?    (l e-mail) \n\edbrowse  [-e] [-d?] -m? endereco1 endereco2 ... arquivo [+anexos]\n\edbrowse  [-e] [-d?] arquivo1 arquivo2 ...",
    "por favor especifique ao menos um destinatrio e o arquivo a enviar",
    "por favor especifique ao menos um destinatrio e o arquivo a enviar, antes dos anexos",
    "demais arquivos abertos ao mesmo tempo; o limite  %d",
    "sesso %d invlida na fetchLineContext()",
    "nmero de linha %d invlido na fetchLineContext()",
    "linha %d->%d tornou-se nula",
    "sesso %d fora do intervalo na cxActive",
    "init duplo na sesso %d",
    "fechando sesso no ativa %d",
    "novo trecho vazio na addToMap()",
    "sem linha nova na entrada do diretrio %s",
    "sem fecho > na linha %d",
    "fieldInBuffer no encontrou a etiqueta %d newtext %s",
    "impossvel refazer a cookie jar %s",
    "endereos em excesso na lista negra de IPs; o limite  %d",
    "o cliente de recepo de cartas  interativo e no pode rodar em segundo plano",
    "diretrio para caixa de entrada no especificado no arquivo .ebrc",
    "no posso mudar para o diretrio %s",
    "introduo do POP3 <%s> inesperada",
    "no consegui completar a seqncia usuario/senha <%s> no POP3",
    "no consegui obter o status da caixa de entrada <%s>",
    "erro a ler mensagens no servidor; cdigo %d",
    "impossvel pegar carta %d <%s>",
    "voc esperou demais; servidor desconectou.",
    "no posso apagar carta <%s>",
    "o cdigo da etiqueta %d possui o caractere invlido %c a seguir",
    "chamando preFormatTag sem parsePage",
    "htmlParse() no  reentrante.",
    "dipo de entrada inesperado na submitForm()",
    "lista = 0 in tagFromJavaVar()",
    "servidor vazio na httpConnect",
    "no consegui alocar memria para operao Javascript.",
    "impossvel criar contexto Javascript ",
    "impossvel criar objeto de janela para o Javascript",
    "impossvel criar classes padro para o Javascript",
    "impossvel criar objeto de documento para o Javascript",
    "servidor:porta est comprido demais",
    "protocolo: est comprido demais",
    "erro a alocar %u bytes",
    "erro a alocar %u bytes",
    "reallocMem(p,0)",
    "reallocMem(0,%d)",
    "erro a realocar %u bytes",
    "stringInList(null,...)",
    "stringInListCI(null,...)",
    "charInList(null,...)",
    "ponteiro nulo na pstLength",
    "no posso usar ioctl() para controlar o TTY",
    "no  possvel abrir %s",
    "no  possvel criar ou escrever em %s",
    "chamando fopen() em modo invlido %s",
    "/ mal posicionada na getDirURL(%s)",
    "/ mal posicionada na %s",
    "decodePostData(0,0)",
    "No foi possvel converter o PDF para HTML; certifique-se que o PDFToHTML esteja instalado e tente us-lo no %s",
    "No momento, somente o mtodo `auth login' do sendmail  suportado",
    "no consegui completar a seqncia usuario/senha <%s> no SMTP",
    "no  possvel replicar em modo diretrio",
    "no  possvel replicar em modo banco de dados",
    "no posso replicar para um arquivo vazio",
    "no posso replicar para um arquivo binrio",
    "linhas subject e reply so obrigatrias",
    "aviso: no h ID da mensagem a referenciar",
    "Desculpe; o cabealho da carta no est disponvel.\nComece com uma carta no formatada, escolha browse e depois reply all.",
    "l expande caracteres de controle para hexadecimais",
    "l expande caracteres de controle e no-ASCII para hexadecimais",
    "Ateno: as funes buscar e substituir no aceitaro caracteres UTF8\nporque a biblioteca PCRE que voc tem instalada no suporta essa funcionalidade.\nExporte PCREUTF8=off para desabilitar esse recurso e suprimir este aviso.",
    "convertendo para iso8859",
    "convertendo para utf8",
    "no converta entre iso8859 e utf8",
    "converte automaticamente entre iso8859 e utf8",
    "No posso copiar uma rvore de diretrios para uma lixeira em outro sistema de arquivos;\nUse cpio -p ou cp -r a partir do shell",
    "No posso apagar uma rvore de diretrios; use rm -r a partir do shell",
};

/* English by default */
static const char **messageArray = englishMessages;
static int messageArrayLength = sizeof (englishMessages) / sizeof (char *);

bool cons_utf8, iuConvert = true;

void
selectLanguage(void)
{
    char buf[8];
    char *s = getenv("LANG");
    if(!s)
	return;
    if(!*s)
	return;

    if(strstrCI(s, "utf8") || strstrCI(s, "utf-8"))
	cons_utf8 = true;

/* I thought I needed this; guess I don't, for now. */
#if 0
    if(!setlocale(LC_CTYPE, "")) {
	fprintf(stderr,
	   "Can't set the specified locale.  Check LANG, LC_CTYPE, LC_ALL.\n");
    }
#endif

    strncpy(buf, s, 7);
    buf[7] = 0;
    caseShift(buf, 'l');

    if(!strncmp(buf, "en", 2))
	return;			/* english is default */

    if(!strncmp(buf, "fr", 2)) {
	messageArray = frenchMessages;
	messageArrayLength = sizeof (frenchMessages) / sizeof (char *);
	return;
    }

    if(!strncmp(buf, "pt_br", 5)) {
	messageArray = brazilianPortugueseMessages;
	messageArrayLength =
	   sizeof (brazilianPortugueseMessages) / sizeof (char *);
	return;
    }

    fprintf(stderr, "Sorry, language %s is not implemented\n", buf);
    exit(1);
}
    /* selectLanguage */
static const char *
getString(int msg)
{
    const char **a = messageArray;
    const char *s;
    char *t, c;
    static char utfbuf[1000];

    if(msg >= messageArrayLength)
	a = englishMessages;
    s = a[msg];
    if(!s)
	s = englishMessages[msg];
    if(!s)
	s = "spurious message";

    if(!cons_utf8)
	return s;

/* We have to convert it. */
    for(t = utfbuf; c = *s; ++s) {
	if(c >= 0) {
	    *t++ = c;
	    continue;
	}
	*t++ = 0xc0 | ((uchar) c >> 6);
	*t++ = 0x80 | (c & 0x3f);
    }
    *t = 0;

    return utfbuf;
}				/* getString */

/*********************************************************************
Internationalize the standard puts and printf.
These are simple informational messages, where you don't need to error out,
or check the debug level, or store the error in a buffer.
The i_ prefix means international.
*********************************************************************/

void
i_puts(int msg)
{
    puts(getString(msg));
}				/* i_puts */

void
i_printf(int msg, ...)
{
    const char *realmsg = getString(msg);
    va_list p;
    va_start(p, msg);
    vprintf(realmsg, p);
    va_end(p);
}				/* i_printf */

/* Print and exit.  This puts newline on, like puts. */
void
i_printfExit(int msg, ...)
{
    const char *realmsg = getString(msg);
    va_list p;
    va_start(p, msg);
    vfprintf(stderr, realmsg, p);
    fprintf(stderr, "\n");
    va_end(p);
    ebClose(1);
}				/* i_printfExit */

/*********************************************************************
The following error display functions are specific to edbrowse,
rather than extended versions of the standard unix print functions.
Thus I don't need the i_ prefix.
*********************************************************************/

char errorMsg[4000];

/* Show the error message, not just the question mark, after these commands. */
static const char showerror_cmd[] = "AbefMqrw^";

/* Set the error message.  Type h to see the message. */
void
setError(int msg, ...)
{
    va_list p;

    if(msg < 0) {
	errorMsg[0] = 0;
	return;
    }

    va_start(p, msg);
    vsprintf(errorMsg, getString(msg), p);
    va_end(p);

/* sanity check */
    if(strlen(errorMsg) >= sizeof (errorMsg)) {
	i_printf(63, strlen(errorMsg));
	puts(errorMsg);
	exit(1);
    }
}				/* setError */

void
showError(void)
{
    if(errorMsg[0])
	puts(errorMsg);
    else
	i_puts(106);
}				/* showError */

void
showErrorConditional(char cmd)
{
    if(helpMessagesOn || strchr(showerror_cmd, cmd))
	showError();
    else
	printf("?\n");
}				/* showErrorConditional */

void
showErrorAbort(void)
{
    errorPrint("1%s", errorMsg);
}				/* showErrorAbort */

void
browseError(int msg, ...)
{
    va_list p;
    if(ismc)
	return;
    if(browseLocal != 1)
	return;
    if(browseLine) {
	i_printf(64, browseLine);
	cw->labels[4] = browseLine;
    } else
	i_printf(65);
    va_start(p, msg);
    vprintf(getString(msg), p);
    va_end(p);
    nl();
    browseLocal = 2;
}				/* browseError */

/* Javascript errors, we need to see these no matter what. */
void
runningError(int msg, ...)
{
    va_list p;
    if(ismc)
	return;
    if(browseLine) {
	i_printf(64, browseLine);
	cw->labels[4] = browseLine;
    }
    va_start(p, msg);
    vprintf(getString(msg), p);
    va_end(p);
    nl();
    browseLocal = 2;
}				/* runningError */


/*********************************************************************
Now for the international version of caseShift.
This converts anything that might reasonably be a letter, such as  and .
This routine is used by default; even if the language is English.
After all, you might be a native English speaker, using edbrowse
in English, but you are writing a document in French.
This (unfortunately) does not affect \w in regular expressions,
which is still restricted to English letters.
Even more annoying, \b uses English as boundary,
so that \bbar\b will indeed match on the line foobar.
There may be a way to set locale in libpcre; I don't know.
Anyways, here are the nonascii letters, upper and lower.
*********************************************************************/

static const char upperMore[] = "";

static const char lowerMore[] = "";

static const char letterMore[] =
   "ީ";
static bool
i_isalphaByte(unsigned char c)
{
    if(isalphaByte(c))
	return true;
    if(c == false)
	return 0;
    if(strchr(letterMore, c))
	return true;
    return false;
}				/* i_isalphaByte */

/* assumes the arg is a letter */
static unsigned char
i_tolower(unsigned char c)
{
    char *s;
    if(isalphaByte(c))
	return tolower(c);
    s = strchr(upperMore, c);
    if(s)
	c = lowerMore[s - upperMore];
    return c;
}				/* i_tolower */

static unsigned char
i_toupper(unsigned char c)
{
    char *s;
    if(isalphaByte(c))
	return toupper(c);
    s = strchr(lowerMore, c);
    if(s)
	c = upperMore[s - lowerMore];
    return c;
}				/* i_toupper */

/* This is a variation on the original routine, found in stringfile.c */
void
i_caseShift(unsigned char *s, char action)
{
    unsigned char c;
/* The McDonalds conversion is very English - should we do it in all languages? */
    int mc = 0;
    bool ws = true;

    for(; c = *s; ++s) {
	if(action == 'u') {
	    if(i_isalphaByte(c))
		*s = i_toupper(c);
	    continue;
	}

	if(action == 'l') {
	    if(i_isalphaByte(c))
		*s = i_tolower(c);
	    continue;
	}

/* mixed case left */
	if(i_isalphaByte(c)) {
	    if(ws)
		c = i_toupper(c);
	    else
		c = i_tolower(c);
	    if(ws && c == 'M')
		mc = 1;
	    else if(mc == 1 && c == 'c')
		mc = 2;
	    else if(mc == 2) {
		c = i_toupper(c);
		mc = 0;
	    } else
		mc = 0;
	    *s = c;
	    ws = false;
	    continue;
	}

	ws = true, mc = 0;
    }				/* loop */
}				/* caseShift */
