dnl Copyright (C) 2008 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_ADF
#----------------
# modifies or sets have_adf, ADF_LDFLAGS, and ADF_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_ADF], [

have_adf=no

AC_ARG_ENABLE(ADF,
  [  --disable-adf           do not use ADF when available],
  [
    case "${enableval}" in
      yes) adf=true ;;
      no)  adf=false ;;
      *)   AC_MSG_ERROR([bad value ${enableval} for --enable-adf]) ;;
    esac
  ],
  [adf=true ]
)

AC_ARG_WITH(adf,
  [  --with-adf=DIR          specify prefix directory for ADF],[
])

AC_ARG_WITH(adf-lib,
  [  --with-adf-lib=DIR      specify directory for ADF library],[
])

if test "x$adf" = "xtrue" ; then

  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  if test "x$with_adf_lib" != "x" ; then
    ADF_LDFLAGS="-L$with_adf_lib"
  elif test "x$with_adf" != "x" ; then
    ADF_LDFLAGS="-L$with_adf/lib"
  fi

  ADF_LIBS="-ladf"
  LDFLAGS="${LDFLAGS} ${ADF_LDFLAGS}"
  LIBS="${LIBS} ${ADF_LIBS}"

  AC_CHECK_LIB(adf, ADF_Database_Open, 
               [ AC_DEFINE([HAVE_ADF], 1, [ADF file support])
                 have_adf=yes
               ], 
               [ AC_MSG_WARN([no ADF file support])
               ],
               )

  if test "x$have_adf" = "xno"; then
    ADF_LDFLAGS=""
    ADF_LIBS=""
  fi

  LDFLAGS="$saved_LDFLAGS"
  LIBS="$saved_LIBS"

  unset saved_LDFLAGS
  unset saved_LIBS

fi

AC_SUBST(ADF_LDFLAGS)
AC_SUBST(ADF_LIBS)

])dnl

