#ifndef CYGONCE_LIBM_COS_H
#define CYGONCE_LIBM_COS_H
//===========================================================================
//
//      cos.h
//
//      Test vectors for testing of cos() math library function
//
//===========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/cos.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define COS_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t cos_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1077999148u, 2506787616u, 1090024059u, 3619148316u, 3219768992u, 2016484542u, 0, COS_TOLERANCE, 0},
{ 2, 3218153654u, 3176730980u, 1051524793u, 2993920299u, 1072618594u, 3065796144u, 0, COS_TOLERANCE, 0},
{ 3, 3239659803u, 2725707538u, 3232101343u, 2346810316u, 3220123085u, 3078481391u, 0, COS_TOLERANCE, 0},
{ 4, 1092554362u, 2088062470u, 3201242716u, 420891118u, 1072356932u, 4042953682u, 0, COS_TOLERANCE, 0},
{ 5, 3221200677u, 2636405208u, 1100049309u, 471635570u, 3218685952u, 3960691400u, 0, COS_TOLERANCE, 0},
{ 6, 1089363191u, 1746012320u, 1054478713u, 3333988501u, 1071809942u, 2003021887u, 0, COS_TOLERANCE, 0},
{ 7, 1047953160u, 183014794u, 3202039382u, 2016785810u, 1072693247u, 4294967264u, 0, COS_TOLERANCE, 0},
{ 8, 3213486034u, 2688957927u, 1046089230u, 2709029994u, 1072693080u, 978212037u, 0, COS_TOLERANCE, 0},
{ 9, 1058795730u, 624574473u, 1045840574u, 3473266330u, 1072693247u, 4243804449u, 0, COS_TOLERANCE, 0},
{ 10, 3204919842u, 1605286142u, 1068931671u, 4233776869u, 1072693247u, 4286151936u, 0, COS_TOLERANCE, 0},
{ 11, 1060343410u, 1857607719u, 3222889559u, 3417070006u, 1072693247u, 3893935114u, 0, COS_TOLERANCE, 0},
{ 12, 1103599987u, 3981151660u, 1088899021u, 1332651746u, 1071013305u, 501046957u, 0, COS_TOLERANCE, 0},
{ 13, 1085298022u, 3824988054u, 1066856791u, 2070129652u, 3220173381u, 184726421u, 0, COS_TOLERANCE, 0},
{ 14, 3207559790u, 1372884064u, 1080833116u, 3229926662u, 1072693247u, 4035214061u, 0, COS_TOLERANCE, 0},
{ 15, 1093826501u, 3217805330u, 3191644264u, 2014578707u, 1070032383u, 2277446950u, 0, COS_TOLERANCE, 0},
{ 16, 1102287487u, 265058758u, 3239903247u, 1630600647u, 3220176170u, 1767461132u, 0, COS_TOLERANCE, 0},
{ 17, 1071124229u, 1946677669u, 3198462609u, 926009897u, 1072546806u, 3686417449u, 0, COS_TOLERANCE, 0},
{ 18, 1072130299u, 2271884183u, 3203741999u, 2118617783u, 1072156649u, 125344954u, 0, COS_TOLERANCE, 0},
{ 19, 3194849109u, 213658772u, 3249401130u, 314151656u, 1072693247u, 4294967282u, 0, COS_TOLERANCE, 0},
{ 20, 3254112288u, 1564829925u, 3197817016u, 497230814u, 3219660486u, 631679371u, 0, COS_TOLERANCE, 0},
{ 21, 3216262634u, 2075329122u, 3231746400u, 169900577u, 1072686675u, 1944236140u, 0, COS_TOLERANCE, 0},
{ 22, 1049848642u, 541549344u, 1096608669u, 3119070100u, 1072693247u, 4294966919u, 0, COS_TOLERANCE, 0},
{ 23, 1085427055u, 567496114u, 1045286891u, 1969998540u, 3218068798u, 3978347379u, 0, COS_TOLERANCE, 0},
{ 24, 1060548195u, 1299369769u, 1049342524u, 4167404066u, 1072693247u, 3755541054u, 0, COS_TOLERANCE, 0},
{ 25, 3208865645u, 3348930841u, 1078472138u, 358457347u, 1072693247u, 2715744996u, 0, COS_TOLERANCE, 0},
{ 26, 1071069297u, 2192461366u, 1099527247u, 3184735642u, 1072556722u, 3142942532u, 0, COS_TOLERANCE, 0},
{ 27, 1052861772u, 331696577u, 3189610016u, 793242270u, 1072693247u, 4294947929u, 0, COS_TOLERANCE, 0},
{ 28, 3252528934u, 2322696981u, 1083791358u, 3020766674u, 3219826880u, 2920996550u, 0, COS_TOLERANCE, 0},
{ 29, 1044902177u, 252085215u, 3214426435u, 4139068910u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 30, 3222505725u, 105589263u, 1056316170u, 261630827u, 1069929628u, 2708927296u, 0, COS_TOLERANCE, 0},
{ 31, 1107213408u, 428765703u, 3251828686u, 2009972239u, 1072002281u, 2267619153u, 0, COS_TOLERANCE, 0},
{ 32, 1098568019u, 3517376586u, 3240257920u, 3304487302u, 3219267113u, 2318350078u, 0, COS_TOLERANCE, 0},
{ 33, 3233537912u, 237004814u, 3237899261u, 3364008659u, 3219363466u, 1974819849u, 0, COS_TOLERANCE, 0},
{ 34, 3195247552u, 472004928u, 3226869477u, 1186387580u, 1072693247u, 4294967272u, 0, COS_TOLERANCE, 0},
{ 35, 1054226850u, 4085763910u, 1106394906u, 2684738273u, 1072693247u, 4294840843u, 0, COS_TOLERANCE, 0},
{ 36, 1057053639u, 2055490142u, 3231581370u, 3879040079u, 1072693247u, 4290030503u, 0, COS_TOLERANCE, 0},
{ 37, 3188976647u, 3725731239u, 1061652681u, 591292963u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 38, 3225014981u, 1147041027u, 3215417793u, 624695933u, 1072212739u, 3548552865u, 0, COS_TOLERANCE, 0},
{ 39, 3206052774u, 705725219u, 3238067573u, 1116238321u, 1072693247u, 4255683871u, 0, COS_TOLERANCE, 0},
{ 40, 3207367088u, 7287411u, 1045917232u, 116067742u, 1072693247u, 4081475017u, 0, COS_TOLERANCE, 0},
{ 41, 3240055222u, 3604989074u, 1066381836u, 545298780u, 1069174826u, 481201061u, 0, COS_TOLERANCE, 0},
{ 42, 3219080936u, 1681476121u, 1060345752u, 3553822398u, 1072447760u, 3428441333u, 0, COS_TOLERANCE, 0},
{ 43, 1102831658u, 3410480388u, 1052460275u, 1660607230u, 3220176232u, 3352970825u, 0, COS_TOLERANCE, 0},
{ 44, 1089216869u, 1494984673u, 3196647153u, 287894723u, 1072276901u, 3815649632u, 0, COS_TOLERANCE, 0},
{ 45, 1054885127u, 644548665u, 1081948134u, 2442134629u, 1072693247u, 4294696242u, 0, COS_TOLERANCE, 0},
{ 46, 1087554095u, 2312530895u, 3221584595u, 3379665576u, 1071648109u, 1545486473u, 0, COS_TOLERANCE, 0},
{ 47, 1096085375u, 3018463866u, 1086226574u, 404012923u, 3220172495u, 3110868414u, 0, COS_TOLERANCE, 0},
{ 48, 1064733299u, 1710279345u, 3251401196u, 3528946000u, 1072693216u, 1050271320u, 0, COS_TOLERANCE, 0},
{ 49, 1061536351u, 2164450219u, 1083520023u, 3312018966u, 1072693247u, 2309107782u, 0, COS_TOLERANCE, 0},
{ 50, 1057248676u, 2648986431u, 1050330591u, 1474376550u, 1072693247u, 4288192616u, 0, COS_TOLERANCE, 0},
{ 51, 3194422028u, 1839068700u, 1077406406u, 3013052171u, 1072693247u, 4294967288u, 0, COS_TOLERANCE, 0},
{ 52, 1046493630u, 772102380u, 3220729740u, 4219039958u, 1072693247u, 4294967292u, 0, COS_TOLERANCE, 0},
{ 53, 3229472221u, 3058618779u, 1046304788u, 3338676024u, 1072667959u, 113041016u, 0, COS_TOLERANCE, 0},
{ 54, 1051172137u, 506286854u, 1094907481u, 2217000199u, 1072693247u, 4294965066u, 0, COS_TOLERANCE, 0},
{ 55, 1082428310u, 1147428263u, 1065432625u, 3034786717u, 3219455129u, 3620968391u, 0, COS_TOLERANCE, 0},
{ 56, 1082016752u, 2844125311u, 1082985198u, 2561492677u, 1072492615u, 1705681540u, 0, COS_TOLERANCE, 0},
{ 57, 3211536916u, 704542600u, 3222902057u, 2762779203u, 1072693235u, 2601745815u, 0, COS_TOLERANCE, 0},
{ 58, 3199680614u, 184131949u, 3249723525u, 1667366082u, 1072693247u, 4294958646u, 0, COS_TOLERANCE, 0},
{ 59, 3223609598u, 3904224140u, 1067056698u, 2942159914u, 3219593076u, 1010749237u, 0, COS_TOLERANCE, 0},
{ 60, 1100636863u, 426114282u, 3209056785u, 1083606355u, 3219470205u, 1406323978u, 0, COS_TOLERANCE, 0},
{ 61, 1106165945u, 3774123863u, 1106787580u, 2722107965u, 1072606016u, 4140994146u, 0, COS_TOLERANCE, 0},
{ 62, 1088005092u, 1377734762u, 1104232051u, 2377063483u, 3218242952u, 3735681066u, 0, COS_TOLERANCE, 0},
{ 63, 1069380559u, 1029739074u, 1105467109u, 3062201018u, 1072679384u, 936725322u, 0, COS_TOLERANCE, 0},
{ 64, 3234741597u, 773857656u, 3214251949u, 335833884u, 1071799931u, 384567806u, 0, COS_TOLERANCE, 0},
{ 65, 3203224610u, 1473865960u, 1103073830u, 4000427507u, 1072693247u, 4294086482u, 0, COS_TOLERANCE, 0},
{ 66, 1103185231u, 4242092620u, 1067009473u, 14539161u, 3219397655u, 2052311207u, 0, COS_TOLERANCE, 0},
{ 67, 3192516074u, 1732245037u, 1101371955u, 1533536108u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 68, 3249153995u, 1833841275u, 1099430098u, 4144145552u, 3218112666u, 1530833864u, 0, COS_TOLERANCE, 0},
{ 69, 3244270463u, 935007012u, 3188865420u, 604442938u, 1069791519u, 4238814723u, 0, COS_TOLERANCE, 0},
{ 70, 3206903253u, 2211464602u, 1046255144u, 1635910526u, 1072693247u, 4174238446u, 0, COS_TOLERANCE, 0},
{ 71, 1077871417u, 2549219008u, 3231633258u, 3733639385u, 1072524971u, 2288078414u, 0, COS_TOLERANCE, 0},
{ 72, 1082095089u, 1819374372u, 3202219056u, 2617077637u, 1072177416u, 1438672983u, 0, COS_TOLERANCE, 0},
{ 73, 1094345280u, 546465680u, 1048653554u, 532401530u, 1072449430u, 350777572u, 0, COS_TOLERANCE, 0},
{ 74, 1044571091u, 2759019783u, 3221570188u, 3554409630u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 75, 3212931282u, 2527221960u, 1099107978u, 2696971136u, 1072693171u, 4105298358u, 0, COS_TOLERANCE, 0},
{ 76, 1097158000u, 173134582u, 1087299442u, 2877794600u, 3218695462u, 3908126164u, 0, COS_TOLERANCE, 0},
{ 77, 1086400474u, 547642046u, 3197285510u, 3521286127u, 1072655927u, 2126353027u, 0, COS_TOLERANCE, 0},
{ 78, 1074860702u, 1231582831u, 1090971734u, 1653446832u, 3218833636u, 2717799458u, 0, COS_TOLERANCE, 0},
{ 79, 1061342535u, 3762182190u, 3252967851u, 2615360375u, 1072693247u, 2812236346u, 0, COS_TOLERANCE, 0},
{ 80, 3200834423u, 2588067350u, 3206610957u, 3551059728u, 1072693247u, 4294927751u, 0, COS_TOLERANCE, 0},
{ 81, 3206978856u, 845263327u, 1073415902u, 1749010288u, 1072693247u, 4160909940u, 0, COS_TOLERANCE, 0},
{ 82, 3205576370u, 3092685191u, 3190678390u, 2872219490u, 1072693247u, 4275548308u, 0, COS_TOLERANCE, 0},
{ 83, 3218315055u, 4107255722u, 3205337291u, 3069068345u, 1072595762u, 1566396021u, 0, COS_TOLERANCE, 0},
{ 84, 3243990857u, 2294867524u, 3216653996u, 2860384670u, 3216839369u, 80524119u, 0, COS_TOLERANCE, 0},
{ 85, 3193326350u, 2265437201u, 3240198679u, 1234948614u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 86, 3216359929u, 1186945904u, 3251167793u, 1896750851u, 1072685678u, 821616092u, 0, COS_TOLERANCE, 0},
{ 87, 1081575478u, 3686084548u, 1079286273u, 3309277689u, 1072458457u, 954886600u, 0, COS_TOLERANCE, 0},
{ 88, 3223476240u, 3006860614u, 3231412671u, 2504194724u, 3220110252u, 3100390877u, 0, COS_TOLERANCE, 0},
{ 89, 3236149260u, 1948717780u, 1048317852u, 3791803982u, 3219564158u, 3741596795u, 0, COS_TOLERANCE, 0},
{ 90, 1064345015u, 4272034420u, 3192982124u, 1526175922u, 1072693230u, 3195985048u, 0, COS_TOLERANCE, 0},
{ 91, 3245817826u, 4108948538u, 1104691287u, 640541190u, 1070492631u, 2055939015u, 0, COS_TOLERANCE, 0},
{ 92, 3207257417u, 3259274853u, 1082507103u, 3677038020u, 1072693247u, 4105778929u, 0, COS_TOLERANCE, 0},
{ 93, 1083132498u, 3781708548u, 1096584871u, 1207386447u, 3219419842u, 1550029926u, 0, COS_TOLERANCE, 0},
{ 94, 3188695272u, 3011191657u, 1103798670u, 1096124830u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 95, 1063235023u, 2540404725u, 3240157452u, 4122845725u, 1072693244u, 343002006u, 0, COS_TOLERANCE, 0},
{ 96, 1083643710u, 311336721u, 3214382367u, 4212533768u, 1070821938u, 789880753u, 0, COS_TOLERANCE, 0},
{ 97, 1051139427u, 1769686293u, 3240200923u, 3538602249u, 1072693247u, 4294965159u, 0, COS_TOLERANCE, 0},
{ 98, 1078227549u, 508056696u, 1103793878u, 776520138u, 3220173977u, 2550253995u, 0, COS_TOLERANCE, 0},
{ 99, 1102910577u, 4064962760u, 1077424413u, 819766631u, 1072637279u, 908201379u, 0, COS_TOLERANCE, 0},
{ 100, 1074178362u, 2112385259u, 3227593179u, 1187058516u, 3220077595u, 2239968209u, 0, COS_TOLERANCE, 0},
{ 101, 1082295059u, 2514398118u, 1076579751u, 870169764u, 3217602657u, 1772072422u, 0, COS_TOLERANCE, 0},
{ 102, 3246851392u, 1190259653u, 1069112254u, 3417249840u, 1071168295u, 2722648006u, 0, COS_TOLERANCE, 0},
{ 103, 3193663083u, 3467757357u, 3215075200u, 2168175352u, 1072693247u, 4294967293u, 0, COS_TOLERANCE, 0},
{ 104, 3239643135u, 1508888184u, 1060430241u, 3524949092u, 3218963721u, 2907233862u, 0, COS_TOLERANCE, 0},
{ 105, 3197412883u, 166402802u, 3237198975u, 3572369260u, 1072693247u, 4294966870u, 0, COS_TOLERANCE, 0},
{ 106, 1081866822u, 2441536203u, 3202753937u, 3658194573u, 1067566718u, 4225817352u, 0, COS_TOLERANCE, 0},
{ 107, 1062392908u, 2479742828u, 1062342831u, 4214154303u, 1072693246u, 2641702618u, 0, COS_TOLERANCE, 0},
{ 108, 1082396794u, 426896765u, 1066474375u, 2201754442u, 1071165698u, 123828766u, 0, COS_TOLERANCE, 0},
{ 109, 3195629021u, 2055773734u, 3239267288u, 291396537u, 1072693247u, 4294967256u, 0, COS_TOLERANCE, 0},
{ 110, 3236968033u, 874125203u, 3210508124u, 4091098764u, 1071882731u, 2672345646u, 0, COS_TOLERANCE, 0},
{ 111, 1065716026u, 120488169u, 3241241441u, 1985269424u, 1072693132u, 218165317u, 0, COS_TOLERANCE, 0},
{ 112, 3206539410u, 2243036871u, 3243941101u, 740033495u, 1072693247u, 4228241722u, 0, COS_TOLERANCE, 0},
{ 113, 3209424906u, 1176656356u, 1074261978u, 3588756231u, 1072693247u, 1021260099u, 0, COS_TOLERANCE, 0},
{ 114, 3252816791u, 3037249392u, 1061635587u, 1173102190u, 3219266232u, 3815073247u, 0, COS_TOLERANCE, 0},
{ 115, 3237209581u, 2882725208u, 1071440059u, 69225090u, 3219903600u, 3901518120u, 0, COS_TOLERANCE, 0},
{ 116, 3212663474u, 272319256u, 1072073912u, 2493997123u, 1072693194u, 625444171u, 0, COS_TOLERANCE, 0},
{ 117, 1057720186u, 188610379u, 3232757923u, 2209647371u, 1072693247u, 4282550564u, 0, COS_TOLERANCE, 0},
{ 118, 3236758517u, 1990439193u, 1078073146u, 622849962u, 3219972032u, 2985029200u, 0, COS_TOLERANCE, 0},
{ 119, 1057135741u, 756052458u, 1081649113u, 2247475162u, 1072693247u, 4289292207u, 0, COS_TOLERANCE, 0},
{ 120, 1061623064u, 3878055211u, 3222407050u, 2979438623u, 1072693247u, 2060251828u, 0, COS_TOLERANCE, 0},
{ 121, 3195290997u, 2676398686u, 1105124431u, 3631096636u, 1072693247u, 4294967270u, 0, COS_TOLERANCE, 0},
{ 122, 1065079390u, 1697791764u, 3198136112u, 2299842819u, 1072693199u, 2671749887u, 0, COS_TOLERANCE, 0},
{ 123, 1078084768u, 1931502677u, 3215264397u, 3016456382u, 1071211061u, 1694081574u, 0, COS_TOLERANCE, 0},
{ 124, 1072253426u, 343404215u, 1061072607u, 4266232536u, 1072071754u, 2362655966u, 0, COS_TOLERANCE, 0},
{ 125, 3241230836u, 4140316002u, 1082896196u, 868256971u, 1067970065u, 236323897u, 0, COS_TOLERANCE, 0},
{ 126, 1075422810u, 1864139509u, 3187675097u, 3084482407u, 1072675750u, 738312426u, 0, COS_TOLERANCE, 0},
{ 127, 3220191323u, 2427162817u, 3234748208u, 2715105792u, 1071704804u, 3513111898u, 0, COS_TOLERANCE, 0},
{ 128, 1064600512u, 3943389284u, 1046724025u, 3626825684u, 1072693221u, 2992922303u, 0, COS_TOLERANCE, 0},
{ 129, 1045423002u, 967350972u, 1093012318u, 448002663u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 130, 3251845859u, 105058217u, 1069733884u, 171786224u, 1070874665u, 4056918988u, 0, COS_TOLERANCE, 0},
{ 131, 3189614508u, 2863482262u, 3204997271u, 877784425u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 132, 3202629313u, 2801782962u, 3213604117u, 762347195u, 1072693247u, 4294547593u, 0, COS_TOLERANCE, 0},
{ 133, 3233486727u, 2317950339u, 3246333414u, 2135700283u, 1071423350u, 1925583622u, 0, COS_TOLERANCE, 0},
{ 134, 1056516397u, 4171919805u, 1082858682u, 2180920863u, 1072693247u, 4292374246u, 0, COS_TOLERANCE, 0},
{ 135, 3220149084u, 1918836931u, 1083603224u, 3137821660u, 1071752494u, 1517813325u, 0, COS_TOLERANCE, 0},
{ 136, 1103902874u, 3456203663u, 3235600523u, 2335688936u, 1072655531u, 1757361807u, 0, COS_TOLERANCE, 0},
{ 137, 1042279322u, 4170235262u, 1051824459u, 521583737u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 138, 1081348303u, 1296623194u, 3250673860u, 2442872540u, 1072317229u, 4079105971u, 0, COS_TOLERANCE, 0},
{ 139, 1061684277u, 289979405u, 1049514449u, 3865737145u, 1072693247u, 1875738416u, 0, COS_TOLERANCE, 0},
{ 140, 1075298944u, 3699090239u, 1054539840u, 3259249360u, 1072570919u, 238752392u, 0, COS_TOLERANCE, 0},
{ 141, 1096418100u, 1619819023u, 1045993352u, 1022642459u, 3219637414u, 3481518986u, 0, COS_TOLERANCE, 0},
{ 142, 1081433004u, 19455098u, 3229182089u, 2096003654u, 3219678173u, 2534237273u, 0, COS_TOLERANCE, 0},
{ 143, 1076297936u, 3803689997u, 1071630912u, 2263729518u, 1071580496u, 1399605139u, 0, COS_TOLERANCE, 0},
{ 144, 1101357261u, 2816837387u, 1063422305u, 2597606398u, 1066778374u, 860886019u, 0, COS_TOLERANCE, 0},
{ 145, 1069100169u, 3680967506u, 1040201163u, 179224723u, 1072683116u, 2152105890u, 0, COS_TOLERANCE, 0},
{ 146, 3188629767u, 978126928u, 1101553990u, 4047893399u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 147, 3222322045u, 4059818629u, 1042678728u, 3640293589u, 3219138641u, 3149630976u, 0, COS_TOLERANCE, 0},
{ 148, 3248464040u, 3383497159u, 1070002807u, 1527313008u, 1072628731u, 666198183u, 0, COS_TOLERANCE, 0},
{ 149, 3202707679u, 2599946514u, 1104170406u, 2738675352u, 1072693247u, 4294496550u, 0, COS_TOLERANCE, 0},
{ 150, 1105232623u, 3616571377u, 1060859316u, 1130603218u, 3219551476u, 3842454686u, 0, COS_TOLERANCE, 0},
{ 151, 1076028796u, 3859211180u, 1067940450u, 1744531824u, 3220176319u, 3761295717u, 0, COS_TOLERANCE, 0},
{ 152, 1042831340u, 1958025850u, 3236511256u, 2472176453u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 153, 3233107089u, 182132862u, 3250520938u, 3924356991u, 1070916656u, 1268984698u, 0, COS_TOLERANCE, 0},
{ 154, 3230501884u, 35632886u, 3209806504u, 1453402523u, 3220161476u, 3827356380u, 0, COS_TOLERANCE, 0},
{ 155, 1083522102u, 743225214u, 3202890678u, 142917400u, 3218326965u, 3272616966u, 0, COS_TOLERANCE, 0},
{ 156, 1080684976u, 1472665012u, 3203138231u, 256588219u, 1072648192u, 1641985006u, 0, COS_TOLERANCE, 0},
{ 157, 1094982162u, 1062927000u, 1061134072u, 931677439u, 3219670357u, 1996358820u, 0, COS_TOLERANCE, 0},
{ 158, 1058377732u, 2320910576u, 1055663370u, 288059864u, 1072693247u, 4264496700u, 0, COS_TOLERANCE, 0},
{ 159, 1078958093u, 1448349062u, 3199478070u, 3454027134u, 1072561713u, 3617278346u, 0, COS_TOLERANCE, 0},
{ 160, 3237458798u, 4215445172u, 3196654963u, 2231888973u, 3219831914u, 2197099287u, 0, COS_TOLERANCE, 0},
{ 161, 3246632231u, 40413554u, 3232578253u, 983832844u, 3219393991u, 4244268719u, 0, COS_TOLERANCE, 0},
{ 162, 3223721534u, 3995725873u, 1050082319u, 777231627u, 1068007582u, 3698554498u, 0, COS_TOLERANCE, 0},
{ 163, 1040986626u, 672789828u, 3253385962u, 2982787335u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 164, 1068390875u, 2075971825u, 1070166500u, 4034633931u, 1072689564u, 1480933942u, 0, COS_TOLERANCE, 0},
{ 165, 3210046177u, 1018222907u, 3244621407u, 3090050495u, 1072693246u, 894071046u, 0, COS_TOLERANCE, 0},
{ 166, 1067680885u, 937732557u, 3200798890u, 2557898276u, 1072691724u, 2004754951u, 0, COS_TOLERANCE, 0},
{ 167, 1078342316u, 130346162u, 3223590310u, 275568693u, 1072516434u, 2675973119u, 0, COS_TOLERANCE, 0},
{ 168, 1042898869u, 3807416441u, 1075961161u, 3706820266u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 169, 3216099005u, 1710131411u, 1078123323u, 1900790503u, 1072688194u, 283976070u, 0, COS_TOLERANCE, 0},
{ 170, 3238819361u, 3420420033u, 3210844787u, 588423066u, 1072644591u, 1123227723u, 0, COS_TOLERANCE, 0},
{ 171, 1049684114u, 1160162008u, 3246307879u, 4265764460u, 1072693247u, 4294967010u, 0, COS_TOLERANCE, 0},
{ 172, 1102543434u, 366653268u, 3188814424u, 466059202u, 3219743093u, 986998908u, 0, COS_TOLERANCE, 0},
{ 173, 3226627739u, 1325936170u, 3221436876u, 680097612u, 3216595555u, 1191345507u, 0, COS_TOLERANCE, 0},
{ 174, 3240391116u, 1827735934u, 3200554324u, 2875599271u, 1072503248u, 1868121844u, 0, COS_TOLERANCE, 0},
{ 175, 3191030402u, 3117037091u, 3239246636u, 15838845u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 176, 1051974004u, 749718883u, 3223587064u, 1523766569u, 1072693247u, 4294960992u, 0, COS_TOLERANCE, 0},
{ 177, 1044833651u, 1966536294u, 3250158026u, 699164258u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 178, 1098048435u, 3759049394u, 1106085272u, 1183789499u, 1072691618u, 3041709198u, 0, COS_TOLERANCE, 0},
{ 179, 1081201623u, 1970107747u, 1095245453u, 2308233883u, 3219755792u, 3979452503u, 0, COS_TOLERANCE, 0},
{ 180, 1084756444u, 1491017852u, 1041444355u, 1723375725u, 3219261752u, 4208808435u, 0, COS_TOLERANCE, 0},
{ 181, 3216630070u, 1141349287u, 1097465301u, 3403438584u, 1072682540u, 4092757052u, 0, COS_TOLERANCE, 0},
{ 182, 3230571908u, 1711085243u, 3250239076u, 1377484108u, 1072449179u, 928800032u, 0, COS_TOLERANCE, 0},
{ 183, 1098385019u, 2880275004u, 1084039594u, 1611394950u, 3219752042u, 46623548u, 0, COS_TOLERANCE, 0},
{ 184, 3234221435u, 2626629370u, 1063771493u, 1499080813u, 3219651433u, 2521766740u, 0, COS_TOLERANCE, 0},
{ 185, 1055231263u, 3936262414u, 1103919063u, 3175668759u, 1072693247u, 4294491692u, 0, COS_TOLERANCE, 0},
{ 186, 3207981719u, 1270950554u, 3194616071u, 3680565379u, 1072693247u, 3791307599u, 0, COS_TOLERANCE, 0},
{ 187, 3208148223u, 1066985223u, 3221613219u, 4089383168u, 1072693247u, 3667765955u, 0, COS_TOLERANCE, 0},
{ 188, 3217058839u, 4017329311u, 3208334452u, 1667591498u, 1072676011u, 2167587667u, 0, COS_TOLERANCE, 0},
{ 189, 1088164157u, 3154656624u, 1061894279u, 3886344038u, 3216679210u, 1818609093u, 0, COS_TOLERANCE, 0},
{ 190, 1050652945u, 977586119u, 3209762784u, 953839852u, 1072693247u, 4294966292u, 0, COS_TOLERANCE, 0},
{ 191, 1104965247u, 143071571u, 3206165386u, 913097445u, 3209527911u, 318935467u, 0, COS_TOLERANCE, 0},
{ 192, 3190565456u, 1371169579u, 1057079837u, 2594818628u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 193, 3251793336u, 2259342224u, 3217432469u, 1824221478u, 1070395363u, 3856479702u, 0, COS_TOLERANCE, 0},
{ 194, 3246834775u, 1576604497u, 1079368611u, 185078728u, 3219883428u, 4029972147u, 0, COS_TOLERANCE, 0},
{ 195, 3221679427u, 444800035u, 3243343143u, 1734989302u, 3220097672u, 3511674499u, 0, COS_TOLERANCE, 0},
{ 196, 1072748883u, 130452005u, 1041548088u, 2158433515u, 1071623349u, 3706410280u, 0, COS_TOLERANCE, 0},
{ 197, 3234695968u, 1941318385u, 1045807374u, 792193370u, 3219904781u, 703541186u, 0, COS_TOLERANCE, 0},
{ 198, 3238299666u, 1299392207u, 3212131720u, 3205732280u, 1072599785u, 3720054216u, 0, COS_TOLERANCE, 0},
{ 199, 1098698804u, 3035093505u, 1052187689u, 3287702190u, 3219456887u, 3838760304u, 0, COS_TOLERANCE, 0},
{ 200, 3246676260u, 2160225215u, 1102624859u, 836655570u, 1072687744u, 3313356440u, 0, COS_TOLERANCE, 0},
{ 201, 1096723626u, 3360816360u, 3246176356u, 172860634u, 1069279907u, 1519263517u, 0, COS_TOLERANCE, 0},
{ 202, 1070995788u, 146831910u, 1051558014u, 2340722078u, 1072569465u, 2825939377u, 0, COS_TOLERANCE, 0},
{ 203, 3230416351u, 1603798153u, 3207725532u, 1099413093u, 1071649358u, 2402319227u, 0, COS_TOLERANCE, 0},
{ 204, 3246678378u, 2429340443u, 3190303581u, 3223770005u, 1070273707u, 639884644u, 0, COS_TOLERANCE, 0},
{ 205, 1075882959u, 955542166u, 3230415151u, 275583938u, 3218973899u, 3343006637u, 0, COS_TOLERANCE, 0},
{ 206, 1092971882u, 513397822u, 1090646554u, 2089321329u, 1072578768u, 4105682742u, 0, COS_TOLERANCE, 0},
{ 207, 3193169876u, 2782073372u, 1046063872u, 4023829068u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 208, 1098564822u, 3242223094u, 3194111199u, 4264674108u, 3219756194u, 114364412u, 0, COS_TOLERANCE, 0},
{ 209, 3238510821u, 3506346169u, 1047020885u, 1742757458u, 1068041315u, 3314006670u, 0, COS_TOLERANCE, 0},
{ 210, 3192664477u, 1265459564u, 3193450280u, 3650514880u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 211, 1081755890u, 1525260440u, 3235452527u, 2612331392u, 1072515870u, 1309324223u, 0, COS_TOLERANCE, 0},
{ 212, 3248668920u, 1263613754u, 3219096387u, 635677201u, 1064607335u, 757792299u, 0, COS_TOLERANCE, 0},
{ 213, 3206272087u, 4140947288u, 3200792376u, 2013265346u, 1072693247u, 4244211024u, 0, COS_TOLERANCE, 0},
{ 214, 3249974392u, 1912759945u, 3237045253u, 1351396825u, 3219078023u, 281517845u, 0, COS_TOLERANCE, 0},
{ 215, 3248205162u, 1001433078u, 3206926643u, 2741676659u, 3216471237u, 123092552u, 0, COS_TOLERANCE, 0},
{ 216, 1080923606u, 1088945233u, 1085095743u, 3986114865u, 3219070825u, 662210141u, 0, COS_TOLERANCE, 0},
{ 217, 3215734057u, 831239754u, 1099828675u, 3071308141u, 1072690066u, 501010715u, 0, COS_TOLERANCE, 0},
{ 218, 3225834497u, 3473592372u, 1102759382u, 1309576357u, 1072234656u, 1267394401u, 0, COS_TOLERANCE, 0},
{ 219, 3251186706u, 2042340367u, 1091945628u, 2062772374u, 3218286427u, 4165170757u, 0, COS_TOLERANCE, 0},
{ 220, 3194765687u, 1840632537u, 1096533424u, 807510337u, 1072693247u, 4294967284u, 0, COS_TOLERANCE, 0},
{ 221, 3231451722u, 144814872u, 3212698915u, 2282965697u, 3219652387u, 1204999511u, 0, COS_TOLERANCE, 0},
{ 222, 1071236430u, 2552499583u, 3229111426u, 1470130815u, 1072525515u, 1870070019u, 0, COS_TOLERANCE, 0},
{ 223, 3243093065u, 2858583811u, 1089760910u, 6360994u, 1070394969u, 2858431682u, 0, COS_TOLERANCE, 0},
{ 224, 3198264929u, 1614537194u, 1075198900u, 4088705365u, 1072693247u, 4294966050u, 0, COS_TOLERANCE, 0},
{ 225, 3250939070u, 3545570051u, 1065221325u, 1629217700u, 3220046486u, 2008922076u, 0, COS_TOLERANCE, 0},
{ 226, 1072744324u, 1813392963u, 3235313361u, 3772501596u, 1071639174u, 3586456012u, 0, COS_TOLERANCE, 0},
{ 227, 3196802686u, 2406734491u, 1042055360u, 89226663u, 1072693247u, 4294967109u, 0, COS_TOLERANCE, 0},
{ 228, 3195751081u, 1618759139u, 3194723421u, 3888234802u, 1072693247u, 4294967249u, 0, COS_TOLERANCE, 0},
{ 229, 1055357248u, 3590035633u, 3212424262u, 2892456615u, 1072693247u, 4294403060u, 0, COS_TOLERANCE, 0},
{ 230, 3189943060u, 2431246964u, 3241512456u, 183850734u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 231, 1089501101u, 3088319870u, 3211544311u, 862225364u, 1071959314u, 493775910u, 0, COS_TOLERANCE, 0},
{ 232, 3235294664u, 3495352775u, 1058576726u, 596957268u, 1072451569u, 551802197u, 0, COS_TOLERANCE, 0},
{ 233, 1046553348u, 1839214511u, 3205004060u, 1923240983u, 1072693247u, 4294967291u, 0, COS_TOLERANCE, 0},
{ 234, 1058073864u, 739619702u, 3223356436u, 2689885273u, 1072693247u, 4276192130u, 0, COS_TOLERANCE, 0},
{ 235, 3200324971u, 2143376228u, 1098306332u, 3760236188u, 1072693247u, 4294948617u, 0, COS_TOLERANCE, 0},
{ 236, 1074621795u, 671680995u, 1091262633u, 2315535361u, 3219881910u, 233991145u, 0, COS_TOLERANCE, 0},
{ 237, 3214165989u, 2493598049u, 3194927008u, 1689107592u, 1072692836u, 3009462380u, 0, COS_TOLERANCE, 0},
{ 238, 3189989959u, 1578976988u, 1066368383u, 2117279163u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 239, 3222988111u, 3425290087u, 1098487295u, 1263412017u, 1072492825u, 2465022517u, 0, COS_TOLERANCE, 0},
{ 240, 3208432764u, 3635396812u, 1070999426u, 3965655689u, 1072693247u, 3425310116u, 0, COS_TOLERANCE, 0},
{ 241, 1060196346u, 2183973116u, 1101098363u, 1118613350u, 1072693247u, 3980688356u, 0, COS_TOLERANCE, 0},
{ 242, 3221946089u, 199516350u, 1078368488u, 164621458u, 3220120287u, 1310788330u, 0, COS_TOLERANCE, 0},
{ 243, 3187706018u, 3570940805u, 3230316437u, 3596080877u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 244, 3208209565u, 980880313u, 1079833442u, 884465057u, 1072693247u, 3618839550u, 0, COS_TOLERANCE, 0},
{ 245, 1099977124u, 2558179220u, 1052873711u, 1233598120u, 1071831726u, 2415570643u, 0, COS_TOLERANCE, 0},
{ 246, 1047115221u, 1909994277u, 1085015978u, 2991527452u, 1072693247u, 4294967286u, 0, COS_TOLERANCE, 0},
{ 247, 1060855260u, 1680290941u, 1074309900u, 2943870846u, 1072693247u, 3509653915u, 0, COS_TOLERANCE, 0},
{ 248, 1059496132u, 1451927357u, 3228615456u, 1502585517u, 1072693247u, 4160742701u, 0, COS_TOLERANCE, 0},
{ 249, 3236211951u, 751136990u, 3230392165u, 3493275472u, 1071493159u, 3153711522u, 0, COS_TOLERANCE, 0},
{ 250, 1098365967u, 1209623292u, 3238056647u, 979495322u, 1072345567u, 1983815099u, 0, COS_TOLERANCE, 0},
{ 251, 3250424296u, 1717672108u, 1048120593u, 531240316u, 3220132606u, 3517673695u, 0, COS_TOLERANCE, 0},
{ 252, 1054174923u, 3548721654u, 1086112947u, 3391817224u, 1072693247u, 4294849699u, 0, COS_TOLERANCE, 0},
{ 253, 1077836851u, 2758195125u, 1100880260u, 2028440924u, 1071848560u, 3295006250u, 0, COS_TOLERANCE, 0},
{ 254, 1084223893u, 2750123373u, 3232200256u, 1086294931u, 3219569628u, 148313502u, 0, COS_TOLERANCE, 0},
{ 255, 1043958672u, 2986160931u, 1076097908u, 2540046258u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 256, 3235476602u, 451471221u, 1064816262u, 4187644495u, 3220163367u, 3738180901u, 0, COS_TOLERANCE, 0},
{ 257, 1099460228u, 2439500162u, 1065280276u, 1979490284u, 3220023311u, 1024828250u, 0, COS_TOLERANCE, 0},
{ 258, 1040415832u, 2283342035u, 1078398157u, 1345997553u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 259, 3213249348u, 179066662u, 1103272172u, 1217337578u, 1072693123u, 3202070629u, 0, COS_TOLERANCE, 0},
{ 260, 3211562377u, 3779303391u, 3210023352u, 3115946280u, 1072693235u, 1122971280u, 0, COS_TOLERANCE, 0},
{ 261, 3192989874u, 286247089u, 1085153597u, 713645369u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 262, 1093670500u, 1468283899u, 1042831668u, 2022736418u, 3219645414u, 292214014u, 0, COS_TOLERANCE, 0},
{ 263, 1083139105u, 3305564080u, 1065483445u, 482392433u, 1072067451u, 2731650049u, 0, COS_TOLERANCE, 0},
{ 264, 3201695807u, 2256346551u, 3222430705u, 2071674991u, 1072693247u, 4294843381u, 0, COS_TOLERANCE, 0},
{ 265, 3204024695u, 2295269094u, 1084451053u, 2773103941u, 1072693247u, 4292296141u, 0, COS_TOLERANCE, 0},
{ 266, 1078173946u, 1482721827u, 1092243422u, 3125409590u, 1065951213u, 4253023021u, 0, COS_TOLERANCE, 0},
{ 267, 3221065973u, 1381740563u, 1071545057u, 2918235653u, 3218178568u, 1182312665u, 0, COS_TOLERANCE, 0},
{ 268, 3238715972u, 1105857967u, 3241990046u, 2703723225u, 1072322220u, 1636652464u, 0, COS_TOLERANCE, 0},
{ 269, 1043015571u, 174689677u, 1079333374u, 3947057014u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 270, 1090461859u, 2023082423u, 3242081486u, 1169047927u, 1072659623u, 24608123u, 0, COS_TOLERANCE, 0},
{ 271, 1064525899u, 3742487766u, 1043425732u, 194972788u, 1072693224u, 2299206777u, 0, COS_TOLERANCE, 0},
{ 272, 3213791827u, 2136071361u, 3211529757u, 993675115u, 1072693014u, 1498352825u, 0, COS_TOLERANCE, 0},
{ 273, 3213663381u, 210772141u, 3241441539u, 580731413u, 1072693043u, 1489106434u, 0, COS_TOLERANCE, 0},
{ 274, 1093840413u, 1751560711u, 1074522705u, 180987057u, 1072199249u, 2159086108u, 0, COS_TOLERANCE, 0},
{ 275, 1066754591u, 2552236599u, 1088658621u, 2112468655u, 1072692790u, 3312828073u, 0, COS_TOLERANCE, 0},
{ 276, 3189290617u, 1578223762u, 3224596567u, 2456166162u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 277, 1058506965u, 2110924310u, 1086207177u, 3161208323u, 1072693247u, 4258668672u, 0, COS_TOLERANCE, 0},
{ 278, 3231863394u, 2352173188u, 1079361728u, 4070222179u, 1064984779u, 600856666u, 0, COS_TOLERANCE, 0},
{ 279, 1101012904u, 2481562701u, 1090937016u, 3809489716u, 1072641608u, 727711588u, 0, COS_TOLERANCE, 0},
{ 280, 3197002651u, 330905705u, 1086260896u, 90264431u, 1072693247u, 4294967065u, 0, COS_TOLERANCE, 0},
{ 281, 1040729961u, 4162008079u, 3194387916u, 759522153u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 282, 1081015037u, 1839697482u, 3216442625u, 2211508949u, 3220055171u, 952539875u, 0, COS_TOLERANCE, 0},
{ 283, 3249807211u, 3736863454u, 1063475914u, 3150741666u, 1072328816u, 3934941618u, 0, COS_TOLERANCE, 0},
{ 284, 1060785883u, 4200269406u, 3236646101u, 1061812176u, 1072693247u, 3569234031u, 0, COS_TOLERANCE, 0},
{ 285, 1080217979u, 106027290u, 3234978297u, 2245237549u, 1072627959u, 1497207890u, 0, COS_TOLERANCE, 0},
{ 286, 3246984334u, 2132131375u, 3250483427u, 3449276437u, 1072669917u, 2457870217u, 0, COS_TOLERANCE, 0},
{ 287, 1089388778u, 2334440944u, 1105423490u, 4004336184u, 1072226828u, 3655844754u, 0, COS_TOLERANCE, 0},
{ 288, 3218772704u, 4090088208u, 1042030013u, 3898658299u, 1072515052u, 1642000346u, 0, COS_TOLERANCE, 0},
{ 289, 3207908064u, 2272831437u, 3253082595u, 2639188641u, 1072693247u, 3841638975u, 0, COS_TOLERANCE, 0},
{ 290, 1054766684u, 1856594168u, 3189515294u, 4101853676u, 1072693247u, 4294729740u, 0, COS_TOLERANCE, 0},
{ 291, 1076012412u, 2211699255u, 3195060344u, 3865018604u, 3220166089u, 1388690552u, 0, COS_TOLERANCE, 0},
{ 292, 3242767010u, 996259334u, 3241496889u, 3782673116u, 3220090835u, 3150301332u, 0, COS_TOLERANCE, 0},
{ 293, 1099130747u, 3840380763u, 1048674041u, 550040067u, 1071869811u, 2331064655u, 0, COS_TOLERANCE, 0},
{ 294, 3251419593u, 95874100u, 3237232828u, 2645647822u, 1070705466u, 1321517167u, 0, COS_TOLERANCE, 0},
{ 295, 1043665640u, 3441419500u, 3252367038u, 876710419u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 296, 3238593552u, 2560836004u, 3199616543u, 1180840586u, 3219473031u, 3806360310u, 0, COS_TOLERANCE, 0},
{ 297, 3221602966u, 2218230392u, 3227485787u, 3947214579u, 3219993277u, 2784902361u, 0, COS_TOLERANCE, 0},
{ 298, 1079539654u, 1447312532u, 1081476588u, 780366847u, 3219937861u, 1517430120u, 0, COS_TOLERANCE, 0},
{ 299, 1072569643u, 2842113832u, 3216156731u, 225159029u, 1071831173u, 3436385363u, 0, COS_TOLERANCE, 0},
{ 300, 1098117193u, 1601981129u, 3234628869u, 2236538344u, 3220121730u, 2605810833u, 0, COS_TOLERANCE, 0},
{ 301, 1085173524u, 2194185737u, 3242362684u, 87913366u, 1072691976u, 256415598u, 0, COS_TOLERANCE, 0},
{ 302, 3199083880u, 1346862963u, 1077836259u, 3604666660u, 1072693247u, 4294963661u, 0, COS_TOLERANCE, 0},
{ 303, 3212255979u, 3115209742u, 1099332326u, 1325101950u, 1072693214u, 2337531688u, 0, COS_TOLERANCE, 0},
{ 304, 3224546042u, 3889223100u, 1053247613u, 3371396923u, 1072658737u, 3503272081u, 0, COS_TOLERANCE, 0},
{ 305, 3220477868u, 4163120793u, 1075022670u, 1387631215u, 1070721812u, 2081699423u, 0, COS_TOLERANCE, 0},
{ 306, 3205481779u, 1532426189u, 1063168268u, 3397022615u, 1072693247u, 4278430058u, 0, COS_TOLERANCE, 0},
{ 307, 3201033321u, 89324166u, 1079206060u, 3429424710u, 1072693247u, 4294917506u, 0, COS_TOLERANCE, 0},
{ 308, 3192325102u, 747591401u, 1072238381u, 2803213904u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 309, 1091113780u, 271904221u, 1044258318u, 1858545114u, 3216584532u, 2619540521u, 0, COS_TOLERANCE, 0},
{ 310, 3228068914u, 314958082u, 3249912496u, 2966213175u, 1072324141u, 1738955103u, 0, COS_TOLERANCE, 0},
{ 311, 3197179414u, 3119528953u, 3217179014u, 2908718240u, 1072693247u, 4294967004u, 0, COS_TOLERANCE, 0},
{ 312, 3242467576u, 2018361566u, 1100926600u, 3985805054u, 1071310530u, 1465528159u, 0, COS_TOLERANCE, 0},
{ 313, 1070132580u, 409584884u, 3239758947u, 755795129u, 1072653605u, 3434577925u, 0, COS_TOLERANCE, 0},
{ 314, 1075772446u, 1819156379u, 3251342302u, 2982669005u, 1069254981u, 541526918u, 0, COS_TOLERANCE, 0},
{ 315, 1101563433u, 2080534280u, 3188254060u, 449171797u, 1067588739u, 1933402886u, 0, COS_TOLERANCE, 0},
{ 316, 1095956900u, 168744837u, 3214950009u, 1322217822u, 3219443322u, 2005695949u, 0, COS_TOLERANCE, 0},
{ 317, 3254226900u, 3250487255u, 1062120700u, 1876195180u, 1071200278u, 2307560753u, 0, COS_TOLERANCE, 0},
{ 318, 3226343480u, 1336400247u, 1098057903u, 3314079581u, 3219921214u, 2661345031u, 0, COS_TOLERANCE, 0},
{ 319, 3203678820u, 265025555u, 1063854282u, 3779482256u, 1072693247u, 4293286130u, 0, COS_TOLERANCE, 0},
{ 320, 1067300501u, 887044257u, 1054789618u, 2732056261u, 1072692365u, 802497887u, 0, COS_TOLERANCE, 0},
{ 321, 1050106742u, 4027115185u, 3191764868u, 2940199511u, 1072693247u, 4294966750u, 0, COS_TOLERANCE, 0},
{ 322, 3202500155u, 2875684421u, 3227459837u, 2251967570u, 1072693247u, 4294625329u, 0, COS_TOLERANCE, 0},
{ 323, 1063244412u, 284173546u, 3238823679u, 3557800647u, 1072693244u, 190380283u, 0, COS_TOLERANCE, 0},
{ 324, 1101458560u, 3147771266u, 3220110464u, 2933364246u, 3219734106u, 2044690356u, 0, COS_TOLERANCE, 0},
{ 325, 1064853160u, 3366183281u, 3234870843u, 537442654u, 1072693210u, 3789343972u, 0, COS_TOLERANCE, 0},
{ 326, 3244118788u, 2529029548u, 3249882819u, 3781513577u, 3218152634u, 3189802031u, 0, COS_TOLERANCE, 0},
{ 327, 3213436354u, 1080845539u, 3206760016u, 911778687u, 1072693089u, 3877739302u, 0, COS_TOLERANCE, 0},
{ 328, 3191951036u, 469586759u, 1091830022u, 3080528840u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 329, 1080249104u, 2863108169u, 3225605506u, 2508274250u, 3220004966u, 1582349409u, 0, COS_TOLERANCE, 0},
{ 330, 3210826984u, 4080017377u, 3206492941u, 1470284690u, 1072693243u, 1316205920u, 0, COS_TOLERANCE, 0},
{ 331, 3207120390u, 3867917386u, 1102054928u, 3504746045u, 1072693247u, 4134082073u, 0, COS_TOLERANCE, 0},
{ 332, 1064522279u, 2962134101u, 3244741577u, 3390537350u, 1072693224u, 2873015107u, 0, COS_TOLERANCE, 0},
{ 333, 1088201813u, 1702237980u, 1071598971u, 1102587474u, 1072356356u, 900001206u, 0, COS_TOLERANCE, 0},
{ 334, 3202970118u, 2180218657u, 3211592260u, 1206527853u, 1072693247u, 4294304288u, 0, COS_TOLERANCE, 0},
{ 335, 3197084744u, 394130786u, 3242511482u, 2437699868u, 1072693247u, 4294967046u, 0, COS_TOLERANCE, 0},
{ 336, 1044237059u, 849581558u, 3252006507u, 2008614943u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 337, 3210140014u, 3128971673u, 3249137531u, 2773583059u, 1072693245u, 4125642902u, 0, COS_TOLERANCE, 0},
{ 338, 1085029866u, 590727700u, 3248651761u, 2183878539u, 3219184738u, 2192070315u, 0, COS_TOLERANCE, 0},
{ 339, 1101098629u, 820687580u, 3208143496u, 1402434664u, 3220058761u, 1210702081u, 0, COS_TOLERANCE, 0},
{ 340, 3252290835u, 1873709254u, 3245167989u, 44275991u, 3219673004u, 1212928558u, 0, COS_TOLERANCE, 0},
{ 341, 3189668753u, 1174874204u, 3208263730u, 2360372288u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 342, 1103854676u, 937573440u, 3208953761u, 211240241u, 1072050384u, 2201399798u, 0, COS_TOLERANCE, 0},
{ 343, 3243548934u, 2469774991u, 1043117070u, 3380071805u, 3219556824u, 3682801548u, 0, COS_TOLERANCE, 0},
{ 344, 1058121042u, 442507560u, 3254252803u, 3257889649u, 1072693247u, 4274561110u, 0, COS_TOLERANCE, 0},
{ 345, 1068850520u, 1854921625u, 1049810168u, 2729627545u, 1072685949u, 338147145u, 0, COS_TOLERANCE, 0},
{ 346, 3254712629u, 4001809575u, 3240128649u, 278261523u, 1072401494u, 1009857194u, 0, COS_TOLERANCE, 0},
{ 347, 1087224694u, 1793907966u, 3238955714u, 398859249u, 1070938098u, 1550865209u, 0, COS_TOLERANCE, 0},
{ 348, 3200952547u, 2511916952u, 3219195283u, 1697158299u, 1072693247u, 4294921809u, 0, COS_TOLERANCE, 0},
{ 349, 1069985548u, 3230931724u, 3243897690u, 3508781585u, 1072660402u, 2682188932u, 0, COS_TOLERANCE, 0},
{ 350, 1103847606u, 1674254897u, 1046547577u, 217148561u, 3219915117u, 1778043083u, 0, COS_TOLERANCE, 0},
{ 351, 3211263954u, 3275604304u, 3194840159u, 2991205850u, 1072693239u, 2251119u, 0, COS_TOLERANCE, 0},
{ 352, 3195249375u, 3509997278u, 3248888030u, 3897986511u, 1072693247u, 4294967272u, 0, COS_TOLERANCE, 0},
{ 353, 1047182435u, 2156824613u, 1042295665u, 1239257646u, 1072693247u, 4294967285u, 0, COS_TOLERANCE, 0},
{ 354, 3213264085u, 1073153314u, 3250031627u, 2567234990u, 1072693121u, 971951768u, 0, COS_TOLERANCE, 0},
{ 355, 3190593412u, 4261696995u, 3197784432u, 323702024u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 356, 3243690997u, 4075177615u, 3202791065u, 1919006082u, 3217187639u, 1965923119u, 0, COS_TOLERANCE, 0},
{ 357, 3239270013u, 386429966u, 1086504491u, 3698826164u, 3216317943u, 1107594577u, 0, COS_TOLERANCE, 0},
{ 358, 1078327190u, 1681986446u, 3194985869u, 3072950140u, 1072690830u, 2257146468u, 0, COS_TOLERANCE, 0},
{ 359, 3217311933u, 3719038997u, 1055433962u, 3331415058u, 1072666970u, 2047828524u, 0, COS_TOLERANCE, 0},
{ 360, 1060749713u, 2420250111u, 3238002206u, 1928661079u, 1072693247u, 3599364953u, 0, COS_TOLERANCE, 0},
{ 361, 1081914210u, 3679866727u, 3227386672u, 1273835792u, 1072395803u, 157372037u, 0, COS_TOLERANCE, 0},
{ 362, 1041622738u, 2682092368u, 3234222284u, 1325425811u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 363, 1056312613u, 4175172697u, 3208346191u, 2130706153u, 1072693247u, 4292975565u, 0, COS_TOLERANCE, 0},
{ 364, 1092089624u, 1200784450u, 1083605096u, 1248595607u, 3220015189u, 549505287u, 0, COS_TOLERANCE, 0},
{ 365, 3213890863u, 1897285171u, 3251296075u, 944966123u, 1072692989u, 1504542300u, 0, COS_TOLERANCE, 0},
{ 366, 3241371250u, 2270747330u, 3230692631u, 422503284u, 3217051824u, 2300101304u, 0, COS_TOLERANCE, 0},
{ 367, 1084120037u, 2857564741u, 1075647403u, 3308906709u, 1069138209u, 4033062893u, 0, COS_TOLERANCE, 0},
{ 368, 3203475098u, 1380066948u, 3232612906u, 2613634294u, 1072693247u, 4293762459u, 0, COS_TOLERANCE, 0},
{ 369, 1063890856u, 4022784584u, 1060483857u, 3264056381u, 1072693237u, 2967630019u, 0, COS_TOLERANCE, 0},
{ 370, 1044637404u, 1778509100u, 3213146285u, 2665833973u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 371, 3216727300u, 1859175955u, 1079949560u, 4258450607u, 1072681279u, 1528669149u, 0, COS_TOLERANCE, 0},
{ 372, 1048277388u, 4128020197u, 1076266146u, 4122840980u, 1072693247u, 4294967249u, 0, COS_TOLERANCE, 0},
{ 373, 3193183163u, 2454653987u, 3229487005u, 2977478685u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 374, 3253556483u, 1355181872u, 1095308770u, 436846481u, 1072638418u, 837638418u, 0, COS_TOLERANCE, 0},
{ 375, 3246605302u, 2592856453u, 3247825559u, 3195234082u, 3219761412u, 4175373806u, 0, COS_TOLERANCE, 0},
{ 376, 3222118023u, 3554670043u, 1091621009u, 3321236467u, 3219855658u, 1849229220u, 0, COS_TOLERANCE, 0},
{ 377, 1069012833u, 1936670355u, 1095715713u, 2958468553u, 1072684160u, 113994776u, 0, COS_TOLERANCE, 0},
{ 378, 3192291109u, 2960339502u, 1098808013u, 1044068983u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 379, 3196691185u, 4093388677u, 1095478112u, 1735930261u, 1072693247u, 4294967132u, 0, COS_TOLERANCE, 0},
{ 380, 1091040302u, 1807398746u, 3195743135u, 4261616162u, 1072560488u, 2443022461u, 0, COS_TOLERANCE, 0},
{ 381, 3209294194u, 3250576797u, 1059002384u, 3043079652u, 1072693247u, 1472001997u, 0, COS_TOLERANCE, 0},
{ 382, 1069207109u, 666051428u, 3208765404u, 1912684117u, 1072681761u, 3157012499u, 0, COS_TOLERANCE, 0},
{ 383, 1103487420u, 1949030179u, 1096388934u, 896459246u, 1072112440u, 3662318513u, 0, COS_TOLERANCE, 0},
{ 384, 1054300653u, 622499767u, 1066707637u, 1490260486u, 1072693247u, 4294827704u, 0, COS_TOLERANCE, 0},
{ 385, 1106688493u, 1490616165u, 3251242436u, 795675736u, 1072531194u, 3696734274u, 0, COS_TOLERANCE, 0},
{ 386, 1080943896u, 3662877092u, 3234317146u, 3200513112u, 1072529133u, 2265466345u, 0, COS_TOLERANCE, 0},
{ 387, 1084088786u, 1356101968u, 3236536816u, 3062844611u, 3219578668u, 4220416571u, 0, COS_TOLERANCE, 0},
{ 388, 3219922640u, 2284484846u, 3219498359u, 3240896015u, 1071934299u, 2387177578u, 0, COS_TOLERANCE, 0},
{ 389, 3235759689u, 494503287u, 1092811254u, 142673998u, 3220176682u, 887984525u, 0, COS_TOLERANCE, 0},
{ 390, 3252125916u, 3394882641u, 3225306538u, 364852125u, 1072048934u, 72512142u, 0, COS_TOLERANCE, 0},
{ 391, 3225261763u, 193885269u, 1088149839u, 1359805831u, 3218094098u, 3213564391u, 0, COS_TOLERANCE, 0},
{ 392, 3200484782u, 592580907u, 3199560872u, 3086438952u, 1072693247u, 4294942905u, 0, COS_TOLERANCE, 0},
{ 393, 1059518664u, 1778008540u, 1049064687u, 73581647u, 1072693247u, 4156632868u, 0, COS_TOLERANCE, 0},
{ 394, 3246733598u, 233240285u, 1081923320u, 2710903921u, 1068775539u, 2733461858u, 0, COS_TOLERANCE, 0},
{ 395, 1069513767u, 3719878805u, 1079866720u, 3615458228u, 1072677407u, 497768842u, 0, COS_TOLERANCE, 0},
{ 396, 3221194724u, 3647632375u, 3247225271u, 3839959621u, 3218664046u, 3484392941u, 0, COS_TOLERANCE, 0},
{ 397, 1103401096u, 2232210456u, 3235434773u, 224271737u, 1072307444u, 2600424197u, 0, COS_TOLERANCE, 0},
{ 398, 3193003684u, 2134662911u, 3190390590u, 4239009051u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 399, 1080526145u, 2305279897u, 1077668039u, 1854523320u, 1072579199u, 1091515037u, 0, COS_TOLERANCE, 0},
{ 400, 3219864259u, 538224650u, 3206153057u, 1379649610u, 1071978725u, 4132122137u, 0, COS_TOLERANCE, 0},
{ 401, 3196410507u, 3683897920u, 3244167599u, 3647579469u, 1072693247u, 4294967182u, 0, COS_TOLERANCE, 0},
{ 402, 1090280933u, 2694093608u, 1042775347u, 598406111u, 3216912593u, 4112924109u, 0, COS_TOLERANCE, 0},
{ 403, 3211635392u, 872706833u, 1084802480u, 2200602798u, 1072693234u, 1065041327u, 0, COS_TOLERANCE, 0},
{ 404, 1042339597u, 904146293u, 1060867322u, 1729685598u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 405, 3195694970u, 1894173462u, 3232800651u, 191960416u, 1072693247u, 4294967252u, 0, COS_TOLERANCE, 0},
{ 406, 1091225343u, 3521028551u, 1054522089u, 3287274359u, 1069825174u, 3031550075u, 0, COS_TOLERANCE, 0},
{ 407, 1095386964u, 959640601u, 3201578263u, 4136915018u, 1072408754u, 1688369384u, 0, COS_TOLERANCE, 0},
{ 408, 1064005451u, 1553716379u, 1106027987u, 984725765u, 1072693236u, 1029150851u, 0, COS_TOLERANCE, 0},
{ 409, 3238832641u, 2287646644u, 3240329321u, 2276183378u, 1071746292u, 820755399u, 0, COS_TOLERANCE, 0},
{ 410, 1068209174u, 3940225170u, 3199544434u, 997572161u, 1072690206u, 1917386837u, 0, COS_TOLERANCE, 0},
{ 411, 3212768361u, 36116288u, 3206886566u, 4196602670u, 1072693188u, 485711984u, 0, COS_TOLERANCE, 0},
{ 412, 3241695853u, 3550227562u, 3207257983u, 2747744117u, 3220172545u, 2187450492u, 0, COS_TOLERANCE, 0},
{ 413, 1104236126u, 507130047u, 1048359321u, 3229888373u, 1069360590u, 620968612u, 0, COS_TOLERANCE, 0},
{ 414, 3222996778u, 2210969014u, 1081031001u, 1946786091u, 1072462215u, 1450093973u, 0, COS_TOLERANCE, 0},
{ 415, 3236306990u, 4059150589u, 3189759234u, 1177045799u, 1071955752u, 2076739579u, 0, COS_TOLERANCE, 0},
{ 416, 1093103612u, 2664812822u, 1050343198u, 2034180320u, 3217171938u, 1684460428u, 0, COS_TOLERANCE, 0},
{ 417, 3213779117u, 1175750283u, 3235559706u, 1424491340u, 1072693017u, 1305312596u, 0, COS_TOLERANCE, 0},
{ 418, 3213904193u, 1630036121u, 3231972785u, 3195479448u, 1072692982u, 3293309497u, 0, COS_TOLERANCE, 0},
{ 419, 1090429875u, 2527029044u, 1046927050u, 4000723255u, 1071378480u, 3977336311u, 0, COS_TOLERANCE, 0},
{ 420, 1085208677u, 3335703647u, 3237349676u, 3869440059u, 1072445349u, 2286761790u, 0, COS_TOLERANCE, 0},
{ 421, 1091433848u, 3888398377u, 3196041693u, 1290567220u, 3218367554u, 1055589159u, 0, COS_TOLERANCE, 0},
{ 422, 1066679070u, 3242451480u, 3248384948u, 707431021u, 1072692838u, 3102939233u, 0, COS_TOLERANCE, 0},
{ 423, 1083230509u, 2739665123u, 1060777905u, 1733073225u, 1072675519u, 2422104283u, 0, COS_TOLERANCE, 0},
{ 424, 1078517061u, 1297274853u, 3208848704u, 3341639139u, 1072398277u, 765339862u, 0, COS_TOLERANCE, 0},
{ 425, 1046570941u, 2228057309u, 1084318902u, 1317851136u, 1072693247u, 4294967291u, 0, COS_TOLERANCE, 0},
{ 426, 1088255327u, 270039934u, 3241414679u, 3063626339u, 1072685261u, 597425399u, 0, COS_TOLERANCE, 0},
{ 427, 3219178350u, 83062251u, 3211262173u, 2659016437u, 1072412012u, 4069431777u, 0, COS_TOLERANCE, 0},
{ 428, 1095743886u, 3833539373u, 3206667189u, 1567476111u, 1072307664u, 1056242430u, 0, COS_TOLERANCE, 0},
{ 429, 3205195072u, 2382776852u, 3249232579u, 1546622468u, 1072693247u, 4282670870u, 0, COS_TOLERANCE, 0},
{ 430, 1085536439u, 1714300821u, 1104130938u, 4167591598u, 3217859383u, 2232768404u, 0, COS_TOLERANCE, 0},
{ 431, 1051092760u, 2798720100u, 1086978789u, 449990704u, 1072693247u, 4294965288u, 0, COS_TOLERANCE, 0},
{ 432, 3231198415u, 4039516226u, 3244344107u, 4272932619u, 1067452376u, 2155088169u, 0, COS_TOLERANCE, 0},
{ 433, 3222708441u, 1683007544u, 1091105663u, 3805494321u, 1072295450u, 3246180215u, 0, COS_TOLERANCE, 0},
{ 434, 3220852948u, 2072627412u, 1094383324u, 3394151662u, 3216173352u, 2322177502u, 0, COS_TOLERANCE, 0},
{ 435, 3220570024u, 1120106427u, 3223631624u, 3404608264u, 1070131616u, 4106501870u, 0, COS_TOLERANCE, 0},
{ 436, 1097859997u, 559918757u, 3205077053u, 908100198u, 3218748698u, 3336891511u, 0, COS_TOLERANCE, 0},
{ 437, 1042677918u, 2026673913u, 3244833635u, 2844573214u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 438, 3254567259u, 3946837259u, 3234993796u, 3850406820u, 3220032793u, 4201817022u, 0, COS_TOLERANCE, 0},
{ 439, 1057479809u, 3139330994u, 1046133568u, 1539650690u, 1072693247u, 4285638832u, 0, COS_TOLERANCE, 0},
{ 440, 3236705500u, 1554593884u, 3228899878u, 2813752562u, 1072173572u, 377670647u, 0, COS_TOLERANCE, 0},
{ 441, 1056505004u, 3804703138u, 1072931071u, 2053677923u, 1072693247u, 4292409955u, 0, COS_TOLERANCE, 0},
{ 442, 3244864299u, 289355864u, 1078453818u, 2143066338u, 3219830878u, 3759477379u, 0, COS_TOLERANCE, 0},
{ 443, 3203939880u, 2157691971u, 1106629150u, 110806409u, 1072693247u, 4292560021u, 0, COS_TOLERANCE, 0},
{ 444, 1082157019u, 3570399481u, 1085637605u, 180265334u, 3220059372u, 216871137u, 0, COS_TOLERANCE, 0},
{ 445, 3200980182u, 558779875u, 3202046748u, 2338464653u, 1072693247u, 4294920358u, 0, COS_TOLERANCE, 0},
{ 446, 1045705464u, 1703969219u, 3229797258u, 1417521063u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 447, 3237782261u, 3917440951u, 1051668894u, 3736066983u, 1071954489u, 2643649072u, 0, COS_TOLERANCE, 0},
{ 448, 1064752080u, 3106613409u, 1066627453u, 2735392257u, 1072693215u, 1855155537u, 0, COS_TOLERANCE, 0},
{ 449, 1065665372u, 2229777605u, 1065061963u, 2405869925u, 1072693140u, 962185659u, 0, COS_TOLERANCE, 0},
{ 450, 3239463229u, 3967957902u, 1057416138u, 3459188071u, 1072154343u, 2087114904u, 0, COS_TOLERANCE, 0},
{ 451, 1068639210u, 3699016825u, 3249713090u, 796144848u, 1072687985u, 316016598u, 0, COS_TOLERANCE, 0},
{ 452, 3228816396u, 3285165564u, 3211948811u, 401510871u, 3220174506u, 2051663811u, 0, COS_TOLERANCE, 0},
{ 453, 1094257658u, 634857910u, 3199607513u, 914218057u, 3220079650u, 816248961u, 0, COS_TOLERANCE, 0},
{ 454, 1083743336u, 2030735578u, 3233855943u, 965677531u, 3218690320u, 4171285285u, 0, COS_TOLERANCE, 0},
{ 455, 1079556815u, 3957229084u, 1051050470u, 3123776651u, 3215268432u, 3325789246u, 0, COS_TOLERANCE, 0},
{ 456, 3221863333u, 162122081u, 3239376395u, 108064594u, 3220170995u, 2986073122u, 0, COS_TOLERANCE, 0},
{ 457, 3237271786u, 869031839u, 3225020876u, 1344301606u, 3219226445u, 571732783u, 0, COS_TOLERANCE, 0},
{ 458, 3214433474u, 946696117u, 3231825228u, 1700703647u, 1072692654u, 2166617165u, 0, COS_TOLERANCE, 0},
{ 459, 1075492875u, 3394168074u, 1076939786u, 1666995668u, 1072530509u, 890276858u, 0, COS_TOLERANCE, 0},
{ 460, 3208774795u, 2488789804u, 3238508333u, 1506943664u, 1072693247u, 2933330625u, 0, COS_TOLERANCE, 0},
{ 461, 1072788663u, 3844072288u, 3202592279u, 2630019853u, 1071483620u, 2208326015u, 0, COS_TOLERANCE, 0},
{ 462, 3219934542u, 1244307192u, 3191297711u, 2540916692u, 1071925114u, 1313080148u, 0, COS_TOLERANCE, 0},
{ 463, 3200062692u, 2871645739u, 3239081581u, 1440249115u, 1072693247u, 4294953764u, 0, COS_TOLERANCE, 0},
{ 464, 1068350633u, 1231934926u, 3236746788u, 603977748u, 1072689711u, 3639960946u, 0, COS_TOLERANCE, 0},
{ 465, 3195449689u, 2386312545u, 1063169277u, 2715234268u, 1072693247u, 4294967264u, 0, COS_TOLERANCE, 0},
{ 466, 1087803418u, 915867083u, 1046790892u, 3347417612u, 1071309674u, 1156953860u, 0, COS_TOLERANCE, 0},
{ 467, 1105984188u, 3553288373u, 1065698616u, 2906680663u, 1072261701u, 1351690325u, 0, COS_TOLERANCE, 0},
{ 468, 1045506226u, 2342364630u, 1051356723u, 4019093203u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 469, 3201169162u, 2911548084u, 1105282515u, 2476735795u, 1072693247u, 4294909830u, 0, COS_TOLERANCE, 0},
{ 470, 1050472772u, 1836216409u, 1101062307u, 2519592554u, 1072693247u, 4294966458u, 0, COS_TOLERANCE, 0},
{ 471, 1070178161u, 1235369496u, 3222946447u, 668087854u, 1072651370u, 1135449571u, 0, COS_TOLERANCE, 0},
{ 472, 3208554596u, 2981820811u, 1059838516u, 2845580478u, 1072693247u, 3309410866u, 0, COS_TOLERANCE, 0},
{ 473, 3193931414u, 1565550570u, 3217165795u, 4162017137u, 1072693247u, 4294967292u, 0, COS_TOLERANCE, 0},
{ 474, 3237251378u, 2808968027u, 1055630096u, 1782326814u, 3219252387u, 2702488331u, 0, COS_TOLERANCE, 0},
{ 475, 1053576974u, 1492622658u, 3216653077u, 3972512122u, 1072693247u, 4294916007u, 0, COS_TOLERANCE, 0},
{ 476, 3222171679u, 2722693603u, 3227814791u, 3169731970u, 3219732412u, 2646352387u, 0, COS_TOLERANCE, 0},
{ 477, 3217906631u, 899763203u, 3207606001u, 2804747833u, 1072638326u, 1716712908u, 0, COS_TOLERANCE, 0},
{ 478, 3230670325u, 3789058912u, 3228095081u, 4135937628u, 1071642741u, 1726723037u, 0, COS_TOLERANCE, 0},
{ 479, 1060199382u, 1682808307u, 3206960335u, 232877759u, 1072693247u, 3979004235u, 0, COS_TOLERANCE, 0},
{ 480, 3242091486u, 2851963139u, 3246852961u, 2590862592u, 3219860744u, 3972780260u, 0, COS_TOLERANCE, 0},
{ 481, 1081200406u, 2422232642u, 3234779662u, 290458310u, 3219313360u, 2704073029u, 0, COS_TOLERANCE, 0},
{ 482, 3210671078u, 1082582386u, 1075605675u, 2602133689u, 1072693244u, 1106099360u, 0, COS_TOLERANCE, 0},
{ 483, 3239818611u, 1789635787u, 1059414278u, 1048286093u, 3218252122u, 1300245564u, 0, COS_TOLERANCE, 0},
{ 484, 1098330542u, 231339448u, 1055573265u, 504907415u, 3220173686u, 2481863579u, 0, COS_TOLERANCE, 0},
{ 485, 1063211461u, 1153251200u, 3204617090u, 1772013857u, 1072693244u, 723005056u, 0, COS_TOLERANCE, 0},
{ 486, 1099551055u, 1082898276u, 3212089272u, 1449080862u, 1072558217u, 132128436u, 0, COS_TOLERANCE, 0},
{ 487, 1086008285u, 3177299045u, 1058862813u, 809400815u, 1072543618u, 4039777533u, 0, COS_TOLERANCE, 0},
{ 488, 3230854550u, 1924429710u, 1056464743u, 3349283177u, 1070838822u, 1592886544u, 0, COS_TOLERANCE, 0},
{ 489, 3245473391u, 42238036u, 1042379500u, 2113559863u, 1071848551u, 792274594u, 0, COS_TOLERANCE, 0},
{ 490, 1064761243u, 3304403230u, 3217556703u, 58952646u, 1072693215u, 136408135u, 0, COS_TOLERANCE, 0},
{ 491, 3212669530u, 1645486982u, 3224301095u, 3636267471u, 1072693193u, 3461766790u, 0, COS_TOLERANCE, 0},
{ 492, 1062762009u, 619402181u, 3235208235u, 557360557u, 1072693245u, 2846151980u, 0, COS_TOLERANCE, 0},
{ 493, 3238238394u, 110029735u, 1046937383u, 984375729u, 1072675170u, 1806823293u, 0, COS_TOLERANCE, 0},
{ 494, 3189496738u, 4063688092u, 3203235744u, 1049950343u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 495, 1062350619u, 650996069u, 1054971928u, 3953359826u, 1072693246u, 3042411977u, 0, COS_TOLERANCE, 0},
{ 496, 3227055805u, 66926332u, 1090561839u, 1379780888u, 1072232467u, 3551215499u, 0, COS_TOLERANCE, 0},
{ 497, 3233453307u, 2803378256u, 1086057989u, 498534626u, 1072603670u, 2257983600u, 0, COS_TOLERANCE, 0},
{ 498, 1082618553u, 2846400785u, 1047142525u, 1375153550u, 3219920179u, 2183157773u, 0, COS_TOLERANCE, 0},
{ 499, 1044581201u, 2869128958u, 1070972315u, 4246440273u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 500, 1051832506u, 3112381207u, 1044430965u, 3981604561u, 1072693247u, 4294962289u, 0, COS_TOLERANCE, 0},
{ 501, 3231254997u, 243303420u, 1093735824u, 1575581926u, 1072630208u, 3590549604u, 0, COS_TOLERANCE, 0},
{ 502, 3239137997u, 3218865041u, 3204803496u, 3840388050u, 3220112180u, 785845582u, 0, COS_TOLERANCE, 0},
{ 503, 1048415431u, 336846959u, 1052664471u, 3798336786u, 1072693247u, 4294967241u, 0, COS_TOLERANCE, 0},
{ 504, 1055954236u, 3639240976u, 1081202165u, 1844741676u, 1072693247u, 4293840918u, 0, COS_TOLERANCE, 0},
{ 505, 3211904793u, 717293069u, 3211534283u, 582401011u, 1072693228u, 1061096244u, 0, COS_TOLERANCE, 0},
{ 506, 3251962512u, 3766248610u, 3196520332u, 1174437546u, 3219189828u, 425313336u, 0, COS_TOLERANCE, 0},
{ 507, 1083431226u, 756959182u, 3204099341u, 1581804034u, 1071437392u, 805974233u, 0, COS_TOLERANCE, 0},
{ 508, 3205806444u, 3560686300u, 3220980617u, 4277975772u, 1072693247u, 4266819760u, 0, COS_TOLERANCE, 0},
{ 509, 3209906076u, 2598148853u, 3217622194u, 3460421008u, 1072693246u, 2353707925u, 0, COS_TOLERANCE, 0},
{ 510, 1066720824u, 136600515u, 3209934920u, 3340653128u, 1072692812u, 2318741494u, 0, COS_TOLERANCE, 0},
{ 511, 1096820310u, 1045480938u, 3251354609u, 4133432965u, 3218616375u, 1623062713u, 0, COS_TOLERANCE, 0},
{ 512, 1091599431u, 1630207738u, 3239996829u, 2393354808u, 3219829897u, 4235988833u, 0, COS_TOLERANCE, 0},
{ 513, 3190626018u, 3739770117u, 1059520750u, 3959551225u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 514, 3230730505u, 1498861716u, 1091297147u, 847410798u, 3220160144u, 1401589565u, 0, COS_TOLERANCE, 0},
{ 515, 1073516688u, 983275314u, 3232538664u, 2244973629u, 3217768161u, 1085338811u, 0, COS_TOLERANCE, 0},
{ 516, 1054849265u, 2353103845u, 3235718771u, 2978889966u, 1072693247u, 4294709680u, 0, COS_TOLERANCE, 0},
{ 517, 3251357992u, 1546972125u, 3249076079u, 1987349196u, 3215432163u, 3255331174u, 0, COS_TOLERANCE, 0},
{ 518, 3238219513u, 2769161072u, 1075207126u, 292616282u, 3219474945u, 1396988883u, 0, COS_TOLERANCE, 0},
{ 519, 3199712298u, 36855311u, 1052128202u, 1479039342u, 1072693247u, 4294958282u, 0, COS_TOLERANCE, 0},
{ 520, 1083757053u, 2027463605u, 1066023013u, 3369686340u, 1071267149u, 2773154495u, 0, COS_TOLERANCE, 0},
{ 521, 3197852749u, 3808681655u, 1054161346u, 1821773119u, 1072693247u, 4294966547u, 0, COS_TOLERANCE, 0},
{ 522, 1040685928u, 3175490326u, 3226879970u, 845687760u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 523, 1042302993u, 3124482451u, 3242748377u, 3259417226u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 524, 1045245695u, 2751606436u, 3236210939u, 3923142740u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 525, 1095694737u, 2016872044u, 3228408064u, 4201274408u, 3219321161u, 1921838008u, 0, COS_TOLERANCE, 0},
{ 526, 3199349254u, 1019916843u, 3219974785u, 1977881787u, 1072693247u, 4294961999u, 0, COS_TOLERANCE, 0},
{ 527, 3199478752u, 2060433318u, 1075872515u, 366073725u, 1072693247u, 4294960786u, 0, COS_TOLERANCE, 0},
{ 528, 3191180557u, 1098469906u, 1082900695u, 2349346832u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 529, 3209974707u, 3011196295u, 3252479932u, 2459281672u, 1072693246u, 1657835881u, 0, COS_TOLERANCE, 0},
{ 530, 3221334323u, 2843222682u, 1089275809u, 298982001u, 3219326801u, 414973546u, 0, COS_TOLERANCE, 0},
{ 531, 1101737698u, 914741728u, 3203468059u, 2833809843u, 3219266445u, 2657113532u, 0, COS_TOLERANCE, 0},
{ 532, 3236763878u, 1274901962u, 3241535845u, 3759113509u, 1069183268u, 3668657064u, 0, COS_TOLERANCE, 0},
{ 533, 3245916442u, 2134927252u, 3253802671u, 3013731444u, 1070851538u, 2502169401u, 0, COS_TOLERANCE, 0},
{ 534, 1099201341u, 2230655177u, 3254510616u, 1249674366u, 3220146808u, 409508490u, 0, COS_TOLERANCE, 0},
{ 535, 1062971253u, 717357389u, 1083533731u, 3746683362u, 1072693245u, 54512334u, 0, COS_TOLERANCE, 0},
{ 536, 3213773114u, 834976849u, 3217357661u, 2465861779u, 1072693018u, 2976670979u, 0, COS_TOLERANCE, 0},
{ 537, 1045656117u, 1385714428u, 1053358395u, 3007113740u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 538, 1050527919u, 599268545u, 3201368210u, 2309854744u, 1072693247u, 4294966409u, 0, COS_TOLERANCE, 0},
{ 539, 1069954454u, 2840234388u, 3232496515u, 333365983u, 1072661758u, 3614572093u, 0, COS_TOLERANCE, 0},
{ 540, 1045922781u, 3136078996u, 3194520860u, 2650572904u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 541, 3233687691u, 2405805086u, 3251640319u, 324233833u, 1068811358u, 4162323614u, 0, COS_TOLERANCE, 0},
{ 542, 1106699146u, 2589598340u, 3254677807u, 952438812u, 1071784199u, 1738588699u, 0, COS_TOLERANCE, 0},
{ 543, 3189114773u, 1922837702u, 3216892718u, 3535907549u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 544, 3243615868u, 261447440u, 3209805849u, 1150571079u, 3220053401u, 399142837u, 0, COS_TOLERANCE, 0},
{ 545, 1095805232u, 4026487528u, 1073152064u, 27340691u, 1072388772u, 1533980329u, 0, COS_TOLERANCE, 0},
{ 546, 3229123692u, 338765118u, 1086225786u, 3207238249u, 3219992318u, 2304503256u, 0, COS_TOLERANCE, 0},
{ 547, 3196182703u, 1085283176u, 3187775111u, 1601194210u, 1072693247u, 4294967216u, 0, COS_TOLERANCE, 0},
{ 548, 1091520173u, 3031712790u, 3252307859u, 170666844u, 3218842033u, 2741016994u, 0, COS_TOLERANCE, 0},
{ 549, 3218862231u, 3148395674u, 1041913758u, 3306391490u, 1072496559u, 2937265603u, 0, COS_TOLERANCE, 0},
{ 550, 3201277070u, 2205233857u, 3208100078u, 3993195511u, 1072693247u, 4294903341u, 0, COS_TOLERANCE, 0},
{ 551, 1067699608u, 4282766727u, 1072820377u, 1874778218u, 1072691679u, 2327723158u, 0, COS_TOLERANCE, 0},
{ 552, 3210833092u, 2920860798u, 3218070226u, 3104066154u, 1072693243u, 1098827613u, 0, COS_TOLERANCE, 0},
{ 553, 3204950351u, 969991373u, 3250596895u, 1734386152u, 1072693247u, 4285794546u, 0, COS_TOLERANCE, 0},
{ 554, 3238915818u, 1218740205u, 3239802737u, 2610078504u, 1072341600u, 4056543646u, 0, COS_TOLERANCE, 0},
{ 555, 3206031242u, 1485218325u, 3220870240u, 3591664613u, 1072693247u, 4256731124u, 0, COS_TOLERANCE, 0},
{ 556, 3202074143u, 690157417u, 3190850619u, 4192347699u, 1072693247u, 4294769820u, 0, COS_TOLERANCE, 0},
{ 557, 1096053810u, 4009839784u, 1079670252u, 394167192u, 1067100091u, 683628693u, 0, COS_TOLERANCE, 0},
{ 558, 3234559237u, 961532417u, 1092588071u, 2923790239u, 3219826642u, 2587899721u, 0, COS_TOLERANCE, 0},
{ 559, 3203879091u, 4174125604u, 1050682630u, 2169701868u, 1072693247u, 4292740708u, 0, COS_TOLERANCE, 0},
{ 560, 3243092475u, 4146748230u, 1087373950u, 2481478351u, 3220175227u, 1005025558u, 0, COS_TOLERANCE, 0},
{ 561, 1076987866u, 3984715440u, 1050421618u, 2446142566u, 1070589958u, 3572501181u, 0, COS_TOLERANCE, 0},
{ 562, 1084172406u, 936290150u, 1100614426u, 3625806370u, 3219547017u, 4126560522u, 0, COS_TOLERANCE, 0},
{ 563, 1099787952u, 1866615265u, 3215651428u, 2337013350u, 3219658243u, 456488637u, 0, COS_TOLERANCE, 0},
{ 564, 3253198302u, 712227971u, 1106004723u, 973148499u, 3220091089u, 4169062849u, 0, COS_TOLERANCE, 0},
{ 565, 3230088199u, 3409813738u, 3244817008u, 1933503498u, 3219104826u, 3598702610u, 0, COS_TOLERANCE, 0},
{ 566, 1079943733u, 3180389060u, 3228735703u, 83422217u, 3220176734u, 1468291227u, 0, COS_TOLERANCE, 0},
{ 567, 1077878724u, 556972671u, 3204582372u, 841555801u, 1072604572u, 802866348u, 0, COS_TOLERANCE, 0},
{ 568, 1070767721u, 4189151332u, 1080874032u, 706326922u, 1072605127u, 894556621u, 0, COS_TOLERANCE, 0},
{ 569, 1096151307u, 198291836u, 1057281892u, 2188836928u, 3218147467u, 3777186949u, 0, COS_TOLERANCE, 0},
{ 570, 1078091995u, 1219449298u, 3228734687u, 3504562743u, 1071828869u, 1565632238u, 0, COS_TOLERANCE, 0},
{ 571, 3204570464u, 1776099219u, 1094316777u, 4188083896u, 1072693247u, 4289738353u, 0, COS_TOLERANCE, 0},
{ 572, 3193845708u, 2614400266u, 1073750227u, 3003203347u, 1072693247u, 4294967292u, 0, COS_TOLERANCE, 0},
{ 573, 3213982678u, 2959351406u, 1105603716u, 311851587u, 1072692942u, 1400585228u, 0, COS_TOLERANCE, 0},
{ 574, 1084544434u, 865443613u, 1097532516u, 3622237781u, 3220039406u, 2852313542u, 0, COS_TOLERANCE, 0},
{ 575, 3231786666u, 447506102u, 3195759295u, 3603669725u, 3219760569u, 3069303987u, 0, COS_TOLERANCE, 0},
{ 576, 1097890173u, 3934398273u, 1040996422u, 2968621268u, 1068863315u, 1513793935u, 0, COS_TOLERANCE, 0},
{ 577, 3196739825u, 784208771u, 1088764788u, 2182296421u, 1072693247u, 4294967122u, 0, COS_TOLERANCE, 0},
{ 578, 3248332291u, 1527590526u, 3206961556u, 2823164069u, 3219246387u, 1629246963u, 0, COS_TOLERANCE, 0},
{ 579, 3236644131u, 3876699591u, 3207481130u, 4028148535u, 3219160558u, 3753866329u, 0, COS_TOLERANCE, 0},
{ 580, 1083576186u, 2164249756u, 1059857743u, 1785169952u, 3218175224u, 879726405u, 0, COS_TOLERANCE, 0},
{ 581, 1091804009u, 2079273665u, 1080303860u, 625760474u, 3218606506u, 371401132u, 0, COS_TOLERANCE, 0},
{ 582, 3226486108u, 3636214836u, 1068367620u, 2932621925u, 3219400280u, 3279627080u, 0, COS_TOLERANCE, 0},
{ 583, 1043995372u, 4274131512u, 1047707755u, 92550763u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 584, 3198822121u, 2648933384u, 1084603503u, 3534304873u, 1072693247u, 4294964560u, 0, COS_TOLERANCE, 0},
{ 585, 1064563235u, 3216750767u, 3191088629u, 547482628u, 1072693223u, 580769603u, 0, COS_TOLERANCE, 0},
{ 586, 1061084774u, 1420360746u, 1080063101u, 1690029499u, 1072693247u, 3295800571u, 0, COS_TOLERANCE, 0},
{ 587, 3229855364u, 1908572179u, 1080112083u, 1228319033u, 1068701740u, 1725760599u, 0, COS_TOLERANCE, 0},
{ 588, 1048158178u, 500312015u, 3212368508u, 3864619086u, 1072693247u, 4294967255u, 0, COS_TOLERANCE, 0},
{ 589, 3221335610u, 4211343447u, 1087492676u, 4272583781u, 3219330937u, 1275345573u, 0, COS_TOLERANCE, 0},
{ 590, 1099392394u, 2382118000u, 1042665328u, 567154882u, 3219359292u, 736683867u, 0, COS_TOLERANCE, 0},
{ 591, 1058013442u, 1435344339u, 3216303171u, 2275988178u, 1072693247u, 4278181812u, 0, COS_TOLERANCE, 0},
{ 592, 3214538619u, 3403659753u, 3218043030u, 1926480488u, 1072692573u, 3285328600u, 0, COS_TOLERANCE, 0},
{ 593, 1076840383u, 1198845185u, 3225556149u, 1130089684u, 3220172073u, 668005656u, 0, COS_TOLERANCE, 0},
{ 594, 3222663042u, 2183928090u, 1048403956u, 963834821u, 1072058265u, 439230756u, 0, COS_TOLERANCE, 0},
{ 595, 1101672960u, 2120625396u, 1041006976u, 2137548527u, 3219105835u, 3752162680u, 0, COS_TOLERANCE, 0},
{ 596, 1099230238u, 586700956u, 1059670521u, 303891699u, 1070589874u, 1796035360u, 0, COS_TOLERANCE, 0},
{ 597, 3218994498u, 2509132460u, 1102827530u, 2205707903u, 1072467656u, 2678741737u, 0, COS_TOLERANCE, 0},
{ 598, 3204860597u, 1229308263u, 3209170414u, 4206576047u, 1072693247u, 4286825667u, 0, COS_TOLERANCE, 0},
{ 599, 3224076289u, 4078010749u, 3199236456u, 733478972u, 1071131091u, 915577737u, 0, COS_TOLERANCE, 0},
{ 600, 3197712584u, 4277541051u, 3199806921u, 397102023u, 1072693247u, 4294966660u, 0, COS_TOLERANCE, 0},
{ 601, 3195975013u, 900999594u, 3234720188u, 2530214248u, 1072693247u, 4294967237u, 0, COS_TOLERANCE, 0},
{ 602, 1076543548u, 4000609478u, 1096577064u, 4148592328u, 1072043454u, 840440154u, 0, COS_TOLERANCE, 0},
{ 603, 1048668084u, 2154187873u, 3224392607u, 3957250362u, 1072693247u, 4294967220u, 0, COS_TOLERANCE, 0},
{ 604, 3223413488u, 2867079200u, 1101870326u, 921212001u, 3219640338u, 2663551801u, 0, COS_TOLERANCE, 0},
{ 605, 3233221890u, 674547716u, 1063216239u, 3929755226u, 1071459668u, 723041291u, 0, COS_TOLERANCE, 0},
{ 606, 3240415851u, 3158182449u, 1043794244u, 3259056345u, 3220037664u, 2966147533u, 0, COS_TOLERANCE, 0},
{ 607, 3236776656u, 3002823940u, 1059511739u, 2832435794u, 1070487493u, 280321777u, 0, COS_TOLERANCE, 0},
{ 608, 3217304822u, 2196511929u, 1049973941u, 3672092877u, 1072667250u, 1240548968u, 0, COS_TOLERANCE, 0},
{ 609, 1050438056u, 3655292191u, 1086438127u, 3567072906u, 1072693247u, 4294966489u, 0, COS_TOLERANCE, 0},
{ 610, 3243186948u, 1617573614u, 3201863123u, 3090723732u, 1072690054u, 2844567634u, 0, COS_TOLERANCE, 0},
{ 611, 3233201380u, 679893506u, 3211547753u, 824081024u, 3219939961u, 2810857343u, 0, COS_TOLERANCE, 0},
{ 612, 1089530525u, 2285242807u, 1084999409u, 2221731406u, 1071368057u, 1426300390u, 0, COS_TOLERANCE, 0},
{ 613, 3206733664u, 1935990727u, 1088822246u, 1058156518u, 1072693247u, 4201598491u, 0, COS_TOLERANCE, 0},
{ 614, 1102839166u, 521023584u, 1059186903u, 4245163857u, 3220149846u, 3786871735u, 0, COS_TOLERANCE, 0},
{ 615, 1103891140u, 2312887617u, 3191771354u, 1885370807u, 1072693088u, 1521437248u, 0, COS_TOLERANCE, 0},
{ 616, 3252953815u, 1796441468u, 1100030327u, 2772711004u, 3219885770u, 1681306400u, 0, COS_TOLERANCE, 0},
{ 617, 3204276820u, 2095685003u, 1077984448u, 2100773742u, 1072693247u, 4291430705u, 0, COS_TOLERANCE, 0},
{ 618, 3192954620u, 2892538035u, 1042396334u, 4162200338u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 619, 3242725751u, 2177698116u, 3227557177u, 150832500u, 3220168457u, 3307824821u, 0, COS_TOLERANCE, 0},
{ 620, 3191562216u, 607966734u, 3236250630u, 4164600559u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 621, 3216389812u, 2830122967u, 1046096700u, 3713346883u, 1072685357u, 3355578451u, 0, COS_TOLERANCE, 0},
{ 622, 3237197963u, 2314640506u, 3203696416u, 3276228872u, 1072684594u, 3660350689u, 0, COS_TOLERANCE, 0},
{ 623, 3212912307u, 469331883u, 3249037349u, 2999233437u, 1072693174u, 1974686405u, 0, COS_TOLERANCE, 0},
{ 624, 1097382011u, 560886625u, 1091899487u, 748795120u, 1072341321u, 1561640432u, 0, COS_TOLERANCE, 0},
{ 625, 1049886858u, 2958421324u, 1092569414u, 3235243477u, 1072693247u, 4294966896u, 0, COS_TOLERANCE, 0},
{ 626, 3193026497u, 3221475559u, 1043038304u, 915608434u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 627, 1071197530u, 3007808652u, 3216682290u, 2531019474u, 1072533054u, 1184989401u, 0, COS_TOLERANCE, 0},
{ 628, 3242028999u, 1767658578u, 3237045269u, 2313128318u, 3215226551u, 294612205u, 0, COS_TOLERANCE, 0},
{ 629, 3210617892u, 1926845182u, 1066835624u, 1783256828u, 1072693244u, 1937927066u, 0, COS_TOLERANCE, 0},
{ 630, 1040575629u, 90378038u, 1057168870u, 164358218u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 631, 1106859172u, 1610524680u, 1085283851u, 2903496007u, 3219904172u, 2335619660u, 0, COS_TOLERANCE, 0},
{ 632, 1078635586u, 4274321404u, 3202913591u, 720121831u, 3220172959u, 2167800746u, 0, COS_TOLERANCE, 0},
{ 633, 1051205256u, 2034778236u, 1071133763u, 1413236391u, 1072693247u, 4294964969u, 0, COS_TOLERANCE, 0},
{ 634, 1051063028u, 1489112261u, 1076691395u, 348210906u, 1072693247u, 4294965369u, 0, COS_TOLERANCE, 0},
{ 635, 3206743917u, 2797651324u, 3224410527u, 2374818327u, 1072693247u, 4200044040u, 0, COS_TOLERANCE, 0},
{ 636, 1088287256u, 1823161666u, 3197810695u, 3119680047u, 3219677965u, 2997914837u, 0, COS_TOLERANCE, 0},
{ 637, 1065927336u, 3420950657u, 1087084743u, 2136638961u, 1072693094u, 3146758615u, 0, COS_TOLERANCE, 0},
{ 638, 1069902224u, 3554566429u, 1062907717u, 2736702589u, 1072663973u, 178834935u, 0, COS_TOLERANCE, 0},
{ 639, 3244888667u, 2928437580u, 3187765027u, 1393427873u, 3220173429u, 1922306944u, 0, COS_TOLERANCE, 0},
{ 640, 3209301561u, 189447067u, 1051643315u, 828663513u, 1072693247u, 1447487601u, 0, COS_TOLERANCE, 0},
{ 641, 1052313869u, 2852350928u, 1045683757u, 673354280u, 1072693247u, 4294957268u, 0, COS_TOLERANCE, 0},
{ 642, 1043946301u, 3589563265u, 3248741629u, 812657927u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 643, 3190610826u, 1766416701u, 1100392103u, 2185373290u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 644, 3220275389u, 3763582673u, 3191965790u, 388374829u, 1071472690u, 1891493224u, 0, COS_TOLERANCE, 0},
{ 645, 1079635136u, 1187403069u, 1075300235u, 336640304u, 3220176149u, 3234833894u, 0, COS_TOLERANCE, 0},
{ 646, 1103926251u, 1718795752u, 3243118752u, 683369237u, 3219779573u, 3806121574u, 0, COS_TOLERANCE, 0},
{ 647, 3210792097u, 1863545307u, 1069449477u, 3418627399u, 1072693243u, 2535529384u, 0, COS_TOLERANCE, 0},
{ 648, 1069601294u, 3295607249u, 1068878592u, 1633297809u, 1072675166u, 2110076227u, 0, COS_TOLERANCE, 0},
{ 649, 1058947127u, 2585980994u, 3236670483u, 1286750688u, 1072693247u, 4234994396u, 0, COS_TOLERANCE, 0},
{ 650, 1046157033u, 15816845u, 3233249283u, 2491924775u, 1072693247u, 4294967293u, 0, COS_TOLERANCE, 0},
{ 651, 1042413021u, 1051983351u, 1049180786u, 1474421917u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 652, 3201249525u, 2003816032u, 1086050104u, 668090487u, 1072693247u, 4294905031u, 0, COS_TOLERANCE, 0},
{ 653, 1052556037u, 3671484625u, 1067020039u, 430024694u, 1072693247u, 4294954089u, 0, COS_TOLERANCE, 0},
{ 654, 1067397110u, 3991830201u, 3207808714u, 1021245839u, 1072692275u, 1819605250u, 0, COS_TOLERANCE, 0},
{ 655, 1064194391u, 4255801807u, 3207681716u, 1926756877u, 1072693233u, 2740400643u, 0, COS_TOLERANCE, 0},
{ 656, 1052140785u, 4167786896u, 1077097744u, 1775517981u, 1072693247u, 4294959272u, 0, COS_TOLERANCE, 0},
{ 657, 1085601978u, 3187518564u, 1082437406u, 944672491u, 3220110458u, 913134978u, 0, COS_TOLERANCE, 0},
{ 658, 1049366282u, 953085192u, 3227310828u, 3459155777u, 1072693247u, 4294967099u, 0, COS_TOLERANCE, 0},
{ 659, 1069502506u, 1908555460u, 1073640207u, 260441967u, 1072677579u, 1454510592u, 0, COS_TOLERANCE, 0},
{ 660, 1067219606u, 250762477u, 1072582645u, 2886742039u, 1072692437u, 31148257u, 0, COS_TOLERANCE, 0},
{ 661, 3250906006u, 786180031u, 3197734769u, 2788918312u, 1072326482u, 1005490298u, 0, COS_TOLERANCE, 0},
{ 662, 3234511827u, 2055912467u, 3244244909u, 1394142937u, 3220102579u, 286327760u, 0, COS_TOLERANCE, 0},
{ 663, 1069612985u, 91984146u, 3222252812u, 4126276047u, 1072674781u, 2240078613u, 0, COS_TOLERANCE, 0},
{ 664, 1081340139u, 3942715706u, 3239316352u, 410676547u, 1070049772u, 3039431038u, 0, COS_TOLERANCE, 0},
{ 665, 3198557846u, 86296211u, 1085850694u, 649202596u, 1072693247u, 4294965339u, 0, COS_TOLERANCE, 0},
{ 666, 3245366392u, 3069064472u, 3237358008u, 23209276u, 1072495724u, 3575339626u, 0, COS_TOLERANCE, 0},
{ 667, 1081235288u, 1867297860u, 1072956607u, 2513414118u, 3218189572u, 1975036829u, 0, COS_TOLERANCE, 0},
{ 668, 3250533347u, 3171788768u, 3235208783u, 162138697u, 1070382034u, 2139906112u, 0, COS_TOLERANCE, 0},
{ 669, 1081728455u, 1245110700u, 1081653954u, 2584994077u, 1072012843u, 595067820u, 0, COS_TOLERANCE, 0},
{ 670, 3245510120u, 3347226587u, 1058962932u, 2291943376u, 3220038529u, 1729582222u, 0, COS_TOLERANCE, 0},
{ 671, 1058899062u, 966940828u, 1060726420u, 2798041096u, 1072693247u, 4237867181u, 0, COS_TOLERANCE, 0},
{ 672, 1072793759u, 2487340727u, 3223786370u, 4105954991u, 1071465516u, 1993418532u, 0, COS_TOLERANCE, 0},
{ 673, 3248116497u, 1671039260u, 1086395032u, 3745833360u, 1072592394u, 1092605516u, 0, COS_TOLERANCE, 0},
{ 674, 1057078797u, 651714217u, 1047070645u, 2130549237u, 1072693247u, 4289809738u, 0, COS_TOLERANCE, 0},
{ 675, 3207115731u, 1423000172u, 3247822717u, 1551488170u, 1072693247u, 4135004220u, 0, COS_TOLERANCE, 0},
{ 676, 3201597307u, 921077236u, 3213332351u, 1431049019u, 1072693247u, 4294859733u, 0, COS_TOLERANCE, 0},
{ 677, 1067510295u, 655715547u, 3190985373u, 1527556471u, 1072692103u, 3067599466u, 0, COS_TOLERANCE, 0},
{ 678, 3227654979u, 4110878657u, 3251297180u, 879739345u, 1072574045u, 720418835u, 0, COS_TOLERANCE, 0},
{ 679, 1085804762u, 2623955764u, 1093699897u, 1216444475u, 3220138856u, 1786848118u, 0, COS_TOLERANCE, 0},
{ 680, 1091905603u, 107442539u, 3239767031u, 1149813329u, 3219851592u, 2118474530u, 0, COS_TOLERANCE, 0},
{ 681, 3233445240u, 1761361082u, 3226030205u, 1121849716u, 1072652853u, 178221240u, 0, COS_TOLERANCE, 0},
{ 682, 3240087115u, 2534144722u, 1044223733u, 3512285706u, 3216132876u, 902911402u, 0, COS_TOLERANCE, 0},
{ 683, 3211846077u, 4073670723u, 1050729852u, 3034818849u, 1072693230u, 806668878u, 0, COS_TOLERANCE, 0},
{ 684, 1101984574u, 1421423503u, 1060278048u, 1397153092u, 3219504796u, 3365923665u, 0, COS_TOLERANCE, 0},
{ 685, 3217421829u, 1649206019u, 1104525577u, 1267104290u, 1072662457u, 1345840563u, 0, COS_TOLERANCE, 0},
{ 686, 3189302097u, 3775270392u, 1040251850u, 68667319u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 687, 3204330900u, 3099226694u, 3254103006u, 4020102648u, 1072693247u, 4291229279u, 0, COS_TOLERANCE, 0},
{ 688, 3201591712u, 3718441177u, 3215643451u, 4032951536u, 1072693247u, 4294860627u, 0, COS_TOLERANCE, 0},
{ 689, 1044131371u, 508048351u, 3210196713u, 1707937896u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 690, 3198611627u, 2784738160u, 1073435430u, 1109346010u, 1072693247u, 4294965191u, 0, COS_TOLERANCE, 0},
{ 691, 3225725290u, 3331916473u, 3238794568u, 2707019594u, 3219937123u, 2226610460u, 0, COS_TOLERANCE, 0},
{ 692, 1093182670u, 3093165197u, 1072894805u, 2853215019u, 1072658626u, 3705768894u, 0, COS_TOLERANCE, 0},
{ 693, 3216582139u, 2135797997u, 1048399559u, 2941926126u, 1072683137u, 376959074u, 0, COS_TOLERANCE, 0},
{ 694, 1048430980u, 2083412145u, 3249335391u, 507212448u, 1072693247u, 4294967241u, 0, COS_TOLERANCE, 0},
{ 695, 1075363751u, 4270176401u, 3246546709u, 3288753319u, 1072683587u, 2218972124u, 0, COS_TOLERANCE, 0},
{ 696, 3247932863u, 3692175292u, 3197271515u, 3989064196u, 3217472000u, 1636461035u, 0, COS_TOLERANCE, 0},
{ 697, 3251691738u, 3111924274u, 1066772558u, 59281695u, 3220096880u, 924173556u, 0, COS_TOLERANCE, 0},
{ 698, 1067683911u, 2135245466u, 3208804313u, 3846547392u, 1072691717u, 1073276862u, 0, COS_TOLERANCE, 0},
{ 699, 1094877811u, 972051266u, 3222814246u, 3539700586u, 3219298444u, 3078353466u, 0, COS_TOLERANCE, 0},
{ 700, 3202965930u, 330951080u, 1079189813u, 583922384u, 1072693247u, 4294307614u, 0, COS_TOLERANCE, 0},
{ 701, 1089640092u, 1711944085u, 1104170032u, 643991456u, 3218245979u, 1623606256u, 0, COS_TOLERANCE, 0},
{ 702, 3234429549u, 2072550721u, 3250147641u, 4280263530u, 1071794324u, 38624345u, 0, COS_TOLERANCE, 0},
{ 703, 3192972706u, 1566376352u, 1067251433u, 72984588u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 704, 1095276569u, 3103043079u, 1045853123u, 410067497u, 3219935193u, 2728293583u, 0, COS_TOLERANCE, 0},
{ 705, 3216672493u, 1910366299u, 1081770885u, 634683073u, 1072681999u, 479245867u, 0, COS_TOLERANCE, 0},
{ 706, 1081530688u, 2226525875u, 3224149290u, 2126302825u, 1071247416u, 1032109685u, 0, COS_TOLERANCE, 0},
{ 707, 1073150247u, 1383818978u, 3193885723u, 1220372650u, 1069627701u, 3400212089u, 0, COS_TOLERANCE, 0},
{ 708, 1066482943u, 1953339096u, 1077176252u, 1476516558u, 1072692950u, 3646272527u, 0, COS_TOLERANCE, 0},
{ 709, 1066092000u, 1306277326u, 1079089150u, 4093716191u, 1072693062u, 211505646u, 0, COS_TOLERANCE, 0},
{ 710, 3233148787u, 51750045u, 3242913901u, 4256866157u, 3217216280u, 1160993324u, 0, COS_TOLERANCE, 0},
{ 711, 3195084967u, 2163853087u, 3232053146u, 2962422808u, 1072693247u, 4294967278u, 0, COS_TOLERANCE, 0},
{ 712, 1075516945u, 1618388148u, 3233154824u, 3711953164u, 1072448092u, 4287528395u, 0, COS_TOLERANCE, 0},
{ 713, 3246868002u, 357108214u, 3202294604u, 2306775262u, 1071938433u, 4284753744u, 0, COS_TOLERANCE, 0},
{ 714, 3201904086u, 2571356437u, 3249064063u, 2394851808u, 1072693247u, 4294804996u, 0, COS_TOLERANCE, 0},
{ 715, 3230488091u, 4273880094u, 1103698617u, 3578832032u, 3219842465u, 27990251u, 0, COS_TOLERANCE, 0},
{ 716, 3233426701u, 2091068742u, 3228270226u, 3980489730u, 3220175570u, 3118267747u, 0, COS_TOLERANCE, 0},
{ 717, 3229016752u, 2772307714u, 1051008486u, 32546576u, 3217423140u, 1796767464u, 0, COS_TOLERANCE, 0},
{ 718, 3241229215u, 2143788498u, 3195498043u, 3630119231u, 3218494133u, 503382599u, 0, COS_TOLERANCE, 0},
{ 719, 3198632935u, 2527385594u, 3240503648u, 3482095012u, 1072693247u, 4294965131u, 0, COS_TOLERANCE, 0},
{ 720, 3242168799u, 2690097362u, 1068598730u, 2360266862u, 1071811769u, 2322679045u, 0, COS_TOLERANCE, 0},
{ 721, 1058857869u, 2673272949u, 1082639557u, 522449749u, 1072693247u, 4240273089u, 0, COS_TOLERANCE, 0},
{ 722, 1104424147u, 3596379400u, 3242016775u, 2002293002u, 3218990076u, 882873582u, 0, COS_TOLERANCE, 0},
{ 723, 1099439656u, 4113224369u, 3222122439u, 2152316893u, 1072382483u, 2149265695u, 0, COS_TOLERANCE, 0},
{ 724, 3220796716u, 31662602u, 1047721249u, 1747087514u, 3214199757u, 3014160204u, 0, COS_TOLERANCE, 0},
{ 725, 3250463757u, 2489659568u, 1097051253u, 277506957u, 3219439509u, 846415884u, 0, COS_TOLERANCE, 0},
{ 726, 3191401834u, 3850162281u, 3213841942u, 438724093u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 727, 1095392535u, 2431814052u, 1075518084u, 2672434118u, 3220176605u, 763316173u, 0, COS_TOLERANCE, 0},
{ 728, 3243162735u, 391606792u, 1048184750u, 4168944276u, 3218801484u, 293093886u, 0, COS_TOLERANCE, 0},
{ 729, 3247792416u, 457529672u, 3201090276u, 72407935u, 1070460862u, 3595673825u, 0, COS_TOLERANCE, 0},
{ 730, 3218720719u, 3954981400u, 1052053242u, 2411049585u, 1072525389u, 3235166120u, 0, COS_TOLERANCE, 0},
{ 731, 1086180091u, 485456950u, 1088415093u, 1655397424u, 1072048063u, 2287321430u, 0, COS_TOLERANCE, 0},
{ 732, 3198234428u, 1551748070u, 3236871640u, 1329701152u, 1072693247u, 4294966115u, 0, COS_TOLERANCE, 0},
{ 733, 3224639122u, 3099222537u, 1104984570u, 4293792842u, 1070915285u, 3906708154u, 0, COS_TOLERANCE, 0},
{ 734, 3203949705u, 3603065260u, 3197735968u, 2402359253u, 1072693247u, 4292530155u, 0, COS_TOLERANCE, 0},
{ 735, 3198824584u, 3961208159u, 3219057584u, 2340553876u, 1072693247u, 4294964552u, 0, COS_TOLERANCE, 0},
{ 736, 1074881909u, 4014841779u, 3197672877u, 3697233334u, 3218521683u, 3115963704u, 0, COS_TOLERANCE, 0},
{ 737, 3213275657u, 1403876392u, 3254028950u, 921363393u, 1072693119u, 989562508u, 0, COS_TOLERANCE, 0},
{ 738, 1107251806u, 1862576361u, 3194031708u, 2476290925u, 1072692742u, 3651849297u, 0, COS_TOLERANCE, 0},
{ 739, 1049661768u, 1454212851u, 1088378861u, 3400401866u, 1072693247u, 4294967022u, 0, COS_TOLERANCE, 0},
{ 740, 1074406809u, 552676385u, 3188635745u, 3778112968u, 3220160068u, 1645620146u, 0, COS_TOLERANCE, 0},
{ 741, 3216409282u, 1199568671u, 3225679997u, 46947405u, 1072685145u, 1982517232u, 0, COS_TOLERANCE, 0},
{ 742, 1077685537u, 2596231448u, 3253943728u, 2219151748u, 3220166825u, 1507155374u, 0, COS_TOLERANCE, 0},
{ 743, 1066527035u, 4119719558u, 3222036299u, 1275474618u, 1072692927u, 866333980u, 0, COS_TOLERANCE, 0},
{ 744, 3239908663u, 3347296825u, 1101507910u, 1254014794u, 3219483088u, 312673935u, 0, COS_TOLERANCE, 0},
{ 745, 1084119992u, 673775040u, 1070743626u, 244126093u, 1069712823u, 2081579337u, 0, COS_TOLERANCE, 0},
{ 746, 3203199850u, 1832066983u, 1051358028u, 3262483417u, 1072693247u, 4294109029u, 0, COS_TOLERANCE, 0},
{ 747, 1077559600u, 3962610501u, 3198598777u, 849269178u, 1071367684u, 3164827138u, 0, COS_TOLERANCE, 0},
{ 748, 3235473900u, 2497516122u, 3254374111u, 2821429629u, 1070842357u, 830343203u, 0, COS_TOLERANCE, 0},
{ 749, 1076236288u, 2805941787u, 3217785843u, 779131141u, 1067598783u, 2114613609u, 0, COS_TOLERANCE, 0},
{ 750, 3226908686u, 723423605u, 1084533420u, 627282213u, 3220121516u, 1226468903u, 0, COS_TOLERANCE, 0},
{ 751, 3215947680u, 4292778869u, 1078101071u, 1676860147u, 1072689288u, 2072776390u, 0, COS_TOLERANCE, 0},
{ 752, 1076288502u, 3528118587u, 3194648564u, 2363260897u, 1071311403u, 428792898u, 0, COS_TOLERANCE, 0},
{ 753, 3192897879u, 1307010018u, 1061248120u, 1468743108u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 754, 3246583139u, 107905661u, 3226089788u, 1943427674u, 1070106130u, 186093997u, 0, COS_TOLERANCE, 0},
{ 755, 3188230541u, 760006940u, 1054265604u, 1749976597u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 756, 3237773384u, 2787503556u, 1081282610u, 1195841206u, 1071653293u, 2890745849u, 0, COS_TOLERANCE, 0},
{ 757, 3191802156u, 545462045u, 3208381743u, 1981311808u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 758, 1061232136u, 3657978397u, 1104463616u, 3501253426u, 1072693247u, 3066024794u, 0, COS_TOLERANCE, 0},
{ 759, 1049883857u, 1804177501u, 3210693633u, 3606766729u, 1072693247u, 4294966898u, 0, COS_TOLERANCE, 0},
{ 760, 1076856879u, 1336278526u, 1043741618u, 3165279431u, 3220173366u, 3524098048u, 0, COS_TOLERANCE, 0},
{ 761, 1055471915u, 1599382075u, 1058018527u, 4212580517u, 1072693247u, 4294315811u, 0, COS_TOLERANCE, 0},
{ 762, 3207502326u, 3007589929u, 3202026547u, 2792028313u, 1072693247u, 4049483350u, 0, COS_TOLERANCE, 0},
{ 763, 3253082770u, 1866066996u, 1060329048u, 3727175322u, 1072075197u, 4117100839u, 0, COS_TOLERANCE, 0},
{ 764, 3198416643u, 150890940u, 1056025306u, 3082724735u, 1072693247u, 4294965702u, 0, COS_TOLERANCE, 0},
{ 765, 1062008939u, 80400395u, 1093584426u, 3478941315u, 1072693247u, 774759105u, 0, COS_TOLERANCE, 0},
{ 766, 3251640614u, 4050954182u, 3219263194u, 2537475930u, 3220163144u, 1526664806u, 0, COS_TOLERANCE, 0},
{ 767, 1064841871u, 2881752155u, 3212589299u, 2559651278u, 1072693211u, 1740123982u, 0, COS_TOLERANCE, 0},
{ 768, 3249016304u, 440309030u, 3214267461u, 3788040806u, 1072432298u, 4033522608u, 0, COS_TOLERANCE, 0},
{ 769, 1100476615u, 918813144u, 3208535698u, 1607035904u, 1071075046u, 3768110943u, 0, COS_TOLERANCE, 0},
{ 770, 1042137451u, 2497054124u, 1089139147u, 2549609010u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 771, 1047037641u, 790219083u, 1054657139u, 2797979479u, 1072693247u, 4294967287u, 0, COS_TOLERANCE, 0},
{ 772, 1057781400u, 1149462078u, 1095765205u, 3879963182u, 1072693247u, 4281693680u, 0, COS_TOLERANCE, 0},
{ 773, 3202729813u, 2684353926u, 3205212854u, 1732474928u, 1072693247u, 4294481603u, 0, COS_TOLERANCE, 0},
{ 774, 1095236965u, 2742237025u, 1051317716u, 3386396147u, 1072584987u, 1443922753u, 0, COS_TOLERANCE, 0},
{ 775, 1063230986u, 3408320912u, 1103071166u, 4233059513u, 1072693244u, 408413646u, 0, COS_TOLERANCE, 0},
{ 776, 1064863548u, 1077495917u, 1088399968u, 433115118u, 1072693210u, 1708888818u, 0, COS_TOLERANCE, 0},
{ 777, 3204547572u, 841366493u, 1051716814u, 4121125128u, 1072693247u, 4289940835u, 0, COS_TOLERANCE, 0},
{ 778, 1064632084u, 321857207u, 1089128010u, 1149988239u, 1072693220u, 1919890503u, 0, COS_TOLERANCE, 0},
{ 779, 3245542663u, 799866606u, 3197637091u, 3924438208u, 1072693235u, 2830234323u, 0, COS_TOLERANCE, 0},
{ 780, 3191062890u, 2002049816u, 1077053447u, 2240354761u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 781, 3229006283u, 478939968u, 1097035749u, 1066716440u, 1072038033u, 1963592798u, 0, COS_TOLERANCE, 0},
{ 782, 3232473641u, 1653104725u, 1088548129u, 81977716u, 1072564300u, 3577222580u, 0, COS_TOLERANCE, 0},
{ 783, 3196861276u, 3899475018u, 3189694084u, 3330093036u, 1072693247u, 4294967097u, 0, COS_TOLERANCE, 0},
{ 784, 1089312583u, 2612450289u, 1079065127u, 603380842u, 1071874137u, 2730682483u, 0, COS_TOLERANCE, 0},
{ 785, 1100636791u, 3962735564u, 1101570429u, 1372490825u, 3219484451u, 3424147024u, 0, COS_TOLERANCE, 0},
{ 786, 1054806016u, 1479841439u, 1059312257u, 541504905u, 1072693247u, 4294720287u, 0, COS_TOLERANCE, 0},
{ 787, 1078662178u, 2626148789u, 1057571099u, 4121656076u, 3219613876u, 1330361278u, 0, COS_TOLERANCE, 0},
{ 788, 1081613389u, 1902560314u, 1043130231u, 3557671562u, 3219753066u, 412003789u, 0, COS_TOLERANCE, 0},
{ 789, 3193829772u, 41779312u, 1081626342u, 831171823u, 1072693247u, 4294967292u, 0, COS_TOLERANCE, 0},
{ 790, 1058131100u, 1393168821u, 1066457405u, 1381616968u, 1072693247u, 4274204595u, 0, COS_TOLERANCE, 0},
{ 791, 1072338141u, 3756584649u, 3222267229u, 1423157432u, 1072010372u, 1965542879u, 0, COS_TOLERANCE, 0},
{ 792, 3254435674u, 1894912556u, 1042426694u, 155024547u, 3220102417u, 3146936854u, 0, COS_TOLERANCE, 0},
{ 793, 3195453512u, 35164295u, 3203391785u, 1037041084u, 1072693247u, 4294967264u, 0, COS_TOLERANCE, 0},
{ 794, 1084777479u, 3957875950u, 3232195211u, 1590756436u, 1072162155u, 3181474338u, 0, COS_TOLERANCE, 0},
{ 795, 1068844322u, 1447585080u, 1071279485u, 1107922438u, 1072686013u, 2230343919u, 0, COS_TOLERANCE, 0},
{ 796, 1046252518u, 981897615u, 1051856116u, 430357614u, 1072693247u, 4294967293u, 0, COS_TOLERANCE, 0},
{ 797, 3227524215u, 395145384u, 3219821938u, 50586510u, 3220169459u, 2232263137u, 0, COS_TOLERANCE, 0},
{ 798, 1069775912u, 750827797u, 1082862669u, 230466783u, 1072668996u, 1466987893u, 0, COS_TOLERANCE, 0},
{ 799, 1086668819u, 1365083575u, 3204848310u, 1700831722u, 3219517257u, 2508901127u, 0, COS_TOLERANCE, 0},
{ 800, 3218090390u, 344241827u, 1071538935u, 2715566077u, 1072626729u, 591520264u, 0, COS_TOLERANCE, 0},
{ 801, 3247582856u, 4069301823u, 3193208760u, 2949125229u, 1071869692u, 3800681525u, 0, COS_TOLERANCE, 0},
{ 802, 1103231387u, 3585711710u, 1065801594u, 2302229267u, 1071848763u, 1111779157u, 0, COS_TOLERANCE, 0},
{ 803, 3194118956u, 709803845u, 1048741487u, 2296910194u, 1072693247u, 4294967291u, 0, COS_TOLERANCE, 0},
{ 804, 3193280779u, 744421179u, 1069302001u, 2659232829u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 805, 1092835968u, 1799949903u, 3192522886u, 4212149209u, 3217478798u, 567039304u, 0, COS_TOLERANCE, 0},
{ 806, 3206108502u, 145234164u, 3250614064u, 912384201u, 1072693247u, 4252907712u, 0, COS_TOLERANCE, 0},
{ 807, 3240510664u, 2784620507u, 1102812948u, 3531481022u, 3219875171u, 1925983410u, 0, COS_TOLERANCE, 0},
{ 808, 3251159663u, 383952592u, 3205659905u, 3633194728u, 3219300930u, 1175187344u, 0, COS_TOLERANCE, 0},
{ 809, 3203476252u, 3792395543u, 1070072378u, 3864816376u, 1072693247u, 4293759982u, 0, COS_TOLERANCE, 0},
{ 810, 3205316273u, 2115553675u, 1066288499u, 3538377867u, 1072693247u, 4280954652u, 0, COS_TOLERANCE, 0},
{ 811, 3252075185u, 1230026762u, 1090719723u, 440819880u, 1071705879u, 410002001u, 0, COS_TOLERANCE, 0},
{ 812, 3194595076u, 2991290482u, 1096886719u, 1097971167u, 1072693247u, 4294967286u, 0, COS_TOLERANCE, 0},
{ 813, 1090048600u, 1098035020u, 3230900504u, 1479059095u, 1070691609u, 1556386840u, 0, COS_TOLERANCE, 0},
{ 814, 3251056964u, 1719428427u, 3188631907u, 3707377409u, 3218182768u, 148649403u, 0, COS_TOLERANCE, 0},
{ 815, 1053236165u, 3748932896u, 1084908557u, 1325384361u, 1072693247u, 4294933120u, 0, COS_TOLERANCE, 0},
{ 816, 1084704076u, 3979168763u, 1057455255u, 2454615952u, 1072510630u, 1379118583u, 0, COS_TOLERANCE, 0},
{ 817, 1053106984u, 1449164578u, 1056960316u, 1654931641u, 1072693247u, 4294938702u, 0, COS_TOLERANCE, 0},
{ 818, 1071439010u, 2120487381u, 3226298974u, 2364226633u, 1072483587u, 4085640584u, 0, COS_TOLERANCE, 0},
{ 819, 1075071428u, 1074268944u, 1065730444u, 280016852u, 1071023686u, 839317700u, 0, COS_TOLERANCE, 0},
{ 820, 3200308256u, 3315127889u, 3236295594u, 2900924954u, 1072693247u, 4294949171u, 0, COS_TOLERANCE, 0},
{ 821, 3196425891u, 2246037502u, 1049691002u, 1496066550u, 1072693247u, 4294967179u, 0, COS_TOLERANCE, 0},
{ 822, 3193006859u, 4191285446u, 3217936236u, 2382392789u, 1072693247u, 4294967295u, 0, COS_TOLERANCE, 0},
{ 823, 1092833308u, 640099844u, 1042152237u, 2064279383u, 3219911263u, 3314302700u, 0, COS_TOLERANCE, 0},
{ 824, 1079913438u, 3468560824u, 1093251038u, 310958750u, 1070649459u, 1482103661u, 0, COS_TOLERANCE, 0},
{ 825, 1096788400u, 1413568905u, 1100941106u, 1627289946u, 1072194163u, 3665765707u, 0, COS_TOLERANCE, 0},
{ 826, 3191549550u, 3797143370u, 3195497539u, 3843275034u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 827, 3252077393u, 2806642640u, 3201943068u, 2515980718u, 1072627981u, 3072040624u, 0, COS_TOLERANCE, 0},
{ 828, 1086877316u, 632580632u, 1078673506u, 3259601317u, 1072072842u, 3802210842u, 0, COS_TOLERANCE, 0},
{ 829, 3200980575u, 3309678799u, 1049337078u, 3056787074u, 1072693247u, 4294920337u, 0, COS_TOLERANCE, 0},
{ 830, 3221495289u, 2341164249u, 1080834967u, 2810890005u, 3219778052u, 4039479565u, 0, COS_TOLERANCE, 0},
{ 831, 1067019674u, 932124675u, 1093915797u, 662682630u, 1072692601u, 1903552662u, 0, COS_TOLERANCE, 0},
{ 832, 3249230091u, 1367996113u, 3251723684u, 2974064663u, 3220162345u, 2971280959u, 0, COS_TOLERANCE, 0},
{ 833, 1080230731u, 323437999u, 1090499064u, 901457511u, 1070643331u, 2801218782u, 0, COS_TOLERANCE, 0},
{ 834, 3235778876u, 4184941840u, 3196770014u, 2458988443u, 1070379299u, 3057199715u, 0, COS_TOLERANCE, 0},
{ 835, 1087618284u, 2023065054u, 3211994098u, 2734612965u, 1070619806u, 133610425u, 0, COS_TOLERANCE, 0},
{ 836, 1064074694u, 3679267365u, 3237728785u, 1699558211u, 1072693235u, 1358669674u, 0, COS_TOLERANCE, 0},
{ 837, 1088079010u, 1826799031u, 1078709629u, 3986905229u, 3220155790u, 45714209u, 0, COS_TOLERANCE, 0},
{ 838, 1052843785u, 351061688u, 3194386466u, 4105857588u, 1072693247u, 4294948535u, 0, COS_TOLERANCE, 0},
{ 839, 1054128006u, 1365244058u, 1064457319u, 1452191426u, 1072693247u, 4294857423u, 0, COS_TOLERANCE, 0},
{ 840, 1064122385u, 2463030625u, 3215975031u, 3773488326u, 1072693234u, 2835341684u, 0, COS_TOLERANCE, 0},
{ 841, 3251276671u, 752664055u, 1065110394u, 1835931663u, 1072606330u, 2168006594u, 0, COS_TOLERANCE, 0},
{ 842, 1088045088u, 3496172149u, 1089617208u, 109068701u, 1071646891u, 3454715319u, 0, COS_TOLERANCE, 0},
{ 843, 3198135087u, 1636966254u, 1086098766u, 2016598298u, 1072693247u, 4294966293u, 0, COS_TOLERANCE, 0},
{ 844, 1050931318u, 3551516956u, 1097969102u, 1317953425u, 1072693247u, 4294965706u, 0, COS_TOLERANCE, 0},
{ 845, 3229832217u, 2977627788u, 1045339018u, 516058480u, 3220026354u, 1801307080u, 0, COS_TOLERANCE, 0},
{ 846, 3237408578u, 3901731263u, 3189566462u, 32272932u, 1072612586u, 1999902688u, 0, COS_TOLERANCE, 0},
{ 847, 1077281796u, 1956025297u, 3246628529u, 3840733905u, 3220176264u, 1460906583u, 0, COS_TOLERANCE, 0},
{ 848, 1099818036u, 561057891u, 3198494340u, 4271027193u, 3219706915u, 2487592168u, 0, COS_TOLERANCE, 0},
{ 849, 3250929921u, 692989850u, 3242630588u, 2492225971u, 1071775653u, 3598656665u, 0, COS_TOLERANCE, 0},
{ 850, 3205479397u, 3439913962u, 1067477011u, 2973333638u, 1072693247u, 4278467868u, 0, COS_TOLERANCE, 0},
{ 851, 3213993989u, 877613377u, 1044917899u, 809672798u, 1072692936u, 1124230183u, 0, COS_TOLERANCE, 0},
{ 852, 3222171454u, 905426932u, 1046417457u, 1086320855u, 3219732967u, 2366498859u, 0, COS_TOLERANCE, 0},
{ 853, 3246346629u, 2645567288u, 1051258339u, 557182478u, 3218264361u, 925503775u, 0, COS_TOLERANCE, 0},
{ 854, 3204057950u, 186287752u, 1061342054u, 4054003419u, 1072693247u, 4292188934u, 0, COS_TOLERANCE, 0},
{ 855, 1097266673u, 3506889716u, 3243866036u, 519056371u, 1072524548u, 4130452916u, 0, COS_TOLERANCE, 0},
{ 856, 1042654053u, 2171898436u, 3246911982u, 1091500784u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 857, 3243647673u, 368493885u, 3222871893u, 1419055230u, 3216262723u, 2584514122u, 0, COS_TOLERANCE, 0},
{ 858, 1091950572u, 2010971245u, 3188804530u, 1518695799u, 1072003878u, 3484848839u, 0, COS_TOLERANCE, 0},
{ 859, 3205426509u, 1239207795u, 1040192984u, 2199481342u, 1072693247u, 4279296379u, 0, COS_TOLERANCE, 0},
{ 860, 3210978637u, 4264613432u, 3203460972u, 3558930895u, 1072693241u, 4163824395u, 0, COS_TOLERANCE, 0},
{ 861, 1050299283u, 3772748958u, 3227667376u, 309688336u, 1072693247u, 4294966605u, 0, COS_TOLERANCE, 0},
{ 862, 3230743041u, 1077949160u, 1075769893u, 2405271377u, 3220136004u, 1372765072u, 0, COS_TOLERANCE, 0},
{ 863, 1091835152u, 3751608506u, 3232278094u, 930375071u, 3220132976u, 3623370703u, 0, COS_TOLERANCE, 0},
{ 864, 3198617153u, 1518334131u, 3205247482u, 791756713u, 1072693247u, 4294965176u, 0, COS_TOLERANCE, 0},
{ 865, 1047317453u, 2825203170u, 3245054001u, 1822981827u, 1072693247u, 4294967283u, 0, COS_TOLERANCE, 0},
{ 866, 1100016363u, 514474738u, 1089072073u, 3300845441u, 3220150773u, 1241950753u, 0, COS_TOLERANCE, 0},
{ 867, 3216391250u, 247369460u, 3197320093u, 687450958u, 1072685342u, 869228503u, 0, COS_TOLERANCE, 0},
{ 868, 1104161422u, 2722237629u, 1058272368u, 90602316u, 1071768241u, 2917167493u, 0, COS_TOLERANCE, 0},
{ 869, 3208098435u, 1845900544u, 3231520830u, 3389751458u, 1072693247u, 3706125946u, 0, COS_TOLERANCE, 0},
{ 870, 3247535245u, 737689911u, 3195377751u, 3462616966u, 3219909935u, 25169281u, 0, COS_TOLERANCE, 0},
{ 871, 3223538384u, 3620285831u, 1055501023u, 2708056059u, 3220125731u, 561009732u, 0, COS_TOLERANCE, 0},
{ 872, 3219464996u, 4073430285u, 1056206159u, 172017902u, 1072252135u, 485800405u, 0, COS_TOLERANCE, 0},
{ 873, 3212869638u, 2799176222u, 1052706894u, 4083892667u, 1072693179u, 4024516686u, 0, COS_TOLERANCE, 0},
{ 874, 3202279557u, 1562351330u, 1069705601u, 1247765260u, 1072693247u, 4294722734u, 0, COS_TOLERANCE, 0},
{ 875, 3232717299u, 51853475u, 3189080201u, 2783553144u, 3218702987u, 2062749856u, 0, COS_TOLERANCE, 0},
{ 876, 3219454353u, 3851781549u, 3241598113u, 514064046u, 1072258643u, 3149220087u, 0, COS_TOLERANCE, 0},
{ 877, 1100045965u, 934745487u, 3248182437u, 2798581921u, 1072649916u, 4210399008u, 0, COS_TOLERANCE, 0},
{ 878, 3213082493u, 2948648757u, 3232177250u, 4278702895u, 1072693150u, 2167949766u, 0, COS_TOLERANCE, 0},
{ 879, 1072485724u, 4259101461u, 1061606772u, 84229920u, 1071897988u, 2892918300u, 0, COS_TOLERANCE, 0},
{ 880, 3198075559u, 3891230598u, 1095924595u, 3049217547u, 1072693247u, 4294966350u, 0, COS_TOLERANCE, 0},
{ 881, 1077353053u, 3806018919u, 3243191216u, 280177341u, 3218889273u, 1541679478u, 0, COS_TOLERANCE, 0},
{ 882, 1060624530u, 3900344258u, 1063647809u, 4206745890u, 1072693247u, 3698714150u, 0, COS_TOLERANCE, 0},
{ 883, 3227707336u, 2126253040u, 3207248026u, 808507485u, 1072487400u, 2159060137u, 0, COS_TOLERANCE, 0},
{ 884, 1086090317u, 3465685634u, 3230391053u, 3754958214u, 1072547244u, 3575258804u, 0, COS_TOLERANCE, 0},
{ 885, 1102861084u, 461094531u, 1101110393u, 1316091396u, 3219644021u, 4014018646u, 0, COS_TOLERANCE, 0},
{ 886, 1064980314u, 4197635149u, 1091873113u, 1240127141u, 1072693204u, 3164110352u, 0, COS_TOLERANCE, 0},
{ 887, 1074333893u, 118603800u, 1105304898u, 4291425557u, 3220176737u, 383608412u, 0, COS_TOLERANCE, 0},
{ 888, 3213429165u, 3744663425u, 3212482771u, 953662066u, 1072693091u, 1198201690u, 0, COS_TOLERANCE, 0},
{ 889, 1085171305u, 3564196690u, 3228101916u, 904305212u, 3218446499u, 2064645583u, 0, COS_TOLERANCE, 0},
{ 890, 1048333111u, 3566257266u, 3235138829u, 2734275140u, 1072693247u, 4294967246u, 0, COS_TOLERANCE, 0},
{ 891, 3243948477u, 606044282u, 3241318094u, 2446416887u, 1072483229u, 3024937276u, 0, COS_TOLERANCE, 0},
{ 892, 1041627284u, 2336116589u, 3197594053u, 2296925138u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 893, 1058567659u, 907670625u, 3240769036u, 1827119006u, 1072693247u, 4255755669u, 0, COS_TOLERANCE, 0},
{ 894, 1044467183u, 2818710946u, 3246059905u, 553394170u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 895, 3189504094u, 4099522736u, 3232742168u, 3718083858u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 896, 1092371276u, 1059279404u, 1080245336u, 175941677u, 1071946968u, 3038643463u, 0, COS_TOLERANCE, 0},
{ 897, 1105189691u, 1650862428u, 1061816101u, 1723201723u, 1072546853u, 2900471296u, 0, COS_TOLERANCE, 0},
{ 898, 3239012814u, 2462163405u, 3218946201u, 3876535372u, 3219875653u, 324308466u, 0, COS_TOLERANCE, 0},
{ 899, 1084392886u, 495844137u, 1073721460u, 772777946u, 3219129115u, 4204103924u, 0, COS_TOLERANCE, 0},
{ 900, 1052415330u, 458757721u, 3245680321u, 3609892707u, 1072693247u, 4294955989u, 0, COS_TOLERANCE, 0},
{ 901, 3193282956u, 2533012202u, 1079980803u, 3592268374u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 902, 3203364780u, 4108274117u, 1063045844u, 571992389u, 1072693247u, 4293953329u, 0, COS_TOLERANCE, 0},
{ 903, 1090567271u, 3541110973u, 1096296754u, 3118427427u, 3218286130u, 3681049170u, 0, COS_TOLERANCE, 0},
{ 904, 3193980043u, 1213941007u, 1105433735u, 2172963370u, 1072693247u, 4294967292u, 0, COS_TOLERANCE, 0},
{ 905, 1096853359u, 272190288u, 1095452370u, 4026581530u, 3219573393u, 1754602802u, 0, COS_TOLERANCE, 0},
{ 906, 1095583909u, 2843638672u, 1100510986u, 3190536898u, 1068927336u, 2077295239u, 0, COS_TOLERANCE, 0},
{ 907, 1083757094u, 2014317727u, 3247389683u, 2428462015u, 1071418891u, 3949394807u, 0, COS_TOLERANCE, 0},
{ 908, 1093976717u, 688442200u, 1047852515u, 3035186380u, 3218438567u, 3315807290u, 0, COS_TOLERANCE, 0},
{ 909, 1076664212u, 1010095511u, 3221288076u, 405287991u, 3217309822u, 2575252529u, 0, COS_TOLERANCE, 0},
{ 910, 3252294615u, 2983070435u, 1089546472u, 2907918480u, 3218228705u, 3589822852u, 0, COS_TOLERANCE, 0},
{ 911, 1082988121u, 81928569u, 1056007286u, 2740556321u, 1071928997u, 950952646u, 0, COS_TOLERANCE, 0},
{ 912, 1041110867u, 2076689028u, 1081558619u, 3039159031u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 913, 1047307438u, 1376882094u, 3211003208u, 1296286481u, 1072693247u, 4294967283u, 0, COS_TOLERANCE, 0},
{ 914, 1080114314u, 744133164u, 3200943494u, 955832216u, 1072574444u, 2611483025u, 0, COS_TOLERANCE, 0},
{ 915, 3226290326u, 176522478u, 1069999908u, 2891249491u, 3218846532u, 839584632u, 0, COS_TOLERANCE, 0},
{ 916, 1043564602u, 3685851715u, 3187829932u, 2363997529u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 917, 1040244055u, 3974431579u, 1052505165u, 2589067816u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 918, 3191496789u, 3819109588u, 1048561488u, 969143351u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 919, 1072639397u, 4246896124u, 1104584799u, 1940097860u, 1071774126u, 3327286031u, 0, COS_TOLERANCE, 0},
{ 920, 1048038468u, 2228686199u, 3220231833u, 777624847u, 1072693247u, 4294967261u, 0, COS_TOLERANCE, 0},
{ 921, 3231467306u, 4189906558u, 3203004203u, 854242364u, 1072635801u, 2738772612u, 0, COS_TOLERANCE, 0},
{ 922, 1103910407u, 4089051094u, 3227282692u, 2693170723u, 1072289032u, 2913293455u, 0, COS_TOLERANCE, 0},
{ 923, 1045883607u, 1278581412u, 3239296746u, 1774588717u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 924, 3222372686u, 1794845306u, 1104879344u, 4135865182u, 3218414534u, 3610714925u, 0, COS_TOLERANCE, 0},
{ 925, 1106449055u, 754938390u, 1061291430u, 2010786993u, 1071265111u, 1731432878u, 0, COS_TOLERANCE, 0},
{ 926, 1073581409u, 2034303731u, 3240176537u, 314147356u, 3218175044u, 806346250u, 0, COS_TOLERANCE, 0},
{ 927, 3231449194u, 567588900u, 3195452230u, 1421366017u, 1069959173u, 573109192u, 0, COS_TOLERANCE, 0},
{ 928, 3225089755u, 2708717091u, 1071975971u, 1364590470u, 3218112486u, 3088949577u, 0, COS_TOLERANCE, 0},
{ 929, 3252137283u, 3461956134u, 3207820115u, 1605709634u, 3219751105u, 1269198118u, 0, COS_TOLERANCE, 0},
{ 930, 1065302996u, 1497124553u, 1051715442u, 916736957u, 1072693187u, 123521492u, 0, COS_TOLERANCE, 0},
{ 931, 1058468363u, 834914365u, 1064667143u, 2839166298u, 1072693247u, 4260462906u, 0, COS_TOLERANCE, 0},
{ 932, 1057279949u, 2139295776u, 1062816721u, 914592523u, 1072693247u, 4287870926u, 0, COS_TOLERANCE, 0},
{ 933, 3189636931u, 851569132u, 1058503154u, 1399378677u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 934, 3233537697u, 3897202342u, 3245382590u, 246600375u, 3220170916u, 1054245121u, 0, COS_TOLERANCE, 0},
{ 935, 3225460308u, 3620429520u, 1055627557u, 229305u, 3218059928u, 1414708102u, 0, COS_TOLERANCE, 0},
{ 936, 1083958833u, 3641997865u, 3206673888u, 93720614u, 1071359590u, 2540863482u, 0, COS_TOLERANCE, 0},
{ 937, 3227808435u, 32766320u, 1062084905u, 3668443038u, 1072641997u, 192284648u, 0, COS_TOLERANCE, 0},
{ 938, 3223298996u, 2039713492u, 3248699388u, 1346210821u, 3215759704u, 503757072u, 0, COS_TOLERANCE, 0},
{ 939, 1093050016u, 1335820726u, 3191756860u, 1808427032u, 3219084733u, 3748162632u, 0, COS_TOLERANCE, 0},
{ 940, 1061442763u, 650692001u, 1103515670u, 2253348763u, 1072693247u, 2561215287u, 0, COS_TOLERANCE, 0},
{ 941, 3191395187u, 2372623300u, 3210185343u, 3200572848u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 942, 1100796069u, 762317532u, 3194595095u, 3192607437u, 1071693271u, 4216870113u, 0, COS_TOLERANCE, 0},
{ 943, 1062262701u, 217775356u, 3232827087u, 2969367386u, 1072693246u, 3830754275u, 0, COS_TOLERANCE, 0},
{ 944, 1057172551u, 3621353969u, 1077994795u, 3873976266u, 1072693247u, 4288944491u, 0, COS_TOLERANCE, 0},
{ 945, 1091301987u, 268372152u, 3221764390u, 3216978962u, 1072691551u, 1749079179u, 0, COS_TOLERANCE, 0},
{ 946, 3246437611u, 142942404u, 1075322987u, 1746449109u, 1067877297u, 2819009254u, 0, COS_TOLERANCE, 0},
{ 947, 1104006296u, 496534875u, 3254522293u, 2532372502u, 3219698150u, 64865468u, 0, COS_TOLERANCE, 0},
{ 948, 3250225541u, 2999955409u, 3222793392u, 1868977643u, 3220149279u, 3918709218u, 0, COS_TOLERANCE, 0},
{ 949, 1074319042u, 3353193428u, 3218469191u, 3326244297u, 3220175164u, 3474645289u, 0, COS_TOLERANCE, 0},
{ 950, 1068218799u, 73646871u, 3231442171u, 3711510104u, 1072690173u, 4193166006u, 0, COS_TOLERANCE, 0},
{ 951, 1090483524u, 218135177u, 3198908856u, 3082199105u, 3220146837u, 3066547347u, 0, COS_TOLERANCE, 0},
{ 952, 1068068480u, 1061628117u, 3248859043u, 86776158u, 1072690661u, 1965881568u, 0, COS_TOLERANCE, 0},
{ 953, 3208484674u, 938869114u, 1087911145u, 2416710759u, 1072693247u, 3376814610u, 0, COS_TOLERANCE, 0},
{ 954, 1095576832u, 2970853959u, 3239543429u, 1887505029u, 1072335093u, 1226745687u, 0, COS_TOLERANCE, 0},
{ 955, 3237728787u, 1337895935u, 1076463812u, 1172733328u, 1070268616u, 1986930081u, 0, COS_TOLERANCE, 0},
{ 956, 1049139928u, 1469010822u, 3229583535u, 551399515u, 1072693247u, 4294967145u, 0, COS_TOLERANCE, 0},
{ 957, 1074118123u, 1849711538u, 1049053713u, 1744276190u, 3219991316u, 2380401456u, 0, COS_TOLERANCE, 0},
{ 958, 3242138780u, 2976596113u, 3192137295u, 3033242648u, 3220172732u, 172513277u, 0, COS_TOLERANCE, 0},
{ 959, 1098698481u, 876810930u, 3197470945u, 2571587447u, 1071759494u, 3992980376u, 0, COS_TOLERANCE, 0},
{ 960, 3241770810u, 4007797282u, 3225853845u, 4069319648u, 3217749279u, 4237776152u, 0, COS_TOLERANCE, 0},
{ 961, 1047279982u, 3840538373u, 1043189552u, 3668774580u, 1072693247u, 4294967284u, 0, COS_TOLERANCE, 0},
{ 962, 3217611704u, 200857661u, 3229758439u, 3359367736u, 1072653824u, 1586377961u, 0, COS_TOLERANCE, 0},
{ 963, 3248797869u, 111868139u, 3227902082u, 2366064003u, 1067852060u, 2375960071u, 0, COS_TOLERANCE, 0},
{ 964, 1044195166u, 3510904416u, 3222131653u, 3822770497u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 965, 3242675715u, 789151814u, 1099269239u, 2958956055u, 3219973609u, 4239809652u, 0, COS_TOLERANCE, 0},
{ 966, 1084679320u, 722163228u, 1105524559u, 1534462169u, 3219527636u, 416062612u, 0, COS_TOLERANCE, 0},
{ 967, 1046586062u, 2207037106u, 3208952465u, 1231254630u, 1072693247u, 4294967291u, 0, COS_TOLERANCE, 0},
{ 968, 3197884060u, 3838689849u, 3198769679u, 1302617170u, 1072693247u, 4294966521u, 0, COS_TOLERANCE, 0},
{ 969, 1085938906u, 2527556476u, 3240373426u, 124352692u, 1072479604u, 998241152u, 0, COS_TOLERANCE, 0},
{ 970, 3199540805u, 3502371499u, 1043411944u, 4190072016u, 1072693247u, 4294960160u, 0, COS_TOLERANCE, 0},
{ 971, 1064676142u, 1798470077u, 3200116917u, 3421833729u, 1072693218u, 2810393116u, 0, COS_TOLERANCE, 0},
{ 972, 3193514956u, 3653237931u, 3204255012u, 3683870669u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 973, 1053588582u, 376530104u, 1073853547u, 565755892u, 1072693247u, 4294915363u, 0, COS_TOLERANCE, 0},
{ 974, 3242503851u, 558292492u, 1051772749u, 4267873474u, 3219791395u, 2281335438u, 0, COS_TOLERANCE, 0},
{ 975, 3224772709u, 509637100u, 3212030069u, 215050379u, 3220157703u, 999072486u, 0, COS_TOLERANCE, 0},
{ 976, 1092057101u, 3571665665u, 3188628584u, 757824767u, 3220124006u, 1346258070u, 0, COS_TOLERANCE, 0},
{ 977, 3214799337u, 998858159u, 1063077962u, 436029885u, 1072692351u, 1558924925u, 0, COS_TOLERANCE, 0},
{ 978, 3205946965u, 996300405u, 3193842624u, 80548098u, 1072693247u, 4260694082u, 0, COS_TOLERANCE, 0},
{ 979, 3228848840u, 3876129407u, 3215332180u, 2226970413u, 1066642218u, 885348726u, 0, COS_TOLERANCE, 0},
{ 980, 3237608953u, 200013509u, 3224552716u, 414878724u, 1070775919u, 3997910947u, 0, COS_TOLERANCE, 0},
{ 981, 3230617093u, 309319541u, 1048979765u, 1261662434u, 3219998391u, 1479904630u, 0, COS_TOLERANCE, 0},
{ 982, 1089252639u, 4062255924u, 3224274128u, 4289485681u, 1072688786u, 2112803723u, 0, COS_TOLERANCE, 0},
{ 983, 3236136084u, 1611969213u, 1053890378u, 3774617276u, 1071749943u, 2880945849u, 0, COS_TOLERANCE, 0},
{ 984, 1080412763u, 1752164782u, 3239587974u, 612223386u, 3215050687u, 3711582370u, 0, COS_TOLERANCE, 0},
{ 985, 1041545782u, 2024044989u, 1074932678u, 3259111307u, 1072693248u, 0u, 0, COS_TOLERANCE, 0},
{ 986, 1053207518u, 2564965629u, 1093571065u, 169360454u, 1072693247u, 4294934401u, 0, COS_TOLERANCE, 0},
{ 987, 1089599090u, 1860101737u, 3191222372u, 1676437468u, 1071819589u, 759885329u, 0, COS_TOLERANCE, 0},
{ 988, 1059802968u, 588387057u, 3192103292u, 2495288012u, 1072693247u, 4099451717u, 0, COS_TOLERANCE, 0},
{ 989, 3193155705u, 659070058u, 1073095700u, 1393632068u, 1072693247u, 4294967294u, 0, COS_TOLERANCE, 0},
{ 990, 3217683263u, 4276187829u, 3217553330u, 1868253275u, 1072650297u, 34563883u, 0, COS_TOLERANCE, 0},
{ 991, 3223220272u, 2085481575u, 3215994784u, 800910002u, 1070528947u, 553485972u, 0, COS_TOLERANCE, 0},
{ 992, 1056934836u, 1950570756u, 3200582211u, 941022151u, 1072693247u, 4290891233u, 0, COS_TOLERANCE, 0},
{ 993, 1057530368u, 2075610870u, 3250142022u, 3605152103u, 1072693247u, 4285025881u, 0, COS_TOLERANCE, 0},
{ 994, 3200839250u, 3792931748u, 3204857863u, 804393211u, 1072693247u, 4294927517u, 0, COS_TOLERANCE, 0},
{ 995, 3253646370u, 3430071177u, 3226288311u, 3652522729u, 3216626144u, 1955101016u, 0, COS_TOLERANCE, 0},
{ 996, 3201314702u, 236884699u, 3227874605u, 2193269825u, 1072693247u, 4294900229u, 0, COS_TOLERANCE, 0},
{ 997, 1064936593u, 2744231849u, 1046186036u, 771053722u, 1072693206u, 3877961227u, 0, COS_TOLERANCE, 0},
{ 998, 1083996036u, 3000189819u, 1096500901u, 2057239777u, 1072631052u, 3150737220u, 0, COS_TOLERANCE, 0},
{ 999, 1093835581u, 205759408u, 3244643377u, 2702292618u, 1070705706u, 1138580641u, 0, COS_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_COS_H multiple inclusion protection

// EOF cos.h
