/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.serialize;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DOMBuilder
implements ContentHandler {
    private Document document;
    private Node target;
    private Node currentNode;
    private Locator locator;
    private boolean prefixMappingIsAttribute;
    private List prefixes;

    public boolean isPrefixMappingIsAttribute() {
        return this.prefixMappingIsAttribute;
    }

    public void setPrefixMappingIsAttribute(boolean pPrefixMappingIsAttribute) {
        this.prefixMappingIsAttribute = pPrefixMappingIsAttribute;
    }

    public void setDocument(Document pDocument) {
        this.document = pDocument;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocumentLocator(Locator pLocator) {
        this.locator = pLocator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void setTarget(Node pNode) {
        this.target = pNode;
        this.currentNode = pNode;
        if (this.getDocument() == null) {
            this.setDocument(pNode.getNodeType() == 9 ? (Document)pNode : pNode.getOwnerDocument());
        }
    }

    public Node getTarget() {
        return this.target;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.isPrefixMappingIsAttribute()) {
            if (this.prefixes == null) {
                this.prefixes = new ArrayList();
            }
            this.prefixes.add(prefix);
            this.prefixes.add(uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAttr) throws SAXException {
        int i;
        Document doc = this.getDocument();
        Element element = pNamespaceURI == null || pNamespaceURI.length() == 0 ? doc.createElement(pQName) : doc.createElementNS(pNamespaceURI, pQName);
        if (pAttr != null) {
            i = 0;
            while (i < pAttr.getLength()) {
                String uri = pAttr.getURI(i);
                String qName = pAttr.getQName(i);
                String value = pAttr.getValue(i);
                if (uri == null || uri.length() == 0) {
                    element.setAttribute(qName, value);
                } else {
                    element.setAttributeNS(uri, qName, value);
                }
                ++i;
            }
        }
        if (this.prefixes != null) {
            i = 0;
            while (i < this.prefixes.size()) {
                String prefix = (String)this.prefixes.get(i);
                String uri = (String)this.prefixes.get(i + 1);
                if (prefix == null || "".equals(prefix)) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
                } else {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
                }
                i += 2;
            }
            this.prefixes.clear();
        }
        this.currentNode.appendChild(element);
        this.currentNode = element;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        Node node = this.currentNode.getLastChild();
        String s = new String(ch, start, length);
        if (node != null && node.getNodeType() == 3) {
            ((Text)node).appendData(s);
        } else {
            Text text = this.getDocument().createTextNode(s);
            this.currentNode.appendChild(text);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        ProcessingInstruction pi = this.getDocument().createProcessingInstruction(pTarget, pData);
        this.currentNode.appendChild(pi);
    }

    public void skippedEntity(String pName) throws SAXException {
        EntityReference entity = this.getDocument().createEntityReference(pName);
        this.currentNode.appendChild(entity);
    }
}

