/*
 * Created on Jan 20, 2005
 *
 * @author Fabio Zadrozny
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Str;

/**
 * @author Fabio Zadrozny
 */
public class FindScopeVisitor extends AbstractVisitor {
    
    /**
     * Stack of classes / methods representing the scope.
     */
    protected FastStack<SimpleNode> stackScope = new FastStack<SimpleNode>();

    /**
     * This is the scope.
     */
    public Scope scope = new Scope(new FastStack<SimpleNode>());
    
    /**
     * Variable to mark if we found scope.
     */
    protected boolean found = false;
    
    /**
     * line to find
     */
    private int line;
    
    /**
     * column to find
     */
    private int col;

    /**
     * Only for subclasses
     */
    protected FindScopeVisitor(){
    	
    }
    
    /**
     * Constructor
     * 
     * @param line in ast coords (starts at 1)
     * @param col in ast coords (starts at 1)
     */
    public FindScopeVisitor(int line, int col){
       this.line = line;
       this.col = col;
    }

    /**
     * @see org.python.pydev.parser.jython.ast.VisitorBase#unhandled_node(org.python.pydev.parser.jython.SimpleNode)
     */
    protected Object unhandled_node(SimpleNode node) throws Exception {
        //the line passed in starts at 1 and the lines for the visitor nodes start at 0
        if(! found && !(node instanceof Module)){
	        if(line <= node.beginLine ){
	            //scope is locked at this time.
	            found = true;
	            int original = scope.ifMainLine;
	            scope = new Scope((FastStack<SimpleNode>) this.stackScope.clone());
	            scope.ifMainLine = original;
	        }
        }else{
            if(scope.scopeEndLine == -1 && line < node.beginLine && col >= node.beginColumn){
                scope.scopeEndLine = node.beginLine; 
            }
        }
        return node;
    }

    /**
     * @see org.python.pydev.parser.jython.ast.VisitorBase#traverse(org.python.pydev.parser.jython.SimpleNode)
     */
    public void traverse(SimpleNode node) throws Exception {
        node.traverse(this);
    }
    
    /**
     * @see org.python.pydev.parser.jython.ast.VisitorBase#visitIf(org.python.pydev.parser.jython.ast.If)
     */
    public Object visitIf(If node) throws Exception {
    	checkIfMainNode(node);
        return super.visitIf(node);
    }

    /**
     * Checks if we found an 'if' main node
     */
	protected void checkIfMainNode(If node) {
		Str mainNode = isIfMAinNode(node);
        if(mainNode != null){
            scope.ifMainLine = node.beginLine;
        }
	}

    
    /**
     * @see org.python.pydev.parser.jython.ast.VisitorBase#visitClassDef(org.python.pydev.parser.jython.ast.ClassDef)
     */
    public Object visitClassDef(ClassDef node) throws Exception {
        if(!found){
	        stackScope.push(node);
	        node.traverse(this);
	        stackScope.pop();
        }
        return super.visitClassDef(node);
    }
    
    /**
     * @see org.python.pydev.parser.jython.ast.VisitorBase#visitFunctionDef(org.python.pydev.parser.jython.ast.FunctionDef)
     */
    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if(!found){
	        stackScope.push(node);
	        node.traverse(this);
	        stackScope.pop();
        }
        return super.visitFunctionDef(node);
    }


}
