/* Generated By:JJTree&JavaCC: Do not edit this line. PythonGrammar.java */
package org.python.pydev.parser.jython;
import org.python.pydev.parser.jython.ast.modType;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.Tuple;

public class PythonGrammar/*@bgen(jjtree)*/implements PythonGrammarTreeConstants, PythonGrammarConstants {/*@bgen(jjtree)*/
  protected JJTPythonGrammarState jjtree = new JJTPythonGrammarState();
    public IParserHost hostLiteralMkr;
    private SimpleNode prev;
    private SimpleNode lastIdNode;
    private static boolean DEBUG = false;
    private final static boolean DEFAULT_SEARCH_ON_LAST = false;

    void jjtreeOpenNodeScope(Node n) {
            if(DEBUG){
                System.out.println("opening scope:"+n);
            }
        Token t = getToken(1);
        lastIdNode = (SimpleNode) n;
        jjtree.pushNodePos(t.beginLine, t.beginColumn);
    }

    void addToPeek(Object t, boolean after) {
        addToPeek(t, after, null);
    }

    void addToPeekCallFunc(Object t, boolean after) {
        Call n = (Call) jjtree.peekNode();
        n.func.addSpecial(t, after);
    }

    void addToPeek(Object t, boolean after, Class class_) {
        SimpleNode peeked = (SimpleNode) jjtree.peekNode();
        addToPeek(peeked, t, after, class_);
    }

    void addToPeek(SimpleNode peeked, Object t, boolean after, Class class_) {
        if (class_ != null) {
            // just check if it is the class we were expecting.
            if (peeked.getClass().equals(class_) == false) {
                throw new RuntimeException("Error, expecting another class.");
            }
        }
        peeked.addSpecial(t, after);
    }

    void jjtreeCloseNodeScope(Node n) {
        if (DEBUG) {
            System.out.println("closing scope:" + n);
        }
        SimpleNode peeked = jjtree.setNodePos();
        List specialTokens = token_source.specialTokens;
        boolean after = true;
        if (n instanceof SimpleNode) {
            if (specialTokens.size() > 0) {
                if (prev == null) {
                    // it was not previously set, let's get the current and add it before that token
                    after = false;
                    prev = peeked;
                }
                if (DEBUG) {
                    System.out.println("closing scope " + peeked.getClass());
                }

                for (Iterator iter = specialTokens.iterator(); iter.hasNext();) {
                    Object next = iter.next();
                    int strategy = STRATEGY_ADD_AFTER_PREV; // default strategy
                    if (next instanceof Object[]) {
                        strategy = (Integer) ((Object[]) next)[1];
                        next = ((Object[]) next)[0];
                    }

                    if (strategy == STRATEGY_BEFORE_NEXT) { // try to set 'before the next' and not after prev token
                        addToPeek(peeked, next, false, null);
                    } else {
                        // may still add before the next, if there was no prev (we can check that by the 'after' variable)
                        // in this case, we'll do some checks to see if it is really correct (checking for the line and column)

                        if (next instanceof Token) {
                            findTokenToAdd((Token) next).addSpecial(next, after);
                        } else {
                            prev.addSpecial(next, after);
                        }
                    }
                }
                specialTokens.clear();
            }
            prev = (SimpleNode) peeked;
        }
    }


    /**
     * Default: add after the previous found token
     */
    public static final int STRATEGY_ADD_AFTER_PREV = 0;

    /**
     * Add before the 'next token' strategy
     */
    public static final int STRATEGY_BEFORE_NEXT = 1;

    private SimpleNode findTokenToAdd(Token next) {
        SimpleNode curr = (SimpleNode) jjtree.peekNode();
        if(curr != prev){
            //let's see which one is better suited
            if(prev.beginLine == next.beginLine){
                return prev;
            }
            if(curr.beginLine == next.beginLine){
                return curr;
            }
            //if it was found later than both, let's get the current
            if(next.beginLine > prev.beginLine && next.beginLine > curr.beginLine){
                return curr;
            }

        }
        return prev;

    }

    private void addSpecialToken(Object o, int strategy) {
        token_source.specialTokens.add(new Object[]{o, strategy});
    }

    private void addSpecialToken(Object o) {
        //the default is adding after the previous token
        token_source.specialTokens.add(new Object[]{o, STRATEGY_ADD_AFTER_PREV});
    }


    private boolean findTokenAndAdd(String token) throws ParseException {
        return findTokenAndAdd(token, token, DEFAULT_SEARCH_ON_LAST);
    }

    private Object createSpecialStr(String token) throws ParseException {
        return createSpecialStr(token, token);
    }
    private Object createSpecialStr(String token, boolean searchOnLast) throws ParseException {
        return createSpecialStr(token, token, searchOnLast);
    }

    private Object createSpecialStr(String token, String put) throws ParseException {
        return createSpecialStr(token, put, DEFAULT_SEARCH_ON_LAST);
    }
    private Object createSpecialStr(String token, String put, boolean searchOnLast) throws ParseException {
        Token t;
        if(searchOnLast){
                t = jj_lastpos;
        }else{
                t = this.token;
        }
        while(t != null && t.image != null && t.image.equals(token) == false){
                t = t.next;
        }
        if(t != null){
                return new SpecialStr(put,t.beginLine, t.beginColumn);
        }
        //return put;
        if(this.token != null){
                throw new ParseException("Expected:"+token, this.token);
        }else if(jj_lastpos != null){
                throw new ParseException("Expected:"+token, jj_lastpos);
        }else{
                throw new ParseException("Expected:"+token);
        }
    }

    /**
     * This is so that we add the String with the beginLine and beginColumn
     * @throws ParseException 
     */
    private boolean findTokenAndAdd(String token, String put, boolean searchOnLast) throws ParseException {
        Object s = createSpecialStr(token, put, searchOnLast);
        token_source.specialTokens.add(new Object[]{s, STRATEGY_ADD_AFTER_PREV});
        return s instanceof SpecialStr;
    }



    Object makeInt(String s, int radix) {
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length()-1);
            return hostLiteralMkr.newLong(new java.math.BigInteger(s, radix));
        }
        int ndigits = s.length();
        int i=0;
        while (i < ndigits && s.charAt(i) == '0')
            i++;
        if ((ndigits - i) > 11) {
            return hostLiteralMkr.newLong(new java.math.BigInteger(s, radix));
        }

        long l = Long.valueOf(s, radix).longValue();
        if (l > 0xffffffffl || (radix == 10 && l > Integer.MAX_VALUE)) {
            return hostLiteralMkr.newLong(new java.math.BigInteger(s, radix));
        }
        return hostLiteralMkr.newInteger((int) l);
    }

    Object makeFloat(String s) {
        return hostLiteralMkr.newFloat(Double.valueOf(s).doubleValue());
    }

    Object makeLong(String s) {
        return hostLiteralMkr.newLong(s);
    }

    Object makeComplex(String s) {
        s = s.substring(0, s.length() - 1);
        return hostLiteralMkr.newImaginary(Double.valueOf(s).doubleValue());
    }

    /**
     * Return a Tuple where:
     * 0 = the string
     * 1 = boolean indicating unicode
     * 2 = boolean indicating raw
     * 3 = style
     */
    Object[] makeString(String s, int quotes) {
        //System.out.println("enter: "+s);
        char quoteChar = s.charAt(0);
        int start=0;
        boolean ustring = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            start++;
        }
        quoteChar = s.charAt(start);
        if (quoteChar == 'r' || quoteChar == 'R') {
            //raw string (does not decode slashes)
            String str = s.substring(quotes+start+1, s.length()-quotes);
            //System.out.println("out: "+str);
            return new Object[]{str,ustring, true, getType(s.charAt(start+1), quotes)};

        } else {
            int n = s.length()-quotes;
            int i=quotes+start;

            String str = hostLiteralMkr.decode_UnicodeEscape(s, i, n, "strict", ustring);
            //System.out.println("out: "+str);
            return new Object[]{str, ustring, false, getType(s.charAt(start), quotes)};
        }
    }

    private int getType(char c, int quotes){
        if(quotes == 1){
            if (c == '\''){
                return Str.SingleSingle;
            }
            if(c == '"'){
                return Str.SingleDouble;
            }
        }
        if (c == '\''){
            return Str.TripleSingle;
        }
        if(c == '"'){
            return Str.TripleDouble;
        }
        throw new RuntimeException("Unable to determine type. Char: "+c+" quotes:"+quotes );
    }

    // ! maximal currently used LOOKAHEAD is 3
    private static final int MAX_LOOKAHEAD = 3;

    public boolean partial_valid_sentence(Throwable t) {
        if (t instanceof TokenMgrError) {
           // check whether EOF condition inside multi-line string,
           // or just after newline continuation inside a string (*NLC states)
           TokenMgrError e = (TokenMgrError)t;
           switch(e.lexState) {
           case IN_STRING1NLC:
           case IN_STRING2NLC:
           case IN_STRING13:
           case IN_STRING23:
           case IN_USTRING1NLC:
           case IN_USTRING2NLC:
           case IN_USTRING13:
           case IN_USTRING23:
               return e.EOFSeen;
           default:
               return false;
           }
        }
        if (!(t instanceof ParseException))
            return false;
        try {
            ParseException e = (ParseException)t;
            int tok = getNextToken().kind;
            if (tok == EOF) return true; // all tokens eaten

            // or check whether remaing tokens partially fullfill lookahead
            // expectations

            int[][] expected = e.expectedTokenSequences;

            if (expected == null) return false;

            int[] ahead = new int[MAX_LOOKAHEAD-1];

            int i = 0;
            for(;;) {
                ahead[i] = tok;
                i++;
                tok = getNextToken().kind;
                if (tok == EOF) break;
                if (i >= MAX_LOOKAHEAD-1) return false;
            }

            int nahead = i;

        next_expected:
            for(int j = 0; j<expected.length; j++) {
                int[] cand = expected[j];

                if (cand.length <= nahead ) continue next_expected;

                for(int k = 0; k < nahead; k++)
                    if (ahead[k] != cand[k])
                        continue next_expected;
                return true;
            }

            return false;
        } catch (TokenMgrError e1) {
            return false;
        }
    }

   // constructors taking a IParserHost impl

   public PythonGrammar(CharStream stream,IParserHost host) {
       this(stream);
       hostLiteralMkr = host;
   }

   public PythonGrammar(PythonGrammarTokenManager tm,
                        IParserHost host)
   {
        this(tm);
        hostLiteralMkr = host;
   }

//single_input: NEWLINE | simple_stmt | compound_stmt NEWLINE
// apparently CPython coalesces newlines, we don't
  final public modType single_input() throws ParseException {
                         /*@bgen(jjtree) single_input */
    SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSINGLE_INPUT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);token_source.single_input=true;
    try {
      label_1:
      while (true) {
        if (jj_2_1(2)) {
          ;
        } else {
          break label_1;
        }
        jj_consume_token(NEWLINE);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case PLUS:
      case MINUS:
      case NOT:
      case NOT_BOOL:
      case LAMBDA:
      case IF:
      case WHILE:
      case FOR:
      case TRY:
      case DEF:
      case CLASS:
      case PRINT:
      case PASS:
      case BREAK:
      case CONTINUE:
      case RETURN:
      case YIELD:
      case IMPORT:
      case FROM:
      case DEL:
      case RAISE:
      case GLOBAL:
      case EXEC:
      case ASSERT:
      case AS:
      case AT:
      case NAME:
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
      case 136:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
        case LBRACE:
        case LBRACKET:
        case PLUS:
        case MINUS:
        case NOT:
        case NOT_BOOL:
        case LAMBDA:
        case PRINT:
        case PASS:
        case BREAK:
        case CONTINUE:
        case RETURN:
        case YIELD:
        case IMPORT:
        case FROM:
        case DEL:
        case RAISE:
        case GLOBAL:
        case EXEC:
        case ASSERT:
        case AS:
        case NAME:
        case DECNUMBER:
        case HEXNUMBER:
        case OCTNUMBER:
        case FLOAT:
        case COMPLEX:
        case SINGLE_STRING:
        case SINGLE_STRING2:
        case TRIPLE_STRING:
        case TRIPLE_STRING2:
        case SINGLE_USTRING:
        case SINGLE_USTRING2:
        case TRIPLE_USTRING:
        case TRIPLE_USTRING2:
        case 136:
          simple_stmt();
          break;
        case IF:
        case WHILE:
        case FOR:
        case TRY:
        case DEF:
        case CLASS:
        case AT:
          compound_stmt();
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[0] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        jj_consume_token(NEWLINE);
      }
      jj_consume_token(0);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
      {if (true) return (modType) jjtree.popNode();}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
    throw new Error("Missing return statement in function");
  }

//file_input: (NEWLINE | stmt)* ENDMARKER
  final public modType file_input() throws ParseException {
                       /*@bgen(jjtree) file_input */
                       SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTFILE_INPUT);
                       boolean jjtc000 = true;
                       jjtree.openNodeScope(jjtn000);
                       jjtreeOpenNodeScope(jjtn000);token_source.single_input=false;
    try {
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case LPAREN:
        case LBRACE:
        case LBRACKET:
        case PLUS:
        case MINUS:
        case NOT:
        case NOT_BOOL:
        case LAMBDA:
        case IF:
        case WHILE:
        case FOR:
        case TRY:
        case DEF:
        case CLASS:
        case PRINT:
        case PASS:
        case BREAK:
        case CONTINUE:
        case RETURN:
        case YIELD:
        case IMPORT:
        case FROM:
        case DEL:
        case RAISE:
        case GLOBAL:
        case EXEC:
        case ASSERT:
        case AS:
        case AT:
        case NAME:
        case DECNUMBER:
        case HEXNUMBER:
        case OCTNUMBER:
        case FLOAT:
        case COMPLEX:
        case SINGLE_STRING:
        case SINGLE_STRING2:
        case TRIPLE_STRING:
        case TRIPLE_STRING2:
        case SINGLE_USTRING:
        case SINGLE_USTRING2:
        case TRIPLE_USTRING:
        case TRIPLE_USTRING2:
        case 136:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        case LPAREN:
        case LBRACE:
        case LBRACKET:
        case PLUS:
        case MINUS:
        case NOT:
        case NOT_BOOL:
        case LAMBDA:
        case IF:
        case WHILE:
        case FOR:
        case TRY:
        case DEF:
        case CLASS:
        case PRINT:
        case PASS:
        case BREAK:
        case CONTINUE:
        case RETURN:
        case YIELD:
        case IMPORT:
        case FROM:
        case DEL:
        case RAISE:
        case GLOBAL:
        case EXEC:
        case ASSERT:
        case AS:
        case AT:
        case NAME:
        case DECNUMBER:
        case HEXNUMBER:
        case OCTNUMBER:
        case FLOAT:
        case COMPLEX:
        case SINGLE_STRING:
        case SINGLE_STRING2:
        case TRIPLE_STRING:
        case TRIPLE_STRING2:
        case SINGLE_USTRING:
        case SINGLE_USTRING2:
        case TRIPLE_USTRING:
        case TRIPLE_USTRING2:
        case 136:
          stmt();
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(0);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
      {if (true) return (modType) jjtree.popNode();}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
    throw new Error("Missing return statement in function");
  }

//eval_input: NEWLINE* testlist NEWLINE* ENDMARKER
  final public modType eval_input() throws ParseException {
                       /*@bgen(jjtree) eval_input */
                       SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEVAL_INPUT);
                       boolean jjtc000 = true;
                       jjtree.openNodeScope(jjtn000);
                       jjtreeOpenNodeScope(jjtn000);token_source.single_input=false;
    try {
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[5] = jj_gen;
          break label_4;
        }
        jj_consume_token(NEWLINE);
      }
      SmartTestList();
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_5;
        }
        jj_consume_token(NEWLINE);
      }
      jj_consume_token(0);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtreeCloseNodeScope(jjtn000);
      {if (true) return (modType) jjtree.popNode();}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
    throw new Error("Missing return statement in function");
  }

//funcdef: 'def' NAME parameters ':' suite
  final public void funcdef() throws ParseException {
                 /*@bgen(jjtree) funcdef */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTFUNCDEF);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      decorators();
      jj_consume_token(DEF);
      AnyName();
      parameters();
      jj_consume_token(COLON);
                                              this.addSpecialToken(":");
      suite();
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

//@ call, name, attr ... <nl>
  final public void decorators() throws ParseException {
                    /*@bgen(jjtree) decorators */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDECORATORS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AT:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_6;
        }
        begin_decorator();
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            ;
            break;
          default:
            jj_la1[8] = jj_gen;
            break label_7;
          }
          jj_consume_token(LPAREN);
                                       this.addSpecialToken("(", STRATEGY_BEFORE_NEXT);
          insidetuporcall();
          jj_consume_token(RPAREN);
                                                                                                                      this.findTokenAndAdd(")");
        }
        jj_consume_token(NEWLINE);
      }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

  final public void begin_decorator() throws ParseException {
                         /*@bgen(jjtree) begin_decorator */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_DECORATOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(AT);
      dotted_name();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//parameters: '(' [varargslist] ')'
  final public void parameters() throws ParseException {
    jj_consume_token(LPAREN);
           this.findTokenAndAdd("(");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case MULTIPLY:
    case POWER:
    case AS:
    case NAME:
      varargslist();
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
           this.findTokenAndAdd(")");
  }

//varargslist: (fpdef ['=' test] ',')* ('*' NAME [',' ('**'|'*' '*') NAME] | ('**'|'*' '*') NAME) | fpdef ['=' test] (',' fpdef ['=' test])* [',']
  final public void varargslist() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case AS:
    case NAME:
      defaultarg();
      label_8:
      while (true) {
        if (jj_2_2(2)) {
          ;
        } else {
          break label_8;
        }
                                this.addSpecialToken(",");
        jj_consume_token(COMMA);
        defaultarg();
      }
      if (jj_2_3(3)) {
                       this.addSpecialToken(",");
        jj_consume_token(COMMA);
        ExtraArgList();
      } else {
        ;
      }
      if (jj_2_4(2)) {
                       this.addSpecialToken(",");
        jj_consume_token(COMMA);
        ExtraKeywordList();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
          this.addSpecialToken(",");
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      break;
    case MULTIPLY:
    case POWER:
      if (jj_2_5(2)) {
        ExtraArgList();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
                                            this.addSpecialToken(",");
          jj_consume_token(COMMA);
          ExtraKeywordList();
          break;
        default:
          jj_la1[11] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULTIPLY:
        case POWER:
          ExtraKeywordList();
          break;
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ExtraArgList() throws ParseException {
                      /*@bgen(jjtree) ExtraArgList */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEXTRAARGLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(MULTIPLY);
              this.addSpecialToken("*", STRATEGY_BEFORE_NEXT);
      Name();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void ExtraKeywordList() throws ParseException {
                          /*@bgen(jjtree) ExtraKeywordList */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEXTRAKEYWORDLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case POWER:
        jj_consume_token(POWER);
           this.addSpecialToken("**", STRATEGY_BEFORE_NEXT);
        break;
      case MULTIPLY:
        jj_consume_token(MULTIPLY);
                                                                          this.addSpecialToken("*", STRATEGY_BEFORE_NEXT);
                                                                                                                            this.addSpecialToken("*", STRATEGY_BEFORE_NEXT);
        jj_consume_token(MULTIPLY);
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      Name();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void defaultarg() throws ParseException {
                    /*@bgen(jjtree) defaultarg */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDEFAULTARG);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      fpdef();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
        jj_consume_token(EQUAL);
        test();
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//fpdef: NAME | '(' fplist ')'
  final public void fpdef() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case NAME:
      Name();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
                      this.addSpecialToken("(",STRATEGY_BEFORE_NEXT);
      fplist();
      jj_consume_token(RPAREN);
                                                                                            this.findTokenAndAdd(")");
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//fplist: fpdef (',' fpdef)* [',']
  final public void fplist() throws ParseException {
                       /*@bgen(jjtree) tuple */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTUPLE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      fpdef();
      label_9:
      while (true) {
        if (jj_2_6(2)) {
          ;
        } else {
          break label_9;
        }
                         this.addSpecialToken(",");
        jj_consume_token(COMMA);
        fpdef();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
                                                                         this.addSpecialToken(",");
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[17] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//stmt: simple_stmt | compound_stmt
  final public void stmt() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case PLUS:
    case MINUS:
    case NOT:
    case NOT_BOOL:
    case LAMBDA:
    case PRINT:
    case PASS:
    case BREAK:
    case CONTINUE:
    case RETURN:
    case YIELD:
    case IMPORT:
    case FROM:
    case DEL:
    case RAISE:
    case GLOBAL:
    case EXEC:
    case ASSERT:
    case AS:
    case NAME:
    case DECNUMBER:
    case HEXNUMBER:
    case OCTNUMBER:
    case FLOAT:
    case COMPLEX:
    case SINGLE_STRING:
    case SINGLE_STRING2:
    case TRIPLE_STRING:
    case TRIPLE_STRING2:
    case SINGLE_USTRING:
    case SINGLE_USTRING2:
    case TRIPLE_USTRING:
    case TRIPLE_USTRING2:
    case 136:
      simple_stmt();
      break;
    case IF:
    case WHILE:
    case FOR:
    case TRY:
    case DEF:
    case CLASS:
    case AT:
      compound_stmt();
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//simple_stmt: small_stmt (';' small_stmt)* [';'] NEWLINE
  final public void simple_stmt() throws ParseException {
    small_stmt();
    label_10:
    while (true) {
      if (jj_2_7(2)) {
        ;
      } else {
        break label_10;
      }
      jj_consume_token(SEMICOLON);
      small_stmt();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    jj_consume_token(NEWLINE);
  }

//small_stmt: expr_stmt | print_stmt  | del_stmt | pass_stmt | flow_stmt | import_stmt | global_stmt | exec_stmt | assert_stmt
  final public void small_stmt() throws ParseException {
                          SimpleNode simpleNode;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case PLUS:
    case MINUS:
    case NOT:
    case NOT_BOOL:
    case LAMBDA:
    case AS:
    case NAME:
    case DECNUMBER:
    case HEXNUMBER:
    case OCTNUMBER:
    case FLOAT:
    case COMPLEX:
    case SINGLE_STRING:
    case SINGLE_STRING2:
    case TRIPLE_STRING:
    case TRIPLE_STRING2:
    case SINGLE_USTRING:
    case SINGLE_USTRING2:
    case TRIPLE_USTRING:
    case TRIPLE_USTRING2:
    case 136:
      expr_stmt();
      break;
    case PRINT:
      print_stmt();
      break;
    case DEL:
      del_stmt();
      break;
    case PASS:
      pass_stmt();
                 addToPeek("pass", false);
      break;
    case BREAK:
    case CONTINUE:
    case RETURN:
    case YIELD:
    case RAISE:
      flow_stmt();
      break;
    case IMPORT:
    case FROM:
      import_stmt();
      break;
    case GLOBAL:
      global_stmt();
      break;
    case EXEC:
      exec_stmt();
      break;
    case ASSERT:
      assert_stmt();
                   addToPeek("assert ", false);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//expr_stmt: testlist (augassign testlist | ('=' testlist)*)
  final public void expr_stmt() throws ParseException {
    SmartTestList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUSEQ:
      jj_consume_token(PLUSEQ);
               SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_PLUS);
               boolean jjtc001 = true;
               jjtree.openNodeScope(jjtn001);
               jjtreeOpenNodeScope(jjtn001);
      try {
        SmartTestList();
      } catch (Throwable jjte001) {
               if (jjtc001) {
                 jjtree.clearNodeScope(jjtn001);
                 jjtc001 = false;
               } else {
                 jjtree.popNode();
               }
               if (jjte001 instanceof RuntimeException) {
                 {if (true) throw (RuntimeException)jjte001;}
               }
               if (jjte001 instanceof ParseException) {
                 {if (true) throw (ParseException)jjte001;}
               }
               {if (true) throw (Error)jjte001;}
      } finally {
               if (jjtc001) {
                 jjtree.closeNodeScope(jjtn001,  2);
                 jjtreeCloseNodeScope(jjtn001);
               }
      }
      break;
    case MINUSEQ:
      jj_consume_token(MINUSEQ);
                SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_MINUS);
                boolean jjtc002 = true;
                jjtree.openNodeScope(jjtn002);
                jjtreeOpenNodeScope(jjtn002);
      try {
        SmartTestList();
      } catch (Throwable jjte002) {
                if (jjtc002) {
                  jjtree.clearNodeScope(jjtn002);
                  jjtc002 = false;
                } else {
                  jjtree.popNode();
                }
                if (jjte002 instanceof RuntimeException) {
                  {if (true) throw (RuntimeException)jjte002;}
                }
                if (jjte002 instanceof ParseException) {
                  {if (true) throw (ParseException)jjte002;}
                }
                {if (true) throw (Error)jjte002;}
      } finally {
                if (jjtc002) {
                  jjtree.closeNodeScope(jjtn002,  2);
                  jjtreeCloseNodeScope(jjtn002);
                }
      }
      break;
    case MULTIPLYEQ:
      jj_consume_token(MULTIPLYEQ);
                   SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_MULTIPLY);
                   boolean jjtc003 = true;
                   jjtree.openNodeScope(jjtn003);
                   jjtreeOpenNodeScope(jjtn003);
      try {
        SmartTestList();
      } catch (Throwable jjte003) {
                   if (jjtc003) {
                     jjtree.clearNodeScope(jjtn003);
                     jjtc003 = false;
                   } else {
                     jjtree.popNode();
                   }
                   if (jjte003 instanceof RuntimeException) {
                     {if (true) throw (RuntimeException)jjte003;}
                   }
                   if (jjte003 instanceof ParseException) {
                     {if (true) throw (ParseException)jjte003;}
                   }
                   {if (true) throw (Error)jjte003;}
      } finally {
                   if (jjtc003) {
                     jjtree.closeNodeScope(jjtn003,  2);
                     jjtreeCloseNodeScope(jjtn003);
                   }
      }
      break;
    case DIVIDEEQ:
      jj_consume_token(DIVIDEEQ);
                 SimpleNode jjtn004 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_DIVIDE);
                 boolean jjtc004 = true;
                 jjtree.openNodeScope(jjtn004);
                 jjtreeOpenNodeScope(jjtn004);
      try {
        SmartTestList();
      } catch (Throwable jjte004) {
                 if (jjtc004) {
                   jjtree.clearNodeScope(jjtn004);
                   jjtc004 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte004 instanceof RuntimeException) {
                   {if (true) throw (RuntimeException)jjte004;}
                 }
                 if (jjte004 instanceof ParseException) {
                   {if (true) throw (ParseException)jjte004;}
                 }
                 {if (true) throw (Error)jjte004;}
      } finally {
                 if (jjtc004) {
                   jjtree.closeNodeScope(jjtn004,  2);
                   jjtreeCloseNodeScope(jjtn004);
                 }
      }
      break;
    case FLOORDIVIDEEQ:
      jj_consume_token(FLOORDIVIDEEQ);
                      SimpleNode jjtn005 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_FLOORDIVIDE);
                      boolean jjtc005 = true;
                      jjtree.openNodeScope(jjtn005);
                      jjtreeOpenNodeScope(jjtn005);
      try {
        SmartTestList();
      } catch (Throwable jjte005) {
                      if (jjtc005) {
                        jjtree.clearNodeScope(jjtn005);
                        jjtc005 = false;
                      } else {
                        jjtree.popNode();
                      }
                      if (jjte005 instanceof RuntimeException) {
                        {if (true) throw (RuntimeException)jjte005;}
                      }
                      if (jjte005 instanceof ParseException) {
                        {if (true) throw (ParseException)jjte005;}
                      }
                      {if (true) throw (Error)jjte005;}
      } finally {
                      if (jjtc005) {
                        jjtree.closeNodeScope(jjtn005,  2);
                        jjtreeCloseNodeScope(jjtn005);
                      }
      }
      break;
    case MODULOEQ:
      jj_consume_token(MODULOEQ);
                 SimpleNode jjtn006 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_MODULO);
                 boolean jjtc006 = true;
                 jjtree.openNodeScope(jjtn006);
                 jjtreeOpenNodeScope(jjtn006);
      try {
        SmartTestList();
      } catch (Throwable jjte006) {
                 if (jjtc006) {
                   jjtree.clearNodeScope(jjtn006);
                   jjtc006 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte006 instanceof RuntimeException) {
                   {if (true) throw (RuntimeException)jjte006;}
                 }
                 if (jjte006 instanceof ParseException) {
                   {if (true) throw (ParseException)jjte006;}
                 }
                 {if (true) throw (Error)jjte006;}
      } finally {
                 if (jjtc006) {
                   jjtree.closeNodeScope(jjtn006,  2);
                   jjtreeCloseNodeScope(jjtn006);
                 }
      }
      break;
    case ANDEQ:
      jj_consume_token(ANDEQ);
              SimpleNode jjtn007 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_AND);
              boolean jjtc007 = true;
              jjtree.openNodeScope(jjtn007);
              jjtreeOpenNodeScope(jjtn007);
      try {
        SmartTestList();
      } catch (Throwable jjte007) {
              if (jjtc007) {
                jjtree.clearNodeScope(jjtn007);
                jjtc007 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte007 instanceof RuntimeException) {
                {if (true) throw (RuntimeException)jjte007;}
              }
              if (jjte007 instanceof ParseException) {
                {if (true) throw (ParseException)jjte007;}
              }
              {if (true) throw (Error)jjte007;}
      } finally {
              if (jjtc007) {
                jjtree.closeNodeScope(jjtn007,  2);
                jjtreeCloseNodeScope(jjtn007);
              }
      }
      break;
    case OREQ:
      jj_consume_token(OREQ);
             SimpleNode jjtn008 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_OR);
             boolean jjtc008 = true;
             jjtree.openNodeScope(jjtn008);
             jjtreeOpenNodeScope(jjtn008);
      try {
        SmartTestList();
      } catch (Throwable jjte008) {
             if (jjtc008) {
               jjtree.clearNodeScope(jjtn008);
               jjtc008 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte008 instanceof RuntimeException) {
               {if (true) throw (RuntimeException)jjte008;}
             }
             if (jjte008 instanceof ParseException) {
               {if (true) throw (ParseException)jjte008;}
             }
             {if (true) throw (Error)jjte008;}
      } finally {
             if (jjtc008) {
               jjtree.closeNodeScope(jjtn008,  2);
               jjtreeCloseNodeScope(jjtn008);
             }
      }
      break;
    case XOREQ:
      jj_consume_token(XOREQ);
              SimpleNode jjtn009 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_XOR);
              boolean jjtc009 = true;
              jjtree.openNodeScope(jjtn009);
              jjtreeOpenNodeScope(jjtn009);
      try {
        SmartTestList();
      } catch (Throwable jjte009) {
              if (jjtc009) {
                jjtree.clearNodeScope(jjtn009);
                jjtc009 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte009 instanceof RuntimeException) {
                {if (true) throw (RuntimeException)jjte009;}
              }
              if (jjte009 instanceof ParseException) {
                {if (true) throw (ParseException)jjte009;}
              }
              {if (true) throw (Error)jjte009;}
      } finally {
              if (jjtc009) {
                jjtree.closeNodeScope(jjtn009,  2);
                jjtreeCloseNodeScope(jjtn009);
              }
      }
      break;
    case LSHIFTEQ:
      jj_consume_token(LSHIFTEQ);
                 SimpleNode jjtn010 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_LSHIFT);
                 boolean jjtc010 = true;
                 jjtree.openNodeScope(jjtn010);
                 jjtreeOpenNodeScope(jjtn010);
      try {
        SmartTestList();
      } catch (Throwable jjte010) {
                 if (jjtc010) {
                   jjtree.clearNodeScope(jjtn010);
                   jjtc010 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte010 instanceof RuntimeException) {
                   {if (true) throw (RuntimeException)jjte010;}
                 }
                 if (jjte010 instanceof ParseException) {
                   {if (true) throw (ParseException)jjte010;}
                 }
                 {if (true) throw (Error)jjte010;}
      } finally {
                 if (jjtc010) {
                   jjtree.closeNodeScope(jjtn010,  2);
                   jjtreeCloseNodeScope(jjtn010);
                 }
      }
      break;
    case RSHIFTEQ:
      jj_consume_token(RSHIFTEQ);
                 SimpleNode jjtn011 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_RSHIFT);
                 boolean jjtc011 = true;
                 jjtree.openNodeScope(jjtn011);
                 jjtreeOpenNodeScope(jjtn011);
      try {
        SmartTestList();
      } catch (Throwable jjte011) {
                 if (jjtc011) {
                   jjtree.clearNodeScope(jjtn011);
                   jjtc011 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte011 instanceof RuntimeException) {
                   {if (true) throw (RuntimeException)jjte011;}
                 }
                 if (jjte011 instanceof ParseException) {
                   {if (true) throw (ParseException)jjte011;}
                 }
                 {if (true) throw (Error)jjte011;}
      } finally {
                 if (jjtc011) {
                   jjtree.closeNodeScope(jjtn011,  2);
                   jjtreeCloseNodeScope(jjtn011);
                 }
      }
      break;
    case POWEREQ:
      jj_consume_token(POWEREQ);
                SimpleNode jjtn012 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAUG_POWER);
                boolean jjtc012 = true;
                jjtree.openNodeScope(jjtn012);
                jjtreeOpenNodeScope(jjtn012);
      try {
        SmartTestList();
      } catch (Throwable jjte012) {
                if (jjtc012) {
                  jjtree.clearNodeScope(jjtn012);
                  jjtc012 = false;
                } else {
                  jjtree.popNode();
                }
                if (jjte012 instanceof RuntimeException) {
                  {if (true) throw (RuntimeException)jjte012;}
                }
                if (jjte012 instanceof ParseException) {
                  {if (true) throw (ParseException)jjte012;}
                }
                {if (true) throw (Error)jjte012;}
      } finally {
                if (jjtc012) {
                  jjtree.closeNodeScope(jjtn012,  2);
                  jjtreeCloseNodeScope(jjtn012);
                }
      }
      break;
    default:
      jj_la1[22] = jj_gen;
      SimpleNode jjtn013 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEXPR_STMT);
      boolean jjtc013 = true;
      jjtree.openNodeScope(jjtn013);
      jjtreeOpenNodeScope(jjtn013);
      try {
        label_11:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EQUAL:
            ;
            break;
          default:
            jj_la1[21] = jj_gen;
            break label_11;
          }
          jj_consume_token(EQUAL);
          SmartTestList();
        }
      } catch (Throwable jjte013) {
      if (jjtc013) {
        jjtree.clearNodeScope(jjtn013);
        jjtc013 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte013 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte013;}
      }
      if (jjte013 instanceof ParseException) {
        {if (true) throw (ParseException)jjte013;}
      }
      {if (true) throw (Error)jjte013;}
      } finally {
      if (jjtc013) {
        jjtree.closeNodeScope(jjtn013,  jjtree . nodeArity ( ) + 1);
        jjtreeCloseNodeScope(jjtn013);
      }
      }
    }
  }

//print_stmt: 'print' (test ',')* [test] | 'print' '>>' test (, test)+ [,]
  final public void print_stmt() throws ParseException {
    if (jj_2_10(2)) {
      jj_consume_token(PRINT);
      jj_consume_token(RSHIFT);
      SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTPRINTEXT_STMT);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      try {
        test();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          label_12:
          while (true) {
                             this.addSpecialToken(",");
            jj_consume_token(COMMA);
            test();
            if (jj_2_8(2)) {
              ;
            } else {
              break label_12;
            }
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            Comma();
            break;
          default:
            jj_la1[23] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[24] = jj_gen;
          ;
        }
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
        jjtreeCloseNodeScope(jjtn001);
      }
      }
    } else if (jj_2_11(2)) {
      jj_consume_token(PRINT);
          SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTPRINT_STMT);
          boolean jjtc002 = true;
          jjtree.openNodeScope(jjtn002);
          jjtreeOpenNodeScope(jjtn002);
      try {
        test();
        label_13:
        while (true) {
          if (jj_2_9(2)) {
            ;
          } else {
            break label_13;
          }
                               this.addSpecialToken(",");
          jj_consume_token(COMMA);
          test();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          Comma();
          break;
        default:
          jj_la1[25] = jj_gen;
          ;
        }
      } catch (Throwable jjte002) {
          if (jjtc002) {
            jjtree.clearNodeScope(jjtn002);
            jjtc002 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte002 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte002;}
          }
          if (jjte002 instanceof ParseException) {
            {if (true) throw (ParseException)jjte002;}
          }
          {if (true) throw (Error)jjte002;}
      } finally {
          if (jjtc002) {
            jjtree.closeNodeScope(jjtn002, true);
            jjtreeCloseNodeScope(jjtn002);
          }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRINT:
      SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTPRINT_STMT);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
      jjtreeOpenNodeScope(jjtn003);
        try {
          jj_consume_token(PRINT);
        } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, true);
        jjtreeCloseNodeScope(jjtn003);
      }
        }
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

//del_stmt: 'del' exprlist
  final public void del_stmt() throws ParseException {
                  /*@bgen(jjtree) del_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDEL_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      begin_del_stmt();
      exprlist();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_del_stmt() throws ParseException {
                        /*@bgen(jjtree) begin_del_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_DEL_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(DEL);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtreeCloseNodeScope(jjtn000);
         this.addToPeek("del ",false);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//pass_stmt: 'pass'
  final public void pass_stmt() throws ParseException {
                   /*@bgen(jjtree) pass_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTPASS_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(PASS);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//flow_stmt: break_stmt | continue_stmt | return_stmt | yield_stmt | raise_stmt
  final public void flow_stmt() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BREAK:
      jj_consume_token(BREAK);
              SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBREAK_STMT);
              boolean jjtc001 = true;
              jjtree.openNodeScope(jjtn001);
              jjtreeOpenNodeScope(jjtn001);
      try {
              jjtree.closeNodeScope(jjtn001,  0);
              jjtc001 = false;
              jjtreeCloseNodeScope(jjtn001);
             addToPeek("break",true);
      } finally {
              if (jjtc001) {
                jjtree.closeNodeScope(jjtn001,  0);
                jjtreeCloseNodeScope(jjtn001);
              }
      }
      break;
    case CONTINUE:
      jj_consume_token(CONTINUE);
                  SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCONTINUE_STMT);
                  boolean jjtc002 = true;
                  jjtree.openNodeScope(jjtn002);
                  jjtreeOpenNodeScope(jjtn002);
      try {
                  jjtree.closeNodeScope(jjtn002,  0);
                  jjtc002 = false;
                  jjtreeCloseNodeScope(jjtn002);
                 addToPeek("continue",true);
      } finally {
                  if (jjtc002) {
                    jjtree.closeNodeScope(jjtn002,  0);
                    jjtreeCloseNodeScope(jjtn002);
                  }
      }
      break;
    case RETURN:
      return_stmt();
      break;
    case YIELD:
      yield_stmt();
      break;
    case RAISE:
      raise_stmt();
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//return_stmt: 'return' [testlist]
  final public void return_stmt() throws ParseException {
                     /*@bgen(jjtree) return_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTRETURN_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      begin_return_stmt();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case PLUS:
      case MINUS:
      case NOT:
      case NOT_BOOL:
      case LAMBDA:
      case AS:
      case NAME:
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
      case 136:
        SmartTestList();
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_return_stmt() throws ParseException {
                           /*@bgen(jjtree) begin_return_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_RETURN_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(RETURN);
             jjtree.closeNodeScope(jjtn000, true);
             jjtc000 = false;
             jjtreeCloseNodeScope(jjtn000);
            this.addToPeek("return ",false);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//yield_stmt: 'yield' [testlist]
  final public void yield_stmt() throws ParseException {
                    /*@bgen(jjtree) yield_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTYIELD_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(YIELD);
      SmartTestList();
                            jjtree.closeNodeScope(jjtn000, true);
                            jjtc000 = false;
                            jjtreeCloseNodeScope(jjtn000);
                           this.addToPeek("yield ",false, Yield.class);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//raise_stmt: 'raise' [test [',' test [',' test]]]
  final public void raise_stmt() throws ParseException {
                    /*@bgen(jjtree) raise_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTRAISE_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(RAISE);
           this.addSpecialToken("raise ", STRATEGY_BEFORE_NEXT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case PLUS:
      case MINUS:
      case NOT:
      case NOT_BOOL:
      case LAMBDA:
      case AS:
      case NAME:
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
      case 136:
        test();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
                                                                            this.addSpecialToken(",");
          jj_consume_token(COMMA);
          test();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
                                                                                                                         this.addSpecialToken(",");
            jj_consume_token(COMMA);
            test();
            break;
          default:
            jj_la1[29] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[30] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//import_stmt: 'import' dotted_name (',' dotted_name)* | 'from' dotted_name 'import' ('*' | NAME (',' NAME)*)
  final public void import_stmt() throws ParseException {
                           Import imp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPORT:
      jj_consume_token(IMPORT);
      imp = Import();
                            imp.addSpecial("import ",false);
      break;
    case FROM:
      jj_consume_token(FROM);
           this.addSpecialToken("from ",STRATEGY_BEFORE_NEXT);
      ImportFrom();
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Import Import() throws ParseException {
                  /*@bgen(jjtree) Import */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTIMPORT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      dotted_as_name();
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_14;
        }
                     this.addSpecialToken(",");
        jj_consume_token(COMMA);
        dotted_as_name();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtreeCloseNodeScope(jjtn000);
   {if (true) return (Import)jjtree.peekNode();}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
    throw new Error("Missing return statement in function");
  }

//TODO: allways allowed (treat different versions in other places, to see if this is correct or not)
  final public void ImportFrom() throws ParseException {
                    /*@bgen(jjtree) ImportFrom */
                     SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTIMPORTFROM);
                     boolean jjtc000 = true;
                     jjtree.openNodeScope(jjtn000);
                     jjtreeOpenNodeScope(jjtn000);String mod; String name;int state=0;
    try {
      mod = dotted_name();
      jj_consume_token(IMPORT);
                                this.addSpecialToken(" import ");
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        jj_consume_token(MULTIPLY);
                         jjtree.closeNodeScope(jjtn000, true);
                         jjtc000 = false;
                         jjtreeCloseNodeScope(jjtn000);
                        this.addSpecialToken("*",STRATEGY_ADD_AFTER_PREV);
        break;
      case OR_BOOL:
      case AND_BOOL:
      case NOT_BOOL:
      case IS:
      case IN:
      case LAMBDA:
      case IF:
      case ELSE:
      case ELIF:
      case WHILE:
      case FOR:
      case TRY:
      case EXCEPT:
      case DEF:
      case CLASS:
      case FINALLY:
      case PRINT:
      case PASS:
      case BREAK:
      case CONTINUE:
      case RETURN:
      case YIELD:
      case IMPORT:
      case FROM:
      case DEL:
      case RAISE:
      case GLOBAL:
      case EXEC:
      case ASSERT:
      case AS:
      case NAME:
        name = import_as_name();
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[34] = jj_gen;
            break label_15;
          }
                                       this.addSpecialToken(",");
          jj_consume_token(COMMA);
          import_as_name();
        }
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
                         this.addSpecialToken("(",STRATEGY_BEFORE_NEXT);
        name = import_as_name();
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[35] = jj_gen;
            break label_16;
          }
                 if(state!=0){
                     {if (true) throw new ParseException("Invalid syntax: 2 commas cannot be grouped.", getToken(1));}
                 }
                 state=1;
                 this.addSpecialToken(",");
          jj_consume_token(COMMA);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case OR_BOOL:
          case AND_BOOL:
          case NOT_BOOL:
          case IS:
          case IN:
          case LAMBDA:
          case IF:
          case ELSE:
          case ELIF:
          case WHILE:
          case FOR:
          case TRY:
          case EXCEPT:
          case DEF:
          case CLASS:
          case FINALLY:
          case PRINT:
          case PASS:
          case BREAK:
          case CONTINUE:
          case RETURN:
          case YIELD:
          case IMPORT:
          case FROM:
          case DEL:
          case RAISE:
          case GLOBAL:
          case EXEC:
          case ASSERT:
          case AS:
          case NAME:
                            state=0;
            import_as_name();
            break;
          default:
            jj_la1[36] = jj_gen;
            ;
          }
        }
        jj_consume_token(RPAREN);
                           jjtree.closeNodeScope(jjtn000, true);
                           jjtc000 = false;
                           jjtreeCloseNodeScope(jjtn000);
                          this.findTokenAndAdd(")");
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

//dotted_as_name: dotted_name [NAME NAME]
  final public void dotted_as_name() throws ParseException {
                        /*@bgen(jjtree) dotted_as_name */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDOTTED_AS_NAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      dotted_name();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
                       this.addSpecialToken(" as ");
        Name();
        break;
      default:
        jj_la1[38] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//dotted_name: NAME ('.' NAME)*
  final public String dotted_name() throws ParseException {
                       /*@bgen(jjtree) dotted_name */
                        SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDOTTED_NAME);
                        boolean jjtc000 = true;
                        jjtree.openNodeScope(jjtn000);
                        jjtreeOpenNodeScope(jjtn000);Token t; StringBuffer sb = new StringBuffer();
    try {
      t = AnyName();
                sb.append(t.image);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_17;
        }
        jj_consume_token(DOT);
        t = AnyName();
                         sb.append("." + t.image);
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtreeCloseNodeScope(jjtn000);
          {if (true) return sb.toString();}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
    throw new Error("Missing return statement in function");
  }

//import_as_name: NAME [NAME NAME]
  final public String import_as_name() throws ParseException {
                          /*@bgen(jjtree) import_as_name */
                           SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTIMPORT_AS_NAME);
                           boolean jjtc000 = true;
                           jjtree.openNodeScope(jjtn000);
                           jjtreeOpenNodeScope(jjtn000);Token t;
    try {
      t = AnyName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
                     this.addSpecialToken(" as ");
        Name();
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
                                                              jjtree.closeNodeScope(jjtn000, true);
                                                              jjtc000 = false;
                                                              jjtreeCloseNodeScope(jjtn000);
                                                              {if (true) return t.image;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
    throw new Error("Missing return statement in function");
  }

//global_stmt: 'global' NAME (',' NAME)*
  final public void global_stmt() throws ParseException {
                     /*@bgen(jjtree) global_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTGLOBAL_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(GLOBAL);
            this.addSpecialToken("global ", STRATEGY_BEFORE_NEXT);
      Name();
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_18;
        }
                                                                             this.addSpecialToken(",");
        jj_consume_token(COMMA);
        Name();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//exec_stmt: 'exec' expr ['in' test [',' test]]
  final public void exec_stmt() throws ParseException {
                   /*@bgen(jjtree) exec_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEXEC_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(EXEC);
         this.addSpecialToken("exec ", STRATEGY_BEFORE_NEXT);
      expr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IN:
        jj_consume_token(IN);
                                                                            this.addSpecialToken(" in ");
        test();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
                                                                                                                    this.addSpecialToken(",");
          jj_consume_token(COMMA);
          test();
          break;
        default:
          jj_la1[42] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[43] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//assert_stmt: 'assert' test [',' test]
  final public void assert_stmt() throws ParseException {
                     /*@bgen(jjtree) assert_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTASSERT_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(ASSERT);
      test();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
                    this.addSpecialToken(",");
        jj_consume_token(COMMA);
        test();
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//compound_stmt: if_stmt | while_stmt | for_stmt | try_stmt | funcdef | classdef
  final public void compound_stmt() throws ParseException {
                               token_source.compound = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      if_stmt();
      break;
    case WHILE:
      while_stmt();
      break;
    case FOR:
      for_stmt();
      break;
    case TRY:
      try_stmt();
      break;
    case DEF:
    case AT:
      funcdef();
      break;
    case CLASS:
      classdef();
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//if_stmt: 'if' test ':' suite ('elif' test ':' suite)* ['else' ':' suite]
  final public void if_stmt() throws ParseException {
                 /*@bgen(jjtree) if_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTIF_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      begin_if_stmt();
      test();
      jj_consume_token(COLON);
                                    this.addSpecialToken(":");
      suite();
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ELIF:
          ;
          break;
        default:
          jj_la1[46] = jj_gen;
          break label_19;
        }
        begin_elif_stmt();
        test();
        jj_consume_token(COLON);
                                            this.addSpecialToken(":");
        suite();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        jj_consume_token(COLON);
                                   this.findTokenAndAdd("else","else:",true);
        suite();
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void begin_if_stmt() throws ParseException {
                       /*@bgen(jjtree) begin_if_stmt */
                       SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_IF_STMT);
                       boolean jjtc000 = true;
                       jjtree.openNodeScope(jjtn000);
                       jjtreeOpenNodeScope(jjtn000);Object spStr;
    try {
   spStr = createSpecialStr("if","if ", false);
      jj_consume_token(IF);
                                                        jjtree.closeNodeScope(jjtn000, true);
                                                        jjtc000 = false;
                                                        jjtreeCloseNodeScope(jjtn000);
                                                       this.addToPeek(spStr,false);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_elif_stmt() throws ParseException {
                         /*@bgen(jjtree) begin_elif_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_ELIF_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(ELIF);
           jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtreeCloseNodeScope(jjtn000);
          this.addToPeek("elif ",false);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//while_stmt: 'while' test ':' suite ['else' ':' suite]
  final public void while_stmt() throws ParseException {
                    /*@bgen(jjtree) while_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTWHILE_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      begin_while_stmt();
      test();
      jj_consume_token(COLON);
                                     this.addSpecialToken(":");
      suite();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        begin_else_stmt();
        suite();
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_while_stmt() throws ParseException {
                          /*@bgen(jjtree) begin_while_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_WHILE_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
   this.addSpecialToken("while ",STRATEGY_BEFORE_NEXT);
      jj_consume_token(WHILE);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_else_stmt() throws ParseException {
                         /*@bgen(jjtree) begin_else_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_ELSE_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(ELSE);
          this.addSpecialToken("else",STRATEGY_BEFORE_NEXT);
                                                               this.addSpecialToken(":",STRATEGY_BEFORE_NEXT);
      jj_consume_token(COLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//for_stmt: 'for' exprlist 'in' testlist ':' suite ['else' ':' suite]
  final public void for_stmt() throws ParseException {
                  /*@bgen(jjtree) for_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTFOR_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      begin_for_stmt();
      exprlist();
      jj_consume_token(IN);
                                      this.addSpecialToken(" in ");
      SmartTestList();
      jj_consume_token(COLON);
                                                                                              this.addSpecialToken(":");
      suite();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        begin_for_else_stmt();
        suite();
        break;
      default:
        jj_la1[49] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void begin_for_stmt() throws ParseException {
                        /*@bgen(jjtree) begin_for_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_FOR_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(FOR);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtreeCloseNodeScope(jjtn000);
         this.addToPeek("for ",false);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_for_else_stmt() throws ParseException {
                             /*@bgen(jjtree) begin_for_else_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_FOR_ELSE_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(ELSE);
          this.addSpecialToken("else",STRATEGY_BEFORE_NEXT);
                                                               this.addSpecialToken(":",STRATEGY_BEFORE_NEXT);
      jj_consume_token(COLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//try_stmt: ('try' ':' suite (except_clause ':' suite)+ #diagram:break
//           ['else' ':' suite] | 'try' ':' suite 'finally' ':' suite)
  final public void try_stmt() throws ParseException {
                        SimpleNode tryNode;
    begin_try_stmt();
                      tryNode = (SimpleNode)jjtree.peekNode();
    suite();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCEPT:
      SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTRY_STMT);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      try {
        label_20:
        while (true) {
          except_clause(tryNode);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EXCEPT:
            ;
            break;
          default:
            jj_la1[50] = jj_gen;
            break label_20;
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ELSE:
          begin_try_else_stmt();
          suite();
          break;
        default:
          jj_la1[51] = jj_gen;
          ;
        }
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  jjtree . nodeArity ( ) + 1);
        jjtreeCloseNodeScope(jjtn001);
      }
      }
      break;
    case FINALLY:
      begin_finally_stmt();
                             SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTRYFINALLY_STMT);
                             boolean jjtc002 = true;
                             jjtree.openNodeScope(jjtn002);
                             jjtreeOpenNodeScope(jjtn002);
      try {
        suite();
      } catch (Throwable jjte002) {
                             if (jjtc002) {
                               jjtree.clearNodeScope(jjtn002);
                               jjtc002 = false;
                             } else {
                               jjtree.popNode();
                             }
                             if (jjte002 instanceof RuntimeException) {
                               {if (true) throw (RuntimeException)jjte002;}
                             }
                             if (jjte002 instanceof ParseException) {
                               {if (true) throw (ParseException)jjte002;}
                             }
                             {if (true) throw (Error)jjte002;}
      } finally {
                             if (jjtc002) {
                               jjtree.closeNodeScope(jjtn002,  jjtree . nodeArity ( ) + 1);
                               jjtreeCloseNodeScope(jjtn002);
                             }
      }
      break;
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//this is the 'try' ':'  it is needed because we need that scope closing for getting the specials.
  final public void begin_try_stmt() throws ParseException {
                        /*@bgen(jjtree) begin_try_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_TRY_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(TRY);
         this.addSpecialToken("try", STRATEGY_BEFORE_NEXT);
                                                              this.addSpecialToken(":", STRATEGY_BEFORE_NEXT);
      jj_consume_token(COLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_try_else_stmt() throws ParseException {
                             /*@bgen(jjtree) begin_try_else_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_TRY_ELSE_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(ELSE);
          this.addSpecialToken("else", STRATEGY_BEFORE_NEXT);
                                                               this.addSpecialToken(":", STRATEGY_BEFORE_NEXT);
      jj_consume_token(COLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_finally_stmt() throws ParseException {
                            /*@bgen(jjtree) begin_finally_stmt */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_FINALLY_STMT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(FINALLY);
             this.addSpecialToken("finally", STRATEGY_BEFORE_NEXT);
                                                                      this.addSpecialToken(":", STRATEGY_BEFORE_NEXT);
      jj_consume_token(COLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//except_clause: 'except' [test [',' test]]
  final public void except_clause(SimpleNode tryNode) throws ParseException {
                                         /*@bgen(jjtree) except_clause */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEXCEPT_CLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      begin_except_clause();
                         this.addToPeek("except",false);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case PLUS:
      case MINUS:
      case NOT:
      case NOT_BOOL:
      case LAMBDA:
      case AS:
      case NAME:
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
      case 136:
        test();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
                                                                    this.addSpecialToken(",");
          jj_consume_token(COMMA);
          test();
          break;
        default:
          jj_la1[53] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
                                                                                                                           this.addSpecialToken(":");
      suite();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void begin_except_clause() throws ParseException {
                             /*@bgen(jjtree) begin_except_clause */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTBEGIN_EXCEPT_CLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(EXCEPT);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//suite: simple_stmt | NEWLINE INDENT stmt+ DEDENT
  final public void suite() throws ParseException {
               /*@bgen(jjtree) suite */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSUITE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case PLUS:
      case MINUS:
      case NOT:
      case NOT_BOOL:
      case LAMBDA:
      case PRINT:
      case PASS:
      case BREAK:
      case CONTINUE:
      case RETURN:
      case YIELD:
      case IMPORT:
      case FROM:
      case DEL:
      case RAISE:
      case GLOBAL:
      case EXEC:
      case ASSERT:
      case AS:
      case NAME:
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
      case 136:
        simple_stmt();
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
                     token_source.expect_indent = true;
        jj_consume_token(INDENT);
                                                                     token_source.expect_indent = false;
        label_21:
        while (true) {
          stmt();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case LBRACE:
          case LBRACKET:
          case PLUS:
          case MINUS:
          case NOT:
          case NOT_BOOL:
          case LAMBDA:
          case IF:
          case WHILE:
          case FOR:
          case TRY:
          case DEF:
          case CLASS:
          case PRINT:
          case PASS:
          case BREAK:
          case CONTINUE:
          case RETURN:
          case YIELD:
          case IMPORT:
          case FROM:
          case DEL:
          case RAISE:
          case GLOBAL:
          case EXEC:
          case ASSERT:
          case AS:
          case AT:
          case NAME:
          case DECNUMBER:
          case HEXNUMBER:
          case OCTNUMBER:
          case FLOAT:
          case COMPLEX:
          case SINGLE_STRING:
          case SINGLE_STRING2:
          case TRIPLE_STRING:
          case TRIPLE_STRING2:
          case SINGLE_USTRING:
          case SINGLE_USTRING2:
          case TRIPLE_USTRING:
          case TRIPLE_USTRING2:
          case 136:
            ;
            break;
          default:
            jj_la1[55] = jj_gen;
            break label_21;
          }
        }
        jj_consume_token(DEDENT);
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//test: and_test ('or' and_test)* | lambdef
  final public void test() throws ParseException {
                              /*@bgen(jjtree) #or_boolean(> 1) */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTOR_BOOLEAN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LAMBDA:
        lambdef();
        break;
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case PLUS:
      case MINUS:
      case NOT:
      case NOT_BOOL:
      case AS:
      case NAME:
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
      case 136:
        and_test();
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case OR_BOOL:
            ;
            break;
          default:
            jj_la1[57] = jj_gen;
            break label_22;
          }
          jj_consume_token(OR_BOOL);
          and_test();
        }
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//and_test: not_test ('and' not_test)*
  final public void and_test() throws ParseException {
                                   /*@bgen(jjtree) #and_boolean(> 1) */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAND_BOOLEAN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      not_test();
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND_BOOL:
          ;
          break;
        default:
          jj_la1[59] = jj_gen;
          break label_23;
        }
        jj_consume_token(AND_BOOL);
        not_test();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//not_test: 'not' not_test | comparison
  final public void not_test() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT_BOOL:
      jj_consume_token(NOT_BOOL);
               SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNOT_1OP);
               boolean jjtc001 = true;
               jjtree.openNodeScope(jjtn001);
               jjtreeOpenNodeScope(jjtn001);
      try {
        not_test();
      } catch (Throwable jjte001) {
               if (jjtc001) {
                 jjtree.clearNodeScope(jjtn001);
                 jjtc001 = false;
               } else {
                 jjtree.popNode();
               }
               if (jjte001 instanceof RuntimeException) {
                 {if (true) throw (RuntimeException)jjte001;}
               }
               if (jjte001 instanceof ParseException) {
                 {if (true) throw (ParseException)jjte001;}
               }
               {if (true) throw (Error)jjte001;}
      } finally {
               if (jjtc001) {
                 jjtree.closeNodeScope(jjtn001,  1);
                 jjtreeCloseNodeScope(jjtn001);
               }
      }
      break;
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case PLUS:
    case MINUS:
    case NOT:
    case AS:
    case NAME:
    case DECNUMBER:
    case HEXNUMBER:
    case OCTNUMBER:
    case FLOAT:
    case COMPLEX:
    case SINGLE_STRING:
    case SINGLE_STRING2:
    case TRIPLE_STRING:
    case TRIPLE_STRING2:
    case SINGLE_USTRING:
    case SINGLE_USTRING2:
    case TRIPLE_USTRING:
    case TRIPLE_USTRING2:
    case 136:
      comparison();
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//comparison: expr (comp_op expr)*
  final public void comparison() throws ParseException {
    SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCOMPARISION);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
    jjtreeOpenNodeScope(jjtn001);
    try {
      expr();
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GREATER:
        case LESS:
        case EQEQUAL:
        case EQLESS:
        case EQGREATER:
        case LESSGREATER:
        case NOTEQUAL:
        case NOT_BOOL:
        case IS:
        case IN:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_24;
        }
        comp_op();
        expr();
      }
    } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof ParseException) {
      {if (true) throw (ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
    } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
      jjtreeCloseNodeScope(jjtn001);
    }
    }
  }

//comp_op: '<'|'>'|'=='|'>='|'<='|'<>'|'!='|'in'|'not' 'in'|'is'|'is' 'not'
  final public void comp_op() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LESS:
      SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTLESS_CMP);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(LESS);
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  0);
        jjtreeCloseNodeScope(jjtn001);
      }
      }
      break;
    case GREATER:
      SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTGREATER_CMP);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
      jjtreeOpenNodeScope(jjtn002);
      try {
        jj_consume_token(GREATER);
      } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002,  0);
        jjtreeCloseNodeScope(jjtn002);
      }
      }
      break;
    case EQEQUAL:
      SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEQUAL_CMP);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
      jjtreeOpenNodeScope(jjtn003);
      try {
        jj_consume_token(EQEQUAL);
      } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003,  0);
        jjtreeCloseNodeScope(jjtn003);
      }
      }
      break;
    case EQGREATER:
      SimpleNode jjtn004 = (SimpleNode)SimpleNode.jjtCreate(this, JJTGREATER_EQUAL_CMP);
      boolean jjtc004 = true;
      jjtree.openNodeScope(jjtn004);
      jjtreeOpenNodeScope(jjtn004);
      try {
        jj_consume_token(EQGREATER);
      } finally {
      if (jjtc004) {
        jjtree.closeNodeScope(jjtn004,  0);
        jjtreeCloseNodeScope(jjtn004);
      }
      }
      break;
    case EQLESS:
      SimpleNode jjtn005 = (SimpleNode)SimpleNode.jjtCreate(this, JJTLESS_EQUAL_CMP);
      boolean jjtc005 = true;
      jjtree.openNodeScope(jjtn005);
      jjtreeOpenNodeScope(jjtn005);
      try {
        jj_consume_token(EQLESS);
      } finally {
      if (jjtc005) {
        jjtree.closeNodeScope(jjtn005,  0);
        jjtreeCloseNodeScope(jjtn005);
      }
      }
      break;
    case LESSGREATER:
      SimpleNode jjtn006 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNOTEQUAL_CMP);
      boolean jjtc006 = true;
      jjtree.openNodeScope(jjtn006);
      jjtreeOpenNodeScope(jjtn006);
      try {
        jj_consume_token(LESSGREATER);
      } finally {
      if (jjtc006) {
        jjtree.closeNodeScope(jjtn006,  0);
        jjtreeCloseNodeScope(jjtn006);
      }
      }
      break;
    case NOTEQUAL:
      SimpleNode jjtn007 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNOTEQUAL_CMP);
      boolean jjtc007 = true;
      jjtree.openNodeScope(jjtn007);
      jjtreeOpenNodeScope(jjtn007);
      try {
        jj_consume_token(NOTEQUAL);
      } finally {
      if (jjtc007) {
        jjtree.closeNodeScope(jjtn007,  0);
        jjtreeCloseNodeScope(jjtn007);
      }
      }
      break;
    case IN:
      SimpleNode jjtn008 = (SimpleNode)SimpleNode.jjtCreate(this, JJTIN_CMP);
      boolean jjtc008 = true;
      jjtree.openNodeScope(jjtn008);
      jjtreeOpenNodeScope(jjtn008);
      try {
        jj_consume_token(IN);
      } finally {
      if (jjtc008) {
        jjtree.closeNodeScope(jjtn008,  0);
        jjtreeCloseNodeScope(jjtn008);
      }
      }
      break;
    case NOT_BOOL:
      jj_consume_token(NOT_BOOL);
                 SimpleNode jjtn009 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNOT_IN_CMP);
                 boolean jjtc009 = true;
                 jjtree.openNodeScope(jjtn009);
                 jjtreeOpenNodeScope(jjtn009);
      try {
        jj_consume_token(IN);
      } finally {
                 if (jjtc009) {
                   jjtree.closeNodeScope(jjtn009,  0);
                   jjtreeCloseNodeScope(jjtn009);
                 }
      }
      break;
    default:
      jj_la1[62] = jj_gen;
      if (jj_2_12(2)) {
        jj_consume_token(IS);
                        SimpleNode jjtn010 = (SimpleNode)SimpleNode.jjtCreate(this, JJTIS_NOT_CMP);
                        boolean jjtc010 = true;
                        jjtree.openNodeScope(jjtn010);
                        jjtreeOpenNodeScope(jjtn010);
        try {
          jj_consume_token(NOT_BOOL);
        } finally {
                        if (jjtc010) {
                          jjtree.closeNodeScope(jjtn010,  0);
                          jjtreeCloseNodeScope(jjtn010);
                        }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IS:
      SimpleNode jjtn011 = (SimpleNode)SimpleNode.jjtCreate(this, JJTIS_CMP);
      boolean jjtc011 = true;
      jjtree.openNodeScope(jjtn011);
      jjtreeOpenNodeScope(jjtn011);
          try {
            jj_consume_token(IS);
          } finally {
      if (jjtc011) {
        jjtree.closeNodeScope(jjtn011,  0);
        jjtreeCloseNodeScope(jjtn011);
      }
          }
          break;
        default:
          jj_la1[63] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

//expr: xor_expr ('|' xor_expr)*
  final public void expr() throws ParseException {
    xor_expr();
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_25;
      }
      jj_consume_token(OR);
                     SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTOR_2OP);
                     boolean jjtc001 = true;
                     jjtree.openNodeScope(jjtn001);
                     jjtreeOpenNodeScope(jjtn001);
      try {
        xor_expr();
      } catch (Throwable jjte001) {
                     if (jjtc001) {
                       jjtree.clearNodeScope(jjtn001);
                       jjtc001 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte001 instanceof RuntimeException) {
                       {if (true) throw (RuntimeException)jjte001;}
                     }
                     if (jjte001 instanceof ParseException) {
                       {if (true) throw (ParseException)jjte001;}
                     }
                     {if (true) throw (Error)jjte001;}
      } finally {
                     if (jjtc001) {
                       jjtree.closeNodeScope(jjtn001,  2);
                       jjtreeCloseNodeScope(jjtn001);
                     }
      }
    }
  }

//xor_expr: and_expr ('^' and_expr)*
  final public void xor_expr() throws ParseException {
    and_expr();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XOR:
        ;
        break;
      default:
        jj_la1[65] = jj_gen;
        break label_26;
      }
      jj_consume_token(XOR);
                      SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTXOR_2OP);
                      boolean jjtc001 = true;
                      jjtree.openNodeScope(jjtn001);
                      jjtreeOpenNodeScope(jjtn001);
      try {
        and_expr();
      } catch (Throwable jjte001) {
                      if (jjtc001) {
                        jjtree.clearNodeScope(jjtn001);
                        jjtc001 = false;
                      } else {
                        jjtree.popNode();
                      }
                      if (jjte001 instanceof RuntimeException) {
                        {if (true) throw (RuntimeException)jjte001;}
                      }
                      if (jjte001 instanceof ParseException) {
                        {if (true) throw (ParseException)jjte001;}
                      }
                      {if (true) throw (Error)jjte001;}
      } finally {
                      if (jjtc001) {
                        jjtree.closeNodeScope(jjtn001,  2);
                        jjtreeCloseNodeScope(jjtn001);
                      }
      }
    }
  }

//and_expr: shift_expr ('&' shift_expr)*
  final public void and_expr() throws ParseException {
    shift_expr();
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_27;
      }
      jj_consume_token(AND);
                        SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTAND_2OP);
                        boolean jjtc001 = true;
                        jjtree.openNodeScope(jjtn001);
                        jjtreeOpenNodeScope(jjtn001);
      try {
        shift_expr();
      } catch (Throwable jjte001) {
                        if (jjtc001) {
                          jjtree.clearNodeScope(jjtn001);
                          jjtc001 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte001 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte001;}
                        }
                        if (jjte001 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte001;}
                        }
                        {if (true) throw (Error)jjte001;}
      } finally {
                        if (jjtc001) {
                          jjtree.closeNodeScope(jjtn001,  2);
                          jjtreeCloseNodeScope(jjtn001);
                        }
      }
    }
  }

//shift_expr: arith_expr (('<<'|'>>') arith_expr)*
  final public void shift_expr() throws ParseException {
    arith_expr();
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSHIFT:
      case RSHIFT:
        ;
        break;
      default:
        jj_la1[67] = jj_gen;
        break label_28;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSHIFT:
        jj_consume_token(LSHIFT);
                             SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTLSHIFT_2OP);
                             boolean jjtc001 = true;
                             jjtree.openNodeScope(jjtn001);
                             jjtreeOpenNodeScope(jjtn001);
        try {
          arith_expr();
        } catch (Throwable jjte001) {
                             if (jjtc001) {
                               jjtree.clearNodeScope(jjtn001);
                               jjtc001 = false;
                             } else {
                               jjtree.popNode();
                             }
                             if (jjte001 instanceof RuntimeException) {
                               {if (true) throw (RuntimeException)jjte001;}
                             }
                             if (jjte001 instanceof ParseException) {
                               {if (true) throw (ParseException)jjte001;}
                             }
                             {if (true) throw (Error)jjte001;}
        } finally {
                             if (jjtc001) {
                               jjtree.closeNodeScope(jjtn001,  2);
                               jjtreeCloseNodeScope(jjtn001);
                             }
        }
        break;
      case RSHIFT:
        jj_consume_token(RSHIFT);
               SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTRSHIFT_2OP);
               boolean jjtc002 = true;
               jjtree.openNodeScope(jjtn002);
               jjtreeOpenNodeScope(jjtn002);
        try {
          arith_expr();
        } catch (Throwable jjte002) {
               if (jjtc002) {
                 jjtree.clearNodeScope(jjtn002);
                 jjtc002 = false;
               } else {
                 jjtree.popNode();
               }
               if (jjte002 instanceof RuntimeException) {
                 {if (true) throw (RuntimeException)jjte002;}
               }
               if (jjte002 instanceof ParseException) {
                 {if (true) throw (ParseException)jjte002;}
               }
               {if (true) throw (Error)jjte002;}
        } finally {
               if (jjtc002) {
                 jjtree.closeNodeScope(jjtn002,  2);
                 jjtreeCloseNodeScope(jjtn002);
               }
        }
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

//arith_expr: term (('+'|'-') term)*
  final public void arith_expr() throws ParseException {
    term();
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_29;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
                     SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTADD_2OP);
                     boolean jjtc001 = true;
                     jjtree.openNodeScope(jjtn001);
                     jjtreeOpenNodeScope(jjtn001);
        try {
          term();
        } catch (Throwable jjte001) {
                     if (jjtc001) {
                       jjtree.clearNodeScope(jjtn001);
                       jjtc001 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte001 instanceof RuntimeException) {
                       {if (true) throw (RuntimeException)jjte001;}
                     }
                     if (jjte001 instanceof ParseException) {
                       {if (true) throw (ParseException)jjte001;}
                     }
                     {if (true) throw (Error)jjte001;}
        } finally {
                     if (jjtc001) {
                       jjtree.closeNodeScope(jjtn001,  2);
                       jjtreeCloseNodeScope(jjtn001);
                     }
        }
        break;
      case MINUS:
        jj_consume_token(MINUS);
              SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSUB_2OP);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
              jjtreeOpenNodeScope(jjtn002);
        try {
          term();
        } catch (Throwable jjte002) {
              if (jjtc002) {
                jjtree.clearNodeScope(jjtn002);
                jjtc002 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte002 instanceof RuntimeException) {
                {if (true) throw (RuntimeException)jjte002;}
              }
              if (jjte002 instanceof ParseException) {
                {if (true) throw (ParseException)jjte002;}
              }
              {if (true) throw (Error)jjte002;}
        } finally {
              if (jjtc002) {
                jjtree.closeNodeScope(jjtn002,  2);
                jjtreeCloseNodeScope(jjtn002);
              }
        }
        break;
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

//term: factor (('*'|'/'|'%') factor)*
  final public void term() throws ParseException {
    factor();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case FLOORDIVIDE:
      case MODULO:
        ;
        break;
      default:
        jj_la1[71] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        jj_consume_token(MULTIPLY);
                             SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTMUL_2OP);
                             boolean jjtc001 = true;
                             jjtree.openNodeScope(jjtn001);
                             jjtreeOpenNodeScope(jjtn001);
        try {
          factor();
        } catch (Throwable jjte001) {
                             if (jjtc001) {
                               jjtree.clearNodeScope(jjtn001);
                               jjtc001 = false;
                             } else {
                               jjtree.popNode();
                             }
                             if (jjte001 instanceof RuntimeException) {
                               {if (true) throw (RuntimeException)jjte001;}
                             }
                             if (jjte001 instanceof ParseException) {
                               {if (true) throw (ParseException)jjte001;}
                             }
                             {if (true) throw (Error)jjte001;}
        } finally {
                             if (jjtc001) {
                               jjtree.closeNodeScope(jjtn001,  2);
                               jjtreeCloseNodeScope(jjtn001);
                             }
        }
        break;
      case DIVIDE:
        jj_consume_token(DIVIDE);
               SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDIV_2OP);
               boolean jjtc002 = true;
               jjtree.openNodeScope(jjtn002);
               jjtreeOpenNodeScope(jjtn002);
        try {
          factor();
        } catch (Throwable jjte002) {
               if (jjtc002) {
                 jjtree.clearNodeScope(jjtn002);
                 jjtc002 = false;
               } else {
                 jjtree.popNode();
               }
               if (jjte002 instanceof RuntimeException) {
                 {if (true) throw (RuntimeException)jjte002;}
               }
               if (jjte002 instanceof ParseException) {
                 {if (true) throw (ParseException)jjte002;}
               }
               {if (true) throw (Error)jjte002;}
        } finally {
               if (jjtc002) {
                 jjtree.closeNodeScope(jjtn002,  2);
                 jjtreeCloseNodeScope(jjtn002);
               }
        }
        break;
      case FLOORDIVIDE:
        jj_consume_token(FLOORDIVIDE);
                    SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTFLOORDIV_2OP);
                    boolean jjtc003 = true;
                    jjtree.openNodeScope(jjtn003);
                    jjtreeOpenNodeScope(jjtn003);
        try {
          factor();
        } catch (Throwable jjte003) {
                    if (jjtc003) {
                      jjtree.clearNodeScope(jjtn003);
                      jjtc003 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte003 instanceof RuntimeException) {
                      {if (true) throw (RuntimeException)jjte003;}
                    }
                    if (jjte003 instanceof ParseException) {
                      {if (true) throw (ParseException)jjte003;}
                    }
                    {if (true) throw (Error)jjte003;}
        } finally {
                    if (jjtc003) {
                      jjtree.closeNodeScope(jjtn003,  2);
                      jjtreeCloseNodeScope(jjtn003);
                    }
        }
        break;
      case MODULO:
        jj_consume_token(MODULO);
               SimpleNode jjtn004 = (SimpleNode)SimpleNode.jjtCreate(this, JJTMOD_2OP);
               boolean jjtc004 = true;
               jjtree.openNodeScope(jjtn004);
               jjtreeOpenNodeScope(jjtn004);
        try {
          factor();
        } catch (Throwable jjte004) {
               if (jjtc004) {
                 jjtree.clearNodeScope(jjtn004);
                 jjtc004 = false;
               } else {
                 jjtree.popNode();
               }
               if (jjte004 instanceof RuntimeException) {
                 {if (true) throw (RuntimeException)jjte004;}
               }
               if (jjte004 instanceof ParseException) {
                 {if (true) throw (ParseException)jjte004;}
               }
               {if (true) throw (Error)jjte004;}
        } finally {
               if (jjtc004) {
                 jjtree.closeNodeScope(jjtn004,  2);
                 jjtreeCloseNodeScope(jjtn004);
               }
        }
        break;
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

//factor: ('+'|'-'|'~') factor | power
  final public void factor() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
             SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTPOS_1OP);
             boolean jjtc001 = true;
             jjtree.openNodeScope(jjtn001);
             jjtreeOpenNodeScope(jjtn001);
      try {
        factor();
      } catch (Throwable jjte001) {
             if (jjtc001) {
               jjtree.clearNodeScope(jjtn001);
               jjtc001 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte001 instanceof RuntimeException) {
               {if (true) throw (RuntimeException)jjte001;}
             }
             if (jjte001 instanceof ParseException) {
               {if (true) throw (ParseException)jjte001;}
             }
             {if (true) throw (Error)jjte001;}
      } finally {
             if (jjtc001) {
               jjtree.closeNodeScope(jjtn001,  1);
               jjtreeCloseNodeScope(jjtn001);
             }
      }
      break;
    case MINUS:
      jj_consume_token(MINUS);
              SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNEG_1OP);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
              jjtreeOpenNodeScope(jjtn002);
      try {
        factor();
      } catch (Throwable jjte002) {
              if (jjtc002) {
                jjtree.clearNodeScope(jjtn002);
                jjtc002 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte002 instanceof RuntimeException) {
                {if (true) throw (RuntimeException)jjte002;}
              }
              if (jjte002 instanceof ParseException) {
                {if (true) throw (ParseException)jjte002;}
              }
              {if (true) throw (Error)jjte002;}
      } finally {
              if (jjtc002) {
                jjtree.closeNodeScope(jjtn002,  1);
                jjtreeCloseNodeScope(jjtn002);
              }
      }
      break;
    case NOT:
      jj_consume_token(NOT);
            SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTINVERT_1OP);
            boolean jjtc003 = true;
            jjtree.openNodeScope(jjtn003);
            jjtreeOpenNodeScope(jjtn003);
      try {
        factor();
      } catch (Throwable jjte003) {
            if (jjtc003) {
              jjtree.clearNodeScope(jjtn003);
              jjtc003 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte003 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte003;}
            }
            if (jjte003 instanceof ParseException) {
              {if (true) throw (ParseException)jjte003;}
            }
            {if (true) throw (Error)jjte003;}
      } finally {
            if (jjtc003) {
              jjtree.closeNodeScope(jjtn003,  1);
              jjtreeCloseNodeScope(jjtn003);
            }
      }
      break;
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case AS:
    case NAME:
    case DECNUMBER:
    case HEXNUMBER:
    case OCTNUMBER:
    case FLOAT:
    case COMPLEX:
    case SINGLE_STRING:
    case SINGLE_STRING2:
    case TRIPLE_STRING:
    case TRIPLE_STRING2:
    case SINGLE_USTRING:
    case SINGLE_USTRING2:
    case TRIPLE_USTRING:
    case TRIPLE_USTRING2:
    case 136:
      power();
      break;
    default:
      jj_la1[73] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  /*Modified, no recursion*/

//power: atom trailer* ('**' factor)*
  final public void power() throws ParseException {
    atomtrailer();
    label_31:
    while (true) {
      if (jj_2_13(2)) {
        ;
      } else {
        break label_31;
      }
      jj_consume_token(POWER);
                                        SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTPOW_2OP);
                                        boolean jjtc001 = true;
                                        jjtree.openNodeScope(jjtn001);
                                        jjtreeOpenNodeScope(jjtn001);
      try {
        factor();
      } catch (Throwable jjte001) {
                                        if (jjtc001) {
                                          jjtree.clearNodeScope(jjtn001);
                                          jjtc001 = false;
                                        } else {
                                          jjtree.popNode();
                                        }
                                        if (jjte001 instanceof RuntimeException) {
                                          {if (true) throw (RuntimeException)jjte001;}
                                        }
                                        if (jjte001 instanceof ParseException) {
                                          {if (true) throw (ParseException)jjte001;}
                                        }
                                        {if (true) throw (Error)jjte001;}
      } finally {
                                        if (jjtc001) {
                                          jjtree.closeNodeScope(jjtn001,  2);
                                          jjtreeCloseNodeScope(jjtn001);
                                        }
      }
    }
  }

//trailer: '(' [arglist] ')' | '[' subscriptlist ']' | '.' NAME
  final public void atomtrailer() throws ParseException {
                           Object spStr;Object spStr2;
    atom();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case LBRACKET:
      case DOT:
        ;
        break;
      default:
        jj_la1[74] = jj_gen;
        break label_32;
      }
      if (jj_2_14(2)) {
                   SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCALL_OP);
                   boolean jjtc001 = true;
                   jjtree.openNodeScope(jjtn001);
                   jjtreeOpenNodeScope(jjtn001);
        try {
         spStr  = createSpecialStr("(", false);
          jj_consume_token(LPAREN);
         spStr2 = createSpecialStr(")", false);
          jj_consume_token(RPAREN);
        } finally {
                   if (jjtc001) {
                     jjtree.closeNodeScope(jjtn001,  1);
                     jjtreeCloseNodeScope(jjtn001);
                   }
        }
           addToPeekCallFunc(spStr, true); addToPeek(spStr2, true);
      } else if (jj_2_15(2)) {
                   SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCALL_OP);
                   boolean jjtc002 = true;
                   jjtree.openNodeScope(jjtn002);
                   jjtreeOpenNodeScope(jjtn002);
        try {
         spStr  = createSpecialStr("(", false);
          jj_consume_token(LPAREN);
          insidetuporcall();
         spStr2 = createSpecialStr(")", false);
          jj_consume_token(RPAREN);
        } catch (Throwable jjte002) {
                   if (jjtc002) {
                     jjtree.clearNodeScope(jjtn002);
                     jjtc002 = false;
                   } else {
                     jjtree.popNode();
                   }
                   if (jjte002 instanceof RuntimeException) {
                     {if (true) throw (RuntimeException)jjte002;}
                   }
                   if (jjte002 instanceof ParseException) {
                     {if (true) throw (ParseException)jjte002;}
                   }
                   {if (true) throw (Error)jjte002;}
        } finally {
                   if (jjtc002) {
                     jjtree.closeNodeScope(jjtn002,  jjtree . nodeArity ( ) + 1);
                     jjtreeCloseNodeScope(jjtn002);
                   }
        }
           addToPeekCallFunc(spStr, true); addToPeek(spStr2, true);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
     spStr = createSpecialStr("[", false);
          jj_consume_token(LBRACKET);
          subscriptlist();
         spStr2 = createSpecialStr("]", false);
                                                   SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTINDEX_OP);
                                                   boolean jjtc003 = true;
                                                   jjtree.openNodeScope(jjtn003);
                                                   jjtreeOpenNodeScope(jjtn003);
          try {
            jj_consume_token(RBRACKET);
          } finally {
                                                   if (jjtc003) {
                                                     jjtree.closeNodeScope(jjtn003,  2);
                                                     jjtreeCloseNodeScope(jjtn003);
                                                   }
          }
                                                             addToPeek(spStr, false); addToPeek(spStr2, true);
          break;
        case DOT:
          jj_consume_token(DOT);
            SimpleNode jjtn004 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDOT_OP);
            boolean jjtc004 = true;
            jjtree.openNodeScope(jjtn004);
            jjtreeOpenNodeScope(jjtn004);
          try {
            AnyName();
          } catch (Throwable jjte004) {
            if (jjtc004) {
              jjtree.clearNodeScope(jjtn004);
              jjtc004 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte004 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte004;}
            }
            if (jjte004 instanceof ParseException) {
              {if (true) throw (ParseException)jjte004;}
            }
            {if (true) throw (Error)jjte004;}
          } finally {
            if (jjtc004) {
              jjtree.closeNodeScope(jjtn004,  2);
              jjtreeCloseNodeScope(jjtn004);
            }
          }
          break;
        default:
          jj_la1[75] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

//atom: '(' [testlist] ')' | '[' [testlist] ']' | '{' [dictmaker] '}' | '`' testlist '`' | NAME | NUMBER | STRING+
  final public void atom() throws ParseException {
                    Object spStr;Object spStr2;
    if (jj_2_16(2)) {
                   SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTUPLE);
                   boolean jjtc001 = true;
                   jjtree.openNodeScope(jjtn001);
                   jjtreeOpenNodeScope(jjtn001);
      try {
           spStr  = createSpecialStr("(", false);
        jj_consume_token(LPAREN);
           spStr2 = createSpecialStr(")", false);
        jj_consume_token(RPAREN);
      } finally {
                   if (jjtc001) {
                     jjtree.closeNodeScope(jjtn001, true);
                     jjtreeCloseNodeScope(jjtn001);
                   }
      }
           addToPeek(spStr, false); addToPeek(spStr2, true);
    } else if (jj_2_17(2)) {
                   SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTUPLE);
                   boolean jjtc002 = true;
                   jjtree.openNodeScope(jjtn002);
                   jjtreeOpenNodeScope(jjtn002);
      try {
           spStr  = createSpecialStr("(", false);
        jj_consume_token(LPAREN);
        insidetuporcall();
           spStr2 = createSpecialStr(")", false);
        jj_consume_token(RPAREN);
      } catch (Throwable jjte002) {
                   if (jjtc002) {
                     jjtree.clearNodeScope(jjtn002);
                     jjtc002 = false;
                   } else {
                     jjtree.popNode();
                   }
                   if (jjte002 instanceof RuntimeException) {
                     {if (true) throw (RuntimeException)jjte002;}
                   }
                   if (jjte002 instanceof ParseException) {
                     {if (true) throw (ParseException)jjte002;}
                   }
                   {if (true) throw (Error)jjte002;}
      } finally {
                   if (jjtc002) {
                     jjtree.closeNodeScope(jjtn002, true);
                     jjtreeCloseNodeScope(jjtn002);
                   }
      }
           addToPeek(spStr, false); addToPeek(spStr2, true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                 this.addSpecialToken("(",STRATEGY_BEFORE_NEXT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
        case LBRACE:
        case LBRACKET:
        case PLUS:
        case MINUS:
        case NOT:
        case NOT_BOOL:
        case LAMBDA:
        case AS:
        case NAME:
        case DECNUMBER:
        case HEXNUMBER:
        case OCTNUMBER:
        case FLOAT:
        case COMPLEX:
        case SINGLE_STRING:
        case SINGLE_STRING2:
        case TRIPLE_STRING:
        case TRIPLE_STRING2:
        case SINGLE_USTRING:
        case SINGLE_USTRING2:
        case TRIPLE_USTRING:
        case TRIPLE_USTRING2:
        case 136:
          SmartTestList();
          break;
        default:
          jj_la1[76] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
                                                                                                 this.findTokenAndAdd(")");
        break;
      case LBRACKET:
      SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTLIST);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
      jjtreeOpenNodeScope(jjtn003);
        try {
       spStr = createSpecialStr("[", false);
          jj_consume_token(LBRACKET);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case LBRACE:
          case LBRACKET:
          case PLUS:
          case MINUS:
          case NOT:
          case NOT_BOOL:
          case LAMBDA:
          case AS:
          case NAME:
          case DECNUMBER:
          case HEXNUMBER:
          case OCTNUMBER:
          case FLOAT:
          case COMPLEX:
          case SINGLE_STRING:
          case SINGLE_STRING2:
          case TRIPLE_STRING:
          case TRIPLE_STRING2:
          case SINGLE_USTRING:
          case SINGLE_USTRING2:
          case TRIPLE_USTRING:
          case TRIPLE_USTRING2:
          case 136:
            listmaker();
            break;
          default:
            jj_la1[77] = jj_gen;
            ;
          }
           spStr2 = createSpecialStr("]", false);
          jj_consume_token(RBRACKET);
        } catch (Throwable jjte003) {
      if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte003;}
      }
      if (jjte003 instanceof ParseException) {
        {if (true) throw (ParseException)jjte003;}
      }
      {if (true) throw (Error)jjte003;}
        } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, true);
        jjtreeCloseNodeScope(jjtn003);
      }
        }
           addToPeek(spStr, false); addToPeek(spStr2, true);
        break;
      case LBRACE:
      SimpleNode jjtn004 = (SimpleNode)SimpleNode.jjtCreate(this, JJTDICTIONARY);
      boolean jjtc004 = true;
      jjtree.openNodeScope(jjtn004);
      jjtreeOpenNodeScope(jjtn004);
        try {
       spStr  = createSpecialStr("{", false);
          jj_consume_token(LBRACE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case LBRACE:
          case LBRACKET:
          case PLUS:
          case MINUS:
          case NOT:
          case NOT_BOOL:
          case LAMBDA:
          case AS:
          case NAME:
          case DECNUMBER:
          case HEXNUMBER:
          case OCTNUMBER:
          case FLOAT:
          case COMPLEX:
          case SINGLE_STRING:
          case SINGLE_STRING2:
          case TRIPLE_STRING:
          case TRIPLE_STRING2:
          case SINGLE_USTRING:
          case SINGLE_USTRING2:
          case TRIPLE_USTRING:
          case TRIPLE_USTRING2:
          case 136:
            dictmaker();
            break;
          default:
            jj_la1[78] = jj_gen;
            ;
          }
           spStr2  = createSpecialStr("}", false);
          jj_consume_token(RBRACE);
        } catch (Throwable jjte004) {
      if (jjtc004) {
        jjtree.clearNodeScope(jjtn004);
        jjtc004 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte004 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte004;}
      }
      if (jjte004 instanceof ParseException) {
        {if (true) throw (ParseException)jjte004;}
      }
      {if (true) throw (Error)jjte004;}
        } finally {
      if (jjtc004) {
        jjtree.closeNodeScope(jjtn004, true);
        jjtreeCloseNodeScope(jjtn004);
      }
        }
           addToPeek(spStr, false); addToPeek(spStr2, true);
        break;
      case 136:
        jj_consume_token(136);
        SmartTestList();
                          SimpleNode jjtn005 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSTR_1OP);
                          boolean jjtc005 = true;
                          jjtree.openNodeScope(jjtn005);
                          jjtreeOpenNodeScope(jjtn005);
        try {
          jj_consume_token(136);
        } finally {
                          if (jjtc005) {
                            jjtree.closeNodeScope(jjtn005,  1);
                            jjtreeCloseNodeScope(jjtn005);
                          }
        }
        break;
      case AS:
      case NAME:
        Name();
        break;
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
        Number();
        break;
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
        String();
        label_33:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SINGLE_STRING:
          case SINGLE_STRING2:
          case TRIPLE_STRING:
          case TRIPLE_STRING2:
          case SINGLE_USTRING:
          case SINGLE_USTRING2:
          case TRIPLE_USTRING:
          case TRIPLE_USTRING2:
            ;
            break;
          default:
            jj_la1[79] = jj_gen;
            break label_33;
          }
                SimpleNode jjtn006 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSTRJOIN);
                boolean jjtc006 = true;
                jjtree.openNodeScope(jjtn006);
                jjtreeOpenNodeScope(jjtn006);
          try {
            String();
          } catch (Throwable jjte006) {
                if (jjtc006) {
                  jjtree.clearNodeScope(jjtn006);
                  jjtc006 = false;
                } else {
                  jjtree.popNode();
                }
                if (jjte006 instanceof RuntimeException) {
                  {if (true) throw (RuntimeException)jjte006;}
                }
                if (jjte006 instanceof ParseException) {
                  {if (true) throw (ParseException)jjte006;}
                }
                {if (true) throw (Error)jjte006;}
          } finally {
                if (jjtc006) {
                  jjtree.closeNodeScope(jjtn006,  2);
                  jjtreeCloseNodeScope(jjtn006);
                }
          }
        }
        break;
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

//we can be inside a tuple or a call, and we may have list comprehension in it. (fabioz)
  final public void insidetuporcall() throws ParseException {
    arglist();
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        ;
        break;
      default:
        jj_la1[81] = jj_gen;
        break label_34;
      }
      list_for();
    }
  }

//lambdef: 'lambda' [varargslist] ':' test
//we add the colon to the args if there is some argument... otherwise, we add it to the first token that appears on the test
  final public void lambdef() throws ParseException {
                /*@bgen(jjtree) lambdef */
                SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTLAMBDEF);
                boolean jjtc000 = true;
                jjtree.openNodeScope(jjtn000);
                jjtreeOpenNodeScope(jjtn000);boolean hasArgs=false;
    try {
      jj_consume_token(LAMBDA);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case MULTIPLY:
      case POWER:
      case AS:
      case NAME:
        varargslist();
                          hasArgs=true;
        break;
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
                                                   if(hasArgs)this.addSpecialToken(":");else this.addSpecialToken(":",STRATEGY_BEFORE_NEXT);
      test();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//subscriptlist: subscript (',' subscript)* [',']
  final public void subscriptlist() throws ParseException {
    SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSUBSCRIPTLIST);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
    jjtreeOpenNodeScope(jjtn001);
    try {
      subscript();
      label_35:
      while (true) {
        if (jj_2_18(2)) {
          ;
        } else {
          break label_35;
        }
                              this.addSpecialToken(",");
        jj_consume_token(COMMA);
        subscript();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        Comma();
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof ParseException) {
      {if (true) throw (ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
    } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
      jjtreeCloseNodeScope(jjtn001);
    }
    }
  }

//subscript: '.' '.' '.' | test | [test] ':' [test] [sliceop]
  final public void subscript() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      jj_consume_token(DOT);
                  SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTELLIPSES);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(DOT);
      } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001, true);
                    jjtreeCloseNodeScope(jjtn001);
                  }
      }
      break;
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case PLUS:
    case MINUS:
    case NOT:
    case NOT_BOOL:
    case LAMBDA:
    case AS:
    case NAME:
    case DECNUMBER:
    case HEXNUMBER:
    case OCTNUMBER:
    case FLOAT:
    case COMPLEX:
    case SINGLE_STRING:
    case SINGLE_STRING2:
    case TRIPLE_STRING:
    case TRIPLE_STRING2:
    case SINGLE_USTRING:
    case SINGLE_USTRING2:
    case TRIPLE_USTRING:
    case TRIPLE_USTRING2:
    case 136:
      SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSLICE);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
      jjtreeOpenNodeScope(jjtn002);
      try {
        test();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          slice();
          break;
        default:
          jj_la1[84] = jj_gen;
          ;
        }
      } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof ParseException) {
        {if (true) throw (ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
      } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, true);
        jjtreeCloseNodeScope(jjtn002);
      }
      }
      break;
    case COLON:
      SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSLICE);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
      jjtreeOpenNodeScope(jjtn003);
      try {
        slice();
      } catch (Throwable jjte003) {
      if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte003;}
      }
      if (jjte003 instanceof ParseException) {
        {if (true) throw (ParseException)jjte003;}
      }
      {if (true) throw (Error)jjte003;}
      } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, jjtree.nodeArity() > 0);
        jjtreeCloseNodeScope(jjtn003);
      }
      }
      break;
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//sliceop: ':' [test]
  final public void slice() throws ParseException {
    Colon();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case PLUS:
    case MINUS:
    case NOT:
    case NOT_BOOL:
    case LAMBDA:
    case AS:
    case NAME:
    case DECNUMBER:
    case HEXNUMBER:
    case OCTNUMBER:
    case FLOAT:
    case COMPLEX:
    case SINGLE_STRING:
    case SINGLE_STRING2:
    case TRIPLE_STRING:
    case TRIPLE_STRING2:
    case SINGLE_USTRING:
    case SINGLE_USTRING2:
    case TRIPLE_USTRING:
    case TRIPLE_USTRING2:
    case 136:
      test();
      break;
    default:
      jj_la1[86] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      Colon();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case PLUS:
      case MINUS:
      case NOT:
      case NOT_BOOL:
      case LAMBDA:
      case AS:
      case NAME:
      case DECNUMBER:
      case HEXNUMBER:
      case OCTNUMBER:
      case FLOAT:
      case COMPLEX:
      case SINGLE_STRING:
      case SINGLE_STRING2:
      case TRIPLE_STRING:
      case TRIPLE_STRING2:
      case SINGLE_USTRING:
      case SINGLE_USTRING2:
      case TRIPLE_USTRING:
      case TRIPLE_USTRING2:
      case 136:
        test();
        break;
      default:
        jj_la1[87] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[88] = jj_gen;
      ;
    }
  }

  final public void Colon() throws ParseException {
               /*@bgen(jjtree) Colon */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCOLON);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
                   this.addSpecialToken(createSpecialStr(":", false), STRATEGY_BEFORE_NEXT);
      jj_consume_token(COLON);
    } finally {
                    if (jjtc000) {
                      jjtree.closeNodeScope(jjtn000, true);
                      jjtreeCloseNodeScope(jjtn000);
                    }
    }
  }

  final public void Comma() throws ParseException {
               /*@bgen(jjtree) Comma */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCOMMA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
                   this.addSpecialToken(",");
      jj_consume_token(COMMA);
    } finally {
                    if (jjtc000) {
                      jjtree.closeNodeScope(jjtn000, true);
                      jjtreeCloseNodeScope(jjtn000);
                    }
    }
  }

//exprlist: expr (',' expr)* [',']
  final public void exprlist() throws ParseException {
    SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTUPLE);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
    jjtreeOpenNodeScope(jjtn001);
    try {
      expr();
      label_36:
      while (true) {
        if (jj_2_19(2)) {
          ;
        } else {
          break label_36;
        }
                         this.addSpecialToken(",");
        jj_consume_token(COMMA);
        expr();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        Comma();
        break;
      default:
        jj_la1[89] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof ParseException) {
      {if (true) throw (ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
    } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
      jjtreeCloseNodeScope(jjtn001);
    }
    }
  }

//testlist: test (',' test)* [',']
  final public void SmartTestList() throws ParseException {
    SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTUPLE);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
    jjtreeOpenNodeScope(jjtn001);
    try {
      test();
      label_37:
      while (true) {
        if (jj_2_20(2)) {
          ;
        } else {
          break label_37;
        }
                         this.addSpecialToken(",");
        jj_consume_token(COMMA);
        test();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        Comma();
        break;
      default:
        jj_la1[90] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof ParseException) {
      {if (true) throw (ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
    } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
      jjtreeCloseNodeScope(jjtn001);
    }
    }
  }

//testlist: test (',' test)* [',']
  final public void testlist() throws ParseException {
    test();
    label_38:
    while (true) {
      if (jj_2_21(2)) {
        ;
      } else {
        break label_38;
      }
                        this.addSpecialToken(",");
      jj_consume_token(COMMA);
      test();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
                                                                       this.addSpecialToken(",");
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
  }

//dictmaker: test ':' test (',' test ':' test)* [',']
  final public void dictmaker() throws ParseException {
    test();
    jj_consume_token(COLON);
                 this.addSpecialToken(":");
    test();
    label_39:
    while (true) {
      if (jj_2_22(2)) {
        ;
      } else {
        break label_39;
      }
                                                                   this.addSpecialToken(",");
      jj_consume_token(COMMA);
      test();
      jj_consume_token(COLON);
                                                                                                                       this.addSpecialToken(":");
      test();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
                                                                                                                                                              this.addSpecialToken(",");
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
  }

//listmaker: test ( list_for | (',' test)* [','] )
  final public void listmaker() throws ParseException {
    test();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      label_40:
      while (true) {
        list_for();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FOR:
          ;
          break;
        default:
          jj_la1[93] = jj_gen;
          break label_40;
        }
      }
      break;
    default:
      jj_la1[95] = jj_gen;
      label_41:
      while (true) {
        if (jj_2_23(2)) {
          ;
        } else {
          break label_41;
        }
                                          this.addSpecialToken(",");
        jj_consume_token(COMMA);
        test();
      }
                                                                                         SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTTUPLE);
                                                                                         boolean jjtc001 = true;
                                                                                         jjtree.openNodeScope(jjtn001);
                                                                                         jjtreeOpenNodeScope(jjtn001);
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          Comma();
          break;
        default:
          jj_la1[94] = jj_gen;
          ;
        }
      } catch (Throwable jjte001) {
                                                                                         if (jjtc001) {
                                                                                           jjtree.clearNodeScope(jjtn001);
                                                                                           jjtc001 = false;
                                                                                         } else {
                                                                                           jjtree.popNode();
                                                                                         }
                                                                                         if (jjte001 instanceof RuntimeException) {
                                                                                           {if (true) throw (RuntimeException)jjte001;}
                                                                                         }
                                                                                         if (jjte001 instanceof ParseException) {
                                                                                           {if (true) throw (ParseException)jjte001;}
                                                                                         }
                                                                                         {if (true) throw (Error)jjte001;}
      } finally {
                                                                                         if (jjtc001) {
                                                                                           jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
                                                                                           jjtreeCloseNodeScope(jjtn001);
                                                                                         }
      }
    }
  }

  final public void complistmaker() throws ParseException {
    test();
    list_for();
  }

//list_iter: [list_for | list_if]
//void list_iter() #void: {}
//{ [ (list_for() | list_if()) ] }

//list_for: 'for' exprlist 'in' testlist list_iter
  final public void list_for() throws ParseException {
                  /*@bgen(jjtree) list_for */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTLIST_FOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(FOR);
         this.addSpecialToken(" for ");
      exprlist();
      jj_consume_token(IN);
                                                          this.addSpecialToken(" in ");
      SmartTestList();
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IF:
          ;
          break;
        default:
          jj_la1[96] = jj_gen;
          break label_42;
        }
        jj_consume_token(IF);
                                                                                                                 this.addSpecialToken(" if ");
        test();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//classdef: 'class' NAME ['(' testlist ')'] ':' suite
  final public void classdef() throws ParseException {
                  /*@bgen(jjtree) classdef */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCLASSDEF);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(CLASS);
      Name();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                            this.addSpecialToken("(",STRATEGY_BEFORE_NEXT);
        testlist();
        jj_consume_token(RPAREN);
                                                                                                     this.findTokenAndAdd(")");
        break;
      default:
        jj_la1[97] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
                                                                                                                                            this.addSpecialToken(":");
      suite();
    } catch (Throwable jjte000) {
   if (jjtc000) {
     jjtree.clearNodeScope(jjtn000);
     jjtc000 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte000 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte000;}
   }
   if (jjte000 instanceof ParseException) {
     {if (true) throw (ParseException)jjte000;}
   }
   {if (true) throw (Error)jjte000;}
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000, true);
     jjtreeCloseNodeScope(jjtn000);
   }
    }
  }

//arglist: (argument ',')*
//              (argument [',']| '*' test [',' '**' test] | '**' test)
  final public void arglist() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case PLUS:
    case MINUS:
    case NOT:
    case OR_BOOL:
    case AND_BOOL:
    case NOT_BOOL:
    case IS:
    case IN:
    case LAMBDA:
    case IF:
    case ELSE:
    case ELIF:
    case WHILE:
    case FOR:
    case TRY:
    case EXCEPT:
    case DEF:
    case CLASS:
    case FINALLY:
    case PRINT:
    case PASS:
    case BREAK:
    case CONTINUE:
    case RETURN:
    case YIELD:
    case IMPORT:
    case FROM:
    case DEL:
    case RAISE:
    case GLOBAL:
    case EXEC:
    case ASSERT:
    case AS:
    case NAME:
    case DECNUMBER:
    case HEXNUMBER:
    case OCTNUMBER:
    case FLOAT:
    case COMPLEX:
    case SINGLE_STRING:
    case SINGLE_STRING2:
    case TRIPLE_STRING:
    case TRIPLE_STRING2:
    case SINGLE_USTRING:
    case SINGLE_USTRING2:
    case TRIPLE_USTRING:
    case TRIPLE_USTRING2:
    case 136:
      normalargs();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
                   this.addSpecialToken(",");
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULTIPLY:
        case POWER:
          if (jj_2_24(2)) {
            ExtraArgValueList();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
       this.addSpecialToken(",");
              jj_consume_token(COMMA);
              ExtraKeywordValueList();
              break;
            default:
              jj_la1[98] = jj_gen;
              ;
            }
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case MULTIPLY:
            case POWER:
              ExtraKeywordValueList();
              break;
            default:
              jj_la1[99] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
        default:
          jj_la1[100] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[101] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[105] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case POWER:
        if (jj_2_25(2)) {
          ExtraArgValueList();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
       this.addSpecialToken(",");
            jj_consume_token(COMMA);
            ExtraKeywordValueList();
            break;
          default:
            jj_la1[102] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case MULTIPLY:
          case POWER:
            ExtraKeywordValueList();
            break;
          default:
            jj_la1[103] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[104] = jj_gen;
        ;
      }
    }
  }

  final public void normalargs() throws ParseException {
    argument();
    label_43:
    while (true) {
      if (jj_2_26(2)) {
        ;
      } else {
        break label_43;
      }
                            this.addSpecialToken(",");
      jj_consume_token(COMMA);
      argument();
    }
  }

  final public void ExtraArgValueList() throws ParseException {
                           /*@bgen(jjtree) ExtraArgValueList */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEXTRAARGVALUELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
   this.addSpecialToken(createSpecialStr("*", false));
      jj_consume_token(MULTIPLY);
      test();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void ExtraKeywordValueList() throws ParseException {
                               /*@bgen(jjtree) ExtraKeywordValueList */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTEXTRAKEYWORDVALUELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case POWER:
    this.addSpecialToken(createSpecialStr("**", false));
        jj_consume_token(POWER);
        break;
      case MULTIPLY:
    this.addSpecialToken(createSpecialStr("**", false));
        jj_consume_token(MULTIPLY);
        jj_consume_token(MULTIPLY);
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      test();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

//argument: [test '='] test     # Really [keyword '='] test
  final public void argument() throws ParseException {
    SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTKEYWORD);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
    jjtreeOpenNodeScope(jjtn001);
    try {
      if (jj_2_27(2)) {
        AnyName();
        jj_consume_token(EQUAL);
                                   this.addSpecialToken("=");
      } else {
        ;
      }
      test();
    } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof ParseException) {
      {if (true) throw (ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
    } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
      jjtreeCloseNodeScope(jjtn001);
    }
    }
  }

  final public void Number() throws ParseException {
 /*@bgen(jjtree) Num */
    SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNUM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HEXNUMBER:
        t = jj_consume_token(HEXNUMBER);
            String s = t.image.substring(2, t.image.length());
            jjtn000.setImage(makeInt(s, 16));
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtreeCloseNodeScope(jjtn000);

        break;
      case OCTNUMBER:
        t = jj_consume_token(OCTNUMBER);
                        jjtn000.setImage(makeInt(t.image, 8));
                                                                   jjtree.closeNodeScope(jjtn000, true);
                                                                   jjtc000 = false;
                                                                   jjtreeCloseNodeScope(jjtn000);

        break;
      case DECNUMBER:
        t = jj_consume_token(DECNUMBER);
                        jjtn000.setImage(makeInt(t.image, 10));
                                                                    jjtree.closeNodeScope(jjtn000, true);
                                                                    jjtc000 = false;
                                                                    jjtreeCloseNodeScope(jjtn000);

        break;
      case FLOAT:
        t = jj_consume_token(FLOAT);
                    jjtn000.setImage(makeFloat(t.image));
                                                              jjtree.closeNodeScope(jjtn000, true);
                                                              jjtc000 = false;
                                                              jjtreeCloseNodeScope(jjtn000);

        break;
      case COMPLEX:
        t = jj_consume_token(COMPLEX);
                      jjtn000.setImage(makeComplex(t.image));
                                                                  jjtree.closeNodeScope(jjtn000, true);
                                                                  jjtc000 = false;
                                                                  jjtreeCloseNodeScope(jjtn000);

        break;
      default:
        jj_la1[107] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void Complex() throws ParseException {
                 /*@bgen(jjtree) Complex */
  SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTCOMPLEX);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(FLOAT);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void Name() throws ParseException {
 /*@bgen(jjtree) Name */
    SimpleNode jjtn000 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAME:
        t = jj_consume_token(NAME);
                 jjtn000.setImage(t.image);
                                                jjtree.closeNodeScope(jjtn000, true);
                                                jjtc000 = false;
                                                jjtreeCloseNodeScope(jjtn000);

        break;
      case AS:
        t = jj_consume_token(AS);
               jjtn000.setImage(t.image);
                                              jjtree.closeNodeScope(jjtn000, true);
                                              jjtc000 = false;
                                              jjtreeCloseNodeScope(jjtn000);

        break;
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

  final public void String() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_STRING:
      SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSTRING);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      try {
        t = jj_consume_token(SINGLE_STRING);
                          jjtn001.setImage(makeString(t.image, 1));
                                                                        jjtree.closeNodeScope(jjtn001, true);
                                                                        jjtc001 = false;
                                                                        jjtreeCloseNodeScope(jjtn001);

      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
        jjtreeCloseNodeScope(jjtn001);
      }
      }
      break;
    case SINGLE_STRING2:
      SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSTRING);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
      jjtreeOpenNodeScope(jjtn002);
      try {
        t = jj_consume_token(SINGLE_STRING2);
                           jjtn002.setImage(makeString(t.image, 1));
                                                                         jjtree.closeNodeScope(jjtn002, true);
                                                                         jjtc002 = false;
                                                                         jjtreeCloseNodeScope(jjtn002);

      } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, true);
        jjtreeCloseNodeScope(jjtn002);
      }
      }
      break;
    case TRIPLE_STRING:
      SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSTRING);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
      jjtreeOpenNodeScope(jjtn003);
      try {
        t = jj_consume_token(TRIPLE_STRING);
                          jjtn003.setImage(makeString(t.image, 3));
                                                                        jjtree.closeNodeScope(jjtn003, true);
                                                                        jjtc003 = false;
                                                                        jjtreeCloseNodeScope(jjtn003);

      } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, true);
        jjtreeCloseNodeScope(jjtn003);
      }
      }
      break;
    case TRIPLE_STRING2:
      SimpleNode jjtn004 = (SimpleNode)SimpleNode.jjtCreate(this, JJTSTRING);
      boolean jjtc004 = true;
      jjtree.openNodeScope(jjtn004);
      jjtreeOpenNodeScope(jjtn004);
      try {
        t = jj_consume_token(TRIPLE_STRING2);
                           jjtn004.setImage(makeString(t.image, 3));
                                                                         jjtree.closeNodeScope(jjtn004, true);
                                                                         jjtc004 = false;
                                                                         jjtreeCloseNodeScope(jjtn004);

      } finally {
      if (jjtc004) {
        jjtree.closeNodeScope(jjtn004, true);
        jjtreeCloseNodeScope(jjtn004);
      }
      }
      break;
    case SINGLE_USTRING:
      SimpleNode jjtn005 = (SimpleNode)SimpleNode.jjtCreate(this, JJTUNICODE);
      boolean jjtc005 = true;
      jjtree.openNodeScope(jjtn005);
      jjtreeOpenNodeScope(jjtn005);
      try {
        t = jj_consume_token(SINGLE_USTRING);
                           jjtn005.setImage(makeString(t.image, 1));
                                                                         jjtree.closeNodeScope(jjtn005, true);
                                                                         jjtc005 = false;
                                                                         jjtreeCloseNodeScope(jjtn005);

      } finally {
      if (jjtc005) {
        jjtree.closeNodeScope(jjtn005, true);
        jjtreeCloseNodeScope(jjtn005);
      }
      }
      break;
    case SINGLE_USTRING2:
      SimpleNode jjtn006 = (SimpleNode)SimpleNode.jjtCreate(this, JJTUNICODE);
      boolean jjtc006 = true;
      jjtree.openNodeScope(jjtn006);
      jjtreeOpenNodeScope(jjtn006);
      try {
        t = jj_consume_token(SINGLE_USTRING2);
                            jjtn006.setImage(makeString(t.image, 1));
                                                                          jjtree.closeNodeScope(jjtn006, true);
                                                                          jjtc006 = false;
                                                                          jjtreeCloseNodeScope(jjtn006);

      } finally {
      if (jjtc006) {
        jjtree.closeNodeScope(jjtn006, true);
        jjtreeCloseNodeScope(jjtn006);
      }
      }
      break;
    case TRIPLE_USTRING:
      SimpleNode jjtn007 = (SimpleNode)SimpleNode.jjtCreate(this, JJTUNICODE);
      boolean jjtc007 = true;
      jjtree.openNodeScope(jjtn007);
      jjtreeOpenNodeScope(jjtn007);
      try {
        t = jj_consume_token(TRIPLE_USTRING);
                           jjtn007.setImage(makeString(t.image, 3));
                                                                         jjtree.closeNodeScope(jjtn007, true);
                                                                         jjtc007 = false;
                                                                         jjtreeCloseNodeScope(jjtn007);

      } finally {
      if (jjtc007) {
        jjtree.closeNodeScope(jjtn007, true);
        jjtreeCloseNodeScope(jjtn007);
      }
      }
      break;
    case TRIPLE_USTRING2:
      SimpleNode jjtn008 = (SimpleNode)SimpleNode.jjtCreate(this, JJTUNICODE);
      boolean jjtc008 = true;
      jjtree.openNodeScope(jjtn008);
      jjtreeOpenNodeScope(jjtn008);
      try {
        t = jj_consume_token(TRIPLE_USTRING2);
                            jjtn008.setImage(makeString(t.image, 3));
                                                                          jjtree.closeNodeScope(jjtn008, true);
                                                                          jjtc008 = false;
                                                                          jjtreeCloseNodeScope(jjtn008);

      } finally {
      if (jjtc008) {
        jjtree.closeNodeScope(jjtn008, true);
        jjtreeCloseNodeScope(jjtn008);
      }
      }
      break;
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token AnyName() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAME:
      SimpleNode jjtn001 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      try {
        t = jj_consume_token(NAME);
                  jjtn001.setImage(t.image); {if (true) return t;}
                                                           jjtree.closeNodeScope(jjtn001, true);
                                                           jjtc001 = false;
                                                           jjtreeCloseNodeScope(jjtn001);

      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
        jjtreeCloseNodeScope(jjtn001);
      }
      }
      break;
    case OR_BOOL:
      SimpleNode jjtn002 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
      jjtreeOpenNodeScope(jjtn002);
      try {
        t = jj_consume_token(OR_BOOL);
                      jjtn002.setImage(t.image); {if (true) return t;}
                                                               jjtree.closeNodeScope(jjtn002, true);
                                                               jjtc002 = false;
                                                               jjtreeCloseNodeScope(jjtn002);

      } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, true);
        jjtreeCloseNodeScope(jjtn002);
      }
      }
      break;
    case AND_BOOL:
      SimpleNode jjtn003 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
      jjtreeOpenNodeScope(jjtn003);
      try {
        t = jj_consume_token(AND_BOOL);
                       jjtn003.setImage(t.image); {if (true) return t;}
                                                                jjtree.closeNodeScope(jjtn003, true);
                                                                jjtc003 = false;
                                                                jjtreeCloseNodeScope(jjtn003);

      } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, true);
        jjtreeCloseNodeScope(jjtn003);
      }
      }
      break;
    case NOT_BOOL:
      SimpleNode jjtn004 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc004 = true;
      jjtree.openNodeScope(jjtn004);
      jjtreeOpenNodeScope(jjtn004);
      try {
        t = jj_consume_token(NOT_BOOL);
                       jjtn004.setImage(t.image); {if (true) return t;}
                                                                jjtree.closeNodeScope(jjtn004, true);
                                                                jjtc004 = false;
                                                                jjtreeCloseNodeScope(jjtn004);

      } finally {
      if (jjtc004) {
        jjtree.closeNodeScope(jjtn004, true);
        jjtreeCloseNodeScope(jjtn004);
      }
      }
      break;
    case IS:
      SimpleNode jjtn005 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc005 = true;
      jjtree.openNodeScope(jjtn005);
      jjtreeOpenNodeScope(jjtn005);
      try {
        t = jj_consume_token(IS);
                 jjtn005.setImage(t.image); {if (true) return t;}
                                                          jjtree.closeNodeScope(jjtn005, true);
                                                          jjtc005 = false;
                                                          jjtreeCloseNodeScope(jjtn005);

      } finally {
      if (jjtc005) {
        jjtree.closeNodeScope(jjtn005, true);
        jjtreeCloseNodeScope(jjtn005);
      }
      }
      break;
    case IN:
      SimpleNode jjtn006 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc006 = true;
      jjtree.openNodeScope(jjtn006);
      jjtreeOpenNodeScope(jjtn006);
      try {
        t = jj_consume_token(IN);
                 jjtn006.setImage(t.image); {if (true) return t;}
                                                          jjtree.closeNodeScope(jjtn006, true);
                                                          jjtc006 = false;
                                                          jjtreeCloseNodeScope(jjtn006);

      } finally {
      if (jjtc006) {
        jjtree.closeNodeScope(jjtn006, true);
        jjtreeCloseNodeScope(jjtn006);
      }
      }
      break;
    case LAMBDA:
      SimpleNode jjtn007 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc007 = true;
      jjtree.openNodeScope(jjtn007);
      jjtreeOpenNodeScope(jjtn007);
      try {
        t = jj_consume_token(LAMBDA);
                     jjtn007.setImage(t.image); {if (true) return t;}
                                                              jjtree.closeNodeScope(jjtn007, true);
                                                              jjtc007 = false;
                                                              jjtreeCloseNodeScope(jjtn007);

      } finally {
      if (jjtc007) {
        jjtree.closeNodeScope(jjtn007, true);
        jjtreeCloseNodeScope(jjtn007);
      }
      }
      break;
    case IF:
      SimpleNode jjtn008 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc008 = true;
      jjtree.openNodeScope(jjtn008);
      jjtreeOpenNodeScope(jjtn008);
      try {
        t = jj_consume_token(IF);
                 jjtn008.setImage(t.image); {if (true) return t;}
                                                          jjtree.closeNodeScope(jjtn008, true);
                                                          jjtc008 = false;
                                                          jjtreeCloseNodeScope(jjtn008);

      } finally {
      if (jjtc008) {
        jjtree.closeNodeScope(jjtn008, true);
        jjtreeCloseNodeScope(jjtn008);
      }
      }
      break;
    case ELSE:
      SimpleNode jjtn009 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc009 = true;
      jjtree.openNodeScope(jjtn009);
      jjtreeOpenNodeScope(jjtn009);
      try {
        t = jj_consume_token(ELSE);
                   jjtn009.setImage(t.image); {if (true) return t;}
                                                            jjtree.closeNodeScope(jjtn009, true);
                                                            jjtc009 = false;
                                                            jjtreeCloseNodeScope(jjtn009);

      } finally {
      if (jjtc009) {
        jjtree.closeNodeScope(jjtn009, true);
        jjtreeCloseNodeScope(jjtn009);
      }
      }
      break;
    case ELIF:
      SimpleNode jjtn010 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc010 = true;
      jjtree.openNodeScope(jjtn010);
      jjtreeOpenNodeScope(jjtn010);
      try {
        t = jj_consume_token(ELIF);
                   jjtn010.setImage(t.image); {if (true) return t;}
                                                            jjtree.closeNodeScope(jjtn010, true);
                                                            jjtc010 = false;
                                                            jjtreeCloseNodeScope(jjtn010);

      } finally {
      if (jjtc010) {
        jjtree.closeNodeScope(jjtn010, true);
        jjtreeCloseNodeScope(jjtn010);
      }
      }
      break;
    case WHILE:
      SimpleNode jjtn011 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc011 = true;
      jjtree.openNodeScope(jjtn011);
      jjtreeOpenNodeScope(jjtn011);
      try {
        t = jj_consume_token(WHILE);
                    jjtn011.setImage(t.image); {if (true) return t;}
                                                             jjtree.closeNodeScope(jjtn011, true);
                                                             jjtc011 = false;
                                                             jjtreeCloseNodeScope(jjtn011);

      } finally {
      if (jjtc011) {
        jjtree.closeNodeScope(jjtn011, true);
        jjtreeCloseNodeScope(jjtn011);
      }
      }
      break;
    case FOR:
      SimpleNode jjtn012 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc012 = true;
      jjtree.openNodeScope(jjtn012);
      jjtreeOpenNodeScope(jjtn012);
      try {
        t = jj_consume_token(FOR);
                  jjtn012.setImage(t.image); {if (true) return t;}
                                                           jjtree.closeNodeScope(jjtn012, true);
                                                           jjtc012 = false;
                                                           jjtreeCloseNodeScope(jjtn012);

      } finally {
      if (jjtc012) {
        jjtree.closeNodeScope(jjtn012, true);
        jjtreeCloseNodeScope(jjtn012);
      }
      }
      break;
    case TRY:
      SimpleNode jjtn013 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc013 = true;
      jjtree.openNodeScope(jjtn013);
      jjtreeOpenNodeScope(jjtn013);
      try {
        t = jj_consume_token(TRY);
                  jjtn013.setImage(t.image); {if (true) return t;}
                                                           jjtree.closeNodeScope(jjtn013, true);
                                                           jjtc013 = false;
                                                           jjtreeCloseNodeScope(jjtn013);

      } finally {
      if (jjtc013) {
        jjtree.closeNodeScope(jjtn013, true);
        jjtreeCloseNodeScope(jjtn013);
      }
      }
      break;
    case EXCEPT:
      SimpleNode jjtn014 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc014 = true;
      jjtree.openNodeScope(jjtn014);
      jjtreeOpenNodeScope(jjtn014);
      try {
        t = jj_consume_token(EXCEPT);
                     jjtn014.setImage(t.image); {if (true) return t;}
                                                              jjtree.closeNodeScope(jjtn014, true);
                                                              jjtc014 = false;
                                                              jjtreeCloseNodeScope(jjtn014);

      } finally {
      if (jjtc014) {
        jjtree.closeNodeScope(jjtn014, true);
        jjtreeCloseNodeScope(jjtn014);
      }
      }
      break;
    case DEF:
      SimpleNode jjtn015 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc015 = true;
      jjtree.openNodeScope(jjtn015);
      jjtreeOpenNodeScope(jjtn015);
      try {
        t = jj_consume_token(DEF);
                  jjtn015.setImage(t.image); {if (true) return t;}
                                                           jjtree.closeNodeScope(jjtn015, true);
                                                           jjtc015 = false;
                                                           jjtreeCloseNodeScope(jjtn015);

      } finally {
      if (jjtc015) {
        jjtree.closeNodeScope(jjtn015, true);
        jjtreeCloseNodeScope(jjtn015);
      }
      }
      break;
    case CLASS:
      SimpleNode jjtn016 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc016 = true;
      jjtree.openNodeScope(jjtn016);
      jjtreeOpenNodeScope(jjtn016);
      try {
        t = jj_consume_token(CLASS);
                    jjtn016.setImage(t.image); {if (true) return t;}
                                                             jjtree.closeNodeScope(jjtn016, true);
                                                             jjtc016 = false;
                                                             jjtreeCloseNodeScope(jjtn016);

      } finally {
      if (jjtc016) {
        jjtree.closeNodeScope(jjtn016, true);
        jjtreeCloseNodeScope(jjtn016);
      }
      }
      break;
    case FINALLY:
      SimpleNode jjtn017 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc017 = true;
      jjtree.openNodeScope(jjtn017);
      jjtreeOpenNodeScope(jjtn017);
      try {
        t = jj_consume_token(FINALLY);
                      jjtn017.setImage(t.image); {if (true) return t;}
                                                               jjtree.closeNodeScope(jjtn017, true);
                                                               jjtc017 = false;
                                                               jjtreeCloseNodeScope(jjtn017);

      } finally {
      if (jjtc017) {
        jjtree.closeNodeScope(jjtn017, true);
        jjtreeCloseNodeScope(jjtn017);
      }
      }
      break;
    case PRINT:
      SimpleNode jjtn018 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc018 = true;
      jjtree.openNodeScope(jjtn018);
      jjtreeOpenNodeScope(jjtn018);
      try {
        t = jj_consume_token(PRINT);
                    jjtn018.setImage(t.image); {if (true) return t;}
                                                             jjtree.closeNodeScope(jjtn018, true);
                                                             jjtc018 = false;
                                                             jjtreeCloseNodeScope(jjtn018);

      } finally {
      if (jjtc018) {
        jjtree.closeNodeScope(jjtn018, true);
        jjtreeCloseNodeScope(jjtn018);
      }
      }
      break;
    case PASS:
      SimpleNode jjtn019 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc019 = true;
      jjtree.openNodeScope(jjtn019);
      jjtreeOpenNodeScope(jjtn019);
      try {
        t = jj_consume_token(PASS);
                   jjtn019.setImage(t.image); {if (true) return t;}
                                                            jjtree.closeNodeScope(jjtn019, true);
                                                            jjtc019 = false;
                                                            jjtreeCloseNodeScope(jjtn019);

      } finally {
      if (jjtc019) {
        jjtree.closeNodeScope(jjtn019, true);
        jjtreeCloseNodeScope(jjtn019);
      }
      }
      break;
    case BREAK:
      SimpleNode jjtn020 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc020 = true;
      jjtree.openNodeScope(jjtn020);
      jjtreeOpenNodeScope(jjtn020);
      try {
        t = jj_consume_token(BREAK);
                    jjtn020.setImage(t.image); {if (true) return t;}
                                                             jjtree.closeNodeScope(jjtn020, true);
                                                             jjtc020 = false;
                                                             jjtreeCloseNodeScope(jjtn020);

      } finally {
      if (jjtc020) {
        jjtree.closeNodeScope(jjtn020, true);
        jjtreeCloseNodeScope(jjtn020);
      }
      }
      break;
    case CONTINUE:
      SimpleNode jjtn021 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc021 = true;
      jjtree.openNodeScope(jjtn021);
      jjtreeOpenNodeScope(jjtn021);
      try {
        t = jj_consume_token(CONTINUE);
                       jjtn021.setImage(t.image); {if (true) return t;}
                                                                jjtree.closeNodeScope(jjtn021, true);
                                                                jjtc021 = false;
                                                                jjtreeCloseNodeScope(jjtn021);

      } finally {
      if (jjtc021) {
        jjtree.closeNodeScope(jjtn021, true);
        jjtreeCloseNodeScope(jjtn021);
      }
      }
      break;
    case RETURN:
      SimpleNode jjtn022 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc022 = true;
      jjtree.openNodeScope(jjtn022);
      jjtreeOpenNodeScope(jjtn022);
      try {
        t = jj_consume_token(RETURN);
                     jjtn022.setImage(t.image); {if (true) return t;}
                                                              jjtree.closeNodeScope(jjtn022, true);
                                                              jjtc022 = false;
                                                              jjtreeCloseNodeScope(jjtn022);

      } finally {
      if (jjtc022) {
        jjtree.closeNodeScope(jjtn022, true);
        jjtreeCloseNodeScope(jjtn022);
      }
      }
      break;
    case YIELD:
      SimpleNode jjtn023 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc023 = true;
      jjtree.openNodeScope(jjtn023);
      jjtreeOpenNodeScope(jjtn023);
      try {
        t = jj_consume_token(YIELD);
                    jjtn023.setImage(t.image); {if (true) return t;}
                                                             jjtree.closeNodeScope(jjtn023, true);
                                                             jjtc023 = false;
                                                             jjtreeCloseNodeScope(jjtn023);

      } finally {
      if (jjtc023) {
        jjtree.closeNodeScope(jjtn023, true);
        jjtreeCloseNodeScope(jjtn023);
      }
      }
      break;
    case IMPORT:
      SimpleNode jjtn024 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc024 = true;
      jjtree.openNodeScope(jjtn024);
      jjtreeOpenNodeScope(jjtn024);
      try {
        t = jj_consume_token(IMPORT);
                     jjtn024.setImage(t.image); {if (true) return t;}
                                                              jjtree.closeNodeScope(jjtn024, true);
                                                              jjtc024 = false;
                                                              jjtreeCloseNodeScope(jjtn024);

      } finally {
      if (jjtc024) {
        jjtree.closeNodeScope(jjtn024, true);
        jjtreeCloseNodeScope(jjtn024);
      }
      }
      break;
    case FROM:
      SimpleNode jjtn025 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc025 = true;
      jjtree.openNodeScope(jjtn025);
      jjtreeOpenNodeScope(jjtn025);
      try {
        t = jj_consume_token(FROM);
                   jjtn025.setImage(t.image); {if (true) return t;}
                                                            jjtree.closeNodeScope(jjtn025, true);
                                                            jjtc025 = false;
                                                            jjtreeCloseNodeScope(jjtn025);

      } finally {
      if (jjtc025) {
        jjtree.closeNodeScope(jjtn025, true);
        jjtreeCloseNodeScope(jjtn025);
      }
      }
      break;
    case DEL:
      SimpleNode jjtn026 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc026 = true;
      jjtree.openNodeScope(jjtn026);
      jjtreeOpenNodeScope(jjtn026);
      try {
        t = jj_consume_token(DEL);
                  jjtn026.setImage(t.image); {if (true) return t;}
                                                           jjtree.closeNodeScope(jjtn026, true);
                                                           jjtc026 = false;
                                                           jjtreeCloseNodeScope(jjtn026);

      } finally {
      if (jjtc026) {
        jjtree.closeNodeScope(jjtn026, true);
        jjtreeCloseNodeScope(jjtn026);
      }
      }
      break;
    case RAISE:
      SimpleNode jjtn027 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc027 = true;
      jjtree.openNodeScope(jjtn027);
      jjtreeOpenNodeScope(jjtn027);
      try {
        t = jj_consume_token(RAISE);
                    jjtn027.setImage(t.image); {if (true) return t;}
                                                             jjtree.closeNodeScope(jjtn027, true);
                                                             jjtc027 = false;
                                                             jjtreeCloseNodeScope(jjtn027);

      } finally {
      if (jjtc027) {
        jjtree.closeNodeScope(jjtn027, true);
        jjtreeCloseNodeScope(jjtn027);
      }
      }
      break;
    case GLOBAL:
      SimpleNode jjtn028 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc028 = true;
      jjtree.openNodeScope(jjtn028);
      jjtreeOpenNodeScope(jjtn028);
      try {
        t = jj_consume_token(GLOBAL);
                     jjtn028.setImage(t.image); {if (true) return t;}
                                                              jjtree.closeNodeScope(jjtn028, true);
                                                              jjtc028 = false;
                                                              jjtreeCloseNodeScope(jjtn028);

      } finally {
      if (jjtc028) {
        jjtree.closeNodeScope(jjtn028, true);
        jjtreeCloseNodeScope(jjtn028);
      }
      }
      break;
    case EXEC:
      SimpleNode jjtn029 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc029 = true;
      jjtree.openNodeScope(jjtn029);
      jjtreeOpenNodeScope(jjtn029);
      try {
        t = jj_consume_token(EXEC);
                   jjtn029.setImage(t.image); {if (true) return t;}
                                                            jjtree.closeNodeScope(jjtn029, true);
                                                            jjtc029 = false;
                                                            jjtreeCloseNodeScope(jjtn029);

      } finally {
      if (jjtc029) {
        jjtree.closeNodeScope(jjtn029, true);
        jjtreeCloseNodeScope(jjtn029);
      }
      }
      break;
    case ASSERT:
      SimpleNode jjtn030 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc030 = true;
      jjtree.openNodeScope(jjtn030);
      jjtreeOpenNodeScope(jjtn030);
      try {
        t = jj_consume_token(ASSERT);
                     jjtn030.setImage(t.image); {if (true) return t;}
                                                              jjtree.closeNodeScope(jjtn030, true);
                                                              jjtc030 = false;
                                                              jjtreeCloseNodeScope(jjtn030);

      } finally {
      if (jjtc030) {
        jjtree.closeNodeScope(jjtn030, true);
        jjtreeCloseNodeScope(jjtn030);
      }
      }
      break;
    case AS:
      SimpleNode jjtn031 = (SimpleNode)SimpleNode.jjtCreate(this, JJTNAME);
      boolean jjtc031 = true;
      jjtree.openNodeScope(jjtn031);
      jjtreeOpenNodeScope(jjtn031);
      try {
        t = jj_consume_token(AS);
                 jjtn031.setImage(t.image); {if (true) return t;}
                                                          jjtree.closeNodeScope(jjtn031, true);
                                                          jjtc031 = false;
                                                          jjtreeCloseNodeScope(jjtn031);

      } finally {
      if (jjtc031) {
        jjtree.closeNodeScope(jjtn031, true);
        jjtreeCloseNodeScope(jjtn031);
      }
      }
      break;
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    }
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_3R_124()) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(ASSERT)) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_scan_token(EXEC)) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_scan_token(GLOBAL)) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_scan_token(RAISE)) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_scan_token(DEL)) return true;
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(IMPORT)) return true;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(YIELD)) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_scan_token(PASS)) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(PRINT)) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(FINALLY)) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(DEF)) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(EXCEPT)) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_scan_token(TRY)) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(WHILE)) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(ELIF)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(ELSE)) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(LAMBDA)) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(IS)) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(NOT_BOOL)) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(AND_BOOL)) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(OR_BOOL)) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_scan_token(ASSERT)) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_scan_token(EXEC)) return true;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_scan_token(TRIPLE_USTRING2)) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_scan_token(GLOBAL)) return true;
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_scan_token(TRIPLE_USTRING)) return true;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(SINGLE_USTRING2)) return true;
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_scan_token(SINGLE_USTRING)) return true;
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_3R_164()) return true;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(TRIPLE_STRING2)) return true;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(TRIPLE_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_scan_token(SINGLE_STRING2)) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_scan_token(SINGLE_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_167() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    }
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_scan_token(COMPLEX)) return true;
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_scan_token(DECNUMBER)) return true;
    return false;
  }

  final private boolean jj_3R_171() {
    if (jj_scan_token(OCTNUMBER)) return true;
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_scan_token(HEXNUMBER)) return true;
    return false;
  }

  final private boolean jj_3R_166() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_56()) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) jj_scanpos = xsp;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_120() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) return true;
    }
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_scan_token(IMPORT)) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_149() {
    if (jj_scan_token(RAISE)) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_scan_token(MULTIPLY)) return true;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_scan_token(POWER)) return true;
    return false;
  }

  final private boolean jj_3R_164() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_scan_token(YIELD)) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(MULTIPLY)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    return false;
  }

  final private boolean jj_3R_128() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_144()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_3R_155()) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) return true;
    }
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_3R_149()) return true;
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_3R_148()) return true;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_3R_147()) return true;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_scan_token(PASS)) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_scan_token(DEL)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_3R_133()) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_scan_token(PRINT)) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_scan_token(PRINT)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_145() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(PRINT)) return true;
    if (jj_scan_token(RSHIFT)) return true;
    return false;
  }

  final private boolean jj_3R_116() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(MULTIPLY)) return true;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_3R_145()) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_3R_129()) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_3R_131()) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_123()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_3R_122()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_3R_121()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_120()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_119()) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_scan_token(LAMBDA)) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_116()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_3R_115()) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_3R_167()) return true;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_3R_166()) return true;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_scan_token(136)) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) return true;
    }
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(POWER)) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) return true;
    }
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(MULTIPLY)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_152() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(POWER)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_3R_152()) return true;
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_3R_142()) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_3R_126()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_3R_165()) return true;
    return false;
  }

  final private boolean jj_3R_146() {
    if (jj_3R_154()) return true;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_3R_146()) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_3R_156()) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT_BOOL)) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_125()) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) return true;
    }
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_scan_token(NOT_BOOL)) return true;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_3R_141()) return true;
    return false;
  }

  public PythonGrammarTokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[111];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x30540000,0x30540000,0x40,0x30540040,0x30540040,0x40,0x40,0x0,0x40000,0x40040000,0x2000000,0x2000000,0x40000000,0x40040000,0x40000000,0x0,0x40000,0x2000000,0x30540000,0x1000000,0x30540000,0x0,0x0,0x2000000,0x2000000,0x2000000,0x0,0x0,0x30540000,0x2000000,0x2000000,0x30540000,0x0,0x2000000,0x2000000,0x2000000,0x0,0x40040000,0x0,0x4000000,0x0,0x2000000,0x2000000,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x30540000,0x30540000,0x30540040,0x0,0x30540000,0x0,0x30540000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x30000000,0xc0000000,0xc0000000,0x30540000,0x4440000,0x4400000,0x30540000,0x30540000,0x30540000,0x0,0x540000,0x0,0x40040000,0x2000000,0x8000000,0x3c540000,0x30540000,0x30540000,0x8000000,0x2000000,0x2000000,0x2000000,0x2000000,0x0,0x2000000,0x0,0x0,0x40000,0x2000000,0x40000000,0x40000000,0x2000000,0x2000000,0x40000000,0x40000000,0x30540000,0x40000000,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x80000020,0x80000020,0x0,0x80000020,0x80000020,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x2,0x2,0x2,0x200,0x0,0x0,0x80000020,0x0,0x80000020,0x200,0x1ffe0000,0x0,0x0,0x0,0x0,0x0,0x80000020,0x0,0x0,0x80000020,0x0,0x0,0x0,0x0,0xe0000000,0xe0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000020,0x80000020,0x80000020,0x20000000,0x80000020,0x40000000,0x80000020,0x8001fc00,0x8001fc00,0x0,0x80,0x40,0x100,0xc,0xc,0x0,0x0,0x11,0x11,0x20,0x0,0x0,0x80000020,0x80000020,0x80000020,0x0,0x0,0x0,0x2,0x0,0x0,0x80000020,0x80000020,0x80000020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x2,0x2,0xe0000020,0x2,0x0,0x0,0x0,0xe0000000,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0xdfffedcc,0xdfffedcc,0x0,0xdfffedcc,0xdfffedcc,0x0,0x0,0x8000000,0x0,0x14000000,0x0,0x0,0x0,0x14000000,0x0,0x0,0x14000000,0x0,0xdfffedcc,0x0,0xd7ffe004,0x0,0x0,0x0,0x0,0x0,0x2000,0x478000,0xd4000004,0x0,0x0,0xd4000004,0x180000,0x0,0x0,0x0,0x17ffffff,0x17ffffff,0x4000000,0x0,0x4000000,0x0,0x0,0x2,0x0,0x8000dc8,0x20,0x10,0x10,0x10,0x200,0x10,0x1200,0x0,0xd4000004,0xdfffedcc,0xd7ffe004,0x0,0xd4000004,0x0,0xd4000000,0x3,0x2,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd4000000,0x0,0x0,0xd4000004,0xd4000004,0xd4000004,0x0,0xd4000000,0x80,0x14000000,0x0,0x0,0xd4000004,0xd4000004,0xd4000004,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd7ffffff,0x0,0xc0000000,0x14000000,0x0,0x17ffffff,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x1fe007,0x1fe007,0x0,0x1fe007,0x1fe007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe007,0x0,0x1fe007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe007,0x0,0x0,0x1fe007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe007,0x1fe007,0x1fe007,0x0,0x1fe007,0x0,0x1fe007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe007,0x0,0x0,0x1fe007,0x1fe007,0x1fe007,0x1fe000,0x1fe007,0x0,0x0,0x0,0x0,0x1fe007,0x1fe007,0x1fe007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe007,0x0,0x7,0x0,0x1fe000,0x0,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x100,0x100,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x100,0x0,0x100,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x100,0x100,0x0,0x100,0x0,0x0,0x0,0x0,0x100,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[27];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public PythonGrammar(CharStream stream) {
    token_source = new PythonGrammarTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 111; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 111; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PythonGrammar(PythonGrammarTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 111; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(PythonGrammarTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 111; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[137];
    for (int i = 0; i < 137; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 111; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 137; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 27; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
