/* -*- mode: c; c-basic-offset: 8 -*- */
/*
    iso_latin_names.h -- character names in ISO-LATIN-1
*/
/*
    Copyright (c) 2008, Juan Jose Garcia Ripoll.

    ECL is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/

ecl_def_string_array(char_names,static,const) = {
        ecl_def_string_array_elt("Nul"),
        ecl_def_string_array_elt("Soh"),
        ecl_def_string_array_elt("Stx"),
        ecl_def_string_array_elt("Etx"),
        ecl_def_string_array_elt("Eot"),
        ecl_def_string_array_elt("Enq"),
        ecl_def_string_array_elt("Ack"),
        ecl_def_string_array_elt("Bel"),
        ecl_def_string_array_elt("Backspace"),
        ecl_def_string_array_elt("Tab"),
        ecl_def_string_array_elt("Newline"),
        ecl_def_string_array_elt("Vt"),
        ecl_def_string_array_elt("Page"),
        ecl_def_string_array_elt("Return"),
        ecl_def_string_array_elt("So"),
        ecl_def_string_array_elt("Si"),
        ecl_def_string_array_elt("Dle"),
        ecl_def_string_array_elt("Dc1"),
        ecl_def_string_array_elt("Dc2"),
        ecl_def_string_array_elt("Dc3"),
        ecl_def_string_array_elt("Dc4"),
        ecl_def_string_array_elt("Nak"),
        ecl_def_string_array_elt("Syn"),
        ecl_def_string_array_elt("Etb"),
        ecl_def_string_array_elt("Can"),
        ecl_def_string_array_elt("Em"),
        ecl_def_string_array_elt("Sub"),
        ecl_def_string_array_elt("Esc"),
        ecl_def_string_array_elt("Fs"),
        ecl_def_string_array_elt("Gs"),
        ecl_def_string_array_elt("Rs"),
        ecl_def_string_array_elt("Us"),
        ecl_def_string_array_elt("Space"),
        ecl_def_string_array_elt("EXCLAMATION_MARK"),
        ecl_def_string_array_elt("QUOTATION_MARK"),
        ecl_def_string_array_elt("NUMBER_SIGN"),
        ecl_def_string_array_elt("DOLLAR_SIGN"),
        ecl_def_string_array_elt("PERCENT_SIGN"),
        ecl_def_string_array_elt("AMPERSAND"),
        ecl_def_string_array_elt("APOSTROPHE"),
        ecl_def_string_array_elt("LEFT_PARENTHESIS"),
        ecl_def_string_array_elt("RIGHT_PARENTHESIS"),
        ecl_def_string_array_elt("ASTERISK"),
        ecl_def_string_array_elt("PLUS_SIGN"),
        ecl_def_string_array_elt("COMMA"),
        ecl_def_string_array_elt("HYPHEN-MINUS"),
        ecl_def_string_array_elt("FULL_STOP"),
        ecl_def_string_array_elt("SOLIDUS"),
        ecl_def_string_array_elt("DIGIT_ZERO"),
        ecl_def_string_array_elt("DIGIT_ONE"),
        ecl_def_string_array_elt("DIGIT_TWO"),
        ecl_def_string_array_elt("DIGIT_THREE"),
        ecl_def_string_array_elt("DIGIT_FOUR"),
        ecl_def_string_array_elt("DIGIT_FIVE"),
        ecl_def_string_array_elt("DIGIT_SIX"),
        ecl_def_string_array_elt("DIGIT_SEVEN"),
        ecl_def_string_array_elt("DIGIT_EIGHT"),
        ecl_def_string_array_elt("DIGIT_NINE"),
        ecl_def_string_array_elt("COLON"),
        ecl_def_string_array_elt("SEMICOLON"),
        ecl_def_string_array_elt("LESS-THAN_SIGN"),
        ecl_def_string_array_elt("EQUALS_SIGN"),
        ecl_def_string_array_elt("GREATER-THAN_SIGN"),
        ecl_def_string_array_elt("QUESTION_MARK"),
        ecl_def_string_array_elt("COMMERCIAL_AT"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_A"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_B"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_C"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_D"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_E"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_F"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_G"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_H"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_I"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_J"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_K"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_L"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_M"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_N"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_O"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_P"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_Q"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_R"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_S"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_T"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_U"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_V"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_W"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_X"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_Y"),
        ecl_def_string_array_elt("LATIN_CAPITAL_LETTER_Z"),
        ecl_def_string_array_elt("LEFT_SQUARE_BRACKET"),
        ecl_def_string_array_elt("REVERSE_SOLIDUS"),
        ecl_def_string_array_elt("RIGHT_SQUARE_BRACKET"),
        ecl_def_string_array_elt("CIRCUMFLEX_ACCENT"),
        ecl_def_string_array_elt("LOW_LINE"),
        ecl_def_string_array_elt("GRAVE_ACCENT"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_A"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_B"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_C"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_D"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_E"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_F"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_G"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_H"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_I"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_J"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_K"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_L"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_M"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_N"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_O"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_P"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_Q"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_R"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_S"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_T"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_U"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_V"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_W"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_X"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_Y"),
        ecl_def_string_array_elt("LATIN_SMALL_LETTER_Z"),
        ecl_def_string_array_elt("LEFT_CURLY_BRACKET"),
        ecl_def_string_array_elt("VERTICAL_LINE"),
        ecl_def_string_array_elt("RIGHT_CURLY_BRACKET"),
        ecl_def_string_array_elt("TILDE"),
        ecl_def_string_array_elt("Rubout"),
        ecl_def_string_array_elt(0)
};

/* Linefeed is redundant with one of the names given in
 * iso_latin_names.h, but it can not be associated to the code
 * 10, because the default name must be Newline. Similar to
 * the other codes. */
ecl_def_string_array(extra_char_names,static,const) = {
        ecl_def_string_array_elt("Null"), /* 0 */
	ecl_def_string_array_elt("Bell"), /* 7 */
	ecl_def_string_array_elt("Bs"), /* 8 */
	ecl_def_string_array_elt("Ht"), /* 9 */
	ecl_def_string_array_elt("Linefeed"), /* 10 */
	ecl_def_string_array_elt("Lf"), /* 10 */
	ecl_def_string_array_elt("Escape"), /* 27 */
	ecl_def_string_array_elt("Ff"), /* 12 */
	ecl_def_string_array_elt("Cr"), /* 13 */
	ecl_def_string_array_elt("Sp"), /* 32 */
	ecl_def_string_array_elt("Del") /* 127 */
};

static const unsigned char extra_char_codes[] = {
	0, 7, 8, 9, 10, 10, 27, 12, 13, 32, 127
};

#define extra_char_names_size 11

