/* -*- mode: c; c-basic-offset: 8 -*- */
#ifdef ECL_CMU_FORMAT
# define ECL_NAME_PPRINT(x) ECL_NAME(x)
#else
# define ECL_NAME_PPRINT(x) NULL
#endif
#ifdef ECL_FINAL
# define ECL_NAME(x) x
#else
# define ECL_NAME(x) NULL
#endif
#ifdef ECL_RELATIVE_PACKAGE_NAMES
# define RELATIVE_PACKAGES_P Ct
#else
# define RELATIVE_PACKAGES_P Cnil
#endif
#ifdef DPP
#define CLOS_ "CLOS::"
#define EXT_ "EXT::"
#define SYS_ "SI::"
#define MP_ "MP::"
#define KEY_ ":"
#define GRAY_ "GRAY::"
struct {
	const char *name, *translation;
}
#else
#define CLOS_
#define EXT_
#define SYS_
#define MP_
#define KEY_
#define GRAY_
cl_symbol_initializer
#endif
cl_symbols[] = {

{"NIL", CL_ORDINARY, NULL, -1, OBJNULL},
{"T", CL_ORDINARY, NULL, -1, OBJNULL},
#ifdef CLOS
{SYS_ "UNBOUND", SI_CONSTANT, si_unbound, 0, ECL_UNBOUND},
#else
{SYS_ "UNBOUND", SI_ORDINARY, NULL, -1, ECL_UNBOUND},
#endif
{SYS_ "PROTECT-TAG", SI_ORDINARY, NULL, -1, OBJNULL},

/* LISP PACKAGE */
{"&ALLOW-OTHER-KEYS", CL_ORDINARY, NULL, -1, OBJNULL},
{"&AUX", CL_ORDINARY, NULL, -1, OBJNULL},
{"&BODY", CL_ORDINARY, NULL, -1, OBJNULL},
{"&ENVIRONMENT", CL_ORDINARY, NULL, -1, OBJNULL},
{"&KEY", CL_ORDINARY, NULL, -1, OBJNULL},
{"&OPTIONAL", CL_ORDINARY, NULL, -1, OBJNULL},
{"&REST", CL_ORDINARY, NULL, -1, OBJNULL},
{"&WHOLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"+", CL_SPECIAL, cl_P, -1, Cnil},
{"++", CL_SPECIAL, NULL, -1, Cnil},
{"+++", CL_SPECIAL, NULL, -1, Cnil},
{"-", CL_SPECIAL, cl_M, -1, Cnil},
{"*", CL_SPECIAL, cl_X, -1, Cnil},
{"**", CL_SPECIAL, NULL, -1, Cnil},
{"***", CL_SPECIAL, NULL, -1, Cnil},
{"/", CL_SPECIAL, cl_N, -1, Cnil},
{"//", CL_SPECIAL, NULL, -1, Cnil},
{"///", CL_SPECIAL, NULL, -1, Cnil},
{"/=", CL_ORDINARY, cl_NE, -1, OBJNULL},
{"*BREAK-ON-SIGNALS*", CL_SPECIAL, NULL, -1, Cnil},
{"*COMPILE-FILE-PATHNAME*", CL_SPECIAL, NULL, -1, Cnil},
{"*COMPILE-FILE-TRUENAME*", CL_SPECIAL, NULL, -1, Cnil},
{"*COMPILE-PRINT*", CL_SPECIAL, NULL, -1, Ct},
{"*COMPILE-VERBOSE*", CL_SPECIAL, NULL, -1, Ct},
{"*DEBUG-IO*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*DEBUGGER-HOOK*", CL_SPECIAL, NULL, -1, Cnil},
{"*DEFAULT-PATHNAME-DEFAULTS*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*ERROR-OUTPUT*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*FEATURES*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*GENSYM-COUNTER*", CL_SPECIAL, NULL, -1, MAKE_FIXNUM(0)},
{"*LOAD-PATHNAME*", CL_SPECIAL, NULL, -1, Cnil},
{"*LOAD-PRINT*", CL_SPECIAL, NULL, -1, Cnil},
{"*LOAD-TRUENAME*", CL_SPECIAL, NULL, -1, Cnil},
{"*LOAD-VERBOSE*", CL_SPECIAL, NULL, -1, Ct},
{"*MACROEXPAND-HOOK*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*MODULES*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*MODULE-PROVIDER-FUNCTIONS*", SI_SPECIAL, NULL, -1, OBJNULL},
{"*PACKAGE*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*PRINT-ARRAY*", CL_SPECIAL, NULL, -1, Ct},
{"*PRINT-BASE*", CL_SPECIAL, NULL, -1, MAKE_FIXNUM(10)},
{"*PRINT-CASE*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*PRINT-CIRCLE*", CL_SPECIAL, NULL, -1, Cnil},
{"*PRINT-ESCAPE*", CL_SPECIAL, NULL, -1, Ct},
{"*PRINT-GENSYM*", CL_SPECIAL, NULL, -1, Ct},
{"*PRINT-LENGTH*", CL_SPECIAL, NULL, -1, Cnil},
{"*PRINT-LEVEL*", CL_SPECIAL, NULL, -1, Cnil},
{"*PRINT-LINES*", CL_SPECIAL, NULL, -1, Cnil},
{"*PRINT-MISER-WIDTH*", CL_SPECIAL, NULL, -1, Cnil},
{"*PRINT-PPRINT-DISPATCH*", CL_SPECIAL, NULL, -1, Cnil},
#if defined(ECL_CMU_FORMAT)
{"*PRINT-PRETTY*", CL_SPECIAL, NULL, -1, Cnil},
#else
{"*PRINT-PRETTY*", CL_SPECIAL, NULL, -1, Ct},
#endif
{"*PRINT-RADIX*", CL_SPECIAL, NULL, -1, Cnil},
{"*PRINT-READABLY*", CL_SPECIAL, NULL, -1, Cnil},
{"*PRINT-RIGHT-MARGIN*", CL_SPECIAL, NULL, -1, Cnil},
{"*QUERY-IO*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*RANDOM-STATE*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*READ-BASE*", CL_SPECIAL, NULL, -1, MAKE_FIXNUM(10)},
{"*READ-DEFAULT-FLOAT-FORMAT*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*READ-EVAL*", CL_SPECIAL, NULL, -1, Ct},
{"*READ-SUPPRESS*", CL_SPECIAL, NULL, -1, Cnil},
{"*READTABLE*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*STANDARD-INPUT*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*STANDARD-OUTPUT*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*TERMINAL-IO*", CL_SPECIAL, NULL, -1, OBJNULL},
{"*TRACE-OUTPUT*", CL_SPECIAL, NULL, -1, OBJNULL},
{"1+", CL_ORDINARY, cl_1P, 1, OBJNULL},
{"1-", CL_ORDINARY, cl_1M, 1, OBJNULL},
{"<", CL_ORDINARY, cl_L, -1, OBJNULL},
{"<=", CL_ORDINARY, cl_LE, -1, OBJNULL},
{"=", CL_ORDINARY, cl_E, -1, OBJNULL},
{">", CL_ORDINARY, cl_G, -1, OBJNULL},
{">=", CL_ORDINARY, cl_GE, -1, OBJNULL},
{"ABORT", CL_ORDINARY, NULL, -1, OBJNULL},
{"ABS", CL_ORDINARY, cl_abs, 1, OBJNULL},
{"ACONS", CL_ORDINARY, cl_acons, 3, OBJNULL},
{"ACOS", CL_ORDINARY, ECL_NAME(cl_acos), 1, OBJNULL},
{"ACOSH", CL_ORDINARY, ECL_NAME(cl_acosh), 1, OBJNULL},
{"ADJOIN", CL_ORDINARY, cl_adjoin, -1, OBJNULL},
{"ADJUST-ARRAY", CL_ORDINARY, ECL_NAME(cl_adjust_array), -1, OBJNULL},
{"ADJUSTABLE-ARRAY-P", CL_ORDINARY, cl_adjustable_array_p, 1, OBJNULL},
{"ALPHA-CHAR-P", CL_ORDINARY, cl_alpha_char_p, 1, OBJNULL},
{"ALPHANUMERICP", CL_ORDINARY, cl_alphanumericp, 1, OBJNULL},
{"AND", CL_ORDINARY, NULL, -1, OBJNULL},
{"APPEND", CL_ORDINARY, cl_append, -1, OBJNULL},
{"APPLY", CL_ORDINARY, cl_apply, -1, OBJNULL},
{"APROPOS", CL_ORDINARY, ECL_NAME(cl_apropos), -1, OBJNULL},
{"APROPOS-LIST", CL_ORDINARY, ECL_NAME(cl_apropos_list), -1, OBJNULL},
{"AREF", CL_ORDINARY, cl_aref, -1, OBJNULL},
{"ARITHMETIC-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"ARITHMETIC-ERROR-OPERANDS", CL_ORDINARY, NULL, -1, OBJNULL},
{"ARITHMETIC-ERROR-OPERATION", CL_ORDINARY, NULL, -1, OBJNULL},
{"ARRAY", CL_ORDINARY, NULL, -1, OBJNULL},
{"ARRAY-DIMENSION", CL_ORDINARY, cl_array_dimension, 2, OBJNULL},
{"ARRAY-DIMENSION-LIMIT", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ADIMLIM)},
{"ARRAY-DIMENSIONS", CL_ORDINARY, ECL_NAME(cl_array_dimensions), 1, OBJNULL},
{"ARRAY-DISPLACEMENT", CL_ORDINARY, cl_array_displacement, 1, OBJNULL},
{"ARRAY-ELEMENT-TYPE", CL_ORDINARY, cl_array_element_type, 1, OBJNULL},
{"ARRAY-HAS-FILL-POINTER-P", CL_ORDINARY, cl_array_has_fill_pointer_p, 1, OBJNULL},
{"ARRAY-IN-BOUNDS-P", CL_ORDINARY, ECL_NAME(cl_array_in_bounds_p), -1, OBJNULL},
{"ARRAY-RANK", CL_ORDINARY, cl_array_rank, 1, OBJNULL},
{"ARRAY-RANK-LIMIT", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ARANKLIM)},
{"ARRAY-ROW-MAJOR-INDEX", CL_ORDINARY, ECL_NAME(cl_array_row_major_index), -1, OBJNULL},
{"ARRAY-TOTAL-SIZE", CL_ORDINARY, cl_array_total_size, 1, OBJNULL},
{"ARRAY-TOTAL-SIZE-LIMIT", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ATOTLIM)},
{"ARRAYP", CL_ORDINARY, cl_arrayp, 1, OBJNULL},
{"ASH", CL_ORDINARY, cl_ash, 2, OBJNULL},
{"ASIN", CL_ORDINARY, ECL_NAME(cl_asin), 1, OBJNULL},
{"ASINH", CL_ORDINARY, ECL_NAME(cl_asinh), 1, OBJNULL},
{"ASSERT", CL_ORDINARY, NULL, -1, OBJNULL},
{"ASSOC", CL_ORDINARY, cl_assoc, -1, OBJNULL},
{"ASSOC-IF", CL_ORDINARY, ECL_NAME(cl_assoc_if), -1, OBJNULL},
{"ASSOC-IF-NOT", CL_ORDINARY, ECL_NAME(cl_assoc_if_not), -1, OBJNULL},
{"ATAN", CL_ORDINARY, cl_atan, -1, OBJNULL},
{"ATANH", CL_ORDINARY, ECL_NAME(cl_atanh), 1, OBJNULL},
{"ATOM", CL_ORDINARY, cl_atom, 1, OBJNULL},
{"BASE-CHAR", CL_ORDINARY, NULL, -1, OBJNULL},
{"BASE-STRING", CL_ORDINARY, NULL, -1, OBJNULL},
{"BIGNUM", CL_ORDINARY, NULL, -1, OBJNULL},
{"BIT", CL_ORDINARY, ECL_NAME(cl_bit), -1, OBJNULL},
{"BIT-AND", CL_ORDINARY, ECL_NAME(cl_bit_and), -1, OBJNULL},
{"BIT-ANDC1", CL_ORDINARY, ECL_NAME(cl_bit_andc1), -1, OBJNULL},
{"BIT-ANDC2", CL_ORDINARY, ECL_NAME(cl_bit_andc2), -1, OBJNULL},
{"BIT-EQV", CL_ORDINARY, ECL_NAME(cl_bit_eqv), -1, OBJNULL},
{"BIT-IOR", CL_ORDINARY, ECL_NAME(cl_bit_ior), -1, OBJNULL},
{"BIT-NAND", CL_ORDINARY, ECL_NAME(cl_bit_nand), -1, OBJNULL},
{"BIT-NOR", CL_ORDINARY, ECL_NAME(cl_bit_nor), -1, OBJNULL},
{"BIT-NOT", CL_ORDINARY, ECL_NAME(cl_bit_not), -1, OBJNULL},
{"BIT-ORC1", CL_ORDINARY, ECL_NAME(cl_bit_orc1), -1, OBJNULL},
{"BIT-ORC2", CL_ORDINARY, ECL_NAME(cl_bit_orc2), -1, OBJNULL},
{"BIT-VECTOR", CL_ORDINARY, NULL, -1, OBJNULL},
{"BIT-VECTOR-P", CL_ORDINARY, cl_bit_vector_p, 1, OBJNULL},
{"BIT-XOR", CL_ORDINARY, ECL_NAME(cl_bit_xor), -1, OBJNULL},
{"BLOCK", CL_FORM, NULL, -1, OBJNULL},
{"BOOLE", CL_ORDINARY, cl_boole, 3, OBJNULL},
{"BOOLE-1", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOL1)},
{"BOOLE-2", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOL2)},
{"BOOLE-AND", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLAND)},
{"BOOLE-ANDC1", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLANDC1)},
{"BOOLE-ANDC2", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLANDC2)},
{"BOOLE-C1", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLC1)},
{"BOOLE-C2", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLC2)},
{"BOOLE-CLR", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLCLR)},
{"BOOLE-EQV", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLEQV)},
{"BOOLE-IOR", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLIOR)},
{"BOOLE-NAND", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLNAND)},
{"BOOLE-NOR", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLNOR)},
{"BOOLE-ORC1", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLORC1)},
{"BOOLE-ORC2", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLORC2)},
{"BOOLE-SET", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLSET)},
{"BOOLE-XOR", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_BOOLXOR)},
{"BOOLEAN", CL_ORDINARY, NULL, -1, OBJNULL},
{"BOTH-CASE-P", CL_ORDINARY, cl_both_case_p, 1, OBJNULL},
{"BOUNDP", CL_ORDINARY, cl_boundp, 1, OBJNULL},
{"BREAK", CL_ORDINARY, NULL, -1, OBJNULL},
{"BROADCAST-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"BROADCAST-STREAM-STREAMS", CL_ORDINARY, cl_broadcast_stream_streams, 1, OBJNULL},
{"BUTLAST", CL_ORDINARY, cl_butlast, -1, OBJNULL},
{"BYTE", CL_ORDINARY, ECL_NAME(cl_byte), 2, OBJNULL},
{"BYTE-POSITION", CL_ORDINARY, ECL_NAME(cl_byte_position), 1, OBJNULL},
{"BYTE-SIZE", CL_ORDINARY, ECL_NAME(cl_byte_size), 1, OBJNULL},
{"CAAAAR", CL_ORDINARY, cl_caaaar, 1, OBJNULL},
{"CAAADR", CL_ORDINARY, cl_caaadr, 1, OBJNULL},
{"CAAAR", CL_ORDINARY, cl_caaar, 1, OBJNULL},
{"CAADAR", CL_ORDINARY, cl_caadar, 1, OBJNULL},
{"CAADDR", CL_ORDINARY, cl_caaddr, 1, OBJNULL},
{"CAADR", CL_ORDINARY, cl_caadr, 1, OBJNULL},
{"CAAR", CL_ORDINARY, cl_caar, 1, OBJNULL},
{"CADAAR", CL_ORDINARY, cl_cadaar, 1, OBJNULL},
{"CADADR", CL_ORDINARY, cl_cadadr, 1, OBJNULL},
{"CADAR", CL_ORDINARY, cl_cadar, 1, OBJNULL},
{"CADDAR", CL_ORDINARY, cl_caddar, 1, OBJNULL},
{"CADDDR", CL_ORDINARY, cl_cadddr, 1, OBJNULL},
{"CADDR", CL_ORDINARY, cl_caddr, 1, OBJNULL},
{"CADR", CL_ORDINARY, cl_cadr, 1, OBJNULL},
{"CALL-ARGUMENTS-LIMIT", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(CALL_ARGUMENTS_LIMIT)},
{"CAR", CL_ORDINARY, cl_car, 1, OBJNULL},
{"CASE", CL_FORM, NULL, -1, OBJNULL},
{"CATCH", CL_FORM, NULL, -1, OBJNULL},
{"CCASE", CL_ORDINARY, NULL, -1, OBJNULL},
{"CDAAAR", CL_ORDINARY, cl_cdaaar, 1, OBJNULL},
{"CDAADR", CL_ORDINARY, cl_cdaadr, 1, OBJNULL},
{"CDAAR", CL_ORDINARY, cl_cdaar, 1, OBJNULL},
{"CDADAR", CL_ORDINARY, cl_cdadar, 1, OBJNULL},
{"CDADDR", CL_ORDINARY, cl_cdaddr, 1, OBJNULL},
{"CDADR", CL_ORDINARY, cl_cdadr, 1, OBJNULL},
{"CDAR", CL_ORDINARY, cl_cdar, 1, OBJNULL},
{"CDDAAR", CL_ORDINARY, cl_cddaar, 1, OBJNULL},
{"CDDADR", CL_ORDINARY, cl_cddadr, 1, OBJNULL},
{"CDDAR", CL_ORDINARY, cl_cddar, 1, OBJNULL},
{"CDDDAR", CL_ORDINARY, cl_cdddar, 1, OBJNULL},
{"CDDDDR", CL_ORDINARY, cl_cddddr, 1, OBJNULL},
{"CDDDR", CL_ORDINARY, cl_cdddr, 1, OBJNULL},
{"CDDR", CL_ORDINARY, cl_cddr, 1, OBJNULL},
{"CDR", CL_ORDINARY, cl_cdr, 1, OBJNULL},
{"CEILING", CL_ORDINARY, cl_ceiling, -1, OBJNULL},
{"CELL-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"CELL-ERROR-NAME", CL_ORDINARY, NULL, -1, OBJNULL},
{"CERROR", CL_ORDINARY, cl_cerror, -1, OBJNULL},
{"CHAR", CL_ORDINARY, cl_char, 2, OBJNULL},
{"CHAR-CODE", CL_ORDINARY, cl_char_code, 1, OBJNULL},
{"CHAR-CODE-LIMIT", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(CHAR_CODE_LIMIT)},
{"CHAR-DOWNCASE", CL_ORDINARY, cl_char_downcase, 1, OBJNULL},
{"CHAR-EQUAL", CL_ORDINARY, cl_char_equal, -1, OBJNULL},
{"CHAR-GREATERP", CL_ORDINARY, cl_char_greaterp, -1, OBJNULL},
{"CHAR-INT", CL_ORDINARY, cl_char_int, 1, OBJNULL},
{"CHAR-LESSP", CL_ORDINARY, cl_char_lessp, -1, OBJNULL},
{"CHAR-NAME", CL_ORDINARY, cl_char_name, 1, OBJNULL},
{"CHAR-NOT-EQUAL", CL_ORDINARY, cl_char_not_equal, -1, OBJNULL},
{"CHAR-NOT-GREATERP", CL_ORDINARY, cl_char_not_greaterp, -1, OBJNULL},
{"CHAR-NOT-LESSP", CL_ORDINARY, cl_char_not_lessp, -1, OBJNULL},
{"CHAR-UPCASE", CL_ORDINARY, cl_char_upcase, 1, OBJNULL},
{"CHAR/=", CL_ORDINARY, cl_charNE, -1, OBJNULL},
{"CHAR<", CL_ORDINARY, cl_charL, -1, OBJNULL},
{"CHAR<=", CL_ORDINARY, cl_charLE, -1, OBJNULL},
{"CHAR=", CL_ORDINARY, cl_charE, -1, OBJNULL},
{"CHAR>", CL_ORDINARY, cl_charG, -1, OBJNULL},
{"CHAR>=", CL_ORDINARY, cl_charGE, -1, OBJNULL},
{"CHARACTER", CL_ORDINARY, cl_character, 1, OBJNULL},
{"CHARACTERP", CL_ORDINARY, cl_characterp, 1, OBJNULL},
{"CHECK-TYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"CIS", CL_ORDINARY, ECL_NAME(cl_cis), 1, OBJNULL},
{"CLEAR-INPUT", CL_ORDINARY, cl_clear_input, -1, OBJNULL},
{"CLEAR-OUTPUT", CL_ORDINARY, cl_clear_output, -1, OBJNULL},
{"CLOSE", CL_ORDINARY, cl_close, -1, OBJNULL},
{"CLRHASH", CL_ORDINARY, cl_clrhash, 1, OBJNULL},
{"CODE-CHAR", CL_ORDINARY, cl_code_char, 1, OBJNULL},
{"COERCE", CL_ORDINARY, ECL_NAME(cl_coerce), 2, OBJNULL},
{"COMPILATION-SPEED", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPILE", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPILE-FILE", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPILE-FILE-PATHNAME", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPILED-FUNCTION", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPILED-FUNCTION-P", CL_ORDINARY, cl_compiled_function_p, 1, OBJNULL},
{"COMPILER-MACRO", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPILER-MACRO-FUNCTION", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPLEMENT", CL_ORDINARY, NULL, -1, OBJNULL},
{"COMPLEX", CL_ORDINARY, cl_complex, -1, OBJNULL},
{"COMPLEXP", CL_ORDINARY, cl_complexp, 1, OBJNULL},
{"COMPUTE-RESTARTS", CL_ORDINARY, NULL, 1, OBJNULL},
{"CONCATENATE", CL_ORDINARY, ECL_NAME(cl_concatenate), -1, OBJNULL},
{"CONCATENATED-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"CONCATENATED-STREAM-STREAMS", CL_ORDINARY, cl_concatenated_stream_streams, 1, OBJNULL},
{"COND", CL_FORM, NULL, -1, OBJNULL},
{"CONDITION", CL_ORDINARY, NULL, -1, OBJNULL},
{"CONJUGATE", CL_ORDINARY, cl_conjugate, 1, OBJNULL},
{"CONTINUE", CL_ORDINARY, NULL, -1, OBJNULL},
{"CONS", CL_ORDINARY, cl_cons, 2, OBJNULL},
{"CONSP", CL_ORDINARY, cl_consp, 1, OBJNULL},
{"CONSTANTLY", CL_ORDINARY, ECL_NAME(cl_constantly), 1, OBJNULL},
{"CONSTANTP", CL_ORDINARY, cl_constantp, -1, OBJNULL},
{"CONTROL-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"COPY-ALIST", CL_ORDINARY, cl_copy_alist, 1, OBJNULL},
{"COPY-LIST", CL_ORDINARY, cl_copy_list, 1, OBJNULL},
{"COPY-PPRINT-DISPATCH", CL_ORDINARY, ECL_NAME_PPRINT(cl_copy_pprint_dispatch), -1, OBJNULL},
{"COPY-READTABLE", CL_ORDINARY, cl_copy_readtable, -1, OBJNULL},
{"COPY-SEQ", CL_ORDINARY, cl_copy_seq, 1, OBJNULL},
{"COPY-STRUCTURE", CL_ORDINARY, cl_copy_structure, 1, OBJNULL},
{"COPY-SYMBOL", CL_ORDINARY, cl_copy_symbol, -1, OBJNULL},
{"COPY-TREE", CL_ORDINARY, cl_copy_tree, 1, OBJNULL},
{"COS", CL_ORDINARY, cl_cos, 1, OBJNULL},
{"COSH", CL_ORDINARY, cl_cosh, 1, OBJNULL},
{"COUNT", CL_ORDINARY, ECL_NAME(cl_count), -1, OBJNULL},
{"COUNT-IF", CL_ORDINARY, ECL_NAME(cl_count_if), -1, OBJNULL},
{"COUNT-IF-NOT", CL_ORDINARY, ECL_NAME(cl_count_if_not), -1, OBJNULL},
{"CTYPECASE", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEBUG", CL_ORDINARY, NULL, -1, OBJNULL},
{"DECF", CL_ORDINARY, NULL, -1, OBJNULL},
{"DECLAIM", CL_ORDINARY, NULL, -1, OBJNULL},
{"DECLARATION", CL_ORDINARY, NULL, -1, OBJNULL},
{"DECLARE", CL_ORDINARY, NULL, -1, OBJNULL},
{"DECODE-FLOAT", CL_ORDINARY, cl_decode_float, 1, OBJNULL},
{"DECODE-UNIVERSAL-TIME", CL_ORDINARY, ECL_NAME(cl_decode_universal_time), -1, OBJNULL},
{"DEFCONSTANT", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFINE-CONDITION", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFINE-COMPILER-MACRO", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFINE-MODIFY-MACRO", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFINE-SETF-EXPANDER", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFINE-SYMBOL-MACRO", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFMACRO", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFPACKAGE", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFPARAMETER", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFSETF", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFSTRUCT", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFTYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFUN", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFVAR", CL_ORDINARY, NULL, -1, OBJNULL},
{"DELETE", CL_ORDINARY, ECL_NAME(cl_delete), -1, OBJNULL},
{"DELETE-DUPLICATES", CL_ORDINARY, ECL_NAME(cl_delete_duplicates), -1, OBJNULL},
{"DELETE-FILE", CL_ORDINARY, cl_delete_file, 1, OBJNULL},
{"DELETE-IF", CL_ORDINARY, ECL_NAME(cl_delete_if), -1, OBJNULL},
{"DELETE-IF-NOT", CL_ORDINARY, ECL_NAME(cl_delete_if_not), -1, OBJNULL},
{"DELETE-PACKAGE", CL_ORDINARY, cl_delete_package, 1, OBJNULL},
{"DENOMINATOR", CL_ORDINARY, cl_denominator, 1, OBJNULL},
{"DEPOSIT-FIELD", CL_ORDINARY, ECL_NAME(cl_deposit_field), 3, OBJNULL},
{"DESCRIBE", CL_ORDINARY, NULL, -1, OBJNULL},
{"DESTRUCTURING-BIND", CL_ORDINARY, NULL, -1, OBJNULL},
{"DIGIT-CHAR", CL_ORDINARY, cl_digit_char, -1, OBJNULL},
{"DIGIT-CHAR-P", CL_ORDINARY, cl_digit_char_p, -1, OBJNULL},
{"DIRECTORY", CL_ORDINARY, cl_directory, -1, OBJNULL},
{"DIRECTORY-NAMESTRING", CL_ORDINARY, cl_directory_namestring, 1, OBJNULL},
{"DISASSEMBLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"DIVISION-BY-ZERO", CL_ORDINARY, NULL, -1, OBJNULL},
{"DO", CL_FORM, NULL, -1, OBJNULL},
{"DO*", CL_FORM, NULL, -1, OBJNULL},
{"DO-ALL-SYMBOLS", CL_ORDINARY, NULL, -1, OBJNULL},
{"DO-EXTERNAL-SYMBOLS", CL_ORDINARY, NULL, -1, OBJNULL},
{"DO-SYMBOLS", CL_ORDINARY, NULL, -1, OBJNULL},
{"DOCUMENTATION", CL_ORDINARY, NULL, -1, OBJNULL},
{"DOLIST", CL_FORM, NULL, -1, OBJNULL},
{"DOTIMES", CL_FORM, NULL, -1, OBJNULL},
{"DOUBLE-FLOAT", CL_ORDINARY, NULL, -1, OBJNULL},
{"DOUBLE-FLOAT-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"DOUBLE-FLOAT-NEGATIVE-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"DPB", CL_ORDINARY, ECL_NAME(cl_dpb), 3, OBJNULL},
{"DRIBBLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"DYNAMIC-EXTENT", CL_ORDINARY, NULL, -1, OBJNULL},
{"ECASE", CL_ORDINARY, NULL, -1, OBJNULL},
{"ECHO-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"ECHO-STREAM-INPUT-STREAM", CL_ORDINARY, cl_echo_stream_input_stream, 1, OBJNULL},
{"ECHO-STREAM-OUTPUT-STREAM", CL_ORDINARY, cl_echo_stream_output_stream, 1, OBJNULL},
{"ED", CL_ORDINARY, NULL, -1, OBJNULL},
{"EIGHTH", CL_ORDINARY, cl_eighth, 1, OBJNULL},
{"ELT", CL_ORDINARY, cl_elt, 2, OBJNULL},
{"ENCODE-UNIVERSAL-TIME", CL_ORDINARY, ECL_NAME(cl_encode_universal_time), -1, OBJNULL},
{"END-OF-FILE", CL_ORDINARY, NULL, -1, OBJNULL},
{"ENDP", CL_ORDINARY, cl_endp, 1, OBJNULL},
{"ENOUGH-NAMESTRING", CL_ORDINARY, cl_enough_namestring, -1, OBJNULL},
{"ENSURE-DIRECTORIES-EXIST", CL_ORDINARY, ECL_NAME(cl_ensure_directories_exist), -1, OBJNULL},
{"EQ", CL_ORDINARY, cl_eq, 2, OBJNULL},
{"EQL", CL_ORDINARY, cl_eql, 2, OBJNULL},
{"EQUAL", CL_ORDINARY, cl_equal, 2, OBJNULL},
{"EQUALP", CL_ORDINARY, cl_equalp, 2, OBJNULL},
{"ERROR", CL_ORDINARY, cl_error, -1, OBJNULL},
{"ETYPECASE", CL_ORDINARY, NULL, -1, OBJNULL},
{"EVAL", CL_ORDINARY, cl_eval, 1, OBJNULL},
{"EVAL-WHEN", CL_FORM, NULL, -1, OBJNULL},
{"EVENP", CL_ORDINARY, cl_evenp, 1, OBJNULL},
{"EVERY", CL_ORDINARY, ECL_NAME(cl_every), -1, OBJNULL},
{"EXP", CL_ORDINARY, cl_exp, 1, OBJNULL},
{"EXPORT", CL_ORDINARY, cl_export, -1, OBJNULL},
{"EXPT", CL_ORDINARY, cl_expt, 2, OBJNULL},
{"EXTENDED-CHAR", CL_ORDINARY, NULL, -1, OBJNULL},
{"FBOUNDP", CL_ORDINARY, cl_fboundp, 1, OBJNULL},
{"FCEILING", CL_ORDINARY, ECL_NAME(cl_fceiling), -1, OBJNULL},
{"FDEFINITION", CL_ORDINARY, cl_fdefinition, 1, OBJNULL},
{"FFLOOR", CL_ORDINARY, ECL_NAME(cl_ffloor), -1, OBJNULL},
{"FIFTH", CL_ORDINARY, cl_fifth, 1, OBJNULL},
{"FILE-AUTHOR", CL_ORDINARY, cl_file_author, 1, OBJNULL},
{"FILE-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"FILE-ERROR-PATHNAME", CL_ORDINARY, NULL, -1, OBJNULL},
{"FILE-LENGTH", CL_ORDINARY, cl_file_length, 1, OBJNULL},
{"FILE-NAMESTRING", CL_ORDINARY, cl_file_namestring, 1, OBJNULL},
{"FILE-POSITION", CL_ORDINARY, cl_file_position, -1, OBJNULL},
{"FILE-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"FILE-STRING-LENGTH", CL_ORDINARY, cl_file_string_length, 2, OBJNULL},
{"FILE-WRITE-DATE", CL_ORDINARY, cl_file_write_date, 1, OBJNULL},
{"FILL", CL_ORDINARY, ECL_NAME(cl_fill), -1, OBJNULL},
{"FILL-POINTER", CL_ORDINARY, cl_fill_pointer, 1, OBJNULL},
{"FIND", CL_ORDINARY, ECL_NAME(cl_find), -1, OBJNULL},
{"FIND-ALL-SYMBOLS", CL_ORDINARY, ECL_NAME(cl_find_all_symbols), 1, OBJNULL},
{"FIND-IF", CL_ORDINARY, ECL_NAME(cl_find_if), -1, OBJNULL},
{"FIND-IF-NOT", CL_ORDINARY, ECL_NAME(cl_find_if_not), -1, OBJNULL},
{"FIND-PACKAGE", CL_ORDINARY, cl_find_package, 1, OBJNULL},
{"FIND-RESTART", CL_ORDINARY, NULL, -1, OBJNULL},
{"FIND-SYMBOL", CL_ORDINARY, cl_find_symbol, -1, OBJNULL},
{"FINISH-OUTPUT", CL_ORDINARY, cl_finish_output, -1, OBJNULL},
{"FIRST", CL_ORDINARY, cl_car, 1, OBJNULL},
{"FIXNUM", CL_ORDINARY, NULL, -1, OBJNULL},
{"FLET", CL_FORM, NULL, -1, OBJNULL},
{"FLOAT", CL_ORDINARY, cl_float, -1, OBJNULL},
{"FLOAT-DIGITS", CL_ORDINARY, cl_float_digits, 1, OBJNULL},
{"FLOAT-PRECISION", CL_ORDINARY, cl_float_precision, 1, OBJNULL},
{"FLOAT-RADIX", CL_ORDINARY, cl_float_radix, 1, OBJNULL},
{"FLOAT-SIGN", CL_ORDINARY, cl_float_sign, -1, OBJNULL},
{"FLOATING-POINT-INEXACT", CL_ORDINARY, NULL, -1, OBJNULL},
{"FLOATING-POINT-INVALID-OPERATION", CL_ORDINARY, NULL, -1, OBJNULL},
{"FLOATING-POINT-OVERFLOW", CL_ORDINARY, NULL, -1, OBJNULL},
{"FLOATING-POINT-UNDERFLOW", CL_ORDINARY, NULL, -1, OBJNULL},
{"FLOATP", CL_ORDINARY, cl_floatp, 1, OBJNULL},
{"FLOOR", CL_ORDINARY, cl_floor, -1, OBJNULL},
{"FMAKUNBOUND", CL_ORDINARY, cl_fmakunbound, 1, OBJNULL},
{"FORCE-OUTPUT", CL_ORDINARY, cl_force_output, -1, OBJNULL},
{"FORMAT", CL_ORDINARY, cl_format, -1, OBJNULL},
{"FORMATTER", CL_ORDINARY, NULL, -1, OBJNULL},
{"FOURTH", CL_ORDINARY, cl_cadddr, 1, OBJNULL},
{"FRESH-LINE", CL_ORDINARY, cl_fresh_line, -1, OBJNULL},
{"FROUND", CL_ORDINARY, ECL_NAME(cl_fround), -1, OBJNULL},
{"FTRUNCATE", CL_ORDINARY, ECL_NAME(cl_ftruncate), -1, OBJNULL},
{"FTYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"FUNCALL", CL_ORDINARY, cl_funcall, -1, OBJNULL},
{"FUNCTION-LAMBDA-EXPRESSION", CL_ORDINARY, cl_function_lambda_expression, 1, OBJNULL},
{"FUNCTION", CL_FORM, NULL, -1, OBJNULL},
{"FUNCTION-KEYWORDS", CL_ORDINARY, NULL, -1, OBJNULL},
{"FUNCTIONP", CL_ORDINARY, cl_functionp, 1, OBJNULL},
{"GCD", CL_ORDINARY, cl_gcd, -1, OBJNULL},
{"GENSYM", CL_ORDINARY, cl_gensym, -1, OBJNULL},
{"GENTEMP", CL_ORDINARY, cl_gentemp, -1, OBJNULL},
{"GET", CL_ORDINARY, cl_get, -1, OBJNULL},
{"GET-DECODED-TIME", CL_ORDINARY, ECL_NAME(cl_get_decoded_time), 0, OBJNULL},
{"GET-DISPATCH-MACRO-CHARACTER", CL_ORDINARY, cl_get_dispatch_macro_character, -1, OBJNULL},
{"GET-INTERNAL-REAL-TIME", CL_ORDINARY, cl_get_internal_real_time, 0, OBJNULL},
{"GET-INTERNAL-RUN-TIME", CL_ORDINARY, cl_get_internal_run_time, 0, OBJNULL},
{"GET-MACRO-CHARACTER", CL_ORDINARY, cl_get_macro_character, -1, OBJNULL},
{"GET-OUTPUT-STREAM-STRING", CL_ORDINARY, cl_get_output_stream_string, 1, OBJNULL},
{"GET-PROPERTIES", CL_ORDINARY, cl_get_properties, 2, OBJNULL},
{"GET-SETF-EXPANSION", CL_ORDINARY, NULL, -1, OBJNULL},
{"GET-UNIVERSAL-TIME", CL_ORDINARY, cl_get_universal_time, 0, OBJNULL},
{"GETF", CL_ORDINARY, cl_getf, -1, OBJNULL},
{"GETHASH", CL_ORDINARY, cl_gethash, -1, OBJNULL},
{"GO", CL_FORM, NULL, -1, OBJNULL},
{"GRAPHIC-CHAR-P", CL_ORDINARY, cl_graphic_char_p, 1, OBJNULL},
{"HANDLER-CASE", CL_ORDINARY, NULL, -1, OBJNULL},
{"HANDLER-BIND", CL_ORDINARY, NULL, -1, OBJNULL},
{"HASH-TABLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"HASH-TABLE-COUNT", CL_ORDINARY, cl_hash_table_count, 1, OBJNULL},
{"HASH-TABLE-P", CL_ORDINARY, cl_hash_table_p, 1, OBJNULL},
{"HASH-TABLE-REHASH-SIZE", CL_ORDINARY, cl_hash_table_rehash_size, 1, OBJNULL},
{"HASH-TABLE-REHASH-THRESHOLD", CL_ORDINARY, cl_hash_table_rehash_threshold, 1, OBJNULL},
{"HASH-TABLE-SIZE", CL_ORDINARY, cl_hash_table_size, 1, OBJNULL},
{"HASH-TABLE-TEST", CL_ORDINARY, cl_hash_table_test, 1, OBJNULL},
{"HOST-NAMESTRING", CL_ORDINARY, cl_host_namestring, 1, OBJNULL},
{"IDENTITY", CL_ORDINARY, cl_identity, 1, OBJNULL},
{"IGNORABLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"IGNORE", CL_ORDINARY, NULL, -1, OBJNULL},
{"IGNORE-ERRORS", CL_ORDINARY, NULL, -1, OBJNULL},
{"IMAGPART", CL_ORDINARY, cl_imagpart, 1, OBJNULL},
{"IMPORT", CL_ORDINARY, cl_import, -1, OBJNULL},
{"IN-PACKAGE", CL_ORDINARY, NULL, -1, OBJNULL},
{"INCF", CL_ORDINARY, NULL, -1, OBJNULL},
{"INLINE", CL_ORDINARY, NULL, -1, OBJNULL},
{"INPUT-STREAM-P", CL_ORDINARY, cl_input_stream_p, 1, OBJNULL},
{"INSPECT", CL_ORDINARY, NULL, -1, OBJNULL},
{"INTEGER", CL_ORDINARY, NULL, -1, OBJNULL},
{"INTEGER-DECODE-FLOAT", CL_ORDINARY, cl_integer_decode_float, 1, OBJNULL},
{"INTEGER-LENGTH", CL_ORDINARY, cl_integer_length, 1, OBJNULL},
{"INTEGERP", CL_ORDINARY, cl_integerp, 1, OBJNULL},
{"INTERACTIVE-STREAM-P", CL_ORDINARY, cl_interactive_stream_p, 1, OBJNULL},
{"INTERN", CL_ORDINARY, cl_intern, -1, OBJNULL},
{"INTERNAL-TIME-UNITS-PER-SECOND", CL_CONSTANT, NULL, -1, OBJNULL},
{"INTERSECTION", CL_ORDINARY, ECL_NAME(cl_intersection), -1, OBJNULL},
{"INVOKE-DEBUGGER", CL_ORDINARY, NULL, -1, OBJNULL},
{"INVOKE-RESTART", CL_ORDINARY, NULL, -1, OBJNULL},
{"INVOKE-RESTART-INTERACTIVELY", CL_ORDINARY, NULL, -1, OBJNULL},
{"ISQRT", CL_ORDINARY, ECL_NAME(cl_isqrt), 1, OBJNULL},
{"KEYWORD", CL_ORDINARY, NULL, -1, OBJNULL},
{"KEYWORDP", CL_ORDINARY, cl_keywordp, 1, OBJNULL},
{"LABELS", CL_FORM, NULL, -1, OBJNULL},
{"LAMBDA", CL_FORM, NULL, -1, OBJNULL},
{"LAMBDA-LIST-KEYWORDS", CL_CONSTANT, NULL, -1, OBJNULL},
{"LAMBDA-PARAMETERS-LIMIT", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(LAMBDA_PARAMETERS_LIMIT)},
{"LAST", CL_ORDINARY, cl_last, -1, OBJNULL},
{"LCM", CL_ORDINARY, cl_lcm, -1, OBJNULL},
{"LDB", CL_ORDINARY, ECL_NAME(cl_ldb), 2, OBJNULL},
{"LDB-TEST", CL_ORDINARY, ECL_NAME(cl_ldb_test), 2, OBJNULL},
{"LDIFF", CL_ORDINARY, cl_ldiff, 2, OBJNULL},
{"LEAST-NEGATIVE-DOUBLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-NEGATIVE-LONG-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-NEGATIVE-SHORT-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-NEGATIVE-SINGLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-DOUBLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-LONG-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-NORMALIZED-LONG-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-SHORT-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LEAST-POSITIVE-SINGLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"LENGTH", CL_ORDINARY, cl_length, 1, OBJNULL},
{"LET", CL_FORM, NULL, -1, OBJNULL},
{"LET*", CL_FORM, NULL, -1, OBJNULL},
{"LISP-IMPLEMENTATION-TYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"LISP-IMPLEMENTATION-VERSION", CL_ORDINARY, NULL, -1, OBJNULL},
{"LIST", CL_ORDINARY, cl_list, -1, OBJNULL},
{"LIST*", CL_ORDINARY, cl_listX, -1, OBJNULL},
{"LIST-ALL-PACKAGES", CL_ORDINARY, cl_list_all_packages, 0, OBJNULL},
{"LIST-LENGTH", CL_ORDINARY, cl_list_length, 1, OBJNULL},
{"LISTEN", CL_ORDINARY, cl_listen, -1, OBJNULL},
{"LISTP", CL_ORDINARY, cl_listp, 1, OBJNULL},
{"LOAD", CL_ORDINARY, cl_load, -1, OBJNULL},
{"LOAD-LOGICAL-PATHNAME-TRANSLATIONS", CL_ORDINARY, ECL_NAME(cl_load_logical_pathname_translations), 1, OBJNULL},
{"LOAD-TIME-VALUE", CL_FORM, NULL, -1, OBJNULL},
{"LOCALLY", CL_FORM, NULL, -1, OBJNULL},
{"LOG", CL_ORDINARY, cl_log, -1, OBJNULL},
{"LOGAND", CL_ORDINARY, cl_logand, -1, OBJNULL},
{"LOGANDC1", CL_ORDINARY, cl_logandc1, 2, OBJNULL},
{"LOGANDC2", CL_ORDINARY, cl_logandc2, 2, OBJNULL},
{"LOGBITP", CL_ORDINARY, cl_logbitp, 2, OBJNULL},
{"LOGCOUNT", CL_ORDINARY, cl_logcount, 1, OBJNULL},
{"LOGEQV", CL_ORDINARY, cl_logeqv, -1, OBJNULL},
{"LOGICAL-PATHNAME", CL_ORDINARY, cl_logical_pathname, 1, OBJNULL},
{"LOGICAL-PATHNAME-TRANSLATIONS", CL_ORDINARY, ECL_NAME(cl_logical_pathname_translations), 1, OBJNULL},
{"LOGIOR", CL_ORDINARY, cl_logior, -1, OBJNULL},
{"LOGNAND", CL_ORDINARY, cl_lognand, 2, OBJNULL},
{"LOGNOR", CL_ORDINARY, cl_lognor, 2, OBJNULL},
{"LOGNOT", CL_ORDINARY, cl_lognot, 1, OBJNULL},
{"LOGORC1", CL_ORDINARY, cl_logorc1, 2, OBJNULL},
{"LOGORC2", CL_ORDINARY, cl_logorc2, 2, OBJNULL},
{"LOGTEST", CL_ORDINARY, ECL_NAME(cl_logtest), 2, OBJNULL},
{"LOGXOR", CL_ORDINARY, cl_logxor, -1, OBJNULL},
{"LONG-FLOAT", CL_ORDINARY, NULL, -1, OBJNULL},
{"LONG-FLOAT-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"LONG-FLOAT-NEGATIVE-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"LONG-SITE-NAME", CL_ORDINARY, NULL, -1, OBJNULL},
{"LOOP", CL_ORDINARY, NULL, -1, OBJNULL},
{"LOOP-FINISH", CL_ORDINARY, NULL, -1, OBJNULL},
{"LOWER-CASE-P", CL_ORDINARY, cl_lower_case_p, 1, OBJNULL},
{"MACHINE-INSTANCE", CL_ORDINARY, NULL, -1, OBJNULL},
{"MACHINE-TYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"MACHINE-VERSION", CL_ORDINARY, NULL, -1, OBJNULL},
{"MACRO-FUNCTION", CL_ORDINARY, cl_macro_function, -1, OBJNULL},
{"MACROEXPAND", CL_ORDINARY, cl_macroexpand, -1, OBJNULL},
{"MACROEXPAND-1", CL_ORDINARY, cl_macroexpand_1, -1, OBJNULL},
{"MACROLET", CL_FORM, NULL, -1, OBJNULL},
{"MAKE-ARRAY", CL_ORDINARY, ECL_NAME(cl_make_array), -1, OBJNULL},
{"MAKE-BROADCAST-STREAM", CL_ORDINARY, cl_make_broadcast_stream, -1, OBJNULL},
{"MAKE-CONDITION", CL_ORDINARY, NULL, -1, OBJNULL},
{"MAKE-CONCATENATED-STREAM", CL_ORDINARY, cl_make_concatenated_stream, -1, OBJNULL},
{"MAKE-DISPATCH-MACRO-CHARACTER", CL_ORDINARY, cl_make_dispatch_macro_character, -1, OBJNULL},
{"MAKE-ECHO-STREAM", CL_ORDINARY, cl_make_echo_stream, 2, OBJNULL},
{"MAKE-HASH-TABLE", CL_ORDINARY, cl_make_hash_table, -1, OBJNULL},
{"MAKE-LIST", CL_ORDINARY, cl_make_list, -1, OBJNULL},
{"MAKE-PACKAGE", CL_ORDINARY, cl_make_package, -1, OBJNULL},
{"MAKE-PATHNAME", CL_ORDINARY, cl_make_pathname, -1, OBJNULL},
{"MAKE-RANDOM-STATE", CL_ORDINARY, cl_make_random_state, -1, OBJNULL},
{"MAKE-SEQUENCE", CL_ORDINARY, ECL_NAME(cl_make_sequence), -1, OBJNULL},
{"MAKE-STRING", CL_ORDINARY, cl_make_string, -1, OBJNULL},
{"MAKE-STRING-INPUT-STREAM", CL_ORDINARY, cl_make_string_input_stream, -1, OBJNULL},
{"MAKE-STRING-OUTPUT-STREAM", CL_ORDINARY, cl_make_string_output_stream, -1, OBJNULL},
{"MAKE-SYMBOL", CL_ORDINARY, cl_make_symbol, 1, OBJNULL},
{"MAKE-SYNONYM-STREAM", CL_ORDINARY, cl_make_synonym_stream, 1, OBJNULL},
{"MAKE-TWO-WAY-STREAM", CL_ORDINARY, cl_make_two_way_stream, 2, OBJNULL},
{"MAKUNBOUND", CL_ORDINARY, cl_makunbound, 1, OBJNULL},
{"MAP", CL_ORDINARY, ECL_NAME(cl_map), -1, OBJNULL},
{"MAP-INTO", CL_ORDINARY, ECL_NAME(cl_map_into), -1, OBJNULL},
{"MAPC", CL_ORDINARY, cl_mapc, -1, OBJNULL},
{"MAPCAN", CL_ORDINARY, cl_mapcan, -1, OBJNULL},
{"MAPCAR", CL_ORDINARY, cl_mapcar, -1, OBJNULL},
{"MAPCON", CL_ORDINARY, cl_mapcon, -1, OBJNULL},
{"MAPHASH", CL_ORDINARY, cl_maphash, 2, OBJNULL},
{"MAPL", CL_ORDINARY, cl_mapl, -1, OBJNULL},
{"MAPLIST", CL_ORDINARY, cl_maplist, -1, OBJNULL},
{"MASK-FIELD", CL_ORDINARY, ECL_NAME(cl_mask_field), 2, OBJNULL},
{"MAX", CL_ORDINARY, cl_max, -1, OBJNULL},
{"MEMBER", CL_ORDINARY, cl_member, -1, OBJNULL},
{"MEMBER-IF", CL_ORDINARY, ECL_NAME(cl_member_if), -1, OBJNULL},
{"MEMBER-IF-NOT", CL_ORDINARY, ECL_NAME(cl_member_if_not), -1, OBJNULL},
{"MERGE", CL_ORDINARY, ECL_NAME(cl_merge), -1, OBJNULL},
{"MERGE-PATHNAMES", CL_ORDINARY, cl_merge_pathnames, -1, OBJNULL},
{"MIN", CL_ORDINARY, cl_min, -1, OBJNULL},
{"MINUSP", CL_ORDINARY, cl_minusp, 1, OBJNULL},
{"MISMATCH", CL_ORDINARY, ECL_NAME(cl_mismatch), -1, OBJNULL},
{"MOD", CL_ORDINARY, cl_mod, 2, OBJNULL},
{"MOST-NEGATIVE-DOUBLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MOST-NEGATIVE-FIXNUM", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(MOST_NEGATIVE_FIXNUM)},
{"MOST-NEGATIVE-LONG-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MOST-NEGATIVE-SHORT-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MOST-NEGATIVE-SINGLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MOST-POSITIVE-DOUBLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MOST-POSITIVE-FIXNUM", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(MOST_POSITIVE_FIXNUM)},
{"MOST-POSITIVE-LONG-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MOST-POSITIVE-SHORT-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MOST-POSITIVE-SINGLE-FLOAT", CL_CONSTANT, NULL, -1, OBJNULL},
{"MUFFLE-WARNING", CL_ORDINARY, NULL, -1, OBJNULL},
{"MULTIPLE-VALUE-BIND", CL_FORM, NULL, -1, OBJNULL},
{"MULTIPLE-VALUE-CALL", CL_FORM, NULL, -1, OBJNULL},
{"MULTIPLE-VALUE-LIST", CL_FORM, NULL, -1, OBJNULL},
{"MULTIPLE-VALUE-PROG1", CL_FORM, NULL, -1, OBJNULL},
{"MULTIPLE-VALUE-SETQ", CL_FORM, NULL, -1, OBJNULL},
{"MULTIPLE-VALUES-LIMIT", CL_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_MULTIPLE_VALUES_LIMIT)},
{"NAME-CHAR", CL_ORDINARY, cl_name_char, 1, OBJNULL},
{"NAMESTRING", CL_ORDINARY, cl_namestring, 1, OBJNULL},
{"NBUTLAST", CL_ORDINARY, cl_nbutlast, -1, OBJNULL},
{"NCONC", CL_ORDINARY, cl_nconc, -1, OBJNULL},
{"NINTERSECTION", CL_ORDINARY, ECL_NAME(cl_nintersection), -1, OBJNULL},
{"NINTH", CL_ORDINARY, cl_ninth, 1, OBJNULL},
{"NOT", CL_ORDINARY, cl_not, 1, OBJNULL},
{"NOTANY", CL_ORDINARY, ECL_NAME(cl_notany), -1, OBJNULL},
{"NOTEVERY", CL_ORDINARY, ECL_NAME(cl_notevery), -1, OBJNULL},
{"NOTINLINE", CL_ORDINARY, NULL, -1, OBJNULL},
{"NRECONC", CL_ORDINARY, cl_nreconc, 2, OBJNULL},
{"NREVERSE", CL_ORDINARY, cl_nreverse, 1, OBJNULL},
{"NSET-DIFFERENCE", CL_ORDINARY, ECL_NAME(cl_nset_difference), -1, OBJNULL},
{"NSET-EXCLUSIVE-OR", CL_ORDINARY, ECL_NAME(cl_nset_exclusive_or), -1, OBJNULL},
{"NSTRING-CAPITALIZE", CL_ORDINARY, cl_nstring_capitalize, -1, OBJNULL},
{"NSTRING-DOWNCASE", CL_ORDINARY, cl_nstring_downcase, -1, OBJNULL},
{"NSTRING-UPCASE", CL_ORDINARY, cl_nstring_upcase, -1, OBJNULL},
{"NSUBLIS", CL_ORDINARY, cl_nsublis, -1, OBJNULL},
{"NSUBST", CL_ORDINARY, cl_nsubst, -1, OBJNULL},
{"NSUBST-IF", CL_ORDINARY, ECL_NAME(cl_nsubst_if), -1, OBJNULL},
{"NSUBST-IF-NOT", CL_ORDINARY, ECL_NAME(cl_nsubst_if_not), -1, OBJNULL},
{"NSUBSTITUTE", CL_ORDINARY, ECL_NAME(cl_nsubstitute), -1, OBJNULL},
{"NSUBSTITUTE-IF", CL_ORDINARY, ECL_NAME(cl_nsubstitute_if), -1, OBJNULL},
{"NSUBSTITUTE-IF-NOT", CL_ORDINARY, ECL_NAME(cl_nsubstitute_if_not), -1, OBJNULL},
{"NTH", CL_ORDINARY, cl_nth, 2, OBJNULL},
{"NTH-VALUE", CL_FORM, NULL, -1, OBJNULL},
{"NTHCDR", CL_ORDINARY, cl_nthcdr, 2, OBJNULL},
{"NULL", CL_ORDINARY, cl_null, 1, OBJNULL},
{"NUMBER", CL_ORDINARY, NULL, -1, OBJNULL},
{"NUMBERP", CL_ORDINARY, cl_numberp, 1, OBJNULL},
{"NUMERATOR", CL_ORDINARY, cl_numerator, 1, OBJNULL},
{"NUNION", CL_ORDINARY, ECL_NAME(cl_nunion), -1, OBJNULL},
{"ODDP", CL_ORDINARY, cl_oddp, 1, OBJNULL},
{"OPEN", CL_ORDINARY, cl_open, -1, OBJNULL},
{"OPEN-STREAM-P", CL_ORDINARY, cl_open_stream_p, 1, OBJNULL},
{"OPTIMIZE", CL_ORDINARY, NULL, -1, OBJNULL},
{"OR", CL_ORDINARY, NULL, -1, OBJNULL},
{"OTHERWISE", CL_ORDINARY, NULL, -1, OBJNULL},
{"OUTPUT-STREAM-P", CL_ORDINARY, cl_output_stream_p, 1, OBJNULL},
{"PACKAGE", CL_ORDINARY, NULL, -1, OBJNULL},
{"PACKAGE-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"PACKAGE-ERROR-PACKAGE", CL_ORDINARY, NULL, -1, OBJNULL},
{"PACKAGE-NAME", CL_ORDINARY, cl_package_name, 1, OBJNULL},
{"PACKAGE-NICKNAMES", CL_ORDINARY, cl_package_nicknames, 1, OBJNULL},
{"PACKAGE-SHADOWING-SYMBOLS", CL_ORDINARY, cl_package_shadowing_symbols, 1, OBJNULL},
{"PACKAGE-USE-LIST", CL_ORDINARY, cl_package_use_list, 1, OBJNULL},
{"PACKAGE-USED-BY-LIST", CL_ORDINARY, cl_package_used_by_list, 1, OBJNULL},
{"PACKAGEP", CL_ORDINARY, cl_packagep, 1, OBJNULL},
{"PAIRLIS", CL_ORDINARY, cl_pairlis, -1, OBJNULL},
{"PARSE-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"PARSE-INTEGER", CL_ORDINARY, cl_parse_integer, -1, OBJNULL},
{"PARSE-NAMESTRING", CL_ORDINARY, cl_parse_namestring, -1, OBJNULL},
{"PATHNAME", CL_ORDINARY, cl_pathname, 1, OBJNULL},
{"PATHNAME-DEVICE", CL_ORDINARY, cl_pathname_device, -1, OBJNULL},
{"PATHNAME-DIRECTORY", CL_ORDINARY, cl_pathname_directory, -1, OBJNULL},
{"PATHNAME-HOST", CL_ORDINARY, cl_pathname_host, -1, OBJNULL},
{"PATHNAME-MATCH-P", CL_ORDINARY, cl_pathname_match_p, 2, OBJNULL},
{"PATHNAME-NAME", CL_ORDINARY, cl_pathname_name, -1, OBJNULL},
{"PATHNAME-TYPE", CL_ORDINARY, cl_pathname_type, -1, OBJNULL},
{"PATHNAME-VERSION", CL_ORDINARY, cl_pathname_version, 1, OBJNULL},
{"PATHNAMEP", CL_ORDINARY, cl_pathnamep, 1, OBJNULL},
{"PEEK-CHAR", CL_ORDINARY, cl_peek_char, -1, OBJNULL},
{"PHASE", CL_ORDINARY, ECL_NAME(cl_phase), 1, OBJNULL},
{"PI", CL_CONSTANT, NULL, -1, OBJNULL},
{"PLUSP", CL_ORDINARY, cl_plusp, 1, OBJNULL},
{"POP", CL_ORDINARY, NULL, -1, OBJNULL},
{"POSITION", CL_ORDINARY, ECL_NAME(cl_position), -1, OBJNULL},
{"POSITION-IF", CL_ORDINARY, ECL_NAME(cl_position_if), -1, OBJNULL},
{"POSITION-IF-NOT", CL_ORDINARY, ECL_NAME(cl_position_if_not), -1, OBJNULL},
{"PPRINT", CL_ORDINARY, cl_pprint, -1, OBJNULL},
{"PPRINT-DISPATCH", CL_ORDINARY, ECL_NAME_PPRINT(cl_pprint_dispatch), -1, OBJNULL},
{"PPRINT-EXIT-IF-LIST-EXHAUSTED", CL_ORDINARY, NULL, -1, OBJNULL},
{"PPRINT-FILL", CL_ORDINARY, ECL_NAME_PPRINT(cl_pprint_fill), -1, OBJNULL},
{"PPRINT-INDENT", CL_ORDINARY, ECL_NAME_PPRINT(cl_pprint_indent), -1, OBJNULL},
{"PPRINT-LINEAR", CL_ORDINARY, ECL_NAME_PPRINT(cl_pprint_linear), -1, OBJNULL},
{"PPRINT-LOGICAL-BLOCK", CL_ORDINARY, NULL, -1, OBJNULL},
{"PPRINT-NEWLINE", CL_ORDINARY, ECL_NAME_PPRINT(cl_pprint_newline), -1, OBJNULL},
{"PPRINT-POP", CL_ORDINARY, NULL, -1, OBJNULL},
{"PPRINT-TAB", CL_ORDINARY, ECL_NAME_PPRINT(cl_pprint_tab), -1, OBJNULL},
{"PPRINT-TABULAR", CL_ORDINARY, ECL_NAME_PPRINT(cl_pprint_tabular), -1, OBJNULL},
{"PRIN1", CL_ORDINARY, cl_prin1, -1, OBJNULL},
{"PRIN1-TO-STRING", CL_ORDINARY, ECL_NAME(cl_prin1_to_string), 1, OBJNULL},
{"PRINC", CL_ORDINARY, cl_princ, -1, OBJNULL},
{"PRINC-TO-STRING", CL_ORDINARY, ECL_NAME(cl_princ_to_string), 1, OBJNULL},
{"PRINT", CL_ORDINARY, cl_print, -1, OBJNULL},
{"PRINT-NOT-READABLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"PRINT-NOT-READABLE-OBJECT", CL_ORDINARY, NULL, -1, OBJNULL},
{"PROBE-FILE", CL_ORDINARY, cl_probe_file, 1, OBJNULL},
{"PROCLAIM", CL_ORDINARY, NULL, -1, OBJNULL},
{"PROG", CL_FORM, NULL, -1, OBJNULL},
{"PROG*", CL_FORM, NULL, -1, OBJNULL},
{"PROG1", CL_FORM, NULL, -1, OBJNULL},
{"PROG2", CL_FORM, NULL, -1, OBJNULL},
{"PROGN", CL_FORM, NULL, -1, OBJNULL},
{"PROGRAM-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"PROGV", CL_FORM, NULL, -1, OBJNULL},
{"PROVIDE", CL_ORDINARY, ECL_NAME(cl_provide), 1, OBJNULL},
{"PSETF", CL_ORDINARY, NULL, -1, OBJNULL},
{"PSETQ", CL_FORM, NULL, -1, OBJNULL},
{"PUSH", CL_ORDINARY, NULL, -1, OBJNULL},
{"PUSHNEW", CL_ORDINARY, NULL, -1, OBJNULL},
{"QUOTE", CL_FORM, NULL, -1, OBJNULL},
{"RANDOM", CL_ORDINARY, cl_random, -1, OBJNULL},
{"RANDOM-STATE", CL_ORDINARY, NULL, -1, OBJNULL},
{"RANDOM-STATE-P", CL_ORDINARY, cl_random_state_p, 1, OBJNULL},
{"RASSOC", CL_ORDINARY, cl_rassoc, -1, OBJNULL},
{"RASSOC-IF", CL_ORDINARY, ECL_NAME(cl_rassoc_if), -1, OBJNULL},
{"RASSOC-IF-NOT", CL_ORDINARY, ECL_NAME(cl_rassoc_if_not), -1, OBJNULL},
{"RATIO", CL_ORDINARY, NULL, -1, OBJNULL},
{"RATIONAL", CL_ORDINARY, cl_rational, 1, OBJNULL},
{"RATIONALIZE", CL_ORDINARY, cl_rationalize, 1, OBJNULL},
{"RATIONALP", CL_ORDINARY, cl_rationalp, 1, OBJNULL},
{"READ", CL_ORDINARY, cl_read, -1, OBJNULL},
{"READ-BYTE", CL_ORDINARY, cl_read_byte, -1, OBJNULL},
{"READ-CHAR", CL_ORDINARY, cl_read_char, -1, OBJNULL},
{"READ-CHAR-NO-HANG", CL_ORDINARY, cl_read_char_no_hang, -1, OBJNULL},
{"READ-DELIMITED-LIST", CL_ORDINARY, cl_read_delimited_list, -1, OBJNULL},
{"READ-FROM-STRING", CL_ORDINARY, ECL_NAME(cl_read_from_string), -1, OBJNULL},
{"READ-LINE", CL_ORDINARY, cl_read_line, -1, OBJNULL},
{"READ-PRESERVING-WHITESPACE", CL_ORDINARY, cl_read_preserving_whitespace, -1, OBJNULL},
{"READ-SEQUENCE", CL_ORDINARY, cl_read_sequence, -1, OBJNULL},
{"READER-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"READTABLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"READTABLE-CASE", CL_ORDINARY, cl_readtable_case, 1, OBJNULL},
{"READTABLEP", CL_ORDINARY, cl_readtablep, 1, OBJNULL},
{"REAL", CL_ORDINARY, NULL, -1, OBJNULL},
{"REALP", CL_ORDINARY, cl_realp, 1, OBJNULL},
{"REALPART", CL_ORDINARY, cl_realpart, 1, OBJNULL},
{"REDUCE", CL_ORDINARY, ECL_NAME(cl_reduce), -1, OBJNULL},
{"REM", CL_ORDINARY, cl_rem, 2, OBJNULL},
{"REMF", CL_ORDINARY, NULL, -1, OBJNULL},
{"REMHASH", CL_ORDINARY, cl_remhash, 2, OBJNULL},
{"REMOVE", CL_ORDINARY, ECL_NAME(cl_remove), -1, OBJNULL},
{"REMOVE-DUPLICATES", CL_ORDINARY, ECL_NAME(cl_remove_duplicates), -1, OBJNULL},
{"REMOVE-IF", CL_ORDINARY, ECL_NAME(cl_remove_if), -1, OBJNULL},
{"REMOVE-IF-NOT", CL_ORDINARY, ECL_NAME(cl_remove_if_not), -1, OBJNULL},
{"REMPROP", CL_ORDINARY, cl_remprop, 2, OBJNULL},
{"RENAME-FILE", CL_ORDINARY, cl_rename_file, -1, OBJNULL},
{"RENAME-PACKAGE", CL_ORDINARY, cl_rename_package, -1, OBJNULL},
{"REPLACE", CL_ORDINARY, ECL_NAME(cl_replace), -1, OBJNULL},
{"REQUIRE", CL_ORDINARY, ECL_NAME(cl_require), -1, OBJNULL},
{"REST", CL_ORDINARY, cl_cdr, 1, OBJNULL},
{"RESTART", CL_ORDINARY, NULL, 1, OBJNULL},
{"RESTART-BIND", CL_ORDINARY, NULL, 1, OBJNULL},
{"RESTART-CASE", CL_ORDINARY, NULL, 1, OBJNULL},
{"RESTART-NAME", CL_ORDINARY, NULL, 1, OBJNULL},
{"RETURN", CL_FORM, NULL, -1, OBJNULL},
{"RETURN-FROM", CL_FORM, NULL, -1, OBJNULL},
{"REVAPPEND", CL_ORDINARY, cl_revappend, 2, OBJNULL},
{"REVERSE", CL_ORDINARY, cl_reverse, 1, OBJNULL},
{"ROOM", CL_ORDINARY, NULL, -1, OBJNULL},
{"ROTATEF", CL_ORDINARY, NULL, -1, OBJNULL},
{"ROUND", CL_ORDINARY, cl_round, -1, OBJNULL},
{"ROW-MAJOR-AREF", CL_ORDINARY, cl_row_major_aref, 2, OBJNULL},
{"RPLACA", CL_ORDINARY, cl_rplaca, 2, OBJNULL},
{"RPLACD", CL_ORDINARY, cl_rplacd, 2, OBJNULL},
{"SAFETY", CL_ORDINARY, NULL, -1, OBJNULL},
{"SATISFIES", CL_ORDINARY, NULL, -1, OBJNULL},
{"SBIT", CL_ORDINARY, ECL_NAME(cl_sbit), -1, OBJNULL},
{"SCALE-FLOAT", CL_ORDINARY, cl_scale_float, 2, OBJNULL},
{"SCHAR", CL_ORDINARY, cl_char, 2, OBJNULL},
{"SEARCH", CL_ORDINARY, ECL_NAME(cl_search), -1, OBJNULL},
{"SECOND", CL_ORDINARY, cl_cadr, 1, OBJNULL},
{"SEQUENCE", CL_ORDINARY, NULL, -1, OBJNULL},
{"SERIOUS-CONDITION", CL_ORDINARY, NULL, -1, OBJNULL},
{"SET", CL_ORDINARY, cl_set, 2, OBJNULL},
{"SET-DIFFERENCE", CL_ORDINARY, ECL_NAME(cl_set_difference), -1, OBJNULL},
{"SET-DISPATCH-MACRO-CHARACTER", CL_ORDINARY, cl_set_dispatch_macro_character, -1, OBJNULL},
{"SET-EXCLUSIVE-OR", CL_ORDINARY, ECL_NAME(cl_set_exclusive_or), -1, OBJNULL},
{"SET-MACRO-CHARACTER", CL_ORDINARY, cl_set_macro_character, -1, OBJNULL},
{"SET-PPRINT-DISPATCH", CL_ORDINARY, ECL_NAME_PPRINT(cl_set_pprint_dispatch), -1, OBJNULL},
{"SET-SYNTAX-FROM-CHAR", CL_ORDINARY, cl_set_syntax_from_char, -1, OBJNULL},
{"SETF", CL_ORDINARY, NULL, -1, OBJNULL},
{"SETQ", CL_FORM, NULL, -1, OBJNULL},
{"SEVENTH", CL_ORDINARY, cl_seventh, 1, OBJNULL},
{"SHADOW", CL_ORDINARY, cl_shadow, -1, OBJNULL},
{"SHADOWING-IMPORT", CL_ORDINARY, cl_shadowing_import, -1, OBJNULL},
{"SHIFTF", CL_ORDINARY, NULL, -1, OBJNULL},
{"SHORT-FLOAT", CL_ORDINARY, NULL, -1, OBJNULL},
{"SHORT-FLOAT-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"SHORT-FLOAT-NEGATIVE-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"SHORT-SITE-NAME", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIGNAL", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIGNED-BYTE", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIGNUM", CL_ORDINARY, ECL_NAME(cl_signum), 1, OBJNULL},
{"SIMPLE-ARRAY", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-BASE-STRING", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-BIT-VECTOR", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-BIT-VECTOR-P", CL_ORDINARY, cl_simple_bit_vector_p, 1, OBJNULL},
{"SIMPLE-CONDITION", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-CONDITION-FORMAT-CONTROL", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-CONDITION-FORMAT-ARGUMENTS", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-STRING", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-STRING-P", CL_ORDINARY, cl_simple_string_p, 1, OBJNULL},
{"SIMPLE-TYPE-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-VECTOR", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIMPLE-VECTOR-P", CL_ORDINARY, cl_simple_vector_p, 1, OBJNULL},
{"SIMPLE-WARNING", CL_ORDINARY, NULL, -1, OBJNULL},
{"SIN", CL_ORDINARY, cl_sin, 1, OBJNULL},
{"SINGLE-FLOAT", CL_ORDINARY, NULL, -1, OBJNULL},
{"SINGLE-FLOAT-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"SINGLE-FLOAT-NEGATIVE-EPSILON", CL_CONSTANT, NULL, -1, OBJNULL},
{"SINH", CL_ORDINARY, cl_sinh, 1, OBJNULL},
{"SIXTH", CL_ORDINARY, cl_sixth, 1, OBJNULL},
{"SLEEP", CL_ORDINARY, cl_sleep, 1, OBJNULL},
{"SOFTWARE-TYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"SOFTWARE-VERSION", CL_ORDINARY, NULL, -1, OBJNULL},
{"SOME", CL_ORDINARY, ECL_NAME(cl_some), -1, OBJNULL},
{"SORT", CL_ORDINARY, ECL_NAME(cl_sort), -1, OBJNULL},
{"SPACE", CL_ORDINARY, NULL, -1, OBJNULL},
{"SPECIAL", CL_ORDINARY, NULL, -1, OBJNULL},
{"SPECIAL-OPERATOR-P", CL_ORDINARY, cl_special_operator_p, 1, OBJNULL},
{"SPEED", CL_ORDINARY, NULL, -1, OBJNULL},
{"SQRT", CL_ORDINARY, cl_sqrt, 1, OBJNULL},
{"STABLE-SORT", CL_ORDINARY, ECL_NAME(cl_stable_sort), -1, OBJNULL},
{"STANDARD-CHAR", CL_ORDINARY, NULL, -1, OBJNULL},
{"STANDARD-CHAR-P", CL_ORDINARY, cl_standard_char_p, 1, OBJNULL},
{"STEP", CL_ORDINARY, NULL, -1, OBJNULL},
{"STORAGE-CONDITION", CL_ORDINARY, NULL, -1, OBJNULL},
{"STORE-VALUE", CL_ORDINARY, NULL, -1, OBJNULL},
{"STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"STREAM-ELEMENT-TYPE", CL_ORDINARY, cl_stream_element_type, 1, OBJNULL},
{"STREAM-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"STREAM-ERROR-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"STREAM-EXTERNAL-FORMAT", CL_ORDINARY, cl_stream_external_format, 1, OBJNULL},
{"STREAMP", CL_ORDINARY, cl_streamp, 1, OBJNULL},
{"STRING", CL_ORDINARY, cl_string, 1, OBJNULL},
{"STRING-DOWNCASE", CL_ORDINARY, cl_string_downcase, -1, OBJNULL},
{"STRING-CAPITALIZE", CL_ORDINARY, cl_string_capitalize, -1, OBJNULL},
{"STRING-EQUAL", CL_ORDINARY, cl_string_equal, -1, OBJNULL},
{"STRING-GREATERP", CL_ORDINARY, cl_string_greaterp, -1, OBJNULL},
{"STRING-LEFT-TRIM", CL_ORDINARY, cl_string_left_trim, 2, OBJNULL},
{"STRING-LESSP", CL_ORDINARY, cl_string_lessp, -1, OBJNULL},
{"STRING-NOT-EQUAL", CL_ORDINARY, cl_string_not_equal, -1, OBJNULL},
{"STRING-NOT-GREATERP", CL_ORDINARY, cl_string_not_greaterp, -1, OBJNULL},
{"STRING-NOT-LESSP", CL_ORDINARY, cl_string_not_lessp, -1, OBJNULL},
{"STRING-RIGHT-TRIM", CL_ORDINARY, cl_string_right_trim, 2, OBJNULL},
{"STRING-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"STRING-TRIM", CL_ORDINARY, cl_string_trim, 2, OBJNULL},
{"STRING-UPCASE", CL_ORDINARY, cl_string_upcase, -1, OBJNULL},
{"STRING/=", CL_ORDINARY, cl_stringNE, -1, OBJNULL},
{"STRING<", CL_ORDINARY, cl_stringL, -1, OBJNULL},
{"STRING<=", CL_ORDINARY, cl_stringLE, -1, OBJNULL},
{"STRING=", CL_ORDINARY, cl_stringE, -1, OBJNULL},
{"STRING>", CL_ORDINARY, cl_stringG, -1, OBJNULL},
{"STRING>=", CL_ORDINARY, cl_stringGE, -1, OBJNULL},
{"STRINGP", CL_ORDINARY, cl_stringp, 1, OBJNULL},
{"STRUCTURE", CL_ORDINARY, NULL, -1, OBJNULL},
{"STYLE-WARNING", CL_ORDINARY, NULL, -1, OBJNULL},
{"SUBLIS", CL_ORDINARY, cl_sublis, -1, OBJNULL},
{"SUBSEQ", CL_ORDINARY, cl_subseq, -1, OBJNULL},
{"SUBSETP", CL_ORDINARY, ECL_NAME(cl_subsetp), -1, OBJNULL},
{"SUBST", CL_ORDINARY, cl_subst, -1, OBJNULL},
{"SUBST-IF", CL_ORDINARY, ECL_NAME(cl_subst_if), -1, OBJNULL},
{"SUBST-IF-NOT", CL_ORDINARY, ECL_NAME(cl_subst_if_not), -1, OBJNULL},
{"SUBSTITUTE", CL_ORDINARY, ECL_NAME(cl_substitute), -1, OBJNULL},
{"SUBSTITUTE-IF", CL_ORDINARY, ECL_NAME(cl_substitute_if), -1, OBJNULL},
{"SUBSTITUTE-IF-NOT", CL_ORDINARY, ECL_NAME(cl_substitute_if_not), -1, OBJNULL},
{"SUBTYPEP", CL_ORDINARY, ECL_NAME(cl_subtypep), -1, OBJNULL},
{"SVREF", CL_ORDINARY, cl_svref, 2, OBJNULL},
{"SXHASH", CL_ORDINARY, cl_sxhash, 1, OBJNULL},
{"SYMBOL", CL_ORDINARY, NULL, -1, OBJNULL},
{"SYMBOL-FUNCTION", CL_ORDINARY, cl_symbol_function, 1, OBJNULL},
{"SYMBOL-MACROLET", CL_FORM, NULL, -1, OBJNULL},
{"SYMBOL-NAME", CL_ORDINARY, cl_symbol_name, 1, OBJNULL},
{"SYMBOL-PACKAGE", CL_ORDINARY, cl_symbol_package, 1, OBJNULL},
{"SYMBOL-PLIST", CL_ORDINARY, cl_symbol_plist, 1, OBJNULL},
{"SYMBOL-VALUE", CL_ORDINARY, cl_symbol_value, 1, OBJNULL},
{"SYMBOLP", CL_ORDINARY, cl_symbolp, 1, OBJNULL},
{"SYNONYM-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"SYNONYM-STREAM-SYMBOL", CL_ORDINARY, cl_synonym_stream_symbol, 1, OBJNULL},
{"TAGBODY", CL_FORM, NULL, -1, OBJNULL},
{"TAILP", CL_ORDINARY, cl_tailp, 2, OBJNULL},
{"TAN", CL_ORDINARY, cl_tan, 1, OBJNULL},
{"TANH", CL_ORDINARY, cl_tanh, 1, OBJNULL},
{"TENTH", CL_ORDINARY, cl_tenth, 1, OBJNULL},
{"TERPRI", CL_ORDINARY, cl_terpri, -1, OBJNULL},
{"THE", CL_FORM, NULL, -1, OBJNULL},
{"THIRD", CL_ORDINARY, cl_caddr, 1, OBJNULL},
{"THROW", CL_FORM, NULL, -1, OBJNULL},
{"TIME", CL_ORDINARY, NULL, -1, OBJNULL},
{"TRACE", CL_ORDINARY, NULL, -1, OBJNULL},
{"TRANSLATE-LOGICAL-PATHNAME", CL_ORDINARY, cl_translate_logical_pathname, -1, OBJNULL},
{"TRANSLATE-PATHNAME", CL_ORDINARY, cl_translate_pathname, -1, OBJNULL},
{"TREE-EQUAL", CL_ORDINARY, cl_tree_equal, -1, OBJNULL},
{"TRUENAME", CL_ORDINARY, cl_truename, 1, OBJNULL},
{"TRUNCATE", CL_ORDINARY, cl_truncate, -1, OBJNULL},
{"TWO-WAY-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"TWO-WAY-STREAM-INPUT-STREAM", CL_ORDINARY, cl_two_way_stream_input_stream, 1, OBJNULL},
{"TWO-WAY-STREAM-OUTPUT-STREAM", CL_ORDINARY, cl_two_way_stream_output_stream, 1, OBJNULL},
{"TYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"TYPE-ERROR", CL_ORDINARY, NULL, -1, OBJNULL},
{"TYPE-ERROR-DATUM", CL_ORDINARY, NULL, -1, OBJNULL},
{"TYPE-ERROR-EXPECTED-TYPE", CL_ORDINARY, NULL, -1, OBJNULL},
{"TYPE-OF", CL_ORDINARY, cl_type_of, 1, OBJNULL},
{"TYPECASE", CL_ORDINARY, NULL, -1, OBJNULL},
{"TYPEP", CL_ORDINARY, ECL_NAME(cl_typep), -1, OBJNULL},
{"UNBOUND-SLOT", CL_ORDINARY, NULL, -1, OBJNULL},
{"UNBOUND-SLOT-INSTANCE", CL_ORDINARY, NULL, -1, OBJNULL},
{"UNBOUND-VARIABLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"UNDEFINED-FUNCTION", CL_ORDINARY, NULL, -1, OBJNULL},
{"UNEXPORT", CL_ORDINARY, cl_unexport, -1, OBJNULL},
{"UNINTERN", CL_ORDINARY, cl_unintern, -1, OBJNULL},
{"UNION", CL_ORDINARY, ECL_NAME(cl_union), -1, OBJNULL},
{"UNLESS", CL_FORM, NULL, -1, OBJNULL},
{"UNREAD-CHAR", CL_ORDINARY, cl_unread_char, -1, OBJNULL},
{"UNSIGNED-BYTE", CL_ORDINARY, NULL, -1, OBJNULL},
{"UNTRACE", CL_ORDINARY, NULL, -1, OBJNULL},
{"UNUSE-PACKAGE", CL_ORDINARY, cl_unuse_package, -1, OBJNULL},
{"UNWIND-PROTECT", CL_FORM, NULL, -1, OBJNULL},
{"UPGRADED-ARRAY-ELEMENT-TYPE", CL_ORDINARY, ECL_NAME(cl_upgraded_array_element_type), -1, OBJNULL},
{"UPGRADED-COMPLEX-PART-TYPE", CL_ORDINARY, ECL_NAME(cl_upgraded_complex_part_type), -1, OBJNULL},
{"UPPER-CASE-P", CL_ORDINARY, cl_upper_case_p, 1, OBJNULL},
{"USE-PACKAGE", CL_ORDINARY, cl_use_package, -1, OBJNULL},
{"USE-VALUE", CL_ORDINARY, NULL, -1, OBJNULL},
{"USER-HOMEDIR-PATHNAME", CL_ORDINARY, cl_user_homedir_pathname, -1, OBJNULL},
{"VALUES", CL_ORDINARY, cl_values, -1, OBJNULL},
{"VALUES-LIST", CL_ORDINARY, cl_values_list, 1, OBJNULL},
{"VARIABLE", CL_ORDINARY, NULL, -1, OBJNULL},
{"VECTOR", CL_ORDINARY, ECL_NAME(cl_vector), -1, OBJNULL},
{"VECTOR-POP", CL_ORDINARY, ECL_NAME(cl_vector_pop), 1, OBJNULL},
{"VECTOR-PUSH", CL_ORDINARY, ECL_NAME(cl_vector_push), 2, OBJNULL},
{"VECTOR-PUSH-EXTEND", CL_ORDINARY, ECL_NAME(cl_vector_push_extend), -1, OBJNULL},
{"VECTORP", CL_ORDINARY, cl_vectorp, 1, OBJNULL},
{"WARN", CL_ORDINARY, NULL, -1, OBJNULL},
{"WARNING", CL_ORDINARY, NULL, -1, OBJNULL},
{"WHEN", CL_FORM, NULL, -1, OBJNULL},
{"WILD-PATHNAME-P", CL_ORDINARY, cl_wild_pathname_p, -1, OBJNULL},
{"WITH-COMPILATION-UNIT", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-CONDITION-RESTARTS", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-HASH-TABLE-ITERATOR", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-INPUT-FROM-STRING", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-OPEN-FILE", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-OPEN-STREAM", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-OUTPUT-TO-STRING", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-PACKAGE-ITERATOR", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-SIMPLE-RESTART", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-STANDARD-IO-SYNTAX", CL_ORDINARY, NULL, -1, OBJNULL},
{"WRITE", CL_ORDINARY, cl_write, -1, OBJNULL},
{"WRITE-BYTE", CL_ORDINARY, cl_write_byte, 2, OBJNULL},
{"WRITE-CHAR", CL_ORDINARY, cl_write_char, -1, OBJNULL},
{"WRITE-LINE", CL_ORDINARY, cl_write_line, -1, OBJNULL},
{"WRITE-SEQUENCE", CL_ORDINARY, cl_write_sequence, -1, OBJNULL},
{"WRITE-STRING", CL_ORDINARY, cl_write_string, -1, OBJNULL},
{"WRITE-TO-STRING", CL_ORDINARY, ECL_NAME(cl_write_to_string), -1, OBJNULL},
{"Y-OR-N-P", CL_ORDINARY, ECL_NAME(cl_y_or_n_p), -1, OBJNULL},
{"YES-OR-NO-P", CL_ORDINARY, ECL_NAME(cl_yes_or_no_p), -1, OBJNULL},
{"ZEROP", CL_ORDINARY, cl_zerop, 1, OBJNULL},

#ifdef CLOS
{"ALLOCATE-INSTANCE", CL_ORDINARY, NULL, 2, OBJNULL},
{"ADD-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"BUILT-IN-CLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"CALL-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"CALL-NEXT-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"CHANGE-CLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"CLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"CLASS-NAME", CL_ORDINARY, NULL, -1, OBJNULL},
{"CLASS-OF", CL_ORDINARY, cl_class_of, 1, OBJNULL},
{"COMPUTE-APPLICABLE-METHODS", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFCLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFGENERIC", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFINE-METHOD-COMBINATION", CL_ORDINARY, NULL, -1, OBJNULL},
{"DEFMETHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"DESCRIBE-OBJECT", CL_ORDINARY, NULL, -1, OBJNULL},
{"ENSURE-GENERIC-FUNCTION", CL_ORDINARY, NULL, -1, OBJNULL},
{"FIND-CLASS", CL_ORDINARY, cl_find_class, -1, OBJNULL},
{"FIND-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"GENERIC-FUNCTION", CL_ORDINARY, NULL, -1, OBJNULL},
{"IF", CL_FORM, NULL, -1, OBJNULL},
{"INITIALIZE-INSTANCE", CL_ORDINARY, NULL, -1, OBJNULL},
{"INVALID-METHOD-ERROR", CL_ORDINARY, ECL_NAME(cl_invalid_method_error), -1, OBJNULL},
{"MAKE-INSTANCE", CL_ORDINARY, NULL, -1, OBJNULL},
{"MAKE-INSTANCES-OBSOLETE", CL_ORDINARY, NULL, -1, OBJNULL},
{"MAKE-LOAD-FORM", CL_ORDINARY, NULL, -1, OBJNULL},
{"MAKE-LOAD-FORM-SAVING-SLOTS", CL_ORDINARY, NULL, -1, OBJNULL},
{"MAKE-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"METHOD-COMBINATION-ERROR", CL_ORDINARY, ECL_NAME(cl_method_combination_error), -1, OBJNULL},
{"METHOD-COMBINATION", CL_ORDINARY, NULL, -1, OBJNULL},
{"METHOD-QUALIFIERS", CL_ORDINARY, NULL, -1, OBJNULL},
{"NEXT-METHOD-P", CL_ORDINARY, NULL, -1, OBJNULL},
{"NO-APPLICABLE-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"NO-NEXT-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"PRINT-OBJECT", CL_ORDINARY, NULL, -1, OBJNULL},
{"PRINT-UNREADABLE-OBJECT", CL_ORDINARY, NULL, -1, OBJNULL},
{"REINITIALIZE-INSTANCE", CL_ORDINARY, NULL, -1, OBJNULL},
{"REMOVE-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"SHARED-INITIALIZE", CL_ORDINARY, NULL, -1, OBJNULL},
{"SLOT-BOUNDP", CL_ORDINARY, NULL, -1, OBJNULL},
{"SLOT-EXISTS-P", CL_ORDINARY, NULL, -1, OBJNULL},
{"SLOT-MAKUNBOUND", CL_ORDINARY, NULL, -1, OBJNULL},
{"SLOT-MISSING", CL_ORDINARY, NULL, -1, OBJNULL},
{"SLOT-UNBOUND", CL_ORDINARY, NULL, -1, OBJNULL},
{"SLOT-VALUE", CL_ORDINARY, NULL, -1, OBJNULL},
{"STANDARD", CL_ORDINARY, NULL, -1, OBJNULL},
{"STANDARD-CLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"STANDARD-GENERIC-FUNCTION", CL_ORDINARY, NULL, -1, OBJNULL},
{"STANDARD-METHOD", CL_ORDINARY, NULL, -1, OBJNULL},
{"STANDARD-OBJECT", CL_ORDINARY, NULL, -1, OBJNULL},
{"STRUCTURE-CLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"STRUCTURE-OBJECT", CL_ORDINARY, NULL, -1, OBJNULL},
{"UPDATE-INSTANCE-FOR-DIFFERENT-CLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"UPDATE-INSTANCE-FOR-REDEFINED-CLASS", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-ACCESSORS", CL_ORDINARY, NULL, -1, OBJNULL},
{"WITH-SLOTS", CL_ORDINARY, NULL, -1, OBJNULL},
{KEY_ "ARGUMENT-PRECEDENCE-ORDER", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DECLARE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DEFAULT-INITARGS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DIRECT-DEFAULT-INITARGS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DIRECT-SLOTS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DIRECT-SUPERCLASSES", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "GENERIC-FUNCTION-CLASS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LAMBDA-LIST", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "METHOD-CLASS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "METHOD-COMBINATION", KEYWORD, NULL, -1, OBJNULL},
#endif

/* SYSTEM PACKAGE */
{SYS_ "#!", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "*BACKQ-LEVEL*", SI_SPECIAL, NULL, -1, MAKE_FIXNUM(0)},
{SYS_ "*CBLOCK*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*CIRCLE-COUNTER*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*CIRCLE-STACK*", SI_SPECIAL, NULL, -1, OBJNULL},
{SYS_ "*CLASS-NAME-HASH-TABLE*", SI_SPECIAL, NULL, -1, OBJNULL},
{SYS_ "*COMPILER-CONSTANTS*", SI_SPECIAL, NULL, -1, OBJNULL},
{SYS_ "*GC-MESSAGE*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*GC-VERBOSE*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*IGNORE-EOF-ON-TERMINAL-IO*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*INDENT-FORMATTED-OUTPUT*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*INIT-FUNCTION-PREFIX*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*INTERRUPTS-ENABLED*", SI_SPECIAL, NULL, 1, Ct},
{SYS_ "*KEEP-DEFINITIONS*", SI_SPECIAL, NULL, -1, Ct},
{SYS_ "*LOAD-HOOKS*", SI_SPECIAL, NULL, -1, OBJNULL},
{SYS_ "*LOAD-SEARCH-LIST*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*MAKE-CONSTANT", SI_ORDINARY, si_Xmake_constant, 2, OBJNULL},
{SYS_ "*MAKE-SPECIAL", SI_ORDINARY, si_Xmake_special, 1, OBJNULL},
{SYS_ "*PRINT-PACKAGE*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*PRINT-STRUCTURE*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*SHARP-EQ-CONTEXT*", SI_SPECIAL, NULL, -1, Cnil},
{SYS_ "*STEP-LEVEL*", SI_SPECIAL, OBJNULL, -1, MAKE_FIXNUM(0)},
{SYS_ "*STEP-ACTION*", SI_SPECIAL, OBJNULL, -1, Cnil},
{SYS_ ".", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "UNQUOTE", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "UNQUOTE-NSPLICE", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "UNQUOTE-SPLICE", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "ALLOCATE-RAW-INSTANCE", SI_ORDINARY, si_allocate_raw_instance, 3, OBJNULL},
{SYS_ "ARGC", SI_ORDINARY, si_argc, 0, OBJNULL},
{SYS_ "ARGV", SI_ORDINARY, si_argv, 1, OBJNULL},
{SYS_ "ASET", SI_ORDINARY, si_aset, -1, OBJNULL},
{SYS_ "BASE-CHAR-P", SI_ORDINARY, si_base_char_p, 1, OBJNULL},
{SYS_ "BASE-STRING-P", SI_ORDINARY, si_base_string_p, 1, OBJNULL},
{SYS_ "BC-DISASSEMBLE", SI_ORDINARY, si_bc_disassemble, 1, OBJNULL},
{SYS_ "BC-SPLIT", SI_ORDINARY, si_bc_split, 1, OBJNULL},
{SYS_ "BDS-TOP", SI_ORDINARY, si_bds_top, 0, OBJNULL},
{SYS_ "BDS-VAL", SI_ORDINARY, si_bds_val, 1, OBJNULL},
{SYS_ "BDS-VAR", SI_ORDINARY, si_bds_var, 1, OBJNULL},
{SYS_ "BIT-ARRAY-OP", SI_ORDINARY, si_bit_array_op, 4, OBJNULL},
{SYS_ "C-ARGUMENTS-LIMIT", SI_ORDINARY, NULL, -1, MAKE_FIXNUM(C_ARGUMENTS_LIMIT)},
{SYS_ "CHAR-SET", SI_ORDINARY, si_char_set, 3, OBJNULL},
{EXT_ "CHDIR", SI_ORDINARY, si_chdir, -1, OBJNULL},
{SYS_ "CLEAR-COMPILER-PROPERTIES", SI_ORDINARY, cl_identity, 1, OBJNULL},
{SYS_ "COERCE-TO-BASE-STRING", SI_ORDINARY, si_coerce_to_base_string, 1, OBJNULL},
{SYS_ "COERCE-TO-EXTENDED-STRING", SI_ORDINARY, si_coerce_to_extended_string, 1, OBJNULL},
{SYS_ "COERCE-TO-FILENAME", SI_ORDINARY, si_coerce_to_filename, 1, OBJNULL},
{SYS_ "COERCE-TO-FUNCTION", SI_ORDINARY, si_coerce_to_function, 1, OBJNULL},
{SYS_ "COERCE-TO-PACKAGE", SI_ORDINARY, si_coerce_to_package, 1, OBJNULL},
{SYS_ "COPY-TO-SIMPLE-BASE-STRING", SI_ORDINARY, si_copy_to_simple_base_string, 1, OBJNULL},
{SYS_ "COMPILED-FUNCTION-BLOCK", SI_ORDINARY, si_compiled_function_block, 1, OBJNULL},
{SYS_ "COMPILED-FUNCTION-NAME", SI_ORDINARY, si_compiled_function_name, 1, OBJNULL},
{SYS_ "COPY-STREAM", SI_ORDINARY, si_copy_stream, 1, OBJNULL},
{SYS_ "DO-READ-SEQUENCE", SI_ORDINARY, si_do_read_sequence, 4, OBJNULL},
{SYS_ "DO-WRITE-SEQUENCE", SI_ORDINARY, si_do_write_sequence, 4, OBJNULL},
{SYS_ "ELT-SET", SI_ORDINARY, si_elt_set, 3, OBJNULL},
{SYS_ "EVAL-WITH-ENV", SI_ORDINARY, si_eval_with_env, -1, OBJNULL},
{SYS_ "EXPAND-DEFMACRO", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "FILE-COLUMN", SI_ORDINARY, si_file_column, 1, OBJNULL},
{SYS_ "FILE-KIND", SI_ORDINARY, si_file_kind, 2, OBJNULL},
{SYS_ "FILL-POINTER-SET", SI_ORDINARY, si_fill_pointer_set, 2, OBJNULL},
{SYS_ "FILE-STREAM-FD", SI_ORDINARY, si_file_stream_fd, 1, OBJNULL},
{SYS_ "FIXNUMP", SI_ORDINARY, si_fixnump, 1, OBJNULL},
{SYS_ "FORMAT-ERROR", SI_ORDINARY, NULL, -1, OBJNULL},
#ifdef ECL_CMU_FORMAT
{SYS_ "FORMATTER-AUX", SI_ORDINARY, NULL, -1, OBJNULL},
#else
{SYS_ "FORMATTER-AUX", SI_ORDINARY, si_formatter_aux, -1, OBJNULL},
#endif
{SYS_ "FRS-BDS", SI_ORDINARY, si_frs_bds, 1, OBJNULL},
{SYS_ "FRS-IHS", SI_ORDINARY, si_frs_ihs, 1, OBJNULL},
{SYS_ "FRS-TAG", SI_ORDINARY, si_frs_tag, 1, OBJNULL},
{SYS_ "FRS-TOP", SI_ORDINARY, si_frs_top, 0, OBJNULL},
{SYS_ "FSET", SI_ORDINARY, si_fset, -1, OBJNULL},
{SYS_ "FUNCTION-BLOCK-NAME", SI_ORDINARY, si_function_block_name, 1, OBJNULL},
{SYS_ "GET-LIBRARY-PATHNAME", SI_ORDINARY, si_get_library_pathname, 0, OBJNULL},
{SYS_ "GET-SYSPROP", SI_ORDINARY, si_get_sysprop, 2, OBJNULL},
{EXT_ "GETENV", SI_ORDINARY, si_getenv, 1, OBJNULL},
{EXT_ "GETCWD", SI_ORDINARY, si_getcwd, -1, OBJNULL},
{SYS_ "GETPID", SI_ORDINARY, si_getpid, 0, OBJNULL},
{SYS_ "HASH-SET", SI_ORDINARY, si_hash_set, 3, OBJNULL},
{SYS_ "HASH-TABLE-ITERATOR", SI_ORDINARY, si_hash_table_iterator, 1, OBJNULL},
{SYS_ "IHS-BDS", SI_ORDINARY, si_ihs_bds, 1, OBJNULL},
{SYS_ "IHS-ENV", SI_ORDINARY, si_ihs_env, 1, OBJNULL},
{SYS_ "IHS-FUN", SI_ORDINARY, si_ihs_fun, 1, OBJNULL},
{SYS_ "IHS-NEXT", SI_ORDINARY, si_ihs_next, 1, OBJNULL},
{SYS_ "IHS-PREV", SI_ORDINARY, si_ihs_prev, 1, OBJNULL},
{SYS_ "IHS-TOP", SI_ORDINARY, si_ihs_top, 0, OBJNULL},
{SYS_ "INTERPRETER-STACK", SI_ORDINARY, si_interpreter_stack, -1, OBJNULL},
{SYS_ "LINK-FROM", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "LINK-TO", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "LOAD-SOURCE", SI_ORDINARY, si_load_source, 3, OBJNULL},
{SYS_ "LOGICAL-PATHNAME-P", SI_ORDINARY, si_logical_pathname_p, 1, OBJNULL},
{SYS_ "MACRO", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "MAKE-LAMBDA", SI_ORDINARY, si_make_lambda, 2, OBJNULL},
{SYS_ "MAKE-PURE-ARRAY", SI_ORDINARY, si_make_pure_array, 6, OBJNULL},
{SYS_ "MAKE-STRING-OUTPUT-STREAM-FROM-STRING", SI_ORDINARY, si_make_string_output_stream_from_string, 1, OBJNULL},
{SYS_ "MAKE-STRUCTURE", SI_ORDINARY, si_make_structure, -1, OBJNULL},
{SYS_ "MAKE-VECTOR", SI_ORDINARY, si_make_vector, 6, OBJNULL},
{SYS_ "MANGLE-NAME", SI_ORDINARY, si_mangle_name, -1, OBJNULL},
{SYS_ "MEMBER1", SI_ORDINARY, si_member1, 5, OBJNULL},
{SYS_ "MEMQ", SI_ORDINARY, si_memq, 2, OBJNULL},
{SYS_ "MKDIR", SI_ORDINARY, si_mkdir, 2, OBJNULL},
{SYS_ "MKSTEMP", SI_ORDINARY, si_mkstemp, 1, OBJNULL},
{SYS_ "RMDIR", SI_ORDINARY, si_rmdir, 1, OBJNULL},
{EXT_ "MAKE-PIPE", SI_ORDINARY, si_make_pipe, 0, OBJNULL},
{SYS_ "PACKAGE-LOCK", SI_ORDINARY, si_package_lock, 2, OBJNULL},
{SYS_ "PACKAGE-HASH-TABLES", SI_ORDINARY, si_package_hash_tables, 1, OBJNULL},
{SYS_ "PATHNAME-TRANSLATIONS", SI_ORDINARY, si_pathname_translations, -1, OBJNULL},
{SYS_ "POINTER", SI_ORDINARY, si_pointer, 1, OBJNULL},
#ifndef ECL_CMU_FORMAT
{SYS_ "PRETTY-PRINT-FORMAT", SI_ORDINARY, NULL, -1, OBJNULL},
#endif
{SYS_ "PROCESS-DECLARATIONS", SI_ORDINARY, si_process_declarations, -1, OBJNULL},
{SYS_ "PROCESS-LAMBDA", SI_ORDINARY, si_process_lambda, 1, OBJNULL},
{SYS_ "PROCESS-LAMBDA-LIST", SI_ORDINARY, si_process_lambda_list, 2, OBJNULL},
{SYS_ "PUT-F", SI_ORDINARY, si_put_f, 3, OBJNULL},
{SYS_ "PUT-PROPERTIES", SI_ORDINARY, si_put_properties, -1, OBJNULL},
{SYS_ "PUT-SYSPROP", SI_ORDINARY, si_put_sysprop, 3, OBJNULL},
{SYS_ "PUTPROP", SI_ORDINARY, si_putprop, 3, OBJNULL},
{SYS_ "READTABLE-CASE-SET", SI_ORDINARY, si_readtable_case_set, 2, OBJNULL},
{SYS_ "REM-F", SI_ORDINARY, si_rem_f, 2, OBJNULL},
{SYS_ "REM-SYSPROP", SI_ORDINARY, si_rem_sysprop, 2, OBJNULL},
{SYS_ "REPLACE-ARRAY", SI_ORDINARY, si_replace_array, 2, OBJNULL},
{SYS_ "ROW-MAJOR-ASET", SI_ORDINARY, si_row_major_aset, 3, OBJNULL},
{EXT_ "RUN-PROGRAM", SI_ORDINARY, si_run_program, -1, OBJNULL},
{SYS_ "SAFE-EVAL", SI_ORDINARY, si_safe_eval, -1, OBJNULL},
{SYS_ "SCH-FRS-BASE", SI_ORDINARY, si_sch_frs_base, 2, OBJNULL},
{SYS_ "SCHAR-SET", SI_ORDINARY, si_char_set, 3, OBJNULL},
{SYS_ "SHARP-A-READER", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SHARP-S-READER", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SELECT-PACKAGE", SI_ORDINARY, si_select_package, 1, OBJNULL},
{SYS_ "SET-SYMBOL-PLIST", SI_ORDINARY, si_set_symbol_plist, 2, OBJNULL},
#if defined(HAVE_PUTENV) || defined(HAVE_SETENV)
{EXT_ "SETENV", SI_ORDINARY, si_setenv, 2, OBJNULL},
#endif
{SYS_ "SETF-LAMBDA", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SETF-METHOD", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SETF-NAMEP", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SETF-SYMBOL", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SETF-UPDATE", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SIMPLE-PROGRAM-ERROR", SI_ORDINARY,  ECL_NAME(si_simple_program_error), -1, OBJNULL},
{SYS_ "SIGNAL-SIMPLE-ERROR", SI_ORDINARY, si_signal_simple_error, -1, OBJNULL},
{SYS_ "SPECIALP", SI_ORDINARY, si_specialp, 1, OBJNULL},
{SYS_ "STANDARD-READTABLE", SI_ORDINARY, si_standard_readtable, 0, OBJNULL},
{SYS_ "STEPPER", SI_ORDINARY, OBJNULL, -1, OBJNULL},
{SYS_ "BASE-STRING-CONCATENATE", SI_ORDINARY, si_base_string_concatenate, -1, OBJNULL},
{SYS_ "STRING-TO-OBJECT", SI_ORDINARY, ECL_NAME(si_string_to_object), -1, OBJNULL},
{SYS_ "STRUCTURE-NAME", SI_ORDINARY, si_structure_name, 1, OBJNULL},
{SYS_ "STRUCTURE-PRINT-FUNCTION", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "STRUCTURE-REF", SI_ORDINARY, si_structure_ref, 3, OBJNULL},
{SYS_ "STRUCTURE-SET", SI_ORDINARY, si_structure_set, 4, OBJNULL},
{SYS_ "STRUCTURE-SLOT-DESCRIPTIONS", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "STRUCTURE-SUBTYPE-P", SI_ORDINARY, si_structure_subtype_p, 2, OBJNULL},
{SYS_ "STRUCTUREP", SI_ORDINARY, si_structurep, 1, OBJNULL},
{SYS_ "SVSET", SI_ORDINARY, si_svset, 3, OBJNULL},
{SYS_ "SYMBOL-MACRO", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "SYSTEM", SI_ORDINARY, si_system, 1, OBJNULL},
{SYS_ "TERMINAL-INTERRUPT", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "TOP-LEVEL", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "UNIVERSAL-ERROR-HANDLER", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "VALID-FUNCTION-NAME-P", SI_ORDINARY, si_valid_function_name_p, 1, OBJNULL},
{SYS_ "WRITE-OBJECT", SI_SPECIAL, si_write_object, 2, OBJNULL},
{SYS_ "WRITE-UGLY-OBJECT", SI_SPECIAL, si_write_ugly_object, 2, OBJNULL},

#ifndef CLOS
{SYS_ "STRUCTURE-INCLUDE", SI_ORDINARY, NULL, -1, OBJNULL},
#else
{SYS_ "COPY-INSTANCE", SI_ORDINARY, si_copy_instance, 1, OBJNULL},
{SYS_ "GENERIC-FUNCTION-P", SI_ORDINARY, si_generic_function_p, 1, OBJNULL},
{SYS_ "INSTANCE-REF-SAFE", SI_ORDINARY, si_instance_ref_safe, 2, OBJNULL},
{SYS_ "INSTANCE-REF", SI_ORDINARY, si_instance_ref, 2, OBJNULL},
{SYS_ "INSTANCE-SET", SI_ORDINARY, si_instance_set, 3, OBJNULL},
{SYS_ "INSTANCE-SIG", SI_ORDINARY, si_instance_sig, 1, OBJNULL},
{SYS_ "INSTANCE-SIG-SET", SI_ORDINARY, si_instance_sig_set, 1, OBJNULL},
{SYS_ "INSTANCE-CLASS", SI_ORDINARY, si_instance_class, 1, OBJNULL},
{SYS_ "INSTANCE-CLASS-SET", SI_ORDINARY, si_instance_class_set, 2, OBJNULL},
{SYS_ "INSTANCEP", SI_ORDINARY, si_instancep, 1, OBJNULL},
{SYS_ "SL-BOUNDP", SI_ORDINARY, si_sl_boundp, 1, OBJNULL},
{SYS_ "SL-MAKUNBOUND", SI_ORDINARY, si_sl_makunbound, 2, OBJNULL},
{SYS_ "SUBCLASSP", SI_ORDINARY, ECL_NAME(si_subclassp), -1, OBJNULL},
{SYS_ "OF-CLASS-P", SI_ORDINARY, ECL_NAME(si_of_class_p), -1, OBJNULL},
/*{SYS_ "UNBOUND", SI_ORDINARY, si_unbound, 0, OBJNULL}, */
#endif

#ifdef PROFILE
{SYS_ "*PROFILE-ARRAY*", SI_SPECIAL, NULL, -1, OBJNULL},
#endif

{EXT_ "*SOURCE-LOCATION*", EXT_SPECIAL, NULL, -1, Cnil},
{EXT_ "*REGISTER-WITH-PDE-HOOK*", EXT_SPECIAL, NULL, -1, Cnil},
{EXT_ "REGISTER-WITH-PDE", EXT_ORDINARY, NULL, -1, OBJNULL},

#ifdef PROFILE
{SYS_ "PROFILE", SI_ORDINARY, si_profile, -1, OBJNULL},
{SYS_ "CLEAR-PROFILE", SI_ORDINARY, si_clear_profile, -1, OBJNULL},
{SYS_ "DISPLAY-PROFILE", SI_ORDINARY, si_display_profile, -1, OBJNULL},
#endif /* PROFILE */

#ifdef TCP
{SYS_ "OPEN-CLIENT-STREAM", SI_ORDINARY, si_open_client_stream, 2, OBJNULL},
{SYS_ "OPEN-SERVER-STREAM", SI_ORDINARY, si_open_server_stream, 1, OBJNULL},
{SYS_ "OPEN-UNIX-SOCKET-STREAM", SI_ORDINARY, si_open_unix_socket_stream, 1, OBJNULL},
{SYS_ "LOOKUP-HOST-ENTRY", SI_ORDINARY, si_lookup_host_entry, 1, OBJNULL},
#endif

{SYS_ "CATCH-SIGNAL", SI_ORDINARY, si_catch_signal, 2, OBJNULL},

/* KEYWORD PACKAGE */
{KEY_ "ADJUSTABLE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ABORT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ABSOLUTE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ALLOW-OTHER-KEYS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "APPEND", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ARRAY", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "BACK", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "BASE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "BLOCK", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CAPITALIZE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CASE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CIRCLE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "COMPILE-TOPLEVEL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "COMMON",KEYWORD,NULL,-1,OBJNULL},
{KEY_ "CONC-NAME", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CONSTRUCTOR", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CONTROL-STRING", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "COPIER", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CREATE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DATUM", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DEFAULT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DEFAULTS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DEVICE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DIRECTION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DIRECTORY", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DISPLACED-INDEX-OFFSET", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DISPLACED-TO", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DOCUMENTATION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DOWNCASE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ELEMENT-TYPE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "END", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "END1", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "END2", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EOF", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ERROR", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ESCAPE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EXECUTE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EXPECTED-TYPE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EXPORT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EXPORT-FROM", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EXTERNAL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EXTERNAL-FORMAT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FILE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FILL-POINTER", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FORMAT-ARGUMENTS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FORMAT-CONTROL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FUNCTION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "GENSYM", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "HOST", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "IF-DOES-NOT-EXIST", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "IF-EXISTS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "IMPORT-FROM", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INCLUDE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INHERITED", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INITIAL-ELEMENT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INITIAL-CONTENTS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INITIAL-OFFSET", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INPUT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INTERACTIVE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INSTANCE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INTERN", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INTERNAL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INVERT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "IO", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "JUNK-ALLOWED", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "KEY", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LENGTH", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LEVEL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LINES", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LINK", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LIST-ALL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LOCAL",KEYWORD,NULL,-1,OBJNULL},
{KEY_ "LOCKABLE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LOAD-TOPLEVEL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "MISER-WIDTH", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "NAME", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "NAMED", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "NEW-VERSION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "NEWEST", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "NICKNAMES", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "OBJECT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "OFFSET", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "OPERATION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "OPERANDS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "OUTPUT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "OVERWRITE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PACKAGE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PATHNAME", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PPRINT-DISPATCH", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PREDICATE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PRESERVE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PRETTY", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PRINT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PRINT-FUNCTION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PRINT-OBJECT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "PROBE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "RADIX", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "READABLY", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "REHASH-SIZE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "REHASH-THRESHOLD", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "RELATIVE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "RENAME", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "RENAME-AND-DELETE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "REPORT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "RIGHT-MARGIN", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SET-DEFAULT-PATHNAME", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SEARCH-LIST", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SHADOW", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SHADOWING-IMPORT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SIZE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SPECIAL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "START", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "START1", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "START2", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "STREAM", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SUPERSEDE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "TAG", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "TEST", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "TEST-NOT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "TYPE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNSPECIFIC", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UP", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UPCASE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "USE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CSTREAM", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "VERBOSE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "VERSION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "WILD", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "WILD-INFERIORS", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "WAIT", KEYWORD, NULL, -1, OBJNULL},

{EXT_ "BYTE8", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "BYTE16", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "BYTE32", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "BYTE64", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "COMPILER-LET", EXT_FORM, NULL, -1, OBJNULL},
{EXT_ "INTEGER8", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "INTEGER16", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "INTEGER32", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "INTEGER64", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "LAMBDA-BLOCK", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "QUIT", EXT_ORDINARY, si_quit, -1, OBJNULL},
#ifdef CLOS
{EXT_ "GET-METHOD", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "INSTANCE", EXT_ORDINARY, NULL, -1, OBJNULL},
#endif

{SYS_ "ALLOCATE-FOREIGN-DATA", SI_ORDINARY, si_allocate_foreign_data, 2, OBJNULL},
{SYS_ "FIND-FOREIGN-SYMBOL", SI_ORDINARY, si_find_foreign_symbol, 4, OBJNULL},
{SYS_ "FOREIGN-DATA", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "FOREIGN-DATA-ADDRESS", SI_ORDINARY, si_foreign_data_address, 1, OBJNULL},
{SYS_ "FOREIGN-DATA-POINTER", SI_ORDINARY, si_foreign_data_pointer, 4, OBJNULL},
{SYS_ "FOREIGN-DATA-RECAST", SI_ORDINARY, si_foreign_data_recast, 3, OBJNULL},
{SYS_ "FOREIGN-DATA-REF", SI_ORDINARY, si_foreign_data_ref, 4, OBJNULL},
{SYS_ "FOREIGN-DATA-REF-ELT", SI_ORDINARY, si_foreign_data_ref_elt, 3, OBJNULL},
{SYS_ "FOREIGN-DATA-SET", SI_ORDINARY, si_foreign_data_set, 3, OBJNULL},
{SYS_ "FOREIGN-DATA-SET-ELT", SI_ORDINARY, si_foreign_data_set_elt, 4, OBJNULL},
{SYS_ "FOREIGN-DATA-TAG", SI_ORDINARY, si_foreign_data_tag, 1, OBJNULL},
{SYS_ "FREE-FOREIGN-DATA", SI_ORDINARY, si_free_foreign_data, 1, OBJNULL},
{SYS_ "MAKE-FOREIGN-DATA-FROM-ARRAY", SI_ORDINARY, si_make_foreign_data_from_array, 1, OBJNULL},
{SYS_ "LOAD-FOREIGN-MODULE", SI_ORDINARY, si_load_foreign_module, 1, OBJNULL},
{SYS_ "NULL-POINTER-P", SI_ORDINARY, si_null_pointer_p, 1, OBJNULL},
{SYS_ "SIZE-OF-FOREIGN-ELT-TYPE", SI_ORDINARY, si_size_of_foreign_elt_type, 1, OBJNULL},
{KEY_ "BYTE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CHAR", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CSTRING", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "DOUBLE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FIXNUM", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FLOAT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INT8-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INT16-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INT32-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "INT64-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LONG", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LONG-LONG", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "POINTER-SELF", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "POINTER-VOID", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SHORT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "STRUCT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNION", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "VOID", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UINT8-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UINT16-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UINT32-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UINT64-T", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNSIGNED-BYTE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNSIGNED-CHAR", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNSIGNED-INT", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNSIGNED-LONG", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNSIGNED-LONG-LONG", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNSIGNED-SHORT", KEYWORD, NULL, -1, OBJNULL},
{SYS_ "C-CHAR-BIT", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(CHAR_BIT)},
{SYS_ "C-CHAR-MAX", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(CHAR_MAX)},
{SYS_ "C-CHAR-MIN", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(CHAR_MIN)},
{SYS_ "C-INT-MAX", SI_CONSTANT, NULL, -1, OBJNULL}, /* See main.d */
{SYS_ "C-INT-MIN", SI_CONSTANT, NULL, -1, OBJNULL}, /* See main.d */
{SYS_ "C-SHORT-MAX", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(SHRT_MAX)},
{SYS_ "C-SHORT-MIN", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(SHRT_MIN)},
{SYS_ "C-LONG-MAX", SI_CONSTANT, NULL, -1, OBJNULL}, /* See main.d */
{SYS_ "C-LONG-MIN", SI_CONSTANT, NULL, -1, OBJNULL}, /* See main.d */
{SYS_ "C-UCHAR-MAX", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(UCHAR_MAX)},
{SYS_ "C-UINT-MAX", SI_CONSTANT, NULL, -1, OBJNULL}, /* See main.d */
{SYS_ "C-USHORT-MAX", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(USHRT_MAX)},
{SYS_ "C-ULONG-MAX", SI_CONSTANT, NULL, -1, OBJNULL}, /* See main.d */
{SYS_ "C-ULONG-LONG-MAX",SI_CONSTANT,NULL,-1,OBJNULL}, /* See main.d */
#ifdef GBC_BOEHM
{SYS_ "GC", SI_ORDINARY, si_gc, 1, OBJNULL},
{SYS_ "GC-DUMP", SI_ORDINARY, si_gc_dump, 0, OBJNULL},
#endif

#if !defined(GBC_BOEHM)
{SYS_ "GC", SI_ORDINARY, si_gc, 1, OBJNULL},
{SYS_ "ALLOCATE", SI_ORDINARY, si_allocate, -1, OBJNULL},
{SYS_ "ALLOCATED-PAGES", SI_ORDINARY, si_allocated_pages, -1, OBJNULL},
{SYS_ "MAXIMUM-ALLOCATABLE-PAGES", SI_ORDINARY, si_maximum_allocatable_pages, -1, OBJNULL},
{SYS_ "ALLOCATE-CONTIGUOUS-PAGES", SI_ORDINARY, si_allocate_contiguous_pages, -1, OBJNULL},
{SYS_ "ALLOCATED-CONTIGUOUS-PAGES", SI_ORDINARY, si_allocated_contiguous_pages, -1, OBJNULL},
{SYS_ "MAXIMUM-CONTIGUOUS-PAGES", SI_ORDINARY, si_maximum_contiguous_pages, -1, OBJNULL},
{SYS_ "GC-TIME", SI_ORDINARY, si_gc_time, -1, OBJNULL},
{SYS_ "GET-HOLE-SIZE", SI_ORDINARY, si_get_hole_size, -1, OBJNULL},
{SYS_ "SET-HOLE-SIZE", SI_ORDINARY, si_set_hole_size, -1, OBJNULL},
{SYS_ "IGNORE-MAXIMUM-PAGES", SI_ORDINARY, si_ignore_maximum_pages, -1, OBJNULL},
{SYS_ "ROOM-REPORT", SI_ORDINARY, si_room_report, -1, OBJNULL},
{SYS_ "RESET-GC-COUNT", SI_ORDINARY, si_reset_gc_count, -1, OBJNULL},
#endif /* !GBC_BOEHM */

#ifdef ECL_THREADS
{MP_ "PROCESS", MP_ORDINARY, NULL, -1, OBJNULL},
{MP_ "LOCK", MP_ORDINARY, NULL, -1, OBJNULL},
{MP_ "CONDITION-VARIABLE", MP_ORDINARY, NULL, -1, OBJNULL},
{MP_ "*CURRENT-PROCESS*", MP_SPECIAL, NULL, -1, OBJNULL},
{MP_ "ALL-PROCESSES", MP_ORDINARY, mp_all_processes, 0, OBJNULL},
{MP_ "EXIT-PROCESS", MP_ORDINARY, mp_exit_process, 0, OBJNULL},
{MP_ "MAKE-PROCESS", MP_ORDINARY, mp_make_process, -1, OBJNULL},
{MP_ "PROCESS-ACTIVE-P", MP_ORDINARY, mp_process_active_p, 1, OBJNULL},
{MP_ "PROCESS-ENABLE", MP_ORDINARY, mp_process_enable, 1, OBJNULL},
{MP_ "PROCESS-YIELD", MP_ORDINARY, mp_process_yield, 0, OBJNULL},
{MP_ "PROCESS-KILL", MP_ORDINARY, mp_process_kill, 1, OBJNULL},
{MP_ "PROCESS-NAME", MP_ORDINARY, mp_process_name, 1, OBJNULL},
{MP_ "PROCESS-PRESET", MP_ORDINARY, mp_process_preset, -1, OBJNULL},
{MP_ "PROCESS-RUN-FUNCTION", MP_ORDINARY, mp_process_run_function, -1, OBJNULL},
{MP_ "PROCESS-WHOSTATE", MP_ORDINARY, mp_process_whostate, 1, OBJNULL},
{MP_ "PROCESS-JOIN", MP_ORDINARY, mp_process_join, 1, OBJNULL},
{MP_ "MAKE-LOCK", MP_ORDINARY, mp_make_lock, -1, OBJNULL},
{KEY_ "RECURSIVE", KEYWORD, NULL, -1, OBJNULL},
{MP_ "RECURSIVE-LOCK-P", MP_ORDINARY, mp_recursive_lock_p, 1, OBJNULL},
{MP_ "LOCK-NAME", MP_ORDINARY, mp_lock_name, 1, OBJNULL},
{MP_ "LOCK-HOLDER", MP_ORDINARY, mp_lock_holder, 1, OBJNULL},
{MP_ "LOCK-COUNT", MP_ORDINARY, mp_lock_count, 1, OBJNULL},
{MP_ "LOCK-MINE-P", MP_ORDINARY, mp_lock_mine_p, 1, OBJNULL},
{MP_ "LOCK-COUNT-MINE", MP_ORDINARY, mp_lock_count_mine, 1, OBJNULL},
{MP_ "GET-LOCK", MP_ORDINARY, mp_get_lock, -1, OBJNULL},
{MP_ "GIVEUP-LOCK", MP_ORDINARY, mp_giveup_lock, 1, OBJNULL},
{MP_ "MAKE-CONDITION-VARIABLE", MP_ORDINARY, mp_make_condition_variable, 0, OBJNULL},
{MP_ "CONDITION-VARIABLE-WAIT", MP_ORDINARY, mp_condition_variable_wait, 2, OBJNULL},
{MP_ "CONDITION-VARIABLE-TIMEDWAIT", MP_ORDINARY, mp_condition_variable_timedwait, 3, OBJNULL},
{MP_ "CONDITION-VARIABLE-SIGNAL", MP_ORDINARY, mp_condition_variable_signal, 1, OBJNULL},
{MP_ "CONDITION-VARIABLE-BROADCAST", MP_ORDINARY, mp_condition_variable_broadcast, 1, OBJNULL},
{KEY_ "INITIAL-BINDINGS", KEYWORD, NULL, -1, OBJNULL},
{MP_ "INTERRUPT-PROCESS", MP_ORDINARY, mp_interrupt_process, 2, OBJNULL},
{MP_ "+LOAD-COMPILE-LOCK+", MP_CONSTANT, NULL, -1, OBJNULL},
{MP_ "WITH-LOCK", MP_CONSTANT, NULL, -1, OBJNULL},
{MP_ "BLOCK-SIGNALS", MP_ORDINARY, mp_block_signals, 0, OBJNULL},
{MP_ "RESTORE-SIGNALS", MP_ORDINARY, mp_restore_signals, 1, OBJNULL},
{MP_ "PROCESS-SUSPEND", MP_ORDINARY, mp_process_suspend, 1, OBJNULL},
{MP_ "PROCESS-RESUME", MP_ORDINARY, mp_process_resume, 1, OBJNULL},
{MP_ "SUSPEND-LOOP", MP_ORDINARY, mp_suspend_loop, 0, OBJNULL},
{MP_ "BREAK-SUSPEND-LOOP", MP_ORDINARY, mp_break_suspend_loop, 0, OBJNULL},
# ifdef ECL_SEMAPHORES
{MP_ "SEMAPHORE", MP_ORDINARY, NULL, -1, OBJNULL},
{MP_ "MAKE-SEMAPHORE", MP_ORDINARY, mp_make_semaphore, -1, OBJNULL},
{MP_ "SEMAPHORE-WAIT", MP_ORDINARY, mp_semaphore_wait, 1, OBJNULL},
{MP_ "SEMAPHORE-TRYWAIT", MP_ORDINARY, mp_semaphore_trywait, 1, OBJNULL},
{MP_ "SEMAPHORE-SIGNAL", MP_ORDINARY, mp_semaphore_signal, 1, OBJNULL},
{MP_ "SEMAPHORE-CLOSE", MP_ORDINARY, mp_semaphore_close, 1, OBJNULL},
# endif
#endif

{SYS_ "WHILE", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "UNTIL", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "QUASIQUOTE", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "*EXIT-HOOKS*", SI_SPECIAL, NULL, -1, Cnil},

#ifdef CLOS
{CLOS_ ".COMBINED-METHOD-ARGS.", CLOS_SPECIAL, NULL, -1, Cnil},
{CLOS_ "*BUILTIN-CLASSES*", CLOS_SPECIAL, NULL, -1, Cnil},
{CLOS_ "*NEXT-METHODS*", CLOS_SPECIAL, NULL, -1, Cnil},
{CLOS_ "*OPTIMIZE-SLOT-ACCESS*", CLOS_SPECIAL, NULL, -1, Ct},
{CLOS_ "ACCESSOR-METHOD-SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "ADD-DEPENDENT", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "ADD-DIRECT-METHOD", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "ADD-DIRECT-SUBCLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-DEFAULT-INITARGS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-DIRECT-DEFAULT-INITARGS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-DIRECT-SLOTS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-DIRECT-SUBCLASSES", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-DIRECT-SUPERCLASSES", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-FINALIZED-P", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-PRECEDENCE-LIST", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-PROTOTYPE", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "CLASS-SLOTS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "COMPUTE-APPLICABLE-METHODS-USING-CLASSES", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "COMPUTE-CLASS-PRECEDENCE-LIST", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "COMPUTE-DEFAULT-INITARGS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "COMPUTE-DISCRIMINATING-FUNCTION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "COMPUTE-EFFECTIVE-METHOD", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "COMPUTE-EFFECTIVE-SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "COMPUTE-SLOTS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "DIRECT-SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "DIRECT-SLOT-DEFINITION-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "ENSURE-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "ENSURE-CLASS-USING-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "ENSURE-GENERIC-FUNCTION-USING-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "EQL-SPECIALIZER", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "EQL-SPECIALIZER-OBJECT", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "EXTRACT-LAMBDA-LIST", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "EXTRACT-SPECIALIZER-NAMES", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "FINALIZE-INHERITANCE", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "FIND-METHOD-COMBINATION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "FORWARD-REFERENCED-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "FUNCALLABLE-STANDARD-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "FUNCALLABLE-STANDARD-INSTANCE-ACCESS", CLOS_ORDINARY, si_instance_ref, 2, OBJNULL},
{CLOS_ "FUNCALLABLE-STANDARD-OBJECT", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "GENERIC-FUNCTION-ARGUMENT-PRECEDENCE-ORDER", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "GENERIC-FUNCTION-DECLARATIONS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "GENERIC-FUNCTION-LAMBDA-LIST", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "GENERIC-FUNCTION-METHOD-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "GENERIC-FUNCTION-METHOD-COMBINATION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "GENERIC-FUNCTION-METHODS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "GENERIC-FUNCTION-NAME", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "INTERN-EQL-SPECIALIZER", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "MAKE-METHOD-LAMBDA", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "MAP-DEPENDENTS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "METAOBJECT", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "METHOD-FUNCTION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "METHOD-GENERIC-FUNCTION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "METHOD-LAMBDA-LIST", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "METHOD-SPECIALIZERS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "READER-METHOD-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "REMOVE-DEPENDENT", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "REMOVE-DIRECT-METHOD", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "REMOVE-DIRECT-SUBCLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SET-FUNCALLABLE-INSTANCE-FUNCTION", CLOS_ORDINARY, clos_set_funcallable_instance_function, 2, OBJNULL},
{CLOS_ "SLOT-BOUNDP-USING-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-ALLOCATION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-INITARGS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-INITFORM", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-INITFUNCTION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-LOCATION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-NAME", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-READERS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-TYPE", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-DEFINITION-WRITERS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-MAKUNBOUND-USING-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SLOT-VALUE-USING-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SPECIALIZER", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SPECIALIZER-DIRECT-GENERIC-FUNCTIONS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "SPECIALIZER-DIRECT-METHODS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "STANDARD-ACCESSOR-METHOD", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "STANDARD-DIRECT-SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "STANDARD-EFFECTIVE-SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "STANDARD-INSTANCE-ACCESS", CLOS_ORDINARY, si_instance_ref, 2, OBJNULL},
{CLOS_ "STANDARD-READER-METHOD", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "STANDARD-SLOT-DEFINITION", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "STANDARD-WRITER-METHOD", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "UPDATE-DEPENDENT", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "VALIDATE-SUPERCLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
{CLOS_ "WRITER-METHOD-CLASS", CLOS_ORDINARY, NULL, -1, OBJNULL},
#endif

{SYS_ "CL-FIXNUM-BITS", SI_CONSTANT, NULL, -1, MAKE_FIXNUM(FIXNUM_BITS)},
{EXT_ "CL-FIXNUM", SI_ORDINARY, NULL, -1, NULL},
{EXT_ "CL-INDEX", SI_ORDINARY, NULL, -1, NULL},

{SYS_ "DO-DEFTYPE", SI_ORDINARY, ECL_NAME(si_do_deftype), -1, OBJNULL},
{SYS_ "CREATE-TYPE-NAME", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "*ALIEN-DECLARATIONS*", SI_SPECIAL, NULL, -1, Cnil},

#ifdef ENABLE_DLOPEN
{SYS_ "LOAD-BINARY", SI_ORDINARY, si_load_binary, 3, OBJNULL},
#endif

{SYS_ "*CODE-WALKER*", SI_SPECIAL, NULL, -1, OBJNULL},

#if defined(HAVE_LIBFFI) || defined(ECL_DYNAMIC_FFI)
{SYS_ "CALL-CFUN", SI_ORDINARY, si_call_cfun, -1, OBJNULL},
{KEY_ "CALLBACK", KEYWORD, NULL, -1, OBJNULL},
{SYS_ "MAKE-DYNAMIC-CALLBACK", SI_ORDINARY, si_make_dynamic_callback, -1, OBJNULL},
#endif
{KEY_ "CDECL", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "STDCALL", KEYWORD, NULL, -1, OBJNULL},

{SYS_ "TRAP-FPE", SI_ORDINARY, si_trap_fpe, 2, OBJNULL},

{SYS_ "*ACTION-ON-UNDEFINED-VARIABLE*", SI_SPECIAL, NULL, -1, Cnil},

{SYS_ "SET-BUFFERING-MODE", SI_ORDINARY, si_set_buffering_mode, 2, OBJNULL},
{KEY_ "NONE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LINE-BUFFERED", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FULLY-BUFFERED", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LINE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "FULL", KEYWORD, NULL, -1, OBJNULL},

{SYS_ "CMP-ENV-REGISTER-MACROLET", SI_ORDINARY, NULL, -1, OBJNULL},

{SYS_ "GET-FINALIZER", SI_ORDINARY, si_get_finalizer, 1, OBJNULL},
{SYS_ "SET-FINALIZER", SI_ORDINARY, si_set_finalizer, 2, OBJNULL},

#ifdef ECL_RELATIVE_PACKAGE_NAMES
{SYS_ "*RELATIVE-PACKAGE-NAMES*", SI_SPECIAL, NULL, -1, RELATIVE_PACKAGES_P},
{KEY_ "RELATIVE-PACKAGE-NAMES", KEYWORD, NULL, -1, OBJNULL},
{SYS_ "FIND-RELATIVE-PACKAGE", SI_ORDINARY, si_find_relative_package, -1, OBJNULL},
{SYS_ "PACKAGE-PARENT", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "PACKAGE-CHILDREN", SI_ORDINARY, NULL, -1, OBJNULL},
#endif

{SYS_ "WRONG-TYPE-ARGUMENT", SI_ORDINARY, NULL, -1, OBJNULL},

#ifdef GBC_BOEHM
{SYS_ "GC-STATS", SI_ORDINARY, si_gc_stats, 1, OBJNULL},
#endif

{SYS_ "*CURRENT-FORM*", SI_SPECIAL, NULL, -1, OBJNULL},

{SYS_ "CODE-BLOCK", SI_ORDINARY, NULL, -1, OBJNULL},

#ifdef CLOS
{SYS_ "CLEAR-GFUN-HASH", SI_ORDINARY, si_clear_gfun_hash, 1, OBJNULL},
#endif

{SYS_ "FRAME", SI_ORDINARY, NULL, -1, OBJNULL},
{SYS_ "APPLY-FROM-STACK-FRAME", SI_ORDINARY, si_apply_from_stack_frame, 2, OBJNULL},

#ifdef ECL_CLOS_STREAMS
{GRAY_ "CLOSE", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAMP", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "INPUT-STREAM-P", GRAY_ORDINARY, NULL, 1, OBJNULL},
{GRAY_ "OUTPUT-STREAM-P", GRAY_ORDINARY, NULL, 1, OBJNULL},
{GRAY_ "OPEN-STREAM-P", GRAY_ORDINARY, NULL, 1, OBJNULL},
{GRAY_ "STREAM-ADVANCE-TO-COLUMN", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-CLEAR-INPUT", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-CLEAR-OUTPUT", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-ELEMENT-TYPE", GRAY_ORDINARY, NULL, 1, OBJNULL},
{GRAY_ "STREAM-FILE-POSITION", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-FINISH-OUTPUT", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-FORCE-OUTPUT", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-FRESH-LINE", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-INTERACTIVE-P", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-LINE-COLUMN", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-LISTEN", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-PEEK-CHAR", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-READ-BYTE", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-READ-CHAR", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-READ-CHAR-NO-HANG", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-READ-LINE", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-READ-SEQUENCE", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-START-LINE-P", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-TERPRI", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-UNREAD-CHAR", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-WRITE-BYTE", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-WRITE-CHAR", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-WRITE-SEQUENCE", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "STREAM-WRITE-STRING", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-INPUT-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-OUTPUT-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-CHARACTER-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-BINARY-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-CHARACTER-INPUT-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-BINARY-INPUT-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
{GRAY_ "FUNDAMENTAL-BINARY-OUTPUT-STREAM", GRAY_ORDINARY, NULL, -1, OBJNULL},
#endif

{"LOG1P", SI_ORDINARY, si_log1p, 1, OBJNULL},

{EXT_ "BC-FILE", EXT_ORDINARY, si_compiled_function_file, 1, Cnil},
{EXT_ "COMPILED-FUNCTION-FILE", EXT_ORDINARY, si_compiled_function_file, 1, Cnil},

{SYS_ "PROPERTY-LIST", SI_ORDINARY, NULL, 1, OBJNULL},

{SYS_ "BYTECODES", SI_ORDINARY, NULL, 1, OBJNULL},

{SYS_ "HASH-EQL", SI_ORDINARY, si_hash_eql, -1, OBJNULL},
{SYS_ "HASH-EQUAL", SI_ORDINARY, si_hash_equal, -1, OBJNULL},
{SYS_ "HASH-EQUALP", SI_ORDINARY, si_hash_equalp, -1, OBJNULL},

{EXT_ "INTERACTIVE-INTERRUPT", EXT_ORDINARY, NULL, -1, OBJNULL},

{EXT_ "STORAGE-EXHAUSTED", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "STACK-OVERFLOW", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "STACK-OVERFLOW-SIZE", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "STACK-OVERFLOW-TYPE", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "BINDING-STACK", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "FRAME-STACK", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "LISP-STACK", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "C-STACK", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "HEAP-SIZE", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "SET-LIMIT", EXT_ORDINARY, si_set_limit, 2, OBJNULL},
{EXT_ "GET-LIMIT", EXT_ORDINARY, si_get_limit, 1, OBJNULL},
{EXT_ "SEGMENTATION-VIOLATION", EXT_ORDINARY, NULL, -1, OBJNULL},

{EXT_ "EXTENDED-STRING", EXT_ORDINARY, NULL, -1, OBJNULL},

{SYS_ "CHECK-PENDING-INTERRUPTS", SI_ORDINARY, si_check_pending_interrupts, 0, OBJNULL},

{KEY_ "LATIN-1", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "ISO-8859-1", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UTF-8", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UCS-2", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UCS-4", KEYWORD, NULL, -1, OBJNULL},

{EXT_ "CONSTANTLY-T", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "CONSTANTLY-NIL", EXT_ORDINARY, NULL, -1, OBJNULL},

{EXT_ "MAYBE-QUOTE", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "MAYBE-UNQUOTE", EXT_ORDINARY, NULL, -1, OBJNULL},

{KEY_ "CR", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LF", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "CRLF", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UCS-2BE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UCS-4BE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UCS-2LE", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UCS-4LE", KEYWORD, NULL, -1, OBJNULL},

{EXT_ "LOAD-ENCODING", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "MAKE-ENCODING", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "ALL-ENCODINGS", EXT_ORDINARY, NULL, -1, OBJNULL},

{KEY_ "US-ASCII", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "LITTLE-ENDIAN", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "BIG-ENDIAN", KEYWORD, NULL, -1, OBJNULL},

{SYS_ "+UNICODE-DATABASE+", SI_CONSTANT, NULL, -1, Cnil},

{SYS_ "COPY-FILE", SI_ORDINARY, si_copy_file, 2, OBJNULL},

{EXT_ "FILL-ARRAY-WITH-ELT", EXT_ORDINARY, si_fill_array_with_elt, 4, OBJNULL},

{EXT_ "+ECL-VERSION-NUMBER+", EXT_CONSTANT, NULL, -1, MAKE_FIXNUM(ECL_VERSION_NUMBER)},

{EXT_ "*BYTECODES-COMPILER*", EXT_SPECIAL, NULL, -1, Cnil},

{EXT_ "SHORT-FLOAT-POSITIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "SINGLE-FLOAT-POSITIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "DOUBLE-FLOAT-POSITIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "LONG-FLOAT-POSITIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "SHORT-FLOAT-NEGATIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "SINGLE-FLOAT-NEGATIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "DOUBLE-FLOAT-NEGATIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "LONG-FLOAT-NEGATIVE-INFINITY", EXT_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "FLOAT-NAN-P", EXT_ORDINARY, si_float_nan_p, 1, OBJNULL},
{EXT_ "FLOAT-INFINITY-P", EXT_ORDINARY, si_float_infinity_p, 1, OBJNULL},

{SYS_ "READ-OBJECT-OR-IGNORE", EXT_ORDINARY, si_read_object_or_ignore, 2, OBJNULL},

{EXT_ "OUTPUT-FLOAT-NAN", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "OUTPUT-FLOAT-INFINITY", EXT_ORDINARY, NULL, -1, OBJNULL},

{EXT_ "READTABLE-LOCK", EXT_ORDINARY, si_readtable_lock, -1, OBJNULL},

{SYS_ "+IO-SYNTAX-PROGV-LIST+", SI_CONSTANT, NULL, -1, OBJNULL},
{SYS_ "+ECL-SYNTAX-PROGV-LIST+", SI_CONSTANT, NULL, -1, OBJNULL},
{SYS_ "WITH-ECL-IO-SYNTAX", SI_ORDINARY, NULL, -1, OBJNULL},

{SYS_ "STREAM-EXTERNAL-FORMAT-SET", SI_ORDINARY, si_stream_external_format_set, 2, OBJNULL},

{KEY_ "SYSV", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "UNIX64", KEYWORD, NULL, -1, OBJNULL},

{EXT_ "WEAK-POINTER", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "MAKE-WEAK-POINTER", EXT_ORDINARY, si_make_weak_pointer, 1, OBJNULL},
{EXT_ "WEAK-POINTER-VALUE", EXT_ORDINARY, si_weak_pointer_value, 1, OBJNULL},

{SYS_ "*ALLOW-WITH-INTERRUPTS*", SI_SPECIAL, NULL, -1, Ct},

{EXT_ "WITH-UNIQUE-NAMES", EXT_ORDINARY, NULL, -1, OBJNULL},

{SYS_ "HANDLE-SIGNAL", SI_ORDINARY, si_handle_signal, 1, OBJNULL},

{EXT_ "WITH-INTERRUPTS", MP_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "WITHOUT-INTERRUPTS", MP_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "WITH-LOCAL-INTERRUPTS", MP_CONSTANT, NULL, -1, OBJNULL},
{EXT_ "ALLOW-WITH-INTERRUPTS", MP_CONSTANT, NULL, -1, OBJNULL},

{SYS_ "*QUIT-TAG*", SI_SPECIAL, NULL, -1, OBJNULL},

{EXT_ "ARRAY-RAW-DATA", EXT_ORDINARY, si_array_raw_data, 1, OBJNULL},

{EXT_ "*PROGRAM-EXIT-CODE*", EXT_SPECIAL, NULL, -1, MAKE_FIXNUM(0)},
{EXT_ "EXIT", EXT_ORDINARY, si_exit, -1, OBJNULL},

{EXT_ "ENVIRON", EXT_ORDINARY, si_environ, 0, OBJNULL},

{KEY_ "ENVIRON", KEYWORD, NULL, -1, OBJNULL},

{EXT_ "MAKE-EXTERNAL-PROCESS", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "EXTERNAL-PROCESS", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "EXTERNAL-PROCESS-PID", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "EXTERNAL-PROCESS-INPUT", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "EXTERNAL-PROCESS-OUTPUT", EXT_ORDINARY, NULL, -1, OBJNULL},
{EXT_ "EXTERNAL-PROCESS-STATUS", EXT_ORDINARY, NULL, -1, OBJNULL},

{KEY_ "RUNNING", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "EXITED", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "SIGNALED", KEYWORD, NULL, -1, OBJNULL},
{KEY_ "STOPPED", KEYWORD, NULL, -1, OBJNULL},

{EXT_ "EXTERNAL-PROCESS-WAIT", EXT_ORDINARY, si_external_process_wait, -1, OBJNULL},

#if defined(_MSC_VER) || defined(mingw32)
{SYS_ "CLOSE-WINDOWS-HANDLE", SI_ORDINARY, si_close_windows_handle, 1, OBJNULL},
#endif

{EXT_ "*INVOKE-DEBUGGER-HOOK*", EXT_SPECIAL, NULL, -1, Cnil},

{EXT_ "*DOCUMENTATION-POOL*", EXT_SPECIAL, NULL, -1, Cnil},
{EXT_ "ANNOTATE", EXT_ORDINARY, NULL, -1, Cnil},
{EXT_ "GET-ANNOTATION", EXT_ORDINARY, NULL, -1, Cnil},
{EXT_ "REMOVE-ANNOTATION", EXT_ORDINARY, NULL, -1, Cnil},
{EXT_ "FUNCTION-LAMBDA-LIST", EXT_ORDINARY, NULL, -1, Cnil},
{EXT_ "DEFAULT-ANNOTATION-LOGIC", EXT_ORDINARY, NULL, -1, Cnil},
{EXT_ "OPTIONAL-ANNOTATION", EXT_ORDINARY, NULL, -1, Cnil},
{EXT_ "LOCATION", EXT_ORDINARY, NULL, -1, Cnil},

{EXT_ "LISP-IMPLEMENTATION-VCS-ID", EXT_ORDINARY, NULL, -1, Cnil},

/* Tag for end of list */
{NULL, CL_ORDINARY, NULL, -1, OBJNULL}};
