.TH "ecatools" "1" "18\&.04\&.2004" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecatools \- audio processing utils based on ecasound
.PP 
.SH "SYNOPSIS" 
\fBecaconvert\fP \&.extension file1 [ file2,\&.\&.\&.,fileN ]
.PP 
\fBecafixdc\fP file1 [ file2,\&.\&.\&.,fileN ]
.PP 
\fBecalength\fP file1 [ file2,\&.\&.\&.,fileN ]
.PP 
\fBecamonitor\fP [host][:port]
.PP 
\fBecanormalize\fP file1 [ file2,\&.\&.\&.,fileN ]
.PP 
\fBecaplay\fP [-dhk] file1 [ file2,\&.\&.\&.,fileN ]
.PP 
\fBecasignalview\fP [ options ] [ input ] [ output ]
.PP 
.SH "DESCRIPTION" 
.PP 
Ecatools are simple command line utils that do various audio
processing tasks\&. Most of them support batch processing\&. They all
use ecasound to do the actual audio processing work\&.
.PP 
\fBECACONVERT\fP
.PP 
A tool for converting a set of files to a common target format\&.
This target format is given as the first command line
argument, and its syntax is \fI\&.ext\fP\&.
.PP 
\fBECAFIXDC\fP
.PP 
A simple command-line tool for fixing DC-offset\&.
.PP 
\fBECALENGTH\fP
.PP 
See the separate ecalength(1) man page\&.
.PP 
\fBECAMONITOR\fP
.PP 
Ecamonitor is a util program that can be used 
to monitor an active ecasound session\&. Ecamonitor 
is able to show information about the current 
chainsetup such as list of inputs, outputs, 
current position, effects, the engine status 
and numerous other things\&.
.PP 
By default ecamonitor will try to connect 
to IP4 address "localhost", to port "2868"\&. 
A different address can be specified when 
starting ecamonitor, for example 
"ecamonitor foo\&.mynetwork\&.com" or
"ecamonitor foo\&.mynetwork\&.com:4500"\&.
.PP 
To enable inbound connections, ecasound has to be 
started with the \fI--daemon\fP option\&. Ecamonitor is 
implemented in Python using the NetECI API\&.
.PP 
\fBECANORMALIZE\fP
.PP 
A simple command-line tool for normalizing sample volume\&. 
Finds out how much input file can be amplified without clipping
and, if necessary, does the amplification\&.
.PP 
\fBECAPLAY\fP
.PP 
Command-line tool that plays input files using the default output 
specified in \fI~/\&.ecasoundrc\fP\&. Note! You can abort ecaplay at any
time by pressing Ctrl-C\&. If you are playing multiple files, this will 
stop the current file and begin playing the next one\&. If you want 
to abort playing immediately instead of skipping to the 
next file, press Ctrl-C twice in short succession (around one
second)\&.
.PP 
.IP "-d:debuglevel" 
Set libecasound debug level\&. See ecasound(1)\&.
.IP 
.IP "-h" 
Print usage information and exit\&.
.IP 
.IP "-k:number" 
Skip \&'number\&' of files\&.
.IP 
.IP "-o:output_device" 
Use \&'output_device\&' instead of the default output device 
(as specified in \fI~/\&.ecasoundrc\fP\&.
.IP 
.PP 
\fBECASIGNALVIEW\fP
.PP 
Ecasignalview is meant for monitoring signal amplitude and peak 
statistics\&. It accepts the following options:
.PP 
.IP "input" 
The first option not starting with a \&'-\&' is interpreted 
as input string\&. This can be a device or a filename\&. All formats
supported by libecasound are accepted\&. Defaults to \&'/dev/dsp\&'\&.
.IP 
.IP "output" 
Similarly to input, second option not starting with a \&'-\&'
is interpreted as output\&. Defaults to \&'null\&'\&.
.IP 
.IP "-b:buffersize" 
Buffersize in sample frames\&. Defaults to 128\&.
.IP 
.IP "-c" 
Enable cumulative mode\&. Counters are not reseted after refresh\&.
\fI*deprecated*\fP
.IP 
.IP "-d" 
Enable debug mode\&.
.IP 
.IP "-f:format_string" 
Specify default audio format\&. See ecasound(1) for details\&.
.IP 
.IP "-r:rate_msec" 
Specify screen refresh rate in milliseconds\&.
.PP 
More complete documentation for ecasignalview can be found 
from "Ecasound User\&'s Guide" (see \&'\&'http://www\&.eca\&.cx/ecasound 
-> Documentation\&'\&')\&.
.PP 
.SH "ENVIRONMENT" 
.PP 
\fIECASOUND\fP
Path to the ecasound executable\&. Affects most ecatools\&.
.PP 
.SH "FILES" 
.PP 
\fI~/\&.ecasound/ecasoundrc\fP
The default ecasound resource file\&. See ecasoundrc(5)
for details\&.
.PP 
.SH "SEE ALSO" 
.PP 
ecasound (1), ecalength(1), "HTML docs in the Documentation subdirectory"
.PP 
.SH "AUTHOR" 
.PP 
Kai Vehmanen, <kvehmanen -at- eca -dot- cx>
.PP 
