@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-certificate-list: List Available Operations
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;
use Term::ReadKey;

my %opt = ( version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );

my $operationname = $ARGV[0];

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

if ( not($operationname) ) {

	# Get the list of operations
	my $operations = $controlChannel->getOperationList($token);

	# Display the information for each operation
	foreach $operation ( $operations->valueof('//getOperationListResponse/return') ) {
		printf "%-20s %-8s %-20s %-20s\n", $operation->{name}, $operation->{duration}, $operation->{endDate}, $operation->{comment};
	}
}
else {

	# Get the information for the specified operation
	$operation = $controlChannel->getOperation( $token, $operationname )->valueof('//getOperationResponse/return');
	print "   Operation name: ", $operation->{name},      "\n";
	print "Standard Validity: ", $operation->{standard},  "\n";
	print "    Your Validity: ", $operation->{duration},  "\n";
	print "       Start Date: ", $operation->{startDate}, "\n";
	print "         End Date: ", $operation->{endDate},   "\n";
	print "          Comment: ", $operation->{comment},   "\n";
}

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-certificate-list - List Available Operations

=head1 SYNOPSIS

B<ecaccess-certificate-list -version|-help|-manual>

B<ecaccess-certificate-list [-debug] [>I<operation-name>B<]>

=head1 DESCRIPTION

List all the Operations which are available with the current Certificate (the one
in your "$HOME/.eccert.crt" File). If a required Operation is expired then you should
renew your Certificate with the B<ecaccess-certificate-create> command. If you specify
an I<operation-name> on the command-line then the information for this Operation only
will be displayed.

=head1 ARGUMENTS

=over 8

=item <operation-name> (optional)

The name of the Operation to retrieve the details.

=back

=head1 OPTIONS

=over 8

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-certificate-list>

List all the Operations for your certificate.

B<ecaccess-certificate-list> I<submitJob>

List all the details for the Operation I<submitJob> only.

=head1 SEE ALSO

B<ecaccess-certificate-create> and B<ecaccess>.

=cut

__END__
:endofperl
