/* bar.h - 2000/05/05 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __BAR_H__
#define __BAR_H__


/***************
 * Declaration *
 ***************/
GtkWidget      *MenuBar;
GtkWidget      *ProgressBar;
GtkWidget      *ToolBar;
GtkItemFactory *ItemFactory;
guint           StatusBarContext;

GtkWidget *CheckMenuItemBrowseSubdirMainMenu;

/* Tool Bar */
GtkWidget *TBFirstButton;
GtkWidget *TBPrevButton;
GtkWidget *TBNextButton;
GtkWidget *TBLastButton;
GtkWidget *TBScanButton;
GtkWidget *TBRemoveButton;
GtkWidget *TBUndoButton;
GtkWidget *TBRedoButton;
GtkWidget *TBSaveButton;
GtkWidget *TBStopButton;
GtkWidget *TBShowBrowserButton;
GtkWidget *TBSelectAllButton;
GtkWidget *TBInvertSelectionButton;
GtkWidget *TBQuitButton;


/*
 * This values are set to find the entry into the itemfactory
 * and (un)sensitive the item. (Value 0 = not define)
 */
enum Action_Menu 
{     
    AM_PREV = 1,
    AM_NEXT,
    AM_FIRST,
    AM_LAST,
    AM_SCAN,
    AM_REMOVE,
    AM_UNDO,
    AM_REDO,
    AM_UNDO_HISTORY,
    AM_REDO_HISTORY,
    AM_SAVE,
    AM_SELECT_ALL_FILES,
    AM_UNSELECT_ALL_FILES,
    AM_INVERT_SELECTION,
    AM_DELETE_FILE,
    AM_LOAD_HOME_DIR,
    AM_LOAD_DEFAULT_DIR,
    AM_SET_PATH_AS_DEFAULT,
    AM_RENAME_DIR,
    AM_RECURSE,
    AM_COLLAPSE_TREE,
    AM_INITIALIZE_TREE,
    AM_RELOAD_DIRECTORY,
    AM_TREE_OR_ARTISTALBUM_VIEW,
    AM_BROWSE_DIRECTORY_WITH,
    AM_BROWSE_FILE_WITH,
    AM_OPEN_OPTIONS_WINDOW,
    AM_SAVE_CONFIG,
    AM_SCANNER_FILL_TAG,
    AM_SCANNER_RENAME_FILE,
    AM_SCANNER_PROCESS_FIELDS,
    AM_SEARCH_FILE,
    AM_CDDB_SEARCH,
    AM_FILENAME_FROM_TXT,
    AM_WRITE_PLAYLIST,
    AM_RUN_AUDIO_PLAYER,
    AM_OPEN_ABOUT_WINDOW,
    AM_QUIT,
    AM_SORT_ASCENDING_FILENAME,
    AM_SORT_DESCENDING_FILENAME,
    AM_SORT_ASCENDING_CREATION_DATE,
    AM_SORT_DESCENDING_CREATION_DATE,
    AM_SORT_ASCENDING_TRACK_NUMBER,
    AM_SORT_DESCENDING_TRACK_NUMBER,
    AM_SORT_ASCENDING_TITLE,
    AM_SORT_DESCENDING_TITLE,
    AM_SORT_ASCENDING_ARTIST,
    AM_SORT_DESCENDING_ARTIST,
    AM_SORT_ASCENDING_ALBUM,
    AM_SORT_DESCENDING_ALBUM,
    AM_SORT_ASCENDING_YEAR,
    AM_SORT_DESCENDING_YEAR,
    AM_SORT_ASCENDING_GENRE,
    AM_SORT_DESCENDING_GENRE,
    AM_SORT_ASCENDING_COMMENT,
    AM_SORT_DESCENDING_COMMENT,
    AM_SORT_ASCENDING_FILE_TYPE,
    AM_SORT_DESCENDING_FILE_TYPE,
    AM_SORT_ASCENDING_FILE_SIZE,
    AM_SORT_DESCENDING_FILE_SIZE,
    AM_SORT_ASCENDING_FILE_DURATION,
    AM_SORT_DESCENDING_FILE_DURATION,
    AM_SORT_ASCENDING_FILE_BITRATE,
    AM_SORT_DESCENDING_FILE_BITRATE,
    AM_SORT_ASCENDING_FILE_SAMPLERATE,
    AM_SORT_DESCENDING_FILE_SAMPLERATE
};


/**************
 * Prototypes *
 **************/

GtkWidget *Create_Menu_Bar (void);
GtkWidget *Create_Status_Bar (void);
void       Statusbar_Message (gchar *message, gint with_timer);
GtkWidget *Create_Progress_Bar (void);
GtkWidget *Create_Tool_Bar (void);

void Check_Menu_Item_Toggled_Browse_Subdir (GtkWidget *checkmenuitem);
void Check_Menu_Item_Update_Browse_Subdir (void);


#endif /* __BAR_H__ */
