/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/

#ifndef FRAMEPOOL_H
#define FRAMEPOOL_H

class FramePool {
public:
	FramePool(int width, int height, int bpp, int max_frames=20);
	virtual ~FramePool();

	void 	addFrame(unsigned char *src);			// add a frame in a pool. overwrite the oldest if the pool is full
	//void	addSameFrame();					// add the same frame that has been previiously added (if it exists)
	void 	removeFrame();					// remove the oldest frame
	unsigned char 	*getFrame();					// return the adress of the oldest frame, wait for a frame to be added if the pool is empty

	void	setTopMargin(int);				// horizontal margins
	int		getTopMargin() const;
	void	setBottomMargin(int);
	int		getBottomMargin() const;	

	int 	size() const;
	int 	max_size() const;
	bool 	full() const;
	
protected:
	enum { SEM_ID_FRAME_AVAILABLE, SEM_ID_MUTEX };
	int	width, height, bpp, opp;	// opp=(bpp+7)/8    bpp=bits per pixel,  opp=byte per pixel
	int	top_margin, bottom_margin;		
	
	unsigned char	*frames;				// allocation pool:
  bool *frames_null;
	int		max_frames;				// max number of frames in the pool
	unsigned char	*previous_frame;

	int		frame_size;				// size of a chunk in byte

	int		newest;					// where the next added chunk will be
	int		oldest;					// where the oldest chunk is

	int		nb_frames;				// number of chunks actually in the pool

	int		sem_id;
};


#endif //FRAMEPOOL_H
