/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/

// audio configuration dialog box implementation header

#ifndef QAUDIOCONFIGIMPL_H
#define QAUDIOCONFIGIMPL_H
#include "QAudioConfig.h"

struct AudioFormats {
	char *label;
	int id;
};

class QAudioConfigImpl : public QAudioConfig
{ 
    Q_OBJECT

public:
    QAudioConfigImpl( QWidget* parent = 0, const char* name = 0 );
    ~QAudioConfigImpl();

	bool getSoundRecordingEnabled() const;
	int getFormat() const;
	int getFrequency() const;
	int getSampleSize() const;
	int getChannels() const;
	int getByterate() const;
	QString getDevice() const;

	void setSoundRecordingEnabled(bool);
	void setFormat(int);
	void setFrequency(int);
	void setSampleSize(int);
	void setChannels(int);
	void setByterate(int);
	void setDevice(QString);

public slots:
    virtual void changeFormat(const QString &);
	virtual void changeParameter();

signals:
	void parameterChanged();

protected:
	int format;

	static struct AudioFormats formats[];


};

#endif // QAUDIOCONFIGIMPL_H
