/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/
#include <iostream>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <avifile/formats.h>
#include "QAudioConfigImpl.h"


struct AudioFormats QAudioConfigImpl::formats[]={
	{"mp3", WAVE_FORMAT_MPEGLAYER3},
	{"PCM", WAVE_FORMAT_PCM}
};


/* 
 *  Constructs a QAudioConfigImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
QAudioConfigImpl::QAudioConfigImpl( QWidget* parent,  const char* name )
    : QAudioConfig( parent, name )
{
	for(unsigned int f=0; f<sizeof(formats)/sizeof(formats[0]); f++) {
		qcb_format->insertItem(formats[f].label);
	}
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QAudioConfigImpl::~QAudioConfigImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


void QAudioConfigImpl::changeFormat(const QString &s) {
	// a changer si evolution codec son dans avifile
	if(QString::compare(s, "mp3")==0) {
		qcb_bitrate->setEnabled(true);
		format=WAVE_FORMAT_MPEGLAYER3;
	} else {
		qcb_bitrate->setEnabled(false);
		format=WAVE_FORMAT_PCM;
	}
	emit(parameterChanged());
}

bool QAudioConfigImpl::getSoundRecordingEnabled() const {
	return qcb_sound_recording_enabled->isChecked();
}

int QAudioConfigImpl::getFormat() const {
	return format;
}

int QAudioConfigImpl::getFrequency() const {
	return qcb_frequency->text(qcb_frequency->currentItem()).toInt();
}

int QAudioConfigImpl::getSampleSize() const {
	if(qrb_8bits->isChecked()) {
		return 8;
	} else {
		return 16;
	}
}

int QAudioConfigImpl::getChannels() const {
	if(qrb_mono->isChecked()) {
		return 1;
	} else {
		return 2;
	}
}

int QAudioConfigImpl::getByterate() const {
	return qcb_bitrate->text(qcb_bitrate->currentItem()).toInt()*1000/8;
}

QString QAudioConfigImpl::getDevice() const {
	return qle_sound_device->text();
}

void QAudioConfigImpl::setSoundRecordingEnabled(bool e) {
	if(e) {
		qcb_sound_recording_enabled->setChecked(true);
		qgb_capture->setEnabled(true);
		qgb_encoding->setEnabled(true);
	}
	else {
		qcb_sound_recording_enabled->setChecked(false);
		qgb_capture->setEnabled(false);
		qgb_encoding->setEnabled(false);
	}
}

void QAudioConfigImpl::setFormat(int f) {
	format=f;

	for(unsigned int i=0; i<sizeof(formats); i++) {
		if(formats[i].id==format) {
			for(int j=0; j<qcb_format->count(); j++) {
				if(QString::compare(formats[i].label, qcb_format->text(j))==0) {
					qcb_format->setCurrentItem(j);
					break;	
				}
			}
		}
	}

	switch(f) {
		case WAVE_FORMAT_MPEGLAYER3 :
			qcb_bitrate->setEnabled(true);
			break;
		case WAVE_FORMAT_PCM :
			qcb_bitrate->setEnabled(false);
			break;
	}
}

void QAudioConfigImpl::setFrequency(int f) {
	for(int j=0; j<qcb_frequency->count(); j++) {
		if(qcb_frequency->text(j).toInt()==f) {
			qcb_frequency->setCurrentItem(j);
			break;	
		}
	}
}

void QAudioConfigImpl::setSampleSize(int s) {
	if(s==8) {
		qrb_8bits->toggle();
	} else {
		qrb_16bits->toggle();
	}
}

void QAudioConfigImpl::setChannels(int c) {
	if(c==1) {
		qrb_mono->toggle();
	} else {
		qrb_stereo->toggle();
	}
}

void QAudioConfigImpl::setByterate(int b) {
	int bitrate=(b*8)/1000;
	for(int j=0; j<qcb_bitrate->count(); j++) {
		if(qcb_bitrate->text(j).toInt()==bitrate) {
			qcb_bitrate->setCurrentItem(j);
			break;	
		}
	}
}

void QAudioConfigImpl::setDevice(QString device) {
	qle_sound_device->setText(device);
}

void QAudioConfigImpl::changeParameter() {
	if(qcb_sound_recording_enabled->isChecked()) {
		qgb_capture->setEnabled(true);
		qgb_encoding->setEnabled(true);
	} else {
		qgb_capture->setEnabled(false);
		qgb_encoding->setEnabled(false);
	}
	emit(parameterChanged());
}
