/////////////////////////////////////////////////////////////////////////////
// Name:        MenuCellsDlg.h
// Purpose:     The menu cells dialog
// Author:      Alex Thuering
// Created:     10.01.2012
// RCS-ID:      $Id: MenuCellsDlg.h,v 1.2 2012/06/17 12:01:43 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef MENUCELLS_DLG_H
#define MENUCELLS_DLG_H

#include "DVD.h"

//(*Headers(MenuCellsDlg)
#include <wx/bmpbuttn.h>
#include <wx/grid.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
//*)

class MenuCellsDlg: public wxDialog {
public:
	/** Costructor */
	MenuCellsDlg(wxWindow* parent, DVD* dvd, int tsi, vector<Cell*>& cells);
	virtual ~MenuCellsDlg();

	vector<Cell*>& GetCells() { return m_cells; }
	
private:
	DVD* m_dvd;
	int m_tsi;
    vector<Cell*> m_cells;
	
	//(*Declarations(MenuCellsDlg)
	wxBitmapButton* m_delBt;
	wxBitmapButton* m_addBt;
	wxGrid* m_grid;
	//*)

	//(*Identifiers(MenuCellsDlg)
	static const long ID_STATICTEXT1;
	static const long ID_GRID;
	static const long ID_ADD_BT;
	static const long ID_DEL_BT;
	//*)

	//(*Handlers(MenuCellsDlg)
	void OnAddBt(wxCommandEvent& event);
	void OnDelBtClick(wxCommandEvent& event);
	//*)
	void SetCellEditors(int row);
	
	DECLARE_EVENT_TABLE()
};

#endif
