#ifndef MENUACTIONSDLG_H
#define MENUACTIONSDLG_H

#include "DVD.h"

//(*Headers(MenuActionsDlg)
#include <wx/bmpbuttn.h>
#include <wx/grid.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
//*)

class MenuActionsDlg: public wxDialog {
public:
	/** Constructor */
	MenuActionsDlg(wxWindow* parent, DVD* dvd, int tsi, vector<DVDAction*> actions);
	virtual ~MenuActionsDlg();
	
	vector<DVDAction*>& GetActions() { return m_actions; }

private:
	DVD* m_dvd;
	int m_tsi;
	vector<DVDAction*> m_actions;
		
	//(*Declarations(MenuActionsDlg)
	wxBitmapButton* m_delBt;
	wxBitmapButton* m_addBt;
	wxGrid* m_grid;
	//*)

	//(*Identifiers(MenuActionsDlg)
	static const long ID_STATICTEXT1;
	static const long ID_GRID;
	static const long ID_ADD_BT;
	static const long ID_DEL_BT;
	//*)

	//(*Handlers(MenuActionsDlg)
	void OnAddBt(wxCommandEvent& event);
	void OnDelBt(wxCommandEvent& event);
	//*)
	void OnOkBt(wxCommandEvent& event);
	void SetCellEditors(int row);

	DECLARE_EVENT_TABLE()
};

#endif
