<?php

// List of all contries member of the European Union (used for VAT billing)
$cc_europe = array(
  "AT" => 1,
  "BE" => 1,
  "CY" => 1,
  "CZ" => 1,
  "DK" => 1,
  "EE" => 1,
  "FI" => 1,
  "FR" => 1,
  "DE" => 1,
  "GR" => 1,
  "HU" => 1,
  "IE" => 1,
  "IT" => 1,
  "LV" => 1,
  "LT" => 1,
  "LU" => 1,
  "MT" => 1,
  "NL" => 1,
  "PL" => 1,
  "PT" => 1,
  "SK" => 1,
  "SI" => 1,
  "ES" => 1,
  "SE" => 1,
  "UK" => 1
);

// This table sets the VAT for known countries (taken from http://en.wikipedia.org/wiki/Value_added_tax)
// If you know things that are not accurate (like a different rate for internet services)
// please get in touch (send a mail to thomas@goirand.fr)
$cc_code_vat = array(
"AR"=> 21,
"AU"=> 10,
"AT"=> 20,
"BE"=> 21,
"BA"=> 17,
"BG"=> 20,
"CA"=> 6,
"CL"=> 19,
"CN"=> 17,
"HR"=> 22,
"CY"=> 15,
"CZ"=> 19,
"DK"=> 25,
"DO"=> 6,
"EC"=> 12,
"SV"=> 13,
"EE"=> 18,
"FI"=> 22,
"FR"=> 19.6,
"GR"=> 19,
"GY"=> 16,
"HU"=> 20,
"IS"=> 24.5,
"IN"=> 12.5,
"IE"=> 20,
"IL"=> 15.5,
"IT"=> 20,
"JP"=> 5,
"KZ"=> 14,
"KR"=> 10,
"LV"=> 18,
"LB"=> 10,
"LT"=> 18,
"LU"=> 15,
"MO"=> 17,
"MK"=> 18,
"MY"=> 5,
"MT"=> 18,
"MX"=> 15,
"MD"=> 20,
"NL"=> 19,
"NZ"=> 12.5,
"NO"=> 25,
"PY"=> 10,
"PE"=> 19,
"PH"=> 12,
"PL"=> 22,
"PT"=> 21,
"RO"=> 19,
"RU"=> 18,
"RS"=> 18,
"SG"=> 5,
"SK"=> 19,
"SI"=> 20,
"ZA"=> 14,
"ES"=> 16,
"LK"=> 15,
"SE"=> 25,
"CH"=> 7.6,
"TH"=> 7,
"TR"=> 18,
"UA"=> 20,
"UK"=> 17.5,
"VE"=> 16
	);

$cc_code_array = array(
"AF"=>'Afghanistan',
"AL"=>'Albania',
"DZ"=>'Algeria',
"AS"=>'American Samoa',
"AD"=>'Andorra',
"AO"=>'Angola',
"AI"=>'Anguilla',
"AQ"=>'Antarctica',
"AG"=>'Antigua And Barbuda',
"AR"=>'Argentina',
"AM"=>'Armenia',
"AW"=>'Aruba',
"AC"=>'Ascension Island',
"AU"=>'Australia',
"AT"=>'Austria',
"AZ"=>'Azerbaijan',
"BS"=>'Bahamas',
"BH"=>'Bahrain',
"BD"=>'Bangladesh',
"BB"=>'Barbados',
"BE"=>'Belgium',
"BZ"=>'Belize',
"BJ"=>'Benin',
"BM"=>'Bermuda',
"BT"=>'Bhutan',
"BO"=>'Bolivia',
"BA"=>'Bosnia Hercegovina',
"BW"=>'Botswana',
"BV"=>'Bouvet Island',
"BR"=>'Brazil',
"IO"=>'British Indian Ocean Territory',
"BN"=>'Brunei Darussalam',
"BG"=>'Bulgaria',
"BF"=>'Burkina Faso',
"BI"=>'Burundi',
"BY"=>'Byelorussian SSR',
"KH"=>'Cambodia',
"CM"=>'Cameroon',
"CA"=>'Canada',
"CV"=>'Cape Verde',
"KY"=>'Cayman Islands',
"CF"=>'Central African Republic',
"TD"=>'Chad',
"CL"=>'Chile',
"CN"=>'China',
"CX"=>'Christmas Island',
"CC"=>'Cocos (Keeling) Islands',
"CO"=>'Colombia',
"KM"=>'Comoros',
"CG"=>'Congo',
"CD"=>'Congo, The Democratic Republic Of',
"CK"=>'Cook Islands',
"CR"=>'Costa Rica',
"CI"=>'Cote D\'Ivoire',
"HR"=>'Croatia',
"CU"=>'Cuba',
"CY"=>'Cyprus',
"CZ"=>'Czech Republic',
"CS"=>'Czechoslovakia',
"DK"=>'Denmark',
"DJ"=>'Djibouti',
"DM"=>'Dominica',
"DO"=>'Dominican Republic',
"TP"=>'East Timor',
"EC"=>'Ecuador',
"EG"=>'Egypt',
"SV"=>'El Salvador',
"GQ"=>'Equatorial Guinea',
"ER"=>'Eritrea',
"EE"=>'Estonia',
"ET"=>'Ethiopia',
"FK"=>'Falkland Islands (Malvinas)',
"FO"=>'Faroe Islands',
"FJ"=>'Fiji',
"FI"=>'Finland',
"FR"=>'France',
"FX"=>'France, Metropolitan',
"GF"=>'French Guiana',
"PF"=>'French Polynesia',
"TF"=>'French Southern Territories',
"GA"=>'Gabon',
"GM"=>'Gambia',
"GE"=>'Georgia',
"DE"=>'Germany',
"GH"=>'Ghana',
"GI"=>'Gibraltar',
"GB"=>'Great Britain',
"GR"=>'Greece',
"GL"=>'Greenland',
"GD"=>'Grenada',
"GP"=>'Guadeloupe',
"GU"=>'Guam',
"GT"=>'Guatemela',
"GG"=>'Guernsey',
"GN"=>'Guinea',
"GW"=>'Guinea-Bissau',
"GY"=>'Guyana',
"HT"=>'Haiti',
"HM"=>'Heard and McDonald Islands',
"HN"=>'Honduras',
"HK"=>'Hong Kong',
"HU"=>'Hungary',
"IS"=>'Iceland',
"IN"=>'India',
"ID"=>'Indonesia',
"IR"=>'Iran (Islamic Republic Of)',
"IQ"=>'Iraq',
"IE"=>'Ireland',
"IM"=>'Isle Of Man',
"IL"=>'Israel',
"IT"=>'Italy',
"JM"=>'Jamaica',
"JP"=>'Japan',
"JE"=>'Jersey',
"JO"=>'Jordan',
"KZ"=>'Kazakhstan',
"KE"=>'Kenya',
"KI"=>'Kiribati',
"KP"=>'Korea, Democratic People\'s Republic Of',
"KR"=>'Korea, Republic Of',
"KW"=>'Kuwait',
"KG"=>'Kyrgyzstan',
"LA"=>'Lao People\'s Democratic Republic',
"LV"=>'Latvia',
"LB"=>'Lebanon',
"LS"=>'Lesotho',
"LR"=>'Liberia',
"LY"=>'Libyan Arab Jamahiriya',
"LI"=>'Liechtenstein',
"LT"=>'Lithuania',
"LU"=>'Luxembourg',
"MO"=>'Macau',
"MK"=>'Macedonia',
"MG"=>'Madagascar',
"MW"=>'Malawi',
"MY"=>'Malaysia',
"MV"=>'Maldives',
"ML"=>'Mali',
"MT"=>'Malta',
"MH"=>'Marshall Islands',
"MQ"=>'Martinique',
"MR"=>'Mauritania',
"MU"=>'Mauritius',
"YT"=>'Mayotte',
"MX"=>'Mexico',
"FM"=>'Micronesia, Federated States Of',
"MD"=>'Moldova, Republic Of',
"MC"=>'Monaco',
"MN"=>'Mongolia',
"MS"=>'Montserrat',
"MA"=>'Morocco',
"MZ"=>'Mozambique',
"MM"=>'Myanmar',
"NA"=>'Namibia',
"NR"=>'Nauru',
"NP"=>'Nepal',
"NL"=>'Netherlands',
"AN"=>'Netherlands Antilles',
"NT"=>'Neutral Zone',
"NC"=>'New Caledonia',
"NZ"=>'New Zealand',
"NI"=>'Nicaragua',
"NE"=>'Niger',
"NG"=>'Nigeria',
"NU"=>'Niue',
"NF"=>'Norfolk Island',
"MP"=>'Northern Mariana Islands',
"NO"=>'Norway',
"OM"=>'Oman',
"PK"=>'Pakistan',
"PW"=>'Palau',
"PS"=>'Palestine',
"PA"=>'Panama',
"PG"=>'Papua New Guinea',
"PY"=>'Paraguay',
"PE"=>'Peru',
"PH"=>'Philippines',
"PN"=>'Pitcairn',
"PL"=>'Poland',
"PT"=>'Portugal',
"PR"=>'Puerto Rico',
"QA"=>'Qatar',
"RE"=>'Reunion',
"RO"=>'Romania',
"RU"=>'Russian Federation',
"RW"=>'Rwanda',
"SH"=>'Saint Helena',
"KN"=>'Saint Kitts And Nevis',
"LC"=>'Saint Lucia',
"PM"=>'Saint Pierre and Miquelon',
"VC"=>'Saint Vincent and The Grenadines',
"WS"=>'Samoa',
"SM"=>'San Marino',
"ST"=>'Sao Tome and Principe',
"SA"=>'Saudi Arabia',
"SN"=>'Senegal',
"RS"=>'Serbia',
"SC"=>'Seychelles',
"SL"=>'Sierra Leone',
"SG"=>'Singapore',
"SK"=>'Slovakia',
"SI"=>'Slovenia',
"SB"=>'Solomon Islands',
"SO"=>'Somalia',
"ZA"=>'South Africa',
"GS"=>'South Georgia and The Sandwich Islands',
"ES"=>'Spain',
"LK"=>'Sri Lanka',
"SD"=>'Sudan',
"SR"=>'Suriname',
"SJ"=>'Svalbard and Jan Mayen Islands',
"SZ"=>'Swaziland',
"SE"=>'Sweden',
"CH"=>'Switzerland',
"SY"=>'Syrian Arab Republic',
"TW"=>'Taiwan',
"TJ"=>'Tajikista',
"TZ"=>'Tanzania, United Republic Of',
"TH"=>'Thailand',
"TG"=>'Togo',
"TK"=>'Tokelau',
"TO"=>'Tonga',
"TT"=>'Trinidad and Tobago',
"TN"=>'Tunisia',
"TR"=>'Turkey',
"TM"=>'Turkmenistan',
"TC"=>'Turks and Caicos Islands',
"TV"=>'Tuvalu',
"SU"=>'USSR',
"UG"=>'Uganda',
"UA"=>'Ukraine',
"AE"=>'United Arab Emirates',
"UK"=>'United Kingdom',
"US"=>'United States',
"UM"=>'United States Minor Outlying Islands',
"UY"=>'Uruguay',
"UZ"=>'Uzbekistan',
"VU"=>'Vanuatu',
"VA"=>'Vatican City State',
"VE"=>'Venezuela',
"VN"=>'Vietnam',
"VG"=>'Virgin Islands (British)',
"VI"=>'Virgin Islands (U.S.)',
"WF"=>'Wallis and Futuna Islands',
"WG"=>'West Bank and Gaza',
"EH"=>'Western Sahara',
"YE"=>'Yemen, Republic of',
"YU"=>'Yugoslavia',
"ZR"=>'Zaire',
"ZM"=>'Zambia',
"ZW"=>'Zimbabwe'
	);

function cc_code_popup($default="US"){
	global $cc_code_array;

	$out = "";

	$ar_keys = array_keys($cc_code_array);
	$nbr_cc_code = sizeof($ar_keys);
	for($i=0;$i<$nbr_cc_code;$i++){
		if($default == $ar_keys[$i]){
			$sel = " selected ";
		}else{
			$sel = "";
		}
		$out .= '<option value="' . $ar_keys[$i] . '"' . $sel . '>' .
			$cc_code_array[ $ar_keys[$i] ] . '</option>\n';
	}
	return $out;
}

$cc_code_popup = '
<option value="AF">Afghanistan
<option value="AL">Albania
<option value="DZ">Algeria
<option value="AS">American Samoa
<option value="AD">Andorra
<option value="AO">Angola
<option value="AI">Anguilla
<option value="AQ">Antarctica
<option value="AG">Antigua And Barbuda
<option value="AR">Argentina
<option value="AM">Armenia
<option value="AW">Aruba
<option value="AC">Ascension Island
<option value="AU">Australia
<option value="AT">Austria
<option value="AZ">Azerbaijan
<option value="BS">Bahamas
<option value="BH">Bahrain
<option value="BD">Bangladesh
<option value="BB">Barbados
<option value="BE">Belgium
<option value="BZ">Belize
<option value="BJ">Benin
<option value="BM">Bermuda
<option value="BT">Bhutan
<option value="BO">Bolivia
<option value="BA">Bosnia Hercegovina
<option value="BW">Botswana
<option value="BV">Bouvet Island
<option value="BR">Brazil
<option value="IO">British Indian Ocean Territory
<option value="BN">Brunei Darussalam
<option value="BG">Bulgaria
<option value="BF">Burkina Faso
<option value="BI">Burundi
<option value="BY">Byelorussian SSR
<option value="KH">Cambodia
<option value="CM">Cameroon
<option value="CA">Canada
<option value="CV">Cape Verde
<option value="KY">Cayman Islands
<option value="CF">Central African Republic
<option value="TD">Chad
<option value="CL">Chile
<option value="CN">China
<option value="CX">Christmas Island
<option value="CC">Cocos (Keeling) Islands
<option value="CO">Colombia
<option value="KM">Comoros
<option value="CG">Congo
<option value="CD">Congo, The Democratic Republic Of
<option value="CK">Cook Islands
<option value="CR">Costa Rica
<option value="CI">Cote D\'Ivoire
<option value="HR">Croatia
<option value="CU">Cuba
<option value="CY">Cyprus
<option value="CZ">Czech Republic
<option value="CS">Czechoslovakia
<option value="DK">Denmark
<option value="DJ">Djibouti
<option value="DM">Dominica
<option value="DO">Dominican Republic
<option value="TP">East Timor
<option value="EC">Ecuador
<option value="EG">Egypt
<option value="SV">El Salvador
<option value="GQ">Equatorial Guinea
<option value="ER">Eritrea
<option value="EE">Estonia
<option value="ET">Ethiopia
<option value="FK">Falkland Islands (Malvinas)
<option value="FO">Faroe Islands
<option value="FJ">Fiji
<option value="FI">Finland
<option value="FR">France
<option value="FX">France, Metropolitan
<option value="GF">French Guiana
<option value="PF">French Polynesia
<option value="TF">French Southern Territories
<option value="GA">Gabon
<option value="GM">Gambia
<option value="GE">Georgia
<option value="DE">Germany
<option value="GH">Ghana
<option value="GI">Gibraltar
<option value="GB">Great Britain
<option value="GR">Greece
<option value="GL">Greenland
<option value="GD">Grenada
<option value="GP">Guadeloupe
<option value="GU">Guam
<option value="GT">Guatemela
<option value="GG">Guernsey
<option value="GN">Guinea
<option value="GW">Guinea-Bissau
<option value="GY">Guyana
<option value="HT">Haiti
<option value="HM">Heard and McDonald Islands
<option value="HN">Honduras
<option value="HK">Hong Kong
<option value="HU">Hungary
<option value="IS">Iceland
<option value="IN">India
<option value="ID">Indonesia
<option value="IR">Iran (Islamic Republic Of)
<option value="IQ">Iraq
<option value="IE">Ireland
<option value="IM">Isle Of Man
<option value="IL">Israel
<option value="IT">Italy
<option value="JM">Jamaica
<option value="JP">Japan
<option value="JE">Jersey
<option value="JO">Jordan
<option value="KZ">Kazakhstan
<option value="KE">Kenya
<option value="KI">Kiribati
<option value="KP">Korea, Democratic People\'s Republic Of
<option value="KR">Korea, Republic Of
<option value="KW">Kuwait
<option value="KG">Kyrgyzstan
<option value="LA">Lao People\'s Democratic Republic
<option value="LV">Latvia
<option value="LB">Lebanon
<option value="LS">Lesotho
<option value="LR">Liberia
<option value="LY">Libyan Arab Jamahiriya
<option value="LI">Liechtenstein
<option value="LT">Lithuania
<option value="LU">Luxembourg
<option value="MO">Macau
<option value="MK">Macedonia
<option value="MG">Madagascar
<option value="MW">Malawi
<option value="MY">Malaysia
<option value="MV">Maldives
<option value="ML">Mali
<option value="MT">Malta
<option value="MH">Marshall Islands
<option value="MQ">Martinique
<option value="MR">Mauritania
<option value="MU">Mauritius
<option value="YT">Mayotte
<option value="MX">Mexico
<option value="FM">Micronesia, Federated States Of
<option value="MD">Moldova, Republic Of
<option value="MC">Monaco
<option value="MN">Mongolia
<option value="MS">Montserrat
<option value="MA">Morocco
<option value="MZ">Mozambique
<option value="MM">Myanmar
<option value="NA">Namibia
<option value="NR">Nauru
<option value="NP">Nepal
<option value="NL">Netherlands
<option value="AN">Netherlands Antilles
<option value="NT">Neutral Zone
<option value="NC">New Caledonia
<option value="NZ">New Zealand
<option value="NI">Nicaragua
<option value="NE">Niger
<option value="NG">Nigeria
<option value="NU">Niue
<option value="NF">Norfolk Island
<option value="MP">Northern Mariana Islands
<option value="NO">Norway
<option value="OM">Oman
<option value="PK">Pakistan
<option value="PW">Palau
<option value="PS">Palestine
<option value="PA">Panama
<option value="PG">Papua New Guinea
<option value="PY">Paraguay
<option value="PE">Peru
<option value="PH">Philippines
<option value="PN">Pitcairn
<option value="PL">Poland
<option value="PT">Portugal
<option value="PR">Puerto Rico
<option value="QA">Qatar
<option value="RE">Reunion
<option value="RO">Romania
<option value="RU">Russian Federation
<option value="RW">Rwanda
<option value="SH">Saint Helena
<option value="KN">Saint Kitts And Nevis
<option value="LC">Saint Lucia
<option value="PM">Saint Pierre and Miquelon
<option value="VC">Saint Vincent and The Grenadines
<option value="WS">Samoa
<option value="SM">San Marino
<option value="ST">Sao Tome and Principe
<option value="SA">Saudi Arabia
<option value="SN">Senegal
<option value="RS">Serbia
<option value="SC">Seychelles
<option value="SL">Sierra Leone
<option value="SG">Singapore
<option value="SK">Slovakia
<option value="SI">Slovenia
<option value="SB">Solomon Islands
<option value="SO">Somalia
<option value="ZA">South Africa
<option value="GS">South Georgia and The Sandwich Islands
<option value="ES">Spain
<option value="LK">Sri Lanka
<option value="SD">Sudan
<option value="SR">Suriname
<option value="SJ">Svalbard and Jan Mayen Islands
<option value="SZ">Swaziland
<option value="SE">Sweden
<option value="CH">Switzerland
<option value="SY">Syrian Arab Republic
<option value="TW">Taiwan
<option value="TJ">Tajikista
<option value="TZ">Tanzania, United Republic Of
<option value="TH">Thailand
<option value="TG">Togo
<option value="TK">Tokelau
<option value="TO">Tonga
<option value="TT">Trinidad and Tobago
<option value="TN">Tunisia
<option value="TR">Turkey
<option value="TM">Turkmenistan
<option value="TC">Turks and Caicos Islands
<option value="TV">Tuvalu
<option value="SU">USSR
<option value="UG">Uganda
<option value="UA">Ukraine
<option value="AE">United Arab Emirates
<option value="UK">United Kingdom
<option value="US" selected>United States
<option value="UM">United States Minor Outlying Islands
<option value="UY">Uruguay
<option value="UZ">Uzbekistan
<option value="VU">Vanuatu
<option value="VA">Vatican City State
<option value="VE">Venezuela
<option value="VN">Vietnam
<option value="VG">Virgin Islands (British)
<option value="VI">Virgin Islands (U.S.)
<option value="WF">Wallis and Futuna Islands
<option value="WG">West Bank and Gaza
<option value="EH">Western Sahara
<option value="YE">Yemen, Republic of
<option value="YU">Yugoslavia
<option value="ZR">Zaire
<option value="ZM">Zambia
<option value="ZW">Zimbabwe
';

?>
