// Standard Unix includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dotconf.h>
#include <mysql/mysql.h>

#include "log.h"
#include "config_file.h"
#include "global.h"
//#include "message.h"
#include "my_strings.h"
#include "sql_query.h"


MYSQL mysql,*sock;
void do_ze_mysql_connect(){
//	MYSQL_RES res;
	mysql_init(&mysql);
	if (!(sock = mysql_real_connect(&mysql,igw_config.mysql_hostname,
				igw_config.mysql_user,igw_config.mysql_pass,igw_config.mysql_db,0,NULL,0))){
		fprintf(stderr,"Couldn't connect to mysql engine!\n%s\n\n",mysql_error(&mysql));
		exit(2);
	}
	return;
}

void testQuery(){
	char* q;
	printf("testing query\n");
	if(mysql_query(sock,"SELECT pop3_email FROM mailbox WHERE igw_login='zigo' AND pop3_server='gplhost.com' AND pop3_login='zigo@pplchat.com';")){
		fprintf(stderr,"Query: failed ! %s\n",mysql_error(sock));
		exit(2);
	}else{
		fprintf(stderr,"Query: success !\n");
	}
	printf("testing strdup\n");
	q = strdup("test");
	printf("%s\n",q);
}


void mysql_cleanUp(){
	LOG("Disconnect from MySQL.......");
	mysql_close(sock);
	LOG("done!\n");
}

// Does check for input stings size and if contains \ or ' (no db hack possible)
// This one is guessed by the 3 first in DB (table mailbox)
// NULL if not found
// @return: char* fetchmail_email_addr;
char* findRetrivedMailbox(char* igw_login,char* pop3_username,char* pop3_server){
	MYSQL_RES *res;
	MYSQL_ROW row;
	char* ret;
	char q[1024];
	int num_rows;

	if(strlen(pop3_server)+strlen(pop3_username)+strlen(igw_login) > 512){
		return NULL;
	}
	if(
		strstr(pop3_server,"'") || strstr(pop3_server,"\\") ||
		strstr(pop3_username,"'") || strstr(pop3_username,"\\") ||
		strstr(igw_login,"'") || strstr(igw_login,"\\")){
		return NULL;
	}
	LOG("test1\n");
	sprintf(q,"SELECT pop3_email FROM mailbox WHERE igw_login='%s' AND pop3_server='%s' AND pop3_login='%s';",
		igw_login,pop3_server,pop3_username);
	LOG("\"")
	LOG(q);
	LOG("\"")
	LOG("\n");
	if(mysql_query(sock,q)){
		sprintf(q,"Query: \"%s\" failed ! %s\n",q,mysql_error(sock));
		return NULL;
	}
	LOG("test3\n");
	if (!(res=mysql_store_result(sock))){
		fprintf(stderr,"Couldn't get result from %s\n",mysql_error(sock));
		return NULL;
	}
	num_rows = mysql_num_rows(res);
	LOG("test4\n");
	if(num_rows != 1){
		mysql_free_result(res);
		return NULL;
	}
	LOG("test5\n");
	row = mysql_fetch_row(res);
	if(row[0]){
		mysql_free_result(res);
		return NULL;
	}
	LOG("test6\n");
	ret=strdup(row[0]);
	mysql_free_result(res);
	return (ret);
}

char* isInWhitelist(char* igw_login,char* pop3_username,char* pop3_server,char* fromFeild){
	MYSQL_RES *res;
	int num_rows;
	char* from;
	char* user;
	char* domain;
	char* mailboxName;
	char q[1024];

	mailboxName = findRetrivedMailbox(igw_login,pop3_username,pop3_server);

	if(mailboxName == NULL)
		return NULL;

	from = extractMailFromString(fromFeild);
	if(from == NULL)	return NULL;

	user = strdup(from);
	domain = strtok(user,"@");

	sprintf(q,"SELECT * FROM whitelist WHERE igw_login='%s' AND (mail_from_user='%s' OR mail_from_domain='*') AND mail_from_domain='%s' AND mailbox='%s';",
			igw_login,user,domain,from);
	if(mysql_query(sock,q)){
        	fprintf(stderr,"Query: \"%s\" failed ! %s\n",q,mysql_error(sock));
	}
	if (!(res=mysql_store_result(sock))){
		fprintf(stderr,"Couldn't get result from %s\n",mysql_error(sock));
		return NULL;
	}
	num_rows = mysql_num_rows(res);
	if(num_rows != 1){
		mysql_free_result(res);
		return "founded";
	}
	return "founded";
}
