(!html-head "<meta name=description content=\"A practical\nintroduction to the programming language Scheme\">\n\n<meta name=author content=\"Dorai Sitaram\">\n\n<link rev=made href=\"mailto:dorai @ ccs.neu.edu\">\n")
(!default-title "Teach Yourself Scheme in Fixnum Days")
(!toc-page 1)
(!using-chapters)
(!toc-entry 0 "IGNORE" 2 "node_chap_Temp_2" "Preface")
(!index 2 2)
(!index 4 2)
(!index 6 2)
(!using-chapters)
(!toc-entry 0 "1" 3 "node_chap_1" "Enter Scheme")
(!index 8 3)
(!index 10 3)
(!index 12 3)
(!index 14 3)
(!index 16 3)
(!index 18 3)
(!index 20 3)
(!index 22 3)
(!index 24 3)
(!index 26 3)
(!index 28 3)
(!index 30 3)
(!index 32 3)
(!index 34 3)
(!index 36 3)
(!using-chapters)
(!toc-entry 0 "2" 4 "node_chap_2" "Data types")
(!index 38 4)
(!index 40 4)
(!toc-entry 1 "2.1" 4 "node_sec_2.1" "Simple data types")
(!index 42 4)
(!toc-entry 2 "2.1.1" 4 "node_sec_2.1.1" "Booleans")
(!index 44 4)
(!index 46 4)
(!index 48 4)
(!index 50 4)
(!index 52 4)
(!index 54 4)
(!index 56 4)
(!toc-entry 2 "2.1.2" 4 "node_sec_2.1.2" "Numbers")
(!index 58 4)
(!index 60 4)
(!index 62 4)
(!index 64 4)
(!index 66 4)
(!index 68 4)
(!index 70 4)
(!index 72 4)
(!index 74 4)
(!index 76 4)
(!index 78 4)
(!index 80 4)
(!index 82 4)
(!index 84 4)
(!index 86 4)
(!index 88 4)
(!index 90 4)
(!index 92 4)
(!index 94 4)
(!index 96 4)
(!index 98 4)
(!index 100 4)
(!index 102 4)
(!index 104 4)
(!index 106 4)
(!index 108 4)
(!index 110 4)
(!toc-entry 2 "2.1.3" 4 "node_sec_2.1.3" "Characters")
(!index 112 4)
(!index 114 4)
(!index 116 4)
(!index 118 4)
(!index 120 4)
(!index 122 4)
(!index 124 4)
(!index 126 4)
(!index 128 4)
(!index 130 4)
(!index 132 4)
(!index 134 4)
(!index 136 4)
(!index 138 4)
(!index 140 4)
(!toc-entry 2 "2.1.4" 4 "node_sec_2.1.4" "Symbols")
(!index 142 4)
(!index 144 4)
(!index 146 4)
(!index 148 4)
(!index 150 4)
(!index 152 4)
(!index 154 4)
(!index 156 4)
(!index 158 4)
(!index 160 4)
(!index 162 4)
(!toc-entry 1 "2.2" 4 "node_sec_2.2" "Compound data types")
(!index 164 4)
(!toc-entry 2 "2.2.1" 4 "node_sec_2.2.1" "Strings")
(!index 166 4)
(!index 168 4)
(!index 170 4)
(!index 172 4)
(!index 174 4)
(!index 176 4)
(!index 178 4)
(!toc-entry 2 "2.2.2" 4 "node_sec_2.2.2" "Vectors")
(!index 180 4)
(!index 182 4)
(!index 184 4)
(!index 186 4)
(!index 188 4)
(!index 190 4)
(!index 192 4)
(!toc-entry 2 "2.2.3" 4 "node_sec_2.2.3" "Dotted pairs and lists")
(!index 194 4)
(!index 196 4)
(!index 198 4)
(!index 200 4)
(!index 202 4)
(!index 204 4)
(!index 206 4)
(!index 208 4)
(!index 210 4)
(!index 212 4)
(!toc-entry 2 "2.2.4" 4 "node_sec_2.2.4" "Conversions between data types")
(!index 214 4)
(!index 216 4)
(!index 218 4)
(!index 220 4)
(!index 222 4)
(!index 224 4)
(!index 226 4)
(!index 228 4)
(!index 230 4)
(!toc-entry 1 "2.3" 4 "node_sec_2.3" "Other data types")
(!index 232 4)
(!index 234 4)
(!index 236 4)
(!toc-entry 1 "2.4" 4 "node_sec_2.4" "S-expressions")
(!using-chapters)
(!toc-entry 0 "3" 5 "node_chap_3" "Forms")
(!index 238 5)
(!index 240 5)
(!toc-entry 1 "3.1" 5 "node_sec_3.1" "Procedures")
(!index 242 5)
(!toc-entry 2 "3.1.1" 5 "node_sec_3.1.1" "Procedure parameters")
(!toc-entry 2 "3.1.2" 5 "node_sec_3.1.2" "Variable number of arguments")
(!index 244 5)
(!toc-entry 1 "3.2" 5 "node_sec_3.2" "<code class=scheme><span class=variable>apply</span></code>")
(!index 246 5)
(!toc-entry 1 "3.3" 5 "node_sec_3.3" "Sequencing")
(!index 248 5)
(!using-chapters)
(!toc-entry 0 "4" 6 "node_chap_4" "Conditionals")
(!index 250 6)
(!index 252 6)
(!index 254 6)
(!index 256 6)
(!toc-entry 1 "4.1" 6 "node_sec_4.1" "<code class=scheme><span class=keyword>when</span></code> and <code class=scheme><span class=keyword>unless</span></code>")
(!index 258 6)
(!index 260 6)
(!toc-entry 1 "4.2" 6 "node_sec_4.2" "<code class=scheme><span class=keyword>cond</span></code>")
(!index 262 6)
(!toc-entry 1 "4.3" 6 "node_sec_4.3" "<code class=scheme><span class=keyword>case</span></code>")
(!index 264 6)
(!index 266 6)
(!toc-entry 1 "4.4" 6 "node_sec_4.4" "<code class=scheme><span class=keyword>and</span></code> and <code class=scheme><span class=keyword>or</span></code>")
(!using-chapters)
(!toc-entry 0 "5" 7 "node_chap_5" "Lexical variables")
(!index 268 7)
(!index 270 7)
(!index 272 7)
(!index 274 7)
(!index 276 7)
(!toc-entry 1 "5.1" 7 "node_sec_5.1" "<code class=scheme><span class=keyword>let</span></code> and <code class=scheme><span class=keyword>let*</span></code>")
(!index 278 7)
(!toc-entry 1 "5.2" 7 "node_sec_5.2" "<code class=scheme><span class=keyword>fluid-let</span></code>")
(!using-chapters)
(!toc-entry 0 "6" 8 "node_chap_6" "Recursion")
(!index 280 8)
(!index 282 8)
(!index 284 8)
(!index 286 8)
(!index 288 8)
(!index 290 8)
(!toc-entry 1 "6.1" 8 "node_sec_6.1" "<code class=scheme><span class=keyword>letrec</span></code>")
(!index 292 8)
(!index 294 8)
(!toc-entry 1 "6.2" 8 "node_sec_6.2" "Named <code class=scheme><span class=keyword>let</span></code>")
(!index 296 8)
(!index 298 8)
(!index 300 8)
(!index 302 8)
(!index 304 8)
(!index 306 8)
(!index 308 8)
(!index 310 8)
(!toc-entry 1 "6.3" 8 "node_sec_6.3" "Iteration")
(!index 312 8)
(!index 314 8)
(!index 316 8)
(!index 318 8)
(!toc-entry 1 "6.4" 8 "node_sec_6.4" "Mapping a procedure across a list")
(!using-chapters)
(!toc-entry 0 "7" 9 "node_chap_7" "I/O")
(!index 320 9)
(!toc-entry 1 "7.1" 9 "node_sec_7.1" "Reading")
(!index 322 9)
(!index 324 9)
(!index 326 9)
(!index 328 9)
(!toc-entry 1 "7.2" 9 "node_sec_7.2" "Writing")
(!index 330 9)
(!index 332 9)
(!index 334 9)
(!index 336 9)
(!index 338 9)
(!index 340 9)
(!toc-entry 1 "7.3" 9 "node_sec_7.3" "File ports")
(!index 342 9)
(!index 344 9)
(!index 346 9)
(!index 348 9)
(!index 350 9)
(!index 352 9)
(!index 354 9)
(!index 356 9)
(!toc-entry 2 "7.3.1" 9 "node_sec_7.3.1" "Automatic opening and closing of file ports")
(!index 358 9)
(!index 360 9)
(!index 362 9)
(!index 364 9)
(!toc-entry 1 "7.4" 9 "node_sec_7.4" "String ports")
(!index 366 9)
(!index 368 9)
(!index 370 9)
(!index 372 9)
(!index 374 9)
(!toc-entry 1 "7.5" 9 "node_sec_7.5" "Loading files")
(!index 376 9)
(!using-chapters)
(!toc-entry 0 "8" 10 "node_chap_8" "Macros")
(!index 378 10)
(!index 380 10)
(!index 382 10)
(!index 384 10)
(!toc-entry 1 "8.1" 10 "node_sec_8.1" "Specifying the expansion as a template")
(!index 386 10)
(!index 388 10)
(!index 390 10)
(!toc-entry 1 "8.2" 10 "node_sec_8.2" "Avoiding variable capture inside macros")
(!index 392 10)
(!index 394 10)
(!index 396 10)
(!index 398 10)
(!toc-entry 1 "8.3" 10 "node_sec_8.3" "<code class=scheme><span class=keyword>fluid-let</span></code>")
(!using-chapters)
(!toc-entry 0 "9" 11 "node_chap_9" "Structures")
(!index 400 11)
(!index 402 11)
(!index 404 11)
(!toc-entry 1 "9.1" 11 "node_sec_9.1" "Default initializations")
(!toc-entry 1 "9.2" 11 "node_sec_9.2" "<code class=scheme><span class=keyword>defstruct</span></code> defined")
(!using-chapters)
(!toc-entry 0 "10" 12 "node_chap_10" "Alists and tables")
(!index 406 12)
(!index 408 12)
(!index 410 12)
(!index 412 12)
(!using-chapters)
(!toc-entry 0 "11" 13 "node_chap_11" "System interface")
(!toc-entry 1 "11.1" 13 "node_sec_11.1" "Checking for and deleting files")
(!index 414 13)
(!index 416 13)
(!index 418 13)
(!index 420 13)
(!index 422 13)
(!index 424 13)
(!toc-entry 1 "11.2" 13 "node_sec_11.2" "Calling operating-system commands")
(!index 426 13)
(!toc-entry 1 "11.3" 13 "node_sec_11.3" "Environment variables")
(!index 428 13)
(!using-chapters)
(!toc-entry 0 "12" 14 "node_chap_12" "Objects and classes")
(!index 430 14)
(!index 432 14)
(!index 434 14)
(!index 436 14)
(!index 438 14)
(!index 440 14)
(!index 442 14)
(!index 444 14)
(!toc-entry 1 "12.1" 14 "node_sec_12.1" "A simple object system")
(!index 446 14)
(!index 448 14)
(!toc-entry 1 "12.2" 14 "node_sec_12.2" "Classes are instances too")
(!index 450 14)
(!index 452 14)
(!index 454 14)
(!toc-entry 1 "12.3" 14 "node_sec_12.3" "Multiple inheritance")
(!using-chapters)
(!toc-entry 0 "13" 15 "node_chap_13" "Jumps")
(!index 456 15)
(!toc-entry 1 "13.1" 15 "node_sec_13.1" "<code class=scheme><span class=variable>call-with-current-continuation</span></code>")
(!index 458 15)
(!index 460 15)
(!toc-entry 1 "13.2" 15 "node_sec_13.2" "Escaping continuations")
(!toc-entry 1 "13.3" 15 "node_sec_13.3" "Tree matching")
(!index 462 15)
(!index 464 15)
(!toc-entry 1 "13.4" 15 "node_sec_13.4" "Coroutines")
(!toc-entry 2 "13.4.1" 15 "node_sec_13.4.1" "Tree-matching with coroutines")
(!using-chapters)
(!toc-entry 0 "14" 16 "node_chap_14" "Nondeterminism")
(!index 466 16)
(!index 468 16)
(!index 470 16)
(!toc-entry 1 "14.1" 16 "node_sec_14.1" "Description of <code class=scheme><span class=keyword>amb</span></code>")
(!toc-entry 1 "14.2" 16 "node_sec_14.2" "Implementing <code class=scheme><span class=keyword>amb</span></code> in Scheme")
(!toc-entry 1 "14.3" 16 "node_sec_14.3" "Using <code class=scheme><span class=keyword>amb</span></code> in Scheme")
(!index 472 16)
(!toc-entry 1 "14.4" 16 "node_sec_14.4" "Logic puzzles")
(!toc-entry 2 "14.4.1" 16 "node_sec_14.4.1" "The Kalotan puzzle")
(!toc-entry 2 "14.4.2" 16 "node_sec_14.4.2" "Map coloring")
(!using-chapters)
(!toc-entry 0 "15" 17 "node_chap_15" "Engines")
(!index 474 17)
(!index 476 17)
(!index 478 17)
(!toc-entry 1 "15.1" 17 "node_sec_15.1" "The clock")
(!index 480 17)
(!toc-entry 1 "15.2" 17 "node_sec_15.2" "Flat engines")
(!index 482 17)
(!toc-entry 1 "15.3" 17 "node_sec_15.3" "Nestable engines")
(!using-chapters)
(!toc-entry 0 "16" 18 "node_chap_16" "Shell scripts")
(!index 484 18)
(!toc-entry 1 "16.1" 18 "node_sec_16.1" "Hello, World!, again")
(!toc-entry 1 "16.2" 18 "node_sec_16.2" "Scripts with arguments")
(!toc-entry 1 "16.3" 18 "node_sec_16.3" "Example")
(!using-chapters)
(!toc-entry 0 "17" 19 "node_chap_17" "CGI scripts")
(!index 486 19)
(!toc-entry 1 "17.1" 19 "node_sec_17.1" "Example: Displaying environment variables")
(!toc-entry 1 "17.2" 19 "node_sec_17.2" "Example: Displaying selected environment variable")
(!toc-entry 1 "17.3" 19 "node_sec_17.3" "CGI script utilities")
(!toc-entry 1 "17.4" 19 "node_sec_17.4" "A calculator via CGI")
(!using-chapters)
(!toc-entry 0 "A" 20 "node_chap_A" "Scheme dialects")
(!index 488 20)
(!index 490 20)
(!index 492 20)
(!index 494 20)
(!toc-entry 1 "A.1" 20 "node_sec_A.1" "Invocation and init files")
(!index 496 20)
(!index 498 20)
(!index 500 20)
(!toc-entry 1 "A.2" 20 "node_sec_A.2" "Shell scripts")
(!index 502 20)
(!toc-entry 1 "A.3" 20 "node_sec_A.3" "<code class=scheme><span class=keyword>define-macro</span></code>")
(!index 504 20)
(!index 506 20)
(!index 508 20)
(!index 510 20)
(!index 512 20)
(!index 514 20)
(!index 516 20)
(!index 518 20)
(!index 520 20)
(!index 522 20)
(!toc-entry 1 "A.4" 20 "node_sec_A.4" "<code class=scheme><span class=variable>load-relative</span></code>")
(!using-chapters)
(!toc-entry 0 "B" 21 "node_chap_B" "DOS batch files in Scheme")
(!index 524 21)
(!using-chapters)
(!toc-entry 0 "C" 22 "node_chap_C" "Numerical techniques")
(!index 526 22)
(!index 528 22)
(!toc-entry 1 "C.1" 22 "node_sec_C.1" "Simpson&#8217;s rule")
(!toc-entry 1 "C.2" 22 "node_sec_C.2" "Adaptive interval sizes")
(!toc-entry 1 "C.3" 22 "node_sec_C.3" "Improper integrals")
(!using-chapters)
(!toc-entry 0 "D" 23 "node_chap_D" "A clock for infinity")
(!index 530 23)
(!index 532 23)
(!using-chapters)
(!toc-entry 0 "E" 24 "node_chap_E" "References")
(!using-chapters)
(!toc-entry 0 "F" 25 "node_chap_F" "Index")
(!index-page 25)
(!last-page-number 25)
(!last-modification-time 1100802793)
(!head-line "")
(!foot-line "\\folio")
