#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Shortcuts File

import drPrefsFile
from drShortcuts import drShortcut

def GetShortcutList():
	#Shortcut List
	return ["New", "Open", \
		"Load Session", "Save Session", \
		"Save", "Save As", "Save Prompt Output To File", "Reload File", \
		"Restore From Backup", "Close", \
		"Print Setup", "Print File", "Print Prompt", "Exit", \
		"Next Tab", "Previous Tab", "First Tab", "Last Tab", \
		"Find", "Find Next", "Find Previous", \
		"Replace", "Switcheroo", \
		"Find In Files", "Replace In Files", \
		"Insert Regular Expression", "Go To", \
		"Comment", "UnComment", "Indent", "Dedent", \
		"Uppercase", "Lowercase", "Undo", "Redo", "Copy", "Cut", "Paste", \
		"Chop Beginning", "Chop End", "Find And Complete", \
		"Select All", "Select None", "Zoom In", "Zoom Out", "Fold All", "Expand All", \
		"Show Class Browser", "Toggle View Whitespace", "Toggle Prompt", "Clear Prompt", \
		"Run", "Set Arguments", "Python", "Run With Debugger", "End", \
		"Set Log File", "Insert Logger", "Insert String Logger", "Insert Arbitrary Arguments Logger", \
		"Remove All Loggers", \
		"Add Breakpoint", "Remove Breakpoint", "Remove All Breakpoints", \
		"Dynamic DrScript", "Preferences", \
		"Help", "View Python Docs", "View WxWidgets Docs", "View Regular Expression Howto", \
		"Toggle Maximize"]

def IsBuiltIn(name):
	return 1

def GetDefaultShortcuts():
	shortcutArray = []
	keycodeArray = []	
	
	import sys
	if (sys.platform.find("linux") > -1):
		ignorestring = "Meta,"
	else:
		ignorestring = ""
	
	ShortcutList = GetShortcutList()
	l = len(ShortcutList)
	x = 0
	while (x < l):
		shortcutArray.append(drShortcut())
		shortcutArray[x].Name = ShortcutList[x]
		keycodeArray.append("")		
		x = x + 1
	
	return shortcutArray, keycodeArray, ignorestring

def ReadShortcuts(filename, getIgnoreString = 1, customshortcutlist = []):
	if getIgnoreString:
		f = open(filename, 'r')
		text = f.read()
		f.close()
		
		shortcutArray = []
		keycodeArray = []
		ignorestring = ""
		
		ignorestring = drPrefsFile.ExtractPreferenceFromText(text, "ignore")
			
		x = 0
		progshortcutlist = GetShortcutList()
		l = len(progshortcutlist)
		while (x < l):
			shortcutArray.append(drShortcut())
			shortcutArray[x].Name = progshortcutlist[x]
			shortcuttext = drPrefsFile.ExtractPreferenceFromText(text, progshortcutlist[x])
			shortcutArray[x].Keycode = drPrefsFile.ExtractPreferenceFromText(shortcuttext, "keycode")
			
			keycodeArray.append(shortcutArray[x].Keycode)
			
			modifiers = drPrefsFile.ExtractPreferenceFromText(shortcuttext, "mod")
			shortcutArray[x].Control = (modifiers.find("Control") > -1)
			shortcutArray[x].Shift = (modifiers.find("Shift") > -1)
			shortcutArray[x].Meta = (modifiers.find("Meta") > -1)
			shortcutArray[x].Alt = (modifiers.find("Alt") > -1)		
			x = x + 1
	else:
		f = open(filename, 'r')
		
		shortcutArray = []
		keycodeArray = []
		ignorestring = ""		
		
		x = 0
		
		line = f.readline()
		while len(line) > 0:			
			s = line.find("<")
			e = line.find(">")
			if (s > -1) and (e > -1):	
				shortcutArray.append(drShortcut())		
				shortcutArray[x].Name = line[s+1:e]
				shortcutArray[x].Keycode = drPrefsFile.ExtractPreferenceFromText(line, "keycode")
				
				keycodeArray.append(shortcutArray[x].Keycode)
				
				modifiers = drPrefsFile.ExtractPreferenceFromText(line, "mod")
				shortcutArray[x].Control = (modifiers.find("Control") > -1)
				shortcutArray[x].Shift = (modifiers.find("Shift") > -1)
				shortcutArray[x].Meta = (modifiers.find("Meta") > -1)
				shortcutArray[x].Alt = (modifiers.find("Alt") > -1)	
				x = x + 1
			line = f.readline()
		
		f.close()

	
	return shortcutArray, keycodeArray, ignorestring

def WriteShortcuts(filename, shortcutlist, txtValueArray, ignorestring = "", startAt = 0):

	f = open(filename, 'w')
	
	if (not startAt):
		#Ignore String
		f.write("<version.number>2.4.6</version.number>\n")
		f.write("<ignore>" + ignorestring + "</ignore>\n")
	allowControl = not (ignorestring.find("Control") > -1)
	allowShift = not (ignorestring.find("Shift") > -1)
	allowMeta = not (ignorestring.find("Meta") > -1)
	allowAlt = not (ignorestring.find("Alt") > -1)	
	
	l = len(shortcutlist)
	x = startAt
	y = 0
	while (y < l):
		value = txtValueArray[x].GetValue()
		writestring = "<" + shortcutlist[y] + "><mod>"
		target = value.find("#")
		if (target > -1):
			if (value.find("Control") > -1) and allowControl:
				writestring = writestring + "Control,"
			if (value.find("Shift") > -1) and allowShift:
				writestring = writestring + "Shift,"
			if (value.find("Meta") > -1) and allowMeta:
				writestring = writestring + "Meta,"
			if (value.find("Alt") > -1) and allowAlt:
				writestring = writestring + "Alt,"
		writestring = writestring + "</mod><keycode>" + value[(target + 1):] + \
		"</keycode></" + shortcutlist[y] + ">\n"
		f.write(writestring)
		x = x + 1
		y = y + 1
	f.close()
	
def WriteShortcutsFromText(filename, shortcutarray, ignorestring = ""):

	f = open(filename, 'w')
	
	allowControl = not (ignorestring.find("Control") > -1)
	allowShift = not (ignorestring.find("Shift") > -1)
	allowMeta = not (ignorestring.find("Meta") > -1)
	allowAlt = not (ignorestring.find("Alt") > -1)
	
	l = len(shortcutarray)
	x = 0
	while (x < l):
		writestring = "<" + shortcutarray[x].Name + "><mod>"
		if (shortcutarray[x].Control) and allowControl:
			writestring = writestring + "Control,"
		if (shortcutarray[x].Shift) and allowShift:
			writestring = writestring + "Shift,"
		if (shortcutarray[x].Meta) and allowMeta:
			writestring = writestring + "Meta,"
		if (shortcutarray[x].Alt) and allowAlt:
			writestring = writestring + "Alt,"
		writestring = writestring + "</mod><keycode>" + str(shortcutarray[x].Keycode) + \
		"</keycode></" + shortcutarray[x].Name + ">\n"
		f.write(writestring)
		x = x + 1
		
	f.close()
	
