#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Shortcuts

from wxPython.stc import *
from wxPython.wx import *

class drShortcut:
	def __init__(self):
		self.Name = ""
		self.Control = 0
		self.Shift = 0
		self.Meta = 0
		self.Alt = 0
		self.Keycode = ""
		
	def Copy(self, target):		
		self.Name = target.Name
		self.Control = target.Control
		self.Shift = target.Shift
		self.Meta = target.Meta
		self.Alt = target.Alt
		self.Keycode = target.Keycode	
		
def SetSTCBaseShortcuts(stc):
	stc.CmdKeyClearAll()
	
	#Arrows
	stc.CmdKeyAssign(wxSTC_KEY_UP, 0, wxSTC_CMD_LINEUP)
	stc.CmdKeyAssign(wxSTC_KEY_LEFT, 0, wxSTC_CMD_CHARLEFT)
	stc.CmdKeyAssign(wxSTC_KEY_RIGHT, 0, wxSTC_CMD_CHARRIGHT)
	stc.CmdKeyAssign(wxSTC_KEY_DOWN, 0, wxSTC_CMD_LINEDOWN)
	stc.CmdKeyAssign(wxSTC_KEY_UP, wxSTC_SCMOD_SHIFT, wxSTC_CMD_LINEUPEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_LEFT, wxSTC_SCMOD_SHIFT, wxSTC_CMD_CHARLEFTEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_RIGHT, wxSTC_SCMOD_SHIFT, wxSTC_CMD_CHARRIGHTEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_DOWN, wxSTC_SCMOD_SHIFT, wxSTC_CMD_LINEDOWNEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_UP, wxSTC_SCMOD_CTRL, wxSTC_CMD_LINESCROLLUP)
	stc.CmdKeyAssign(wxSTC_KEY_LEFT, wxSTC_SCMOD_CTRL, wxSTC_CMD_WORDLEFT)
	stc.CmdKeyAssign(wxSTC_KEY_RIGHT, wxSTC_SCMOD_CTRL, wxSTC_CMD_WORDRIGHT)
	stc.CmdKeyAssign(wxSTC_KEY_DOWN, wxSTC_SCMOD_CTRL, wxSTC_CMD_LINESCROLLDOWN)
	stc.CmdKeyAssign(wxSTC_KEY_LEFT, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_CTRL, wxSTC_CMD_WORDLEFTEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_RIGHT, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_CTRL, wxSTC_CMD_WORDRIGHTEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_LEFT, wxSTC_SCMOD_ALT, wxSTC_CMD_WORDPARTLEFT)
	stc.CmdKeyAssign(wxSTC_KEY_RIGHT, wxSTC_SCMOD_ALT, wxSTC_CMD_WORDPARTRIGHT)
	stc.CmdKeyAssign(wxSTC_KEY_LEFT, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_ALT, wxSTC_CMD_WORDPARTLEFT)
	stc.CmdKeyAssign(wxSTC_KEY_RIGHT, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_ALT, wxSTC_CMD_WORDPARTRIGHT)
	
	#Home
	stc.CmdKeyAssign(wxSTC_KEY_HOME, 0, wxSTC_CMD_VCHOME)
	stc.CmdKeyAssign(wxSTC_KEY_HOME, wxSTC_SCMOD_SHIFT, wxSTC_CMD_VCHOMEEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_HOME, wxSTC_SCMOD_CTRL, wxSTC_CMD_DOCUMENTSTART)
	stc.CmdKeyAssign(wxSTC_KEY_HOME, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_CTRL, wxSTC_CMD_DOCUMENTSTARTEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_HOME, wxSTC_SCMOD_ALT, wxSTC_CMD_HOMEDISPLAY)
	stc.CmdKeyAssign(wxSTC_KEY_HOME, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_ALT, wxSTC_CMD_HOMEDISPLAYEXTEND)
	
	#End
	stc.CmdKeyAssign(wxSTC_KEY_END, 0, wxSTC_CMD_LINEEND)
	stc.CmdKeyAssign(wxSTC_KEY_END, wxSTC_SCMOD_SHIFT, wxSTC_CMD_LINEENDEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_END, wxSTC_SCMOD_CTRL, wxSTC_CMD_DOCUMENTEND)
	stc.CmdKeyAssign(wxSTC_KEY_END, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_CTRL, wxSTC_CMD_DOCUMENTENDEXTEND)
	stc.CmdKeyAssign(wxSTC_KEY_END, wxSTC_SCMOD_ALT, wxSTC_CMD_LINEENDDISPLAY)
	stc.CmdKeyAssign(wxSTC_KEY_END, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_ALT, wxSTC_CMD_LINEENDDISPLAYEXTEND)

	#Page Up
	stc.CmdKeyAssign(wxSTC_KEY_PRIOR, 0, wxSTC_CMD_PAGEUP)
	stc.CmdKeyAssign(wxSTC_KEY_PRIOR, wxSTC_SCMOD_SHIFT, wxSTC_CMD_PAGEUPEXTEND)
	
	
	#Page Down
	stc.CmdKeyAssign(wxSTC_KEY_NEXT, 0, wxSTC_CMD_PAGEDOWN)
	stc.CmdKeyAssign(wxSTC_KEY_NEXT, wxSTC_SCMOD_SHIFT, wxSTC_CMD_PAGEDOWNEXTEND)
		
	#Delete
	stc.CmdKeyAssign(wxSTC_KEY_DELETE, 0, wxSTC_CMD_CLEAR)
	stc.CmdKeyAssign(wxSTC_KEY_DELETE, wxSTC_SCMOD_SHIFT, wxSTC_CMD_CUT)
	stc.CmdKeyAssign(wxSTC_KEY_DELETE, wxSTC_SCMOD_CTRL, wxSTC_CMD_DELWORDRIGHT)
	stc.CmdKeyAssign(wxSTC_KEY_DELETE, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_CTRL, wxSTC_CMD_DELLINERIGHT)

	#Insert
	stc.CmdKeyAssign(wxSTC_KEY_INSERT, 0, wxSTC_CMD_EDITTOGGLEOVERTYPE)
	stc.CmdKeyAssign(wxSTC_KEY_INSERT, wxSTC_SCMOD_SHIFT, wxSTC_CMD_PASTE)
	stc.CmdKeyAssign(wxSTC_KEY_INSERT, wxSTC_SCMOD_CTRL, wxSTC_CMD_COPY)
	
	#Escape
	stc.CmdKeyAssign(wxSTC_KEY_ESCAPE, 0, wxSTC_CMD_CANCEL)
	
	#Backspace
	stc.CmdKeyAssign(wxSTC_KEY_BACK, 0, wxSTC_CMD_DELETEBACK)
	stc.CmdKeyAssign(wxSTC_KEY_BACK, wxSTC_SCMOD_SHIFT, wxSTC_CMD_DELETEBACK)
	stc.CmdKeyAssign(wxSTC_KEY_BACK, wxSTC_SCMOD_CTRL, wxSTC_CMD_DELWORDLEFT)
	stc.CmdKeyAssign(wxSTC_KEY_BACK, wxSTC_SCMOD_SHIFT | wxSTC_SCMOD_CTRL, wxSTC_CMD_DELLINELEFT)
	stc.CmdKeyAssign(wxSTC_KEY_BACK, wxSTC_SCMOD_ALT, wxSTC_CMD_UNDO)
	
	#Tab
	stc.CmdKeyAssign(wxSTC_KEY_TAB, 0, wxSTC_CMD_TAB)
	stc.CmdKeyAssign(wxSTC_KEY_TAB, wxSTC_SCMOD_SHIFT, wxSTC_CMD_BACKTAB)
	
	#Enter
	stc.CmdKeyAssign(wxSTC_KEY_RETURN, 0, wxSTC_CMD_NEWLINE)
	
def SetShortcuts(frame, Shortcuts, useDefault = 0):
	
	shortcutsActionArray = []
	shortcutsArgumentsArray = []
	KeycodeArray = []
	
	l = len(Shortcuts)
	x = 0
	while (x < l):
		keycode = Shortcuts[x].Keycode
		if (useDefault):
			keycode = ""
		
		#***************
		#STC
		if(Shortcuts[x].Name == "Uppercase"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('U')
				Shortcuts[x].Control = 1
				Shortcuts[x].Shift = 1				
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_UPPERCASE)
		elif(Shortcuts[x].Name == "Lowercase"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('U')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_LOWERCASE)
		elif(Shortcuts[x].Name == "Undo"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('Z')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_UNDO)	
		elif(Shortcuts[x].Name == "Redo"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('Y')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_REDO)
		elif(Shortcuts[x].Name == "Cut"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('X')
				Shortcuts[x].Control = 1	
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_CUT)
		elif(Shortcuts[x].Name == "Copy"):	
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('C')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_COPY)
		elif(Shortcuts[x].Name == "Paste"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('V')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_PASTE)
		elif(Shortcuts[x].Name == "Select All"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('A')
				Shortcuts[x].Control = 1	
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_SELECTALL)
		elif(Shortcuts[x].Name == "Zoom In"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = 392
				Shortcuts[x].Control = 1
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_ZOOMIN)
		elif(Shortcuts[x].Name == "Zoom Out"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = 394
				Shortcuts[x].Control = 1
			shortcutsActionArray.append("stc.CmdKeyExecute")
			shortcutsArgumentsArray.append(wxSTC_CMD_ZOOMOUT)
		#/STC
		#***************

		#File
		elif(Shortcuts[x].Name == "New"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('N')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnNew)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Open"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('O')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnOpen)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Load Session"):
			shortcutsActionArray.append(frame.OnLoadSession)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save Session"):
			shortcutsActionArray.append(frame.OnSaveSession)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('S')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnSave)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save As"):
			shortcutsActionArray.append(frame.OnSaveAs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save Prompt Output To File"):
			shortcutsActionArray.append(frame.OnSavePrompt)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Reload File"):
			shortcutsActionArray.append(frame.OnReload)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Restore From Backup"):
			shortcutsActionArray.append(frame.OnRestoreFromBackup)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Close"):
			shortcutsActionArray.append(frame.OnClose)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Print Setup"):
			shortcutsActionArray.append(frame.OnPrintSetup)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Print File"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('P')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnPrint)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Print Prompt"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('P')
				Shortcuts[x].Control = 1
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnPrintPrompt)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Exit"):
			shortcutsActionArray.append(frame.OnExit)
			shortcutsArgumentsArray.append("frame, event")
		
		#Tabs
		elif(Shortcuts[x].Name == "Next Tab"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F10
			shortcutsActionArray.append(frame.OnSelectTab)
			shortcutsArgumentsArray.append("frame, 1")
		elif(Shortcuts[x].Name == "Previous Tab"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F9
			shortcutsActionArray.append(frame.OnSelectTab)
			shortcutsArgumentsArray.append("frame, -1")
		elif(Shortcuts[x].Name == "First Tab"):
			shortcutsActionArray.append(frame.OnSelectTab)
			shortcutsArgumentsArray.append("frame, 0")
		elif(Shortcuts[x].Name == "Last Tab"):
			shortcutsActionArray.append(frame.OnSelectTab)
			shortcutsArgumentsArray.append("frame, 2")
		
		#Edit
		elif(Shortcuts[x].Name == "Find"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('F')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnMenuFind)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find Next"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F3
			shortcutsActionArray.append(frame.OnMenuFindNext)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find Previous"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F3
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnMenuFindPrevious)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Replace"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('R')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnMenuReplace)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Switcheroo"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('S')
				Shortcuts[x].Control = 1
				Shortcuts[x].Alt = 1
			shortcutsActionArray.append(frame.OnMenuSwitcheroo)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find In Files"):
			shortcutsActionArray.append(frame.OnMenuFindInFiles)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Replace In Files"):
			shortcutsActionArray.append(frame.OnMenuReplaceInFiles)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Insert Regular Expression"):
			shortcutsActionArray.append(frame.OnInsertRegEx)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Go To"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('G')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnGoTo)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Comment"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('[')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnCommentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "UnComment"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord(']')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnUnCommentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Indent"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('I')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnIndentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Dedent"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('I')
				Shortcuts[x].Control = 1
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnDedentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Select None"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('A')
				Shortcuts[x].Control = 1
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnSelectNone)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Chop Beginning"):
			shortcutsActionArray.append(frame.OnChopBeginning)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Chop End"):
			shortcutsActionArray.append(frame.OnChopEnd)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find And Complete"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_RETURN
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnFindAndComplete)
			shortcutsArgumentsArray.append("frame, event")			
		
		#View
		elif(Shortcuts[x].Name == "Fold All"):
			shortcutsActionArray.append(frame.OnFoldAll)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Expand All"):
			shortcutsActionArray.append(frame.OnExpandAll)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Show Class Browser"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('C')
				Shortcuts[x].Control = 1
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnShowClassBrowser)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Toggle View Whitespace"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('W')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnToggleViewWhiteSpace)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Toggle Prompt"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F6
			shortcutsActionArray.append(frame.OnTogglePrompt)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Clear Prompt"):
			shortcutsActionArray.append(frame.OnClearPrompt)
			shortcutsArgumentsArray.append("frame, event")
		
		#Program
		elif(Shortcuts[x].Name == "Run"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('E')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnRun)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Set Arguments"):
			shortcutsActionArray.append(frame.OnSetArgs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Python"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F7
			shortcutsActionArray.append(frame.OnPython)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Run With Debugger"):
			shortcutsActionArray.append(frame.OnRunWithDebugger)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "End"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = ord('D')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnEnd)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Set Log File"):
			shortcutsActionArray.append(frame.OnSetLogFile)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Insert Logger"):
			shortcutsActionArray.append(frame.OnAddLogger)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Insert String Logger"):
			shortcutsActionArray.append(frame.OnAddStringLogger)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Insert Arbitrary Arguments Logger"):
			shortcutsActionArray.append(frame.OnAddArbitraryArgLogger)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Remove All Loggers"):
			shortcutsActionArray.append(frame.OnRemoveAllLoggers)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Add Breakpoint"):
			shortcutsActionArray.append(frame.OnAddBreakpoint)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Remove Breakpoint"):
			shortcutsActionArray.append(frame.OnRemoveBreakpoint)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Remove All Breakpoints"):
			shortcutsActionArray.append(frame.OnRemoveAllBreakpoints)
			shortcutsArgumentsArray.append("frame, event")
		
		#DrScript
		elif(Shortcuts[x].Name == "Dynamic DrScript"):
			shortcutsActionArray.append(frame.dynamicdrscript)
			shortcutsArgumentsArray.append("frame, event")
		
		#Prefs
		elif(Shortcuts[x].Name == "Preferences"):
			shortcutsActionArray.append(frame.OnPrefs)
			shortcutsArgumentsArray.append("frame, event")
		#Docs
		elif(Shortcuts[x].Name == "Help"):
			shortcutsActionArray.append(frame.OnViewHelp)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View Python Docs"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F8
			shortcutsActionArray.append(frame.OnViewPythonDocs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View WxWidgets Docs"):
			shortcutsActionArray.append(frame.OnViewWxWidgetsDocs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View Regular Expression Howto"):
			shortcutsActionArray.append(frame.OnViewREHowtoDocs)
			shortcutsArgumentsArray.append("frame, event")
			
		#General
		elif(Shortcuts[x].Name == "Toggle Maximize"):
			if (len(keycode) < 1):
				Shortcuts[x].Keycode = WXK_F5
			shortcutsActionArray.append(frame.Maximize)
			shortcutsArgumentsArray.append("maximize")
			
		Shortcuts[x].Keycode = str(Shortcuts[x].Keycode)
		KeycodeArray.append(str(Shortcuts[x].Keycode))
		x = x + 1
		
	return KeycodeArray, shortcutsActionArray, shortcutsArgumentsArray
		
def RunShortcuts(frame, event, stc):	
	keycode = event.GetKeyCode()
	keyindex = -1
	allowControl = not (frame.ShortcutsIgnoreString.find("Control") > -1)
	allowShift = not (frame.ShortcutsIgnoreString.find("Shift") > -1)
	allowMeta = not (frame.ShortcutsIgnoreString.find("Meta") > -1)
	allowAlt = not (frame.ShortcutsIgnoreString.find("Alt") > -1)
			
	drpy = -1
	drscript = -1
	drshell = -1
	drpylast = 0
	drscriptlast = 0
	drshelllast = 0

	while (True):
		try:
			drpy = drpylast + frame.KeycodeArray[drpylast:].index(str(keycode))
		except:
			drpy = -1
		try:
			drscript = drscriptlast + frame.DrScriptKeycodeArray[drscriptlast:].index(str(keycode))
		except:
			drscript = -1
		try:
			drshell = drshelllast + frame.DrShellKeycodeArray[drshelllast:].index(str(keycode))
		except:	
			drshell = -1
			
		if (drpy < 0) and (drscript < 0) and (drshell < 0):
			break
							
		if drpy > -1:
			if ((not frame.Shortcuts[drpy].Shift == event.ShiftDown()) and allowShift) or \
			((not frame.Shortcuts[drpy].Control == event.ControlDown()) and allowControl) or \
			((not frame.Shortcuts[drpy].Meta == event.MetaDown()) and allowMeta) or \
			((not frame.Shortcuts[drpy].Alt == event.AltDown()) and allowAlt):
				drpylast = drpy + 1
				drpy = -1
			else:
				break
		if (drscript > -1):					
			if ((not frame.DrScriptShortcuts[drscript].Shift == event.ShiftDown()) and allowShift) or \
			((not frame.DrScriptShortcuts[drscript].Control == event.ControlDown()) and allowControl) or \
			((not frame.DrScriptShortcuts[drscript].Meta == event.MetaDown()) and allowMeta) or \
			((not frame.DrScriptShortcuts[drscript].Alt == event.AltDown()) and allowAlt):
				drscriptlast = drscript + 1
				drscript = -1
			else:
				break			
		if (drshell > -1):					
			if ((not frame.DrShellShortcuts[drshell].Shift == event.ShiftDown()) and allowShift) or \
			((not frame.DrShellShortcuts[drshell].Control == event.ControlDown()) and allowControl) or \
			((not frame.DrShellShortcuts[drshell].Meta == event.MetaDown()) and allowMeta) or \
			((not frame.DrShellShortcuts[drshell].Alt == event.AltDown()) and allowAlt):
				drshelllast = drshell + 1
				drshell = -1
			else:
				break
			
	if drpy > -1 and (not drscript > -1) and (not drshell > -1):
		if (frame.ShortcutsArgumentsArray[drpy] == "frame, event"):
			frame.ShortcutsActionArray[drpy](event)
		elif (frame.ShortcutsArgumentsArray[drpy] == "maximize"):
			#Work Around Bug in wxPython 2.5.1
			try:
				frame.ShortcutsActionArray[drpy](not frame.IsMaximized())
			except:
				pass
		else:
			try:	
				if frame.ShortcutsArgumentsArray[drpy].find("frame, ") > -1:
					try:
						arg = int(frame.ShortcutsArgumentsArray[drpy][7:])
					except:
						arg = -2
					frame.ShortcutsActionArray[drpy](arg)
			except:
				if stc is None:
					if (frame.txtPrompt.GetSTCFocus()):
						frame.txtPrompt.CmdKeyExecute(frame.ShortcutsArgumentsArray[drpy])
					else:			
						frame.txtDocument.CmdKeyExecute(frame.ShortcutsArgumentsArray[drpy])
				else:
					stc.CmdKeyExecute(frame.ShortcutsArgumentsArray[drpy])
		return 1		
	if drscript > -1 and (not drpy > -1) and (not drshell > -1):
		event.SetId(frame.ID_SCRIPT_BASE + drscript)
		frame.DrScriptShortcutsAction(event)
		return 1		
	if drshell > -1 and (not drscript > -1) and (not drpy > -1):
		event.SetId(frame.ID_SHELL_BASE + drshell)
		frame.DrShellShortcutsAction(event)
		return 1
		
	return 0
			
			