#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#drShell Dialog

import os.path
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drProperty import *
from drPrefsFile import ExtractPreferenceFromText
from drPrompt import DrPrompt
import drShortcutsFile

class drTree(wxTreeCtrl):
	def __init__(self, parent, id, point, size, style):
		wxTreeCtrl.__init__(self, parent, id, point, size, style)
		
		style = self.GetGrandParent().prefs.drshellstyle
		yarrr = convertStyleStringTowxFontArray(style)
		
		self.parent = parent
				
		w = wxFont(yarrr[1], wxNORMAL, wxNORMAL, wxNORMAL, yarrr[2])
				
		w.SetFaceName(yarrr[0])
		
		if (yarrr[3]):
			w.SetWeight(wxBOLD)
		else:
			w.SetWeight(wxNORMAL)
		if (yarrr[4]):
			w.SetStyle(wxITALIC)
		else:
			w.SetStyle(wxNORMAL)
		
		self.SetFont(w)
					
		f = convertColorPropertyToColorArray(getStyleProperty("fore", style))
		b = convertColorPropertyToColorArray(getStyleProperty("back", style))
				
		self.TextColor = wxColour(f[0], f[1], f[2])
		
		self.SetForegroundColour(self.TextColor)
				
		self.dragging = 0
		self.draggingId = self.GetRootItem()
		self.dragIndex = -1
		
		self.editindex = -1
		
		self.SetBackgroundColour(wxColour(b[0], b[1], b[2]))

		self.editing = 0

		EVT_TREE_BEGIN_DRAG(self, id, self.OnBeginDrag)
		EVT_TREE_ITEM_ACTIVATED(self, id, self.OnItemActivated)
		EVT_TREE_END_LABEL_EDIT(self, id, self.OnItemEdited)
		EVT_LEFT_UP(self, self.OnLeftUp)
		EVT_MOTION(self, self.OnMotion)	
				
	def OnBeginDrag(self, event):				
		self.draggingId = self.GetSelection()
		if (self.draggingId == self.GetRootItem()) or (not self.draggingId.IsOk()):
			return
				
		t = self.GetItemText(self.draggingId)
		
		try:
			self.dragIndex = self.parent.drshellfileTitleArray.index(t)
		except:
			d = wxScrolledMessageDialog(self.parent, ("The tree item you selected is corrupt.\n"), "Error")
			d.ShowModal()
			d.Destroy()
			return
		
		self.SetCursor(wxStockCursor(wxCURSOR_HAND))
		self.dragging = 1
					
	def OnItemActivated(self, event):
		sel = self.GetSelection()
		if (not sel.IsOk()):
			return
		try:
			self.editindex = self.parent.drshellfileTitleArray.index(self.GetItemText(sel))
		except:
			self.editindex = -1
		self.editing = 1
		self.EditLabel(sel)
	
	def OnItemEdited(self, event):
		newtitle = event.GetLabel()
		#Shells
		self.parent.drshellfileLineArray[self.editindex] = "<path>" + \
		ExtractPreferenceFromText(self.parent.drshellfileLineArray[self.editindex], "path") + "</path><title>" + \
		newtitle + "</title>\n"
		self.parent.drshellfileTitleArray[self.editindex] = newtitle
		
		#Shortcuts
		self.parent.dsShortcuts[self.editindex].Name = newtitle
		self.editindex = -1
		
	def OnLeftUp(self, event):
		self.SetCursor(wxSTANDARD_CURSOR)
		if (self.dragging):
			self.dragging = 0
			item, flags = self.HitTest(event.GetPosition())
			if (item.IsOk()):
				if (item == self.draggingId):
					return
				try:
					i = self.parent.drshellfileTitleArray.index(self.GetItemText(item))
				except:
					i = -1
				#Shells
				draggingPop = self.parent.drshellfileLineArray.pop(self.dragIndex)
				self.parent.drshellfileLineArray.insert(i+1, draggingPop)
				draggingPop = self.parent.drshellfileTitleArray.pop(self.dragIndex)
				self.parent.drshellfileTitleArray.insert(i+1, draggingPop)
				
				#Shortcuts
				draggingPop = self.parent.dsShortcuts.pop(self.dragIndex)
				self.parent.dsShortcuts.insert(i+1, draggingPop)
				draggingPop = self.parent.dsKeycodeArray.pop(self.dragIndex)
				self.parent.dsKeycodeArray.insert(i+1, draggingPop)
				
				t = self.GetItemText(item)
				olditem = item
				item = self.GetItemParent(item)
				if not item.IsOk():
					item = self.parent.root
				newbranch = self.InsertItem(item, olditem, self.GetItemText(self.draggingId))
				self.Delete(self.draggingId)
				self.SelectItem(newbranch)
			self.dragIndex = -1
	
	def OnMotion(self, event):
		if (self.dragging):		
			sel, flags = self.HitTest(event.GetPosition())			
			if (sel.IsOk()):
				self.SelectItem(sel)						
		event.Skip()

class drMoveShellDialog(wxDialog):

	def __init__(self, parent):
		wxDialog.__init__(self, parent, -1, ("Rename | Move Shells"), wxPoint(50, 50), wxSize(425, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
				
		self.ID_SAVE = 1005
		
		self.theSizer = wxBoxSizer(wxVERTICAL)
				
		self.homedirectory = parent.homedirectory
		
		self.drshellfile = self.homedirectory + "/drshell.dat"
		
		self.btnSave = wxButton(self, self.ID_SAVE, "&Save")
		
		self.theSizer.Add(self.btnSave, 0, wxSHAPED | wxALIGN_CENTER)
		
		self.parent = parent
		
		self.drshelltree = drTree(self, -1, wxPoint(0, 0), wxSize(400, 200), wxTR_DEFAULT_STYLE | wxTR_EDIT_LABELS)
		self.theSizer.Add(self.drshelltree, 9, wxEXPAND)
			
		self.root = self.drshelltree.AddRoot("Shell Menu")
		
		self.drshellfileLineArray = []
		self.drshellfileTitleArray = []
		
		self.dsShortcuts = self.parent.DrShellShortcuts
		self.dsKeycodeArray = self.parent.DrShellKeycodeArray
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0, wxSHAPED | wxALIGN_CENTER)
		self.btnClose.SetDefault()
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
		
		self.initialize()
		
		self.drshelltree.Expand(self.root)
		
		EVT_BUTTON(self, self.ID_SAVE, self.OnbtnSave)
		EVT_BUTTON(self, 101, self.OnbtnClose)
	
	def initialize(self):
		if (os.path.exists(self.drshellfile)):
			try:
				f = open(self.drshellfile, 'r')
				line = f.readline()
				while (len(line) > 0):
					line_title = ExtractPreferenceFromText(line, "title")
					self.drshellfileTitleArray.append(line_title)
					self.drshelltree.AppendItem(self.root, line_title)
					self.drshellfileLineArray.append(line)
					line = f.readline()
				f.close()
			except:
				d = wxScrolledMessageDialog(self.parent, ("Your DrShell file is a tad messed up.\n"), "Error")
				d.ShowModal()
				d.Destroy()
			
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnbtnSave(self, event):
		if (not os.path.exists(self.homedirectory)):
			d = wxScrolledMessageDialog(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			d.ShowModal()
			d.Destroy()
			return
		try:						
			if (self.drshelltree.GetChildrenCount(self.root) < 1):
				d = wxScrolledMessageDialog(self, ("Nothing to write!\n"), "Mistake")
				d.ShowModal()
				d.Destroy()
				return
			f = open(self.drshellfile, 'w')
			map(f.write, self.drshellfileLineArray)
			f.close()			
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + self.drshellfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
		#Now try to update and save shortcuts:
		msg = ""
		try:
			self.parent.DrShellShortcuts = self.parent.DrShellShortcuts
			self.parent.DrShellKeycodeArray = self.parent.DrShellKeycodeArray
			self.parent.DrShellShortcuts.extend(self.dsShortcuts)
			self.parent.DrShellKeycodeArray.extend(self.dsKeycodeArray)
			shortcutsfile = self.homedirectory + "/drshell.shortcuts.dat"
			drShortcutsFile.WriteShortcutsFromText(shortcutsfile, self.parent.DrShellShortcuts, self.parent.ShortcutsIgnoreString)
			msg = "\nUpdated and Saved Shortcuts."
		except:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + shortcutsfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
		
		if self.parent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully wrote to:\n"  + self.drshellfile + msg), "Saved Shells")
			d.ShowModal()
			d.Destroy()
			
class drNewShellDialog(wxDialog):

	def __init__(self, parent, title):
		wxDialog.__init__(self, parent, -1, title, wxPoint(50, 50), wxSize(375, 250), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
		
		self.ID_SAVE = 1005
		
		self.theSizer = wxFlexGridSizer(6, 3, 5, 10)
				
		self.btnSave = wxButton(self, self.ID_SAVE, "&Save")
				
		self.parent = parent
		
		self.txtTitle = wxTextCtrl(self, -1, "",  wxPoint(15, 325), wxSize(250, -1))		
		self.txtCommand = wxTextCtrl(self, -1, "",  wxPoint(15, 325), wxSize(250, -1))		
		self.txtArguments = wxTextCtrl(self, -1, parent.prefs.drshelldefaultcommandarguments,  wxPoint(15, 325), wxSize(250, -1))
		self.txtDirectory = wxTextCtrl(self, -1, parent.prefs.drshelldefaultcommanddirectory,  wxPoint(15, 325), wxSize(250, -1))
		self.chkRunInPrompt = wxCheckBox(self, -1, "")
		self.chkRunInPrompt.SetValue(parent.prefs.drshellruninpromptbydefault)
		
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Title:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.txtTitle, 0, wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Command:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.txtCommand, 0, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Arguments:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.txtArguments, 0, wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Directory:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.txtDirectory, 0, wxSHAPED)		
				
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Run In Prompt:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.chkRunInPrompt, 0, wxSHAPED)	
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, " "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0, wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.btnSave, 0, wxSHAPED | wxALIGN_RIGHT)
		self.txtTitle.SetFocus()
		self.btnSave.SetDefault()
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
		
		self.exitstatus = 0
		
		EVT_BUTTON(self, self.ID_SAVE, self.OnbtnSave)
		EVT_BUTTON(self, 101, self.OnbtnClose)
	
	def GetExitStatus(self):
		return self.exitstatus
	
	def GetShellTuple(self):
		return self.txtTitle.GetValue(), self.txtCommand.GetValue(), self.txtArguments.GetValue(), self.txtDirectory.GetValue(), int(self.chkRunInPrompt.GetValue())
			
	def OnbtnClose(self, event):
		self.exitstatus = 0
		self.Close(1)
		
	def OnbtnSave(self, event):
		self.exitstatus = 1
		self.Close(1)
		
	def SetShellTuple(self, title, command, args, dir, inprompt):
		self.txtTitle.SetValue(title)
		self.txtCommand.SetValue(command)
		self.txtArguments.SetValue(args)
		self.txtDirectory.SetValue(dir)
		self.chkRunInPrompt.SetValue(inprompt)