#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#drScript Dialog

import os.path
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drProperty import *
from drPrefsFile import ExtractPreferenceFromText
import drShortcutsFile

class drTree(wxTreeCtrl):
	def __init__(self, parent, id, point, size, style):
		wxTreeCtrl.__init__(self, parent, id, point, size, style)
		
		style = self.GetGrandParent().prefs.drscriptstyle
		yarrr = convertStyleStringTowxFontArray(style)
		
		self.parent = parent
				
		w = wxFont(yarrr[1], wxNORMAL, wxNORMAL, wxNORMAL, yarrr[2])
				
		w.SetFaceName(yarrr[0])
		
		if (yarrr[3]):
			w.SetWeight(wxBOLD)
		else:
			w.SetWeight(wxNORMAL)
		if (yarrr[4]):
			w.SetStyle(wxITALIC)
		else:
			w.SetStyle(wxNORMAL)
		
		self.SetFont(w)
					
		f = convertColorPropertyToColorArray(getStyleProperty("fore", style))
		b = convertColorPropertyToColorArray(getStyleProperty("back", style))
				
		self.TextColor = wxColour(f[0], f[1], f[2])
		
		self.SetForegroundColour(self.TextColor)
				
		self.dragging = 0
		self.draggingId = self.GetRootItem()
		self.dragIndex = -1
		
		self.editindex = -1
		
		self.SetBackgroundColour(wxColour(b[0], b[1], b[2]))

		self.editing = 0

		EVT_TREE_BEGIN_DRAG(self, id, self.OnBeginDrag)
		EVT_TREE_ITEM_ACTIVATED(self, id, self.OnItemActivated)
		EVT_TREE_END_LABEL_EDIT(self, id, self.OnItemEdited)
		EVT_LEFT_UP(self, self.OnLeftUp)
		EVT_MOTION(self, self.OnMotion)	
				
	def OnBeginDrag(self, event):				
		self.draggingId = self.GetSelection()
		if (self.draggingId == self.GetRootItem()) or (not self.draggingId.IsOk()):
			return
				
		t = self.GetItemText(self.draggingId)
		
		try:
			self.dragIndex = self.parent.drscriptfileTitleArray.index(t)
		except:
			d = wxScrolledMessageDialog(self.parent, ("The tree item you selected is corrupt.\n"), "Error")
			d.ShowModal()
			d.Destroy()
			return
		
		self.SetCursor(wxStockCursor(wxCURSOR_HAND))
		self.dragging = 1
					
	def OnItemActivated(self, event):
		sel = self.GetSelection()
		if (not sel.IsOk()):
			return
		try:
			self.editindex = self.parent.drscriptfileTitleArray.index(self.GetItemText(sel))
		except:
			self.editindex = -1
		self.editing = 1
		self.EditLabel(sel)
	
	def OnItemEdited(self, event):
		newtitle = event.GetLabel()
		#Scripts
		self.parent.drscriptfileLineArray[self.editindex] = "<path>" + \
		ExtractPreferenceFromText(self.parent.drscriptfileLineArray[self.editindex], "path") + "</path><title>" + \
		newtitle + "</title>\n"
		self.parent.drscriptfileTitleArray[self.editindex] = newtitle
		
		#Shortcuts
		self.parent.dsShortcuts[self.editindex].Name = newtitle
		self.editindex = -1
		
	def OnLeftUp(self, event):
		self.SetCursor(wxSTANDARD_CURSOR)
		if (self.dragging):
			self.dragging = 0
			item, flags = self.HitTest(event.GetPosition())
			if (item.IsOk()):
				if (item == self.draggingId):
					return
				try:
					i = self.parent.drscriptfileTitleArray.index(self.GetItemText(item))
				except:
					i = -1
				#Scripts
				draggingPop = self.parent.drscriptfileLineArray.pop(self.dragIndex)
				self.parent.drscriptfileLineArray.insert(i+1, draggingPop)
				draggingPop = self.parent.drscriptfileTitleArray.pop(self.dragIndex)
				self.parent.drscriptfileTitleArray.insert(i+1, draggingPop)
				
				#Shortcuts
				draggingPop = self.parent.dsShortcuts.pop(self.dragIndex)
				self.parent.dsShortcuts.insert(i+1, draggingPop)
				draggingPop = self.parent.dsKeycodeArray.pop(self.dragIndex)
				self.parent.dsKeycodeArray.insert(i+1, draggingPop)
				
				t = self.GetItemText(item)
				olditem = item
				item = self.GetItemParent(item)
				if not item.IsOk():
					item = self.parent.root
				newbranch = self.InsertItem(item, olditem, self.GetItemText(self.draggingId))
				self.Delete(self.draggingId)
				self.SelectItem(newbranch)
			self.dragIndex = -1
	
	def OnMotion(self, event):
		if (self.dragging):		
			sel, flags = self.HitTest(event.GetPosition())			
			if (sel.IsOk()):
				self.SelectItem(sel)						
		event.Skip()

class drScriptDialog(wxDialog):

	def __init__(self, parent):
		wxDialog.__init__(self, parent, -1, ("Rename | Move Scripts"), wxPoint(50, 50), wxSize(425, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
		
		self.ID_SAVE = 1005
		
		self.theSizer = wxBoxSizer(wxVERTICAL)
		
		self.homedirectory = parent.homedirectory
		
		self.drscriptfile = self.homedirectory + "/drscript.dat"
		
		self.btnSave = wxButton(self, self.ID_SAVE, "&Save")
		
		self.theSizer.Add(self.btnSave, 0, wxSHAPED | wxALIGN_CENTER)
		
		self.parent = parent
		
		self.drscripttree = drTree(self, -1, wxPoint(0, 0), wxSize(400, 200), wxTR_DEFAULT_STYLE | wxTR_EDIT_LABELS)
		self.theSizer.Add(self.drscripttree, 9, wxEXPAND)
			
		self.root = self.drscripttree.AddRoot("DrScript Menu")
		
		self.drscriptfileLineArray = []
		self.drscriptfileTitleArray = []
		
		self.dsShortcuts = self.parent.DrScriptShortcuts[self.parent.drscriptmenu.ExampleScriptCount:]
		self.dsKeycodeArray = self.parent.DrScriptKeycodeArray[self.parent.drscriptmenu.ExampleScriptCount:]
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0, wxSHAPED | wxALIGN_CENTER)
		self.btnClose.SetDefault()
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
		
		self.initialize()
		
		self.drscripttree.Expand(self.root)
		
		EVT_BUTTON(self, self.ID_SAVE, self.OnbtnSave)
		EVT_BUTTON(self, 101, self.OnbtnClose)
	
	def initialize(self):
		if (os.path.exists(self.drscriptfile)):
			try:
				f = open(self.drscriptfile, 'r')
				line = f.readline()
				while (len(line) > 0):
					line_title = ExtractPreferenceFromText(line, "title")
					self.drscriptfileTitleArray.append(line_title)
					self.drscripttree.AppendItem(self.root, line_title)
					self.drscriptfileLineArray.append(line)
					line = f.readline()
				f.close()
			except:
				d = wxScrolledMessageDialog(self.parent, ("Your DrScript file is a tad messed up.\n"), "Error")
				d.ShowModal()
				d.Destroy()
			
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnbtnSave(self, event):
		if (not os.path.exists(self.homedirectory)):
			d = wxScrolledMessageDialog(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			d.ShowModal()
			d.Destroy()
			return
		try:						
			if (self.drscripttree.GetChildrenCount(self.root) < 1):
				d = wxScrolledMessageDialog(self, ("Nothing to write!\n"), "Mistake")
				d.ShowModal()
				d.Destroy()
				return
			f = open(self.drscriptfile, 'w')
			map(f.write, self.drscriptfileLineArray)
			f.close()			
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + self.drscriptfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
		#Now try to update and save shortcuts:
		msg = ""
		try:
			self.parent.DrScriptShortcuts = self.parent.DrScriptShortcuts[0:self.parent.drscriptmenu.ExampleScriptCount]
			self.parent.DrScriptKeycodeArray = self.parent.DrScriptKeycodeArray[0:self.parent.drscriptmenu.ExampleScriptCount]
			self.parent.DrScriptShortcuts.extend(self.dsShortcuts)
			self.parent.DrScriptKeycodeArray.extend(self.dsKeycodeArray)
			shortcutsfile = self.homedirectory + "/drscript.shortcuts.dat"
			drShortcutsFile.WriteShortcutsFromText(shortcutsfile, self.parent.DrScriptShortcuts, self.parent.ShortcutsIgnoreString)
			msg = "\nUpdated and Saved Shortcuts."
		except:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + shortcutsfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
		
		if self.parent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully wrote to:\n"  + self.drscriptfile + msg), "Saved Scripts")
			d.ShowModal()
			d.Destroy()