#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Class Browser

from wxPython.lib.dialogs import wxScrolledMessageDialog
from wxPython.wx import *
from drProperty import *
from wxPython.stc import *
import inspect

def InspectLine(line):
	i = line.find("class")
	if (i > -1) and ((line[0:i].isspace()) or (i == 0)):	
		if line.find("\\\n") > -1:
			e = line[i:].rfind("\n") + i
		else:
			e = line[i:].find("\n") + i
		end = line[i:e].find(":") + i
		return line[i:end]
		
	i = line.find("def")
	if (i > -1) and ((line[0:i].isspace()) or (i == 0)):
		if line.find("\\\n") > -1:
			e = line[i:].rfind("\n") + i
		else:
			e = line[i:].find("\n") + i
		end = line[i:e].find(":") + i
		return line[i:end]
	return ""

def GetCount(line, compchar):
	l = len(line)
	x = 0
	y = 0
	while(x < l):
		if (line[x] == compchar):
			y = y + 1
		elif (not line[x].isspace()):
			x = l
		x = x + 1
	return y

class drTree(wxTreeCtrl):
	def __init__(self, parent, id, point, size, style):
		wxTreeCtrl.__init__(self, parent, id, point, size, style)
		
		style = self.GetGrandParent().prefs.classbrowserstyle
		yarrr = convertStyleStringTowxFontArray(style)
		
		w = wxFont(yarrr[1], wxNORMAL, wxNORMAL, wxNORMAL, yarrr[2])
		
		w.SetFaceName(yarrr[0])
		
		if (yarrr[3]):
			w.SetWeight(wxBOLD)
		else:
			w.SetWeight(wxNORMAL)
		if (yarrr[4]):
			w.SetStyle(wxITALIC)
		else:
			w.SetStyle(wxNORMAL)
		
		self.SetFont(w)
			
		f = convertColorPropertyToColorArray(getStyleProperty("fore", style))
		b = convertColorPropertyToColorArray(getStyleProperty("back", style))
				
		self.TextColor = wxColour(f[0], f[1], f[2])
		
		self.SetForegroundColour(self.TextColor)
		
		self.SetBackgroundColour(wxColour(b[0], b[1], b[2]))
				
		EVT_TREE_ITEM_ACTIVATED(self, id, self.OnItemActivated)
		EVT_SET_FOCUS(self, parent.OnSetFocus)
		
	def OnCompareItems(self, item1, item2):
		#Overriding Base, Return -1 for <, 0 for ==, +1 for >
		t1 = self.GetItemText(item1).lower()
		t2 = self.GetItemText(item2).lower()
		
		x = 0
		l = len(t1)
		if (l > len(t2)):
			l = len(t2)			
		while(x < l):
			if (t1[x] < t2[x]):
				return -1
			elif (t1[x] > t2[x]):
				return 1
			x = x + 1
		
		if (l == len(t2)):
			return -1
		
		return 0
		
		
	def OnItemActivated(self, event):
		sel = self.GetSelection()
		t = self.GetItemText(sel)
		try:
			if (self.GetGrandParent().prefs.docfolding):
				#Expand All If Folding.
				self.GetGrandParent().txtDocument.FoldAll(True)
			i = self.GetParent().ItemsIndex.index(sel)
			pos = self.GetParent().ItemsPos[i]	
			line = self.GetGrandParent().txtDocument.LineFromPosition(pos)
			self.GetGrandParent().txtDocument.ScrollToLine(line)		
			self.GetGrandParent().txtDocument.GotoLine(line)
			self.GetGrandParent().txtDocument.SetSelection(pos, (pos + len(t)))
			self.GetGrandParent().Raise()
			self.GetGrandParent().SetFocus()
			if (self.GetGrandParent().prefs.classbrowsercloseonactivate):
				self.GetParent().Close(1)
		except:
			print "This Should Not Happen"
			print "Error in OnItemActivated, Line 118ish"
			print "in drClassBrowser.py"

class drClassBrowser(wxFrame):

	def __init__(self, parent, title):
		wxFrame.__init__(self, parent, -1, ("Browse: " + title), wxPoint(50, 50), wxSize(425, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
		
		wxYield()
		
		self.theSizer = wxBoxSizer(wxVERTICAL)

		self.classtree = drTree(self, -1, wxPoint(0, 0), wxSize(400, 200), wxTR_DEFAULT_STYLE|wxTR_HIDE_ROOT)
		self.theSizer.Add(self.classtree, 9, wxEXPAND)		
		
		self.parent = parent
		
		self.mixed = 0
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0,  wxSHAPED | wxALIGN_CENTER)
		self.btnClose.SetDefault()

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
	
		EVT_BUTTON(self, 101, self.OnbtnClose)
		EVT_SET_FOCUS(self, self.OnSetFocus)
		
	def Browse(self):
		if self.mixed:
			return 1
		RootArray = [self.root]
		Roots = [self.root]
		currentRoot = 0
		Indents = [0]
		currentIndent = 0
		l = len(self.targetText)
		x = 0
		line = ""
		lastLineCheckPos = 1
		#What is this document using?
		result = self.parent.CheckIndentation()
		if result == 0:
			return 0
		
		if (result == 1):
			compchar = '\t'
			dec = 1
		else:
			compchar = ' '
			dec = self.parent.prefs.tabwidth
		while (x < l):	
			line = line + self.targetText[x]
			if self.targetText[x] == '\\':
				if (x+1) < l:
					if self.targetText[x+1] == '\n':
						x = x + 1
						line = line + self.targetText[x]
						x = x + 1
						line = line + self.targetText[x]
			if (self.targetText[x] == '\n') or (x == (l - 1)):
				t = InspectLine(line)
				if (len(t) > 0):				
					if not (self.targetText[lastLineCheckPos] == '\\'):
						indent = GetCount(line, compchar)
						while (indent < Indents[currentIndent]):
							Roots.pop()
							currentRoot = currentRoot - 1
							Indents.pop()
							currentIndent = currentIndent - 1
						if (t.find("class ") == 0) or (t.find("def ") == 0):
							Indents.append(indent + dec)
							currentIndent = currentIndent + 1
							Roots.append(self.classtree.AppendItem(Roots[currentRoot], t))
							currentRoot = currentRoot + 1						
							RootArray.append(Roots[currentRoot])
							self.ItemsIndex.append(Roots[currentRoot])
							self.ItemsPos.append(x - (len(t) + 1))					
				if (self.targetText[x] == '\n'):
					lastLineCheckPos = x - 1
				line = ""
			x = x + 1
		
		if (self.GetParent().prefs.classbrowserissorted):
			self.classtree.SortChildren(self.root)	
			x = 0
			l = len(RootArray)
			while (x < l):			
				self.classtree.SortChildren(RootArray[x])
				x = x + 1
				
		return 1
		
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnSetFocus(self, event):
		self.classtree.DeleteAllItems()
		
		self.root = self.classtree.AddRoot("")
						
		self.ItemsIndex = []
		
		self.ItemsPos = []
		
		self.targetText = self.parent.txtDocument.GetText()
				
		if not self.Browse():
			self.mixed = 1		
			msg = 'This document is mixed.  It uses tabs and spaces for indentation.\nDrPython will not be able to correctly\
display the class browser.  Please use "Edit:Whitespace:Clean Up Indentation" to fix this.'
			d = wxScrolledMessageDialog(self, msg, "Check Indentation Results")
			d.ShowModal()
			self.Close(1)