/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#ifndef _NETWORK_H_
#define _NETWORK_H_

#include <config.h>
#include "drivel.h"

typedef struct _ThreadData ThreadData;
typedef struct _HTTPMem HTTPMem;

struct _HTTPMem
{
	gchar *data;
	guint len;
};

struct _ThreadData
{
	DrivelClient *dc;
	gchar *post_data;
	DrivelRequestType type;
	GIOChannel *channel;
};

gboolean
lj_http_reslv_name(DrivelClient *dc);

void
lj_send_request (DrivelClient *dc, const gchar *data, DrivelRequestType type);

gboolean
lj_network_loop (gpointer data);

gchar *
lj_format_string (const gchar *string);

#endif
