/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002-2003 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#include <gnome.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <string.h>

#include <config.h>

#include "about.h"

void
about_show (DrivelClient *dc)
{
	GdkPixbuf *logo;
	static GtkWidget *dialog = NULL;
	static const gchar *authors[] = 	
	{
		"Todd Kulesza <todd@dropline.net>",
		" ",
		"Contributors:",
		"Geoff King <0glk@qlink.queensu.ca>",
		"Evan Martin <evan@livejournal.com>",
		"Ari Pollak <compwiz@aripollak.com>",
		NULL
	};
	static const gchar *documentors[] = 
	{
		NULL
	};
	gchar *translators = NULL;
	
	if (dialog)
	{
		gdk_window_show (dialog->window);
		gdk_window_raise (dialog->window);
		
		return;
	}
	
	logo = gdk_pixbuf_new_from_file (
		DATADIR G_DIR_SEPARATOR_S "pixmaps" G_DIR_SEPARATOR_S "livejournal.png",
		NULL);
	
	dialog = gnome_about_new ("Drivel", VERSION,
				"Copyright 2002-2004 Todd Kulesza",
				_("A LiveJournal client for the GNOME desktop."),
				authors,
				documentors,
				translators,
				logo);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (dc->current_window));
	
	g_signal_connect (G_OBJECT (dialog), "destroy",
			G_CALLBACK (gtk_widget_destroyed), &dialog);
	
	gtk_widget_show_all (dialog);
	
	return;
}
