/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../config.h"
#include "../src/drip.h"
#include "../encoder/plugin-loader.hh"
#include <gmodule.h>
// Custom includes:
#include <math.h>
#include <stdio.h>

#undef DEBUG

static gboolean init_done = FALSE;                 // Plugin initialised flag
static gint width,height;                          // Input Width\Height sizes
static gint xoff,yoff,xlen,ylen;                   // Offset and lenght values
static gdouble framerate;                           // Framerate (25.00, 29.97, etc)
static gdouble value1,value2,value3,value4,value5;  // Plugin defined values
static guint8 *src_planes[3];                      // Input data planes (I420 colour space)
static guint8 *dst_planes[3];                      // Output data planes
// Custom vari's
// none

/* Gui callback */
void on_spinbutton_volumefilter_changed(GtkEditable *editable,gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    value1 = atof(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}

extern "C" {


/* Return type (SPU,AUDIO,VIDEO) of filter */
G_MODULE_EXPORT module_type_e volumefilter_type(void) {
    return AUDIO; // AUDIO filter
}


/* Return phase (PRE,NORMAL,POST) of filter */
G_MODULE_EXPORT module_phase_e volumefilter_phase(void) {
    return PRE;
}


/* Return values of plugin (value1,value2,... value5) */
/* NOTE: calling function must deallocate the returned gdouble[5] */
G_MODULE_EXPORT void volumefilter_values(gdouble* values) {
    values[0] = value1;
    values[2] = value2;
    values[3] = value3;
    values[4] = value4;
    values[5] = value5;
    return;
}


/* Set plugins values */
G_MODULE_EXPORT void volumefilter_values_function(gdouble *v) {
    value1 = v[0];
    value2 = v[1];
    value3 = v[2];
    value4 = v[3];
    value5 = v[4];
    return;
}


/* Function which implements a GtkWidget to let user configure this plugin */
G_MODULE_EXPORT GtkWidget* volumefilter_gui(void) {
    static GtkWidget *gui = NULL;
    GtkObject *spinbutton_audio_adjustment_adj;
    GtkWidget *spinbutton_audio_adjustment;
    GtkWidget *label_audio_adjustment;

    #ifdef DEBUG
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: volumefilter gui");
    #endif
        
    gui = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (gui);
    gtk_widget_show (gui);
    label_audio_adjustment = gtk_label_new ("\n  Audio Volume Multiplier  ");
    gtk_widget_ref (label_audio_adjustment);
    gtk_object_set_data_full (GTK_OBJECT(gui), "label_audio_adjustment", label_audio_adjustment, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_audio_adjustment);
    gtk_box_pack_start (GTK_BOX (gui), label_audio_adjustment, FALSE, FALSE, 0);
    gtk_label_set_justify (GTK_LABEL (label_audio_adjustment), GTK_JUSTIFY_LEFT);
    spinbutton_audio_adjustment_adj = gtk_adjustment_new(value1,0,19,1,10,10);
    spinbutton_audio_adjustment = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_audio_adjustment_adj), 0.1,3);
    gtk_widget_ref (spinbutton_audio_adjustment);
    gtk_object_set_data_full (GTK_OBJECT(gui), "spinbutton_audio_adjustment", spinbutton_audio_adjustment,
                                  (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (spinbutton_audio_adjustment);
    gtk_box_pack_end (GTK_BOX (gui), spinbutton_audio_adjustment, FALSE, FALSE, 0);
    gtk_widget_set_usize (spinbutton_audio_adjustment, 200, -2);
    
    gtk_signal_connect (GTK_OBJECT (spinbutton_audio_adjustment), "changed",
                        GTK_SIGNAL_FUNC (on_spinbutton_volumefilter_changed),
                        spinbutton_audio_adjustment);

    /* Clean & Exit */
    return gui;
}


G_MODULE_EXPORT guint8** volumefilter_apply(guint8** src, glong size, gulong SCR, gulong PTS) {
    register gint32 temp;
    register gint16* src_16 = (gint16*)src[0];
    #ifdef DEBUG
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: volumefilter apply %g",value1);
    #endif
    for (register gint i=0;i<size/2;i++) {
        temp = (gint32)src_16[i];
        temp = (gint32)((gfloat)temp * value1);
        if (temp>32767) temp = 32767;
        else if (temp<-32768) temp = -32768;
        src_16[i] = (gint16)temp;
    }
    /* Clean & Exit */
    return src;             // returning input data: dst=src
}


G_MODULE_EXPORT void volumefilter_init(gint w, gint h,
                                     gint xo, gint yo, gint xl, gint yl,
                                     gdouble fr) {
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: volumefilter init");
    /* Copy values */
    width = w; height = h;
    xoff = xo; yoff = yo; xlen = xl; ylen = yl;
    framerate = fr;
    /* Set init flag */
    init_done = TRUE;

    /* Clean & Exit */
    return;
}


G_MODULE_EXPORT void volumefilter_destruct(void) {
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: volumefilter destruct");
    /* Clean & Exit */
    return;
}


/* Called when parameters need tobe reset to default, auto called when plugin used for 1st time */
G_MODULE_EXPORT void volumefilter_default(void) {                                             /* DEFINE! */
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: volumefilter default");
    /* Set value's to default */
    value1 = 1.00;
    value2 = 0;
    value3 = 0;
    value4 = 0;
    value5 = 0;
    /* Clean & Exit */
    return;
}


/* g_module_check_init is automatically executed upon loading */
G_MODULE_EXPORT const gchar* g_module_check_init(GModule *module) {
    /* Set value1 to volume adjustment value */
    value1 = 1.0;
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: volumefilter selftest passed");
    return NULL;
}

} //extern "C"
