import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class PHPComicModule(BasicComicModule):
    """
        Simple helper for comics which use the phpComic / 
        Comic Update Script for PHP.
        Subclasses should set basePath to the path to the
        phpComic/CUSP installation.
        prevSearch is required as with a normal module as
        phpComic/CUSP uses templates with user-definable 
        images or text for navigation.
    """
    help = 'Index format: yymmdd'
    latestUrl = 'latest.php'

    def __init__(self):
        BasicComicModule.__init__(self)
        self.latestUrl = self.basePath + (self.latestUrl or '')
        self.imageUrl =  self.basePath + 'daily.php?date=%s'
        self.imageSearch = re.compile(r'<img alt=[^>]+ src="(%scomics/\d{6}\..+?)">' % (self.basePath,), re.IGNORECASE)
