import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class WebcomicsNation(BasicComicModule):
    imageUrl = '?view=archive&amp;chapter=%s'
    imageSearch = re.compile(r'<a name="strip\d*?">.*?<img[^>]+?src="([^"]*?memberimages/.+?)"', re.IGNORECASE + re.DOTALL)
    prevSearch = re.compile(r'href="([^"]*?whichbutton=prev[^"]*?)"', re.IGNORECASE)
    help = 'Index format: nnnn (non-contiguous)'

    submodules = {
        'AgnesQuill': 'daveroman/agnes',
        'Elvenbaath': 'tdotodot2k/elvenbaath',
        'IrrationalFears': 'uvernon/irrationalfears',
        'KismetHuntersMoon': 'laylalawlor/huntersmoon',
        'SaikoAndLavender': 'gc/saiko',
        'DungeonsAndDenizens': 'graveyardgreg/dungeoncralwers',
        'MyMuse': 'gc/muse',
        'NekkoAndJoruba': 'nekkoandjoruba/nekkoandjoruba',
        'JaxEpoch': 'johngreen/quicken',
        'QuantumRockOfAges': 'DreamchildNYC/quantum',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = 'http://www.webcomicsnation.com/' + self.submodules[submodule] + "/series.php"
        self.latestUrl = baseUrl
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'WebcomicsNation' + '/' + submodule
