import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class NinthElsewhere(BasicComicModule):
    latestUrl = 'http://www.9thelsewhere.com/icenter.html'
    imageUrl = 'http://www.9thelsewhere.com/%s/9e%s_%s.html'
    imageSearch = re.compile(r'<img src="([^"]*9e\d+_\d+\.jpg)"')
    prevSearch = re.compile(r'<a href="([^"]+\.html)">\s*PREV')
    help = 'Index format: year-chapter-page'

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))

